/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import ai.rapids.cudf.ColumnVector;
import ai.rapids.cudf.ColumnView;
import ai.rapids.cudf.NullPolicy;
import ai.rapids.cudf.Scalar;
import ai.rapids.cudf.ScanAggregation;
import ai.rapids.cudf.ScanType;
import ai.rapids.cudf.Table;
import com.nvidia.spark.rapids.Arm;
import com.nvidia.spark.rapids.CloseableHolder;
import com.nvidia.spark.rapids.GpuColumnVector;
import com.nvidia.spark.rapids.GpuScalar$;
import com.nvidia.spark.rapids.RapidsBuffer;
import java.io.Serializable;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.runtime.BoxesRunTime;

public final class GpuExpressionWithSideEffectUtils$
implements Arm {
    public static GpuExpressionWithSideEffectUtils$ MODULE$;

    static {
        new GpuExpressionWithSideEffectUtils$();
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T r, Function1<T, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T[] r, Function1<T[], V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T, V> V withResourceIfAllowed(T r, Function1<T, V> block) {
        return (V)Arm.withResourceIfAllowed$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T[] r, Function1<T[], V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends RapidsBuffer, V> V freeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.freeOnExcept$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(CloseableHolder<T> h, Function1<CloseableHolder<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, h, block);
    }

    public boolean isAllTrue(GpuColumnVector col) {
        Predef$.MODULE$.assert(BooleanType$.MODULE$.equals(col.dataType()));
        if (col.getRowCount() == 0L) {
            return true;
        }
        if (col.hasNull()) {
            return false;
        }
        return BoxesRunTime.unboxToBoolean(this.withResource(col.getBase().all(), (Function1 & Serializable & scala.Serializable)allTrue -> BoxesRunTime.boxToBoolean((boolean)allTrue.getBoolean())));
    }

    public boolean isAllFalse(GpuColumnVector col, boolean nullsAsFalse) {
        Predef$.MODULE$.assert(BooleanType$.MODULE$.equals(col.dataType()));
        if (nullsAsFalse) {
            if (col.getRowCount() == (long)col.numNulls()) {
                return true;
            }
        } else if (col.hasNull() || col.getRowCount() == 0L) {
            return false;
        }
        return BoxesRunTime.unboxToBoolean(this.withResource(col.getBase().any(), (Function1 & Serializable & scala.Serializable)anyTrue -> BoxesRunTime.boxToBoolean((boolean)GpuExpressionWithSideEffectUtils$.$anonfun$isAllFalse$1(anyTrue))));
    }

    public boolean isAllFalse$default$2() {
        return true;
    }

    public ColumnarBatch filterBatch(Table tbl, ColumnVector pred, DataType[] colTypes) {
        return (ColumnarBatch)this.withResource(tbl.filter((ColumnView)pred), (Function1 & Serializable & scala.Serializable)filteredData -> GpuColumnVector.from(filteredData, colTypes));
    }

    private ColumnVector boolToInt(ColumnVector cv) {
        return (ColumnVector)this.withResource(GpuScalar$.MODULE$.from(BoxesRunTime.boxToInteger((int)1), DataTypes.IntegerType), (Function1 & Serializable & scala.Serializable)one -> (ColumnVector)MODULE$.withResource(GpuScalar$.MODULE$.from(BoxesRunTime.boxToInteger((int)0), DataTypes.IntegerType), (Function1 & Serializable & scala.Serializable)zero -> cv.ifElse(one, zero)));
    }

    public ColumnVector boolInverted(ColumnVector cv) {
        return (ColumnVector)this.withResource(GpuScalar$.MODULE$.from(BoxesRunTime.boxToBoolean((boolean)true), DataTypes.BooleanType), (Function1 & Serializable & scala.Serializable)t -> (ColumnVector)MODULE$.withResource(GpuScalar$.MODULE$.from(BoxesRunTime.boxToBoolean((boolean)false), DataTypes.BooleanType), (Function1 & Serializable & scala.Serializable)f -> cv.ifElse(f, t)));
    }

    public ColumnVector gather(ColumnVector predicate, GpuColumnVector t) {
        ColumnVector prefixSumExclusive2 = (ColumnVector)this.withResource(this.boolToInt(predicate), (Function1 & Serializable & scala.Serializable)boolsAsInts -> boolsAsInts.scan(ScanAggregation.sum(), ScanType.EXCLUSIVE, NullPolicy.INCLUDE));
        ColumnVector gatherMap = (ColumnVector)this.withResource(prefixSumExclusive2, (Function1 & Serializable & scala.Serializable)prefixSumExclusive -> (ColumnVector)MODULE$.withResource(Scalar.fromInt((int)Integer.MIN_VALUE), (Function1 & Serializable & scala.Serializable)outOfBoundsFlag -> predicate.ifElse((ColumnView)prefixSumExclusive, outOfBoundsFlag)));
        return (ColumnVector)this.withResource(gatherMap, (Function1 & Serializable & scala.Serializable)x$1 -> (ColumnVector)MODULE$.withResource(new Table(new ColumnVector[]{t.getBase()}), (Function1 & Serializable & scala.Serializable)tbl -> (ColumnVector)MODULE$.withResource(tbl.gather((ColumnView)gatherMap), (Function1 & Serializable & scala.Serializable)gatherTbl -> gatherTbl.getColumn(0).incRefCount())));
    }

    public ColumnVector replaceNulls(ColumnVector cv, boolean bool) {
        if (!cv.hasNulls()) {
            return cv.incRefCount();
        }
        return (ColumnVector)this.withResource(Scalar.fromBool((boolean)bool), (Function1 & Serializable & scala.Serializable)booleanScalar -> cv.replaceNulls(booleanScalar));
    }

    public GpuColumnVector shortCircuitWithBool(GpuColumnVector gpuCV, boolean bool) {
        return (GpuColumnVector)((Object)this.withResource(GpuScalar$.MODULE$.from(BoxesRunTime.boxToBoolean((boolean)bool), (DataType)BooleanType$.MODULE$), (Function1 & Serializable & scala.Serializable)boolScalar -> GpuColumnVector.from(boolScalar, (int)gpuCV.getRowCount(), (DataType)BooleanType$.MODULE$)));
    }

    public static final /* synthetic */ boolean $anonfun$isAllFalse$1(Scalar anyTrue) {
        return !anyTrue.getBoolean();
    }

    private GpuExpressionWithSideEffectUtils$() {
        MODULE$ = this;
        Arm.$init$(this);
    }
}

