/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import com.nvidia.spark.rapids.CsvFormatType$;
import com.nvidia.spark.rapids.FileFormatChecks$;
import com.nvidia.spark.rapids.GpuCSVScan;
import com.nvidia.spark.rapids.GpuOverrides$;
import com.nvidia.spark.rapids.GpuTextBasedDateUtils$;
import com.nvidia.spark.rapids.RapidsConf$;
import com.nvidia.spark.rapids.RapidsMeta;
import com.nvidia.spark.rapids.ReadFileOp$;
import com.nvidia.spark.rapids.ScanMeta;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.csv.CSVOptions;
import org.apache.spark.sql.catalyst.csv.GpuCsvUtils$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.util.ParseMode;
import org.apache.spark.sql.catalyst.util.PermissiveMode$;
import org.apache.spark.sql.execution.datasources.PartitioningAwareFileIndex;
import org.apache.spark.sql.execution.datasources.v2.csv.CSVScan;
import org.apache.spark.sql.rapids.LegacyTimeParserPolicy$;
import org.apache.spark.sql.rapids.TimeParserPolicy;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple10;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class GpuCSVScan$
implements scala.Serializable {
    public static GpuCSVScan$ MODULE$;

    static {
        new GpuCSVScan$();
    }

    public void tagSupport(ScanMeta<CSVScan> scanMeta) {
        CSVScan scan = (CSVScan)scanMeta.wrapped();
        this.tagSupport(scan.sparkSession(), scan.dataSchema(), scan.readDataSchema(), (scala.collection.immutable.Map<String, String>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)scan.options()).asScala()).toMap(Predef$.MODULE$.$conforms()), scanMeta);
    }

    public void tagSupport(SparkSession sparkSession, StructType dataSchema, StructType readSchema, scala.collection.immutable.Map<String, String> options, RapidsMeta<?, ?, ?> meta) {
        String string;
        CSVOptions parsedOptions = new CSVOptions(options, sparkSession.sessionState().conf().csvColumnPruning(), sparkSession.sessionState().conf().sessionLocalTimeZone(), sparkSession.sessionState().conf().columnNameOfCorruptRecord());
        if (!meta.conf().isCsvEnabled()) {
            meta.willNotWorkOnGpu(new StringBuilder(61).append("CSV input and output has been disabled. To enable set").append(RapidsConf$.MODULE$.ENABLE_CSV()).append(" to true").toString());
        }
        if (!meta.conf().isCsvReadEnabled()) {
            meta.willNotWorkOnGpu(new StringBuilder(50).append("CSV input has been disabled. To enable set").append(RapidsConf$.MODULE$.ENABLE_CSV_READ()).append(" to true").toString());
        }
        if (!parsedOptions.enforceSchema()) {
            meta.willNotWorkOnGpu("GpuCSVScan always enforces schemas");
        }
        if (dataSchema == null || dataSchema.isEmpty()) {
            meta.willNotWorkOnGpu("GpuCSVScan requires a specified data schema");
        }
        if (parsedOptions.delimiter().length() > 1) {
            meta.willNotWorkOnGpu("GpuCSVScan does not support multi-character delimiters");
        }
        if (parsedOptions.delimiter().codePointAt(0) > 127) {
            meta.willNotWorkOnGpu("GpuCSVScan does not support non-ASCII delimiters");
        }
        if (parsedOptions.quote() > '\u007f') {
            meta.willNotWorkOnGpu("GpuCSVScan does not support non-ASCII quote chars");
        }
        if (parsedOptions.comment() > '\u007f') {
            meta.willNotWorkOnGpu("GpuCSVScan does not support non-ASCII comment chars");
        }
        if (parsedOptions.escape() != '\\') {
            meta.willNotWorkOnGpu("GpuCSVScan does not support modified escape chars");
        }
        if (parsedOptions.charToEscapeQuoteEscaping().isDefined()) {
            meta.willNotWorkOnGpu("GPU CSV Parsing does not support charToEscapeQuoteEscaping");
        }
        String string2 = StandardCharsets.UTF_8.name();
        String string3 = parsedOptions.charset();
        if (string2 == null ? string3 != null : !string2.equals(string3)) {
            String string4 = StandardCharsets.US_ASCII.name();
            String string5 = parsedOptions.charset();
            if (string4 == null ? string5 != null : !string4.equals(string5)) {
                meta.willNotWorkOnGpu("GpuCSVScan only supports UTF8 encoded data");
            }
        }
        Object object = parsedOptions.lineSeparator().getOrElse((Function0 & Serializable & scala.Serializable)() -> "\n");
        String string6 = "\n";
        if (object == null ? string6 != null : !object.equals(string6)) {
            meta.willNotWorkOnGpu("GpuCSVScan only supports \"\\n\" as a line separator");
        }
        ParseMode parseMode = parsedOptions.parseMode();
        PermissiveMode$ permissiveMode$ = PermissiveMode$.MODULE$;
        if (parseMode == null ? permissiveMode$ != null : !parseMode.equals(permissiveMode$)) {
            meta.willNotWorkOnGpu("GpuCSVScan only supports Permissive CSV parsing");
        }
        boolean bl = "inf".equals(string = parsedOptions.positiveInf().toLowerCase()) ? true : ("+inf".equals(string) ? true : ("infinity".equals(string) ? true : "+infinity".equals(string)));
        if (bl) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            meta.willNotWorkOnGpu(new StringBuilder(48).append("the positive infinity value '").append(parsedOptions.positiveInf()).append("'").append(" is not supported'").toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        String string7 = parsedOptions.negativeInf().toLowerCase();
        boolean bl2 = "-inf".equals(string7) ? true : "-infinity".equals(string7);
        if (bl2) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            meta.willNotWorkOnGpu(new StringBuilder(48).append("the positive infinity value '").append(parsedOptions.positiveInf()).append("'").append(" is not supported'").toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        Set types = ((TraversableOnce)readSchema.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.dataType(), Seq$.MODULE$.canBuildFrom())).toSet();
        TimeParserPolicy timeParserPolicy = GpuOverrides$.MODULE$.getTimeParserPolicy();
        LegacyTimeParserPolicy$ legacyTimeParserPolicy$ = LegacyTimeParserPolicy$.MODULE$;
        if (!(timeParserPolicy != null ? !timeParserPolicy.equals(legacyTimeParserPolicy$) : legacyTimeParserPolicy$ != null)) {
            if (types.contains((Object)DateType$.MODULE$) || types.contains((Object)TimestampType$.MODULE$)) {
                meta.willNotWorkOnGpu("GpuCSVScan does not support timeParserPolicy=LEGACY");
            }
        }
        if (types.contains((Object)DateType$.MODULE$)) {
            GpuTextBasedDateUtils$.MODULE$.tagCudfFormat(meta, GpuCsvUtils$.MODULE$.dateFormatInRead(parsedOptions), true);
        }
        if (types.contains((Object)TimestampType$.MODULE$)) {
            meta.checkTimeZoneId(parsedOptions.zoneId());
            GpuTextBasedDateUtils$.MODULE$.tagCudfFormat(meta, GpuCsvUtils$.MODULE$.timestampFormatInRead(parsedOptions), true);
        }
        if (!meta.conf().isCsvFloatReadEnabled() && types.contains((Object)FloatType$.MODULE$)) {
            meta.willNotWorkOnGpu(new StringBuilder(89).append("CSV reading is not 100% compatible when reading floats. ").append("To enable it please set ").append(RapidsConf$.MODULE$.ENABLE_READ_CSV_FLOATS()).append(" to true.").toString());
        }
        if (!meta.conf().isCsvDoubleReadEnabled() && types.contains((Object)DoubleType$.MODULE$)) {
            meta.willNotWorkOnGpu(new StringBuilder(90).append("CSV reading is not 100% compatible when reading doubles. ").append("To enable it please set ").append(RapidsConf$.MODULE$.ENABLE_READ_CSV_DOUBLES()).append(" to true.").toString());
        }
        if (!meta.conf().isCsvDecimalReadEnabled() && types.exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)GpuCSVScan$.$anonfun$tagSupport$3(x$2)))) {
            meta.willNotWorkOnGpu(new StringBuilder(91).append("CSV reading is not 100% compatible when reading decimals. ").append("To enable it please set ").append(RapidsConf$.MODULE$.ENABLE_READ_CSV_DECIMALS()).append(" to true.").toString());
        }
        FileFormatChecks$.MODULE$.tag(meta, readSchema, CsvFormatType$.MODULE$, ReadFileOp$.MODULE$);
    }

    public GpuCSVScan apply(SparkSession sparkSession, PartitioningAwareFileIndex fileIndex, StructType dataSchema, StructType readDataSchema, StructType readPartitionSchema, CaseInsensitiveStringMap options, Seq<Expression> partitionFilters2, Seq<Expression> dataFilters, Integer maxReaderBatchSizeRows, long maxReaderBatchSizeBytes) {
        return new GpuCSVScan(sparkSession, fileIndex, dataSchema, readDataSchema, readPartitionSchema, options, partitionFilters2, dataFilters, maxReaderBatchSizeRows, maxReaderBatchSizeBytes);
    }

    public Option<Tuple10<SparkSession, PartitioningAwareFileIndex, StructType, StructType, StructType, CaseInsensitiveStringMap, Seq<Expression>, Seq<Expression>, Integer, Object>> unapply(GpuCSVScan x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple10((Object)x$0.sparkSession(), (Object)x$0.fileIndex(), (Object)x$0.dataSchema(), (Object)x$0.readDataSchema(), (Object)x$0.readPartitionSchema(), (Object)x$0.options(), x$0.partitionFilters(), x$0.dataFilters(), (Object)x$0.maxReaderBatchSizeRows(), (Object)BoxesRunTime.boxToLong((long)x$0.maxReaderBatchSizeBytes())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$tagSupport$3(DataType x$2) {
        return x$2 instanceof DecimalType;
    }

    private GpuCSVScan$() {
        MODULE$ = this;
    }
}

