/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import ai.rapids.cudf.ColumnVector;
import ai.rapids.cudf.ColumnView;
import ai.rapids.cudf.DType;
import ai.rapids.cudf.Scalar;
import com.nvidia.spark.rapids.Arm;
import com.nvidia.spark.rapids.CloseableHolder;
import com.nvidia.spark.rapids.RapidsBuffer;
import scala.Function1;
import scala.Option;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;

public final class FloatUtils$
implements Arm {
    public static FloatUtils$ MODULE$;

    static {
        new FloatUtils$();
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T r, Function1<T, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T[] r, Function1<T[], V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T, V> V withResourceIfAllowed(T r, Function1<T, V> block) {
        return (V)Arm.withResourceIfAllowed$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T[] r, Function1<T[], V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends RapidsBuffer, V> V freeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.freeOnExcept$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(CloseableHolder<T> h, Function1<CloseableHolder<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, h, block);
    }

    public ColumnVector nanToZero(ColumnView cv) {
        DType dType = cv.getType();
        DType dType2 = DType.FLOAT32;
        if (dType == null ? dType2 != null : !dType.equals(dType2)) {
            DType dType3 = cv.getType();
            DType dType4 = DType.FLOAT64;
            if (dType3 == null ? dType4 != null : !dType3.equals(dType4)) {
                throw new IllegalArgumentException("Only Floats and Doubles allowed");
            }
        }
        return (ColumnVector)this.withResource(cv.isNan(), (Function1 & java.io.Serializable & Serializable)isNan -> {
            DType dType = cv.getType();
            DType dType2 = DType.FLOAT64;
            return (ColumnVector)MODULE$.withResource(!(dType != null ? !dType.equals(dType2) : dType2 != null) ? Scalar.fromDouble((double)0.0) : Scalar.fromFloat((float)0.0f), (Function1 & java.io.Serializable & Serializable)zero -> isNan.ifElse(zero, cv));
        });
    }

    public Scalar getNanScalar(DType dType) {
        Scalar scalar;
        DType dType2 = dType;
        DType dType3 = DType.FLOAT64;
        if (!(dType2 != null ? !dType2.equals(dType3) : dType3 != null)) {
            scalar = Scalar.fromDouble((double)Double.NaN);
        } else {
            DType dType4 = dType;
            DType dType5 = DType.FLOAT32;
            if (!(dType4 != null ? !dType4.equals(dType5) : dType5 != null)) {
                scalar = Scalar.fromFloat((float)Float.NaN);
            } else {
                throw new IllegalArgumentException("NaNs are only supported for Float types");
            }
        }
        return scalar;
    }

    public Scalar getPositiveInfinityScalar(DType dType) {
        DType dType2 = dType;
        DType dType3 = DType.FLOAT64;
        return !(dType2 != null ? !dType2.equals(dType3) : dType3 != null) ? Scalar.fromDouble((double)Double.POSITIVE_INFINITY) : Scalar.fromFloat((float)Float.POSITIVE_INFINITY);
    }

    public Scalar getNegativeInfinityScalar(DType dType) {
        DType dType2 = dType;
        DType dType3 = DType.FLOAT64;
        return !(dType2 != null ? !dType2.equals(dType3) : dType3 != null) ? Scalar.fromDouble((double)Double.NEGATIVE_INFINITY) : Scalar.fromFloat((float)Float.NEGATIVE_INFINITY);
    }

    public ColumnVector getInfinityVector(DType dtype) {
        DType dType = dtype;
        DType dType2 = DType.FLOAT64;
        return !(dType != null ? !dType.equals(dType2) : dType2 != null) ? ColumnVector.fromDoubles((double[])new double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY}) : ColumnVector.fromFloats((float[])new float[]{Float.POSITIVE_INFINITY, Float.NEGATIVE_INFINITY});
    }

    public ColumnVector infinityToNulls(ColumnVector vec) {
        return (ColumnVector)this.withResource(this.getInfinityVector(vec.getType()), (Function1 & java.io.Serializable & Serializable)infinityVector -> (ColumnVector)MODULE$.withResource(FloatUtils$.getNullVector$1(vec), (Function1 & java.io.Serializable & Serializable)nullVector -> vec.findAndReplaceAll((ColumnView)infinityVector, (ColumnView)nullVector)));
    }

    private static final ColumnVector getNullVector$1(ColumnVector vec$1) {
        DType dType = vec$1.getType();
        DType dType2 = DType.FLOAT64;
        return !(dType != null ? !dType.equals(dType2) : dType2 != null) ? ColumnVector.fromBoxedDoubles((Double[])new Double[]{null, null}) : ColumnVector.fromBoxedFloats((Float[])new Float[]{null, null});
    }

    private FloatUtils$() {
        MODULE$ = this;
        Arm.$init$(this);
    }
}

