/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import com.nvidia.spark.rapids.PlanUtils$;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.execution.ExecSubqueryExpression;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.ReusedSubqueryExec;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.adaptive.AdaptiveSparkPlanExec;
import org.apache.spark.sql.execution.adaptive.QueryStageExec;
import org.apache.spark.sql.execution.exchange.ReusedExchangeExec;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class ExecutionPlanCaptureCallback$ {
    public static ExecutionPlanCaptureCallback$ MODULE$;
    private final AtomicBoolean shouldCapture;
    private final AtomicReference<SparkPlan> execPlan;

    static {
        new ExecutionPlanCaptureCallback$();
    }

    public void com$nvidia$spark$rapids$ExecutionPlanCaptureCallback$$captureIfNeeded(QueryExecution qe) {
        block0: {
            if (!this.shouldCapture.get()) break block0;
            this.execPlan.set(qe.executedPlan());
        }
    }

    public void startCapture() {
        this.execPlan.set(null);
        this.shouldCapture.set(true);
    }

    public Option<SparkPlan> getResultWithTimeout(long timeoutMs) {
        Some some;
        block6: {
            None$ none$;
            block5: {
                try {
                    long endTime = System.currentTimeMillis() + timeoutMs;
                    SparkPlan plan = this.execPlan.getAndSet(null);
                    while (plan == null) {
                        if (System.currentTimeMillis() > endTime) {
                            none$ = None$.MODULE$;
                            break block5;
                        }
                        Thread.sleep(10L);
                        plan = this.execPlan.getAndSet(null);
                    }
                    some = new Some((Object)plan);
                    break block6;
                }
                finally {
                    this.shouldCapture.set(false);
                    this.execPlan.set(null);
                }
            }
            return none$;
        }
        return some;
    }

    public long getResultWithTimeout$default$1() {
        return 2000L;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SparkPlan extractExecutedPlan(Option<SparkPlan> plan) {
        boolean bl = false;
        Some some = null;
        Option<SparkPlan> option = plan;
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            SparkPlan p = (SparkPlan)some.value();
            if (p instanceof AdaptiveSparkPlanExec) {
                AdaptiveSparkPlanExec adaptiveSparkPlanExec = (AdaptiveSparkPlanExec)p;
                return adaptiveSparkPlanExec.executedPlan();
            }
        }
        if (!bl) throw new IllegalStateException("No execution plan available");
        SparkPlan p = (SparkPlan)some.value();
        return p;
    }

    public void assertCapturedAndGpuFellBack(String fallbackCpuClass, long timeoutMs) {
        Option<SparkPlan> gpuPlan = this.getResultWithTimeout(timeoutMs);
        Predef$.MODULE$.assert(gpuPlan.isDefined(), (Function0 & Serializable & scala.Serializable)() -> "Did not capture a GPU plan");
        this.assertDidFallBack((SparkPlan)gpuPlan.get(), fallbackCpuClass);
    }

    public long assertCapturedAndGpuFellBack$default$2() {
        return 2000L;
    }

    public void assertDidFallBack(SparkPlan gpuPlan, String fallbackCpuClass) {
        SparkPlan executedPlan = this.extractExecutedPlan((Option<SparkPlan>)new Some((Object)gpuPlan));
        Predef$.MODULE$.assert(executedPlan.find((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ExecutionPlanCaptureCallback$.MODULE$.didFallBack(x$6, fallbackCpuClass))).isDefined(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Could not find ").append(fallbackCpuClass).append(" in the GPU plan\n").append(executedPlan).toString());
    }

    public void assertDidFallBack(Dataset<Row> df, String fallbackCpuClass) {
        SparkPlan executedPlan = df.queryExecution().executedPlan();
        this.assertDidFallBack(executedPlan, fallbackCpuClass);
    }

    public void assertContains(SparkPlan gpuPlan, String className) {
        Predef$.MODULE$.assert(this.containsPlan(gpuPlan, className, this.containsPlan$default$3()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Could not find ").append(className).append(" in the Spark plan\n").append(gpuPlan).toString());
    }

    public void assertContains(Dataset<Row> df, String gpuClass) {
        SparkPlan executedPlan = df.queryExecution().executedPlan();
        this.assertContains(executedPlan, gpuClass);
    }

    public void assertNotContain(SparkPlan gpuPlan, String className) {
        Predef$.MODULE$.assert(!this.containsPlan(gpuPlan, className, this.containsPlan$default$3()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("We found ").append(className).append(" in the Spark plan\n").append(gpuPlan).toString());
    }

    public void assertNotContain(Dataset<Row> df, String gpuClass) {
        SparkPlan executedPlan = df.queryExecution().executedPlan();
        this.assertNotContain(executedPlan, gpuClass);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean didFallBack(Expression exp, String fallbackCpuClass) {
        if (!exp.getClass().getCanonicalName().equals("com.nvidia.spark.rapids.GpuExpression")) {
            String string = PlanUtils$.MODULE$.getBaseNameFromClass(exp.getClass().getName());
            String string2 = fallbackCpuClass;
            if (string == null) {
                if (string2 == null) return true;
            } else if (string.equals(string2)) return true;
        }
        if (!exp.children().exists((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ExecutionPlanCaptureCallback$.MODULE$.didFallBack(x$7, fallbackCpuClass)))) return false;
        return true;
    }

    private boolean didFallBack(SparkPlan plan, String fallbackCpuClass) {
        SparkPlan executedPlan = this.extractExecutedPlan((Option<SparkPlan>)new Some((Object)plan));
        return !executedPlan.getClass().getCanonicalName().equals("com.nvidia.spark.rapids.GpuExec") && PlanUtils$.MODULE$.sameClass(executedPlan, fallbackCpuClass) || executedPlan.expressions().exists((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ExecutionPlanCaptureCallback$.MODULE$.didFallBack(x$8, fallbackCpuClass)));
    }

    private boolean containsExpression(Expression exp, String className, Map<String, Regex> regexMap) {
        return exp.find((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ExecutionPlanCaptureCallback$.$anonfun$containsExpression$1(className, regexMap, x0$1))).nonEmpty();
    }

    private boolean containsPlan(SparkPlan plan, String className, Map<String, Regex> regexMap) {
        return plan.find((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ExecutionPlanCaptureCallback$.$anonfun$containsPlan$1(className, regexMap, x0$1))).nonEmpty();
    }

    private Map<String, Regex> containsPlan$default$3() {
        return Map$.MODULE$.empty();
    }

    public static final /* synthetic */ boolean $anonfun$containsExpression$1(String className$3, Map regexMap$1, Expression x0$1) {
        boolean bl;
        Expression expression = x0$1;
        String string = PlanUtils$.MODULE$.getBaseNameFromClass(expression.getClass().getName());
        String string2 = className$3;
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            bl = true;
        } else if (expression instanceof ExecSubqueryExpression) {
            ExecSubqueryExpression execSubqueryExpression = (ExecSubqueryExpression)expression;
            bl = MODULE$.containsPlan((SparkPlan)execSubqueryExpression.plan(), className$3, (Map<String, Regex>)regexMap$1);
        } else {
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$containsPlan$1(String className$4, Map regexMap$2, SparkPlan x0$1) {
        boolean bl;
        SparkPlan sparkPlan = x0$1;
        if (PlanUtils$.MODULE$.sameClass(sparkPlan, className$4)) {
            bl = true;
        } else if (sparkPlan instanceof AdaptiveSparkPlanExec) {
            AdaptiveSparkPlanExec adaptiveSparkPlanExec = (AdaptiveSparkPlanExec)sparkPlan;
            bl = MODULE$.containsPlan(adaptiveSparkPlanExec.executedPlan(), className$4, (Map<String, Regex>)regexMap$2);
        } else if (sparkPlan instanceof QueryStageExec) {
            QueryStageExec queryStageExec = (QueryStageExec)sparkPlan;
            bl = MODULE$.containsPlan(queryStageExec.plan(), className$4, (Map<String, Regex>)regexMap$2);
        } else if (sparkPlan instanceof ReusedSubqueryExec) {
            ReusedSubqueryExec reusedSubqueryExec = (ReusedSubqueryExec)sparkPlan;
            bl = MODULE$.containsPlan((SparkPlan)reusedSubqueryExec.child(), className$4, (Map<String, Regex>)regexMap$2);
        } else if (sparkPlan instanceof ReusedExchangeExec) {
            ReusedExchangeExec reusedExchangeExec = (ReusedExchangeExec)sparkPlan;
            bl = MODULE$.containsPlan((SparkPlan)reusedExchangeExec.child(), className$4, (Map<String, Regex>)regexMap$2);
        } else if (sparkPlan.expressions().exists((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)ExecutionPlanCaptureCallback$.MODULE$.containsExpression(x$9, className$4, (Map<String, Regex>)regexMap$2)))) {
            bl = true;
        } else if (sparkPlan != null) {
            SparkPlan sparkPlan2 = sparkPlan;
            String sparkPlanStringForRegex = sparkPlan2.verboseStringWithSuffix(1000);
            bl = ((Regex)regexMap$2.getOrElseUpdate((Object)className$4, (Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(className$4)).r())).findFirstIn((CharSequence)sparkPlanStringForRegex).nonEmpty();
        } else {
            throw new MatchError((Object)sparkPlan);
        }
        return bl;
    }

    private ExecutionPlanCaptureCallback$() {
        MODULE$ = this;
        this.shouldCapture = new AtomicBoolean(false);
        this.execPlan = new AtomicReference();
    }
}

