/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import ai.rapids.cudf.Scalar;
import com.nvidia.spark.rapids.Arm;
import com.nvidia.spark.rapids.CloseableHolder;
import com.nvidia.spark.rapids.ColumnarPartitionReaderWithPartitionValues;
import com.nvidia.spark.rapids.GpuColumnVector;
import com.nvidia.spark.rapids.GpuScalar$;
import com.nvidia.spark.rapids.RapidsBuffer;
import com.nvidia.spark.rapids.RapidsPluginImplicits;
import com.nvidia.spark.rapids.RapidsPluginImplicits$;
import java.io.Serializable;
import org.apache.spark.sql.connector.read.PartitionReader;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class ColumnarPartitionReaderWithPartitionValues$
implements Arm {
    public static ColumnarPartitionReaderWithPartitionValues$ MODULE$;

    static {
        new ColumnarPartitionReaderWithPartitionValues$();
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T r, Function1<T, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T[] r, Function1<T[], V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T, V> V withResourceIfAllowed(T r, Function1<T, V> block) {
        return (V)Arm.withResourceIfAllowed$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T[] r, Function1<T[], V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends RapidsBuffer, V> V freeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.freeOnExcept$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(CloseableHolder<T> h, Function1<CloseableHolder<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, h, block);
    }

    public PartitionReader<ColumnarBatch> newReader(PartitionedFile partFile, PartitionReader<ColumnarBatch> baseReader, StructType partitionSchema) {
        Seq partitionValues = partFile.partitionValues().toSeq(partitionSchema);
        Scalar[] partitionScalars = this.createPartitionValues((Seq<Object>)partitionValues, partitionSchema);
        return new ColumnarPartitionReaderWithPartitionValues(baseReader, partitionScalars, GpuColumnVector.extractTypes(partitionSchema));
    }

    public Scalar[] createPartitionValues(Seq<Object> partitionValues, StructType partitionSchema) {
        DataType[] partitionScalarTypes = (DataType[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionSchema.fields())).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.dataType(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataType.class)));
        return (Scalar[])RapidsPluginImplicits$.MODULE$.AutoCloseableProducingSeq((Seq)partitionValues.zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])partitionScalarTypes), Seq$.MODULE$.canBuildFrom())).safeMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object v = tuple2._1();
            DataType t = (DataType)tuple2._2();
            Scalar scalar = GpuScalar$.MODULE$.from(v, t);
            return scalar;
        }).toArray(ClassTag$.MODULE$.apply(Scalar.class));
    }

    public ColumnarBatch addPartitionValues(ColumnarBatch fileBatch, Scalar[] partitionValues, DataType[] sparkTypes) {
        return (ColumnarBatch)this.withResource(fileBatch, (Function1 & Serializable & scala.Serializable)x$3 -> (ColumnarBatch)MODULE$.closeOnExcept((AutoCloseable)((AutoCloseable[])MODULE$.buildPartitionColumns(fileBatch.numRows(), partitionValues, sparkTypes)), (Function1)(Function1 & Serializable & scala.Serializable)partitionColumns -> MODULE$.addGpuColumVectorsToBatch(fileBatch, (GpuColumnVector[])partitionColumns)));
    }

    public ColumnarBatch addGpuColumVectorsToBatch(ColumnarBatch fileBatch, GpuColumnVector[] partitionColumns) {
        IndexedSeq fileBatchCols = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), fileBatch.numCols()).map((Function1 & Serializable & scala.Serializable)x$1 -> fileBatch.column(BoxesRunTime.unboxToInt((Object)x$1)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq resultCols = (IndexedSeq)fileBatchCols.$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionColumns)), IndexedSeq$.MODULE$.canBuildFrom());
        ColumnarBatch result = new ColumnarBatch((ColumnVector[])resultCols.toArray(ClassTag$.MODULE$.apply(ColumnVector.class)), fileBatch.numRows());
        fileBatchCols.foreach((Function1 & Serializable & scala.Serializable)x$4 -> ((GpuColumnVector)((Object)x$4)).incRefCount());
        return result;
    }

    private GpuColumnVector[] buildPartitionColumns(int numRows, Scalar[] partitionValues, DataType[] sparkTypes) {
        GpuColumnVector[] gpuColumnVectorArray;
        boolean succeeded = false;
        GpuColumnVector[] result = new GpuColumnVector[partitionValues.length];
        try {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                result$1[i] = GpuColumnVector.from(ai.rapids.cudf.ColumnVector.fromScalar((Scalar)partitionValues[i], (int)numRows), sparkTypes[i]);
            });
            succeeded = true;
            gpuColumnVectorArray = result;
        }
        finally {
            if (!succeeded) {
                RapidsPluginImplicits.AutoCloseableArray qual$1 = RapidsPluginImplicits$.MODULE$.AutoCloseableArray((AutoCloseable[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result)).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ColumnarPartitionReaderWithPartitionValues$.$anonfun$buildPartitionColumns$2(x$5))));
                Throwable x$1 = qual$1.safeClose$default$1();
                qual$1.safeClose(x$1);
            }
        }
        return gpuColumnVectorArray;
    }

    public static final /* synthetic */ boolean $anonfun$buildPartitionColumns$2(GpuColumnVector x$5) {
        return x$5 != null;
    }

    private ColumnarPartitionReaderWithPartitionValues$() {
        MODULE$ = this;
        Arm.$init$(this);
    }
}

