/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import ai.rapids.cudf.HostColumnVector;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.vectorized.ColumnVector;

public class ColumnarCopyHelper {
    public static void nullCopy(HostColumnVector.ColumnBuilder b, int rows) {
        for (int i = 0; i < rows; ++i) {
            b.appendNull();
        }
    }

    public static void booleanCopy(ColumnVector cv, HostColumnVector.ColumnBuilder b, int rows) {
        if (!cv.hasNull()) {
            for (int i = 0; i < rows; ++i) {
                b.append(cv.getBoolean(i));
            }
            return;
        }
        for (int i = 0; i < rows; ++i) {
            if (cv.isNullAt(i)) {
                b.appendNull();
                continue;
            }
            b.append(cv.getBoolean(i));
        }
    }

    public static void byteCopy(ColumnVector cv, HostColumnVector.ColumnBuilder b, int rows) {
        if (!cv.hasNull()) {
            for (int i = 0; i < rows; ++i) {
                b.append(cv.getByte(i));
            }
            return;
        }
        for (int i = 0; i < rows; ++i) {
            if (cv.isNullAt(i)) {
                b.appendNull();
                continue;
            }
            b.append(cv.getByte(i));
        }
    }

    public static void shortCopy(ColumnVector cv, HostColumnVector.ColumnBuilder b, int rows) {
        if (!cv.hasNull()) {
            for (int i = 0; i < rows; ++i) {
                b.append(cv.getShort(i));
            }
            return;
        }
        for (int i = 0; i < rows; ++i) {
            if (cv.isNullAt(i)) {
                b.appendNull();
                continue;
            }
            b.append(cv.getShort(i));
        }
    }

    public static void intCopy(ColumnVector cv, HostColumnVector.ColumnBuilder b, int rows) {
        if (!cv.hasNull()) {
            for (int i = 0; i < rows; ++i) {
                b.append(cv.getInt(i));
            }
            return;
        }
        for (int i = 0; i < rows; ++i) {
            if (cv.isNullAt(i)) {
                b.appendNull();
                continue;
            }
            b.append(cv.getInt(i));
        }
    }

    public static void longCopy(ColumnVector cv, HostColumnVector.ColumnBuilder b, int rows) {
        if (!cv.hasNull()) {
            for (int i = 0; i < rows; ++i) {
                b.append(cv.getLong(i));
            }
            return;
        }
        for (int i = 0; i < rows; ++i) {
            if (cv.isNullAt(i)) {
                b.appendNull();
                continue;
            }
            b.append(cv.getLong(i));
        }
    }

    public static void floatCopy(ColumnVector cv, HostColumnVector.ColumnBuilder b, int rows) {
        if (!cv.hasNull()) {
            for (int i = 0; i < rows; ++i) {
                b.append(cv.getFloat(i));
            }
            return;
        }
        for (int i = 0; i < rows; ++i) {
            if (cv.isNullAt(i)) {
                b.appendNull();
                continue;
            }
            b.append(cv.getFloat(i));
        }
    }

    public static void doubleCopy(ColumnVector cv, HostColumnVector.ColumnBuilder b, int rows) {
        if (!cv.hasNull()) {
            for (int i = 0; i < rows; ++i) {
                b.append(cv.getDouble(i));
            }
            return;
        }
        for (int i = 0; i < rows; ++i) {
            if (cv.isNullAt(i)) {
                b.appendNull();
                continue;
            }
            b.append(cv.getDouble(i));
        }
    }

    public static void stringCopy(ColumnVector cv, HostColumnVector.ColumnBuilder b, int rows) {
        if (!cv.hasNull()) {
            for (int i = 0; i < rows; ++i) {
                b.appendUTF8String(cv.getUTF8String(i).getBytes());
            }
            return;
        }
        for (int i = 0; i < rows; ++i) {
            if (cv.isNullAt(i)) {
                b.appendNull();
                continue;
            }
            b.appendUTF8String(cv.getUTF8String(i).getBytes());
        }
    }

    public static void decimal32Copy(WritableColumnVector cv, HostColumnVector.ColumnBuilder b, int rows) {
        ColumnarCopyHelper.intCopy((ColumnVector)cv, b, rows);
    }

    public static void decimal64Copy(WritableColumnVector cv, HostColumnVector.ColumnBuilder b, int rows) {
        ColumnarCopyHelper.longCopy((ColumnVector)cv, b, rows);
    }

    public static void decimal128Copy(WritableColumnVector cv, HostColumnVector.ColumnBuilder b, int rows) {
        if (!cv.hasNull()) {
            for (int i = 0; i < rows; ++i) {
                b.appendDecimal128(cv.getBinary(i));
            }
            return;
        }
        for (int i = 0; i < rows; ++i) {
            if (cv.isNullAt(i)) {
                b.appendNull();
                continue;
            }
            b.appendDecimal128(cv.getBinary(i));
        }
    }

    public static void decimal32Copy(ColumnVector cv, HostColumnVector.ColumnBuilder b, int rows, int precision, int scale) {
        if (!cv.hasNull()) {
            for (int i = 0; i < rows; ++i) {
                b.append((int)cv.getDecimal(i, precision, scale).toUnscaledLong());
            }
            return;
        }
        for (int i = 0; i < rows; ++i) {
            if (cv.isNullAt(i)) {
                b.appendNull();
                continue;
            }
            b.append((int)cv.getDecimal(i, precision, scale).toUnscaledLong());
        }
    }

    public static void decimal64Copy(ColumnVector cv, HostColumnVector.ColumnBuilder b, int rows, int precision, int scale) {
        if (!cv.hasNull()) {
            for (int i = 0; i < rows; ++i) {
                b.append(cv.getDecimal(i, precision, scale).toUnscaledLong());
            }
            return;
        }
        for (int i = 0; i < rows; ++i) {
            if (cv.isNullAt(i)) {
                b.appendNull();
                continue;
            }
            b.append(cv.getDecimal(i, precision, scale).toUnscaledLong());
        }
    }

    public static void decimal128Copy(ColumnVector cv, HostColumnVector.ColumnBuilder b, int rows, int precision, int scale) {
        if (!cv.hasNull()) {
            for (int i = 0; i < rows; ++i) {
                b.append(cv.getDecimal(i, precision, scale).toJavaBigDecimal());
            }
            return;
        }
        for (int i = 0; i < rows; ++i) {
            if (cv.isNullAt(i)) {
                b.appendNull();
                continue;
            }
            b.append(cv.getDecimal(i, precision, scale).toJavaBigDecimal());
        }
    }
}

