/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import ai.rapids.cudf.BaseDeviceMemoryBuffer;
import ai.rapids.cudf.ContiguousTable;
import ai.rapids.cudf.Cuda;
import ai.rapids.cudf.DeviceMemoryBuffer;
import ai.rapids.cudf.NvtxColor;
import ai.rapids.cudf.NvtxRange;
import com.nvidia.spark.rapids.Arm;
import com.nvidia.spark.rapids.CloseableHolder;
import com.nvidia.spark.rapids.CompressedTable;
import com.nvidia.spark.rapids.RapidsBuffer;
import com.nvidia.spark.rapids.RapidsPluginImplicits;
import com.nvidia.spark.rapids.RapidsPluginImplicits$;
import java.io.Serializable;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0001e4QAD\b\u0002\u0002aA\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\tu\u0001\u0011\t\u0011)A\u0005w!)\u0001\n\u0001C\u0001\u0013\"1Q\n\u0001Q\u0001\n9Ca!\u0017\u0001!\u0002\u0013Q\u0006B\u00020\u0001A\u0003&A\u0007C\u0003`\u0001\u0011\u0005\u0001\rC\u0003g\u0001\u0011\u0005q\rC\u0003m\u0001\u0011\u0005Q\u000eC\u0003p\u0001\u0011\u0005\u0003\u000fC\u0003r\u0001\u0011%\u0001\u000fC\u0003s\u0001\u0011E1\u000fC\u0003v\u0001\u0019EaO\u0001\fCCR\u001c\u0007.\u001a3UC\ndWmQ8naJ,7o]8s\u0015\t\u0001\u0012#\u0001\u0004sCBLGm\u001d\u0006\u0003%M\tQa\u001d9be.T!\u0001F\u000b\u0002\r94\u0018\u000eZ5b\u0015\u00051\u0012aA2p[\u000e\u00011#\u0002\u0001\u001aC\u0011B\u0003C\u0001\u000e \u001b\u0005Y\"B\u0001\u000f\u001e\u0003\u0011a\u0017M\\4\u000b\u0003y\tAA[1wC&\u0011\u0001e\u0007\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005i\u0011\u0013BA\u0012\u001c\u00055\tU\u000f^8DY>\u001cX-\u00192mKB\u0011QEJ\u0007\u0002\u001f%\u0011qe\u0004\u0002\u0004\u0003Jl\u0007CA\u00152\u001b\u0005Q#BA\u0016-\u0003!Ig\u000e^3s]\u0006d'B\u0001\n.\u0015\tqs&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002a\u0005\u0019qN]4\n\u0005IR#a\u0002'pO\u001eLgnZ\u0001\u0013[\u0006D()\u0019;dQ6+Wn\u001c:z'&TX\r\u0005\u00026q5\taGC\u00018\u0003\u0015\u00198-\u00197b\u0013\tIdG\u0001\u0003M_:<\u0017AB:ue\u0016\fW\u000e\u0005\u0002=\u000b:\u0011QhQ\u0007\u0002})\u0011q\bQ\u0001\u0005GV$gM\u0003\u0002\u0011\u0003*\t!)\u0001\u0002bS&\u0011AIP\u0001\u0005\u0007V$\u0017-\u0003\u0002G\u000f\n11\u000b\u001e:fC6T!\u0001\u0012 \u0002\rqJg.\u001b;?)\rQ5\n\u0014\t\u0003K\u0001AQaM\u0002A\u0002QBQAO\u0002A\u0002m\na\u0001^1cY\u0016\u001c\bcA(U-6\t\u0001K\u0003\u0002R%\u00069Q.\u001e;bE2,'BA*7\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003+B\u00131\"\u0011:sCf\u0014UO\u001a4feB\u0011QhV\u0005\u00031z\u0012qbQ8oi&<Wo\\;t)\u0006\u0014G.Z\u0001\be\u0016\u001cX\u000f\u001c;t!\ryEk\u0017\t\u0003KqK!!X\b\u0003\u001f\r{W\u000e\u001d:fgN,G\rV1cY\u0016\fABY1uG\"lU-\\+tK\u0012\f!#\u00193e)\u0006\u0014G.\u001a+p\u0007>l\u0007O]3tgR\u0011\u0011\r\u001a\t\u0003k\tL!a\u0019\u001c\u0003\tUs\u0017\u000e\u001e\u0005\u0006K\u001e\u0001\rAV\u0001\fG>tG/[4UC\ndW-A\u0005bI\u0012$\u0016M\u00197fgR\u0011\u0011\r\u001b\u0005\u0006K\"\u0001\r!\u001b\t\u0004k)4\u0016BA67\u0005\u0015\t%O]1z\u0003\u00191\u0017N\\5tQR\ta\u000eE\u00026Un\u000bQa\u00197pg\u0016$\u0012!Y\u0001\u000eG>l\u0007O]3tg\n\u000bGo\u00195\u0002-I,7/\u001b>f\u001fZ,'o]5{K\u0012|U\u000f\u001e9viN$\"A\u001c;\t\u000b5c\u0001\u0019\u00018\u0002\u0011\r|W\u000e\u001d:fgN$2A\\<y\u0011\u0015iU\u00021\u0001j\u0011\u0015QT\u00021\u0001<\u0001")
public abstract class BatchedTableCompressor
implements AutoCloseable,
Arm,
Logging {
    private final long maxBatchMemorySize;
    private final Cuda.Stream stream;
    private final ArrayBuffer<ContiguousTable> tables;
    private final ArrayBuffer<CompressedTable> results;
    private long batchMemUsed;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T r, Function1<T, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T[] r, Function1<T[], V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T, V> V withResourceIfAllowed(T r, Function1<T, V> block) {
        return (V)Arm.withResourceIfAllowed$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T[] r, Function1<T[], V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends RapidsBuffer, V> V freeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.freeOnExcept$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(CloseableHolder<T> h, Function1<CloseableHolder<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, h, block);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public void addTableToCompress(ContiguousTable contigTable2) {
        this.closeOnExcept(contigTable2, (Function1 & Serializable & scala.Serializable)contigTable -> {
            BatchedTableCompressor.$anonfun$addTableToCompress$1(this, contigTable);
            return BoxedUnit.UNIT;
        });
    }

    public void addTables(ContiguousTable[] contigTable) {
        IntRef i = IntRef.create((int)0);
        try {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])contigTable)).foreach((Function1 & Serializable & scala.Serializable)ct -> {
                BatchedTableCompressor.$anonfun$addTables$1(this, i, ct);
                return BoxedUnit.UNIT;
            });
        }
        catch (Throwable t) {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])contigTable)).drop(i.elem))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                BatchedTableCompressor.$anonfun$addTables$2(x$1);
                return BoxedUnit.UNIT;
            });
            throw t;
        }
    }

    /*
     * WARNING - void declaration
     */
    public CompressedTable[] finish() {
        void var1_1;
        this.compressBatch();
        CompressedTable[] compressedTables = (CompressedTable[])this.results.toArray(ClassTag$.MODULE$.apply(CompressedTable.class));
        this.results.clear();
        this.stream.sync();
        return var1_1;
    }

    @Override
    public void close() {
        RapidsPluginImplicits.AutoCloseableSeq qual$1 = RapidsPluginImplicits$.MODULE$.AutoCloseableSeq(this.tables);
        Throwable x$1 = qual$1.safeClose$default$1();
        qual$1.safeClose(x$1);
        this.tables.clear();
        RapidsPluginImplicits.AutoCloseableSeq qual$2 = RapidsPluginImplicits$.MODULE$.AutoCloseableSeq(this.results);
        Throwable x$2 = qual$2.safeClose$default$1();
        qual$2.safeClose(x$2);
        this.results.clear();
    }

    private void compressBatch() {
        block0: {
            if (!this.tables.nonEmpty()) break block0;
            this.withResource(new NvtxRange("batch compress", NvtxColor.ORANGE), (Function1 & Serializable & scala.Serializable)x$2 -> {
                BatchedTableCompressor.$anonfun$compressBatch$1(this, x$2);
                return BoxedUnit.UNIT;
            });
        }
    }

    public CompressedTable[] resizeOversizedOutputs(CompressedTable[] tables) {
        return (CompressedTable[])this.withResource(new NvtxRange("copy compressed buffers", NvtxColor.PURPLE), (Function1 & Serializable & scala.Serializable)x$5 -> (CompressedTable[])this.withResource((AutoCloseable)tables, (Function1)(Function1 & Serializable & scala.Serializable)x$6 -> (CompressedTable[])RapidsPluginImplicits$.MODULE$.AutoCloseableProducingArray(tables).safeMap((Function1 & Serializable & scala.Serializable)ct -> {
            DeviceMemoryBuffer deviceMemoryBuffer;
            if (ct.buffer().getLength() > ct.compressedSize()) {
                deviceMemoryBuffer = (DeviceMemoryBuffer)this.closeOnExcept(DeviceMemoryBuffer.allocate((long)ct.compressedSize()), (Function1 & Serializable & scala.Serializable)buffer -> {
                    buffer.copyFromDeviceBufferAsync(0L, (BaseDeviceMemoryBuffer)ct.buffer(), 0L, ct.compressedSize(), $this.stream);
                    return buffer;
                });
            } else {
                ct.buffer().incRefCount();
                deviceMemoryBuffer = ct.buffer();
            }
            DeviceMemoryBuffer newBuffer = deviceMemoryBuffer;
            return new CompressedTable(ct.compressedSize(), ct.meta(), newBuffer);
        }, ClassTag$.MODULE$.apply(CompressedTable.class))));
    }

    public abstract CompressedTable[] compress(ContiguousTable[] var1, Cuda.Stream var2);

    public static final /* synthetic */ void $anonfun$addTableToCompress$1(BatchedTableCompressor $this, ContiguousTable contigTable) {
        long memNeededToCompressThisBuffer = contigTable.getBuffer().getLength();
        if ($this.batchMemUsed + memNeededToCompressThisBuffer > $this.maxBatchMemorySize) {
            $this.compressBatch();
        }
        $this.tables.$plus$eq((Object)contigTable);
        $this.batchMemUsed += memNeededToCompressThisBuffer;
    }

    public static final /* synthetic */ void $anonfun$addTables$1(BatchedTableCompressor $this, IntRef i$1, ContiguousTable ct) {
        $this.addTableToCompress(ct);
        ++i$1.elem;
    }

    public static final /* synthetic */ void $anonfun$addTables$2(ContiguousTable x$1) {
        RapidsPluginImplicits.AutoCloseableColumn qual$1 = RapidsPluginImplicits$.MODULE$.AutoCloseableColumn((AutoCloseable)x$1);
        Throwable x$12 = qual$1.safeClose$default$1();
        qual$1.safeClose(x$12);
    }

    public static final /* synthetic */ long $anonfun$compressBatch$2(ContiguousTable x$3) {
        return x$3.getBuffer().getLength();
    }

    public static final /* synthetic */ void $anonfun$compressBatch$1(BatchedTableCompressor $this, NvtxRange x$2) {
        long startTime = System.nanoTime();
        CompressedTable[] compressedTables = $this.compress((ContiguousTable[])$this.tables.toArray(ClassTag$.MODULE$.apply(ContiguousTable.class)), $this.stream);
        $this.results.$plus$plus$eq((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])compressedTables)));
        Predef$.MODULE$.require(compressedTables.length == $this.tables.length());
        if ($this.log().isDebugEnabled()) {
            float duration = System.nanoTime() - startTime;
            long inputSize = BoxesRunTime.unboxToLong((Object)((TraversableOnce)$this.tables.map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)BatchedTableCompressor.$anonfun$compressBatch$2(x$3)), ArrayBuffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            long outputSize = BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])compressedTables)).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.compressedSize()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Compressed ").append($this.tables.length()).append(" tables from ").append(inputSize).append(" to ").append(outputSize).append(" ").append("in ").append(duration / (float)1000000).append(" msec rate=").append((float)((double)inputSize / (double)duration)).append(" GB/s ").append("ratio=").append((float)outputSize / (float)inputSize).toString());
        }
        RapidsPluginImplicits.AutoCloseableSeq qual$1 = RapidsPluginImplicits$.MODULE$.AutoCloseableSeq($this.tables);
        Throwable x$1 = qual$1.safeClose$default$1();
        qual$1.safeClose(x$1);
        $this.tables.clear();
        $this.batchMemUsed = 0L;
    }

    public BatchedTableCompressor(long maxBatchMemorySize, Cuda.Stream stream) {
        this.maxBatchMemorySize = maxBatchMemorySize;
        this.stream = stream;
        Arm.$init$(this);
        Logging.$init$((Logging)this);
        this.tables = new ArrayBuffer();
        this.results = new ArrayBuffer();
        this.batchMemUsed = 0L;
    }
}

