/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import ai.rapids.cudf.BaseDeviceMemoryBuffer;
import ai.rapids.cudf.Cuda;
import ai.rapids.cudf.DeviceMemoryBuffer;
import ai.rapids.cudf.NvtxColor;
import ai.rapids.cudf.NvtxRange;
import com.nvidia.spark.rapids.Arm;
import com.nvidia.spark.rapids.CloseableHolder;
import com.nvidia.spark.rapids.RapidsBuffer;
import com.nvidia.spark.rapids.RapidsPluginImplicits;
import com.nvidia.spark.rapids.RapidsPluginImplicits$;
import com.nvidia.spark.rapids.format.BufferMeta;
import com.nvidia.spark.rapids.format.CodecBufferDescriptor;
import java.io.Serializable;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%a!\u0002\b\u0010\u0003\u0003A\u0002\u0002C\u001a\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001b\t\u0011i\u0002!\u0011!Q\u0001\nmBQ\u0001\u0013\u0001\u0005\u0002%Ca!\u0014\u0001!\u0002\u0013q\u0005BB-\u0001A\u0003%!\f\u0003\u0004b\u0001\u0001\u0006IA\u0019\u0005\u0007M\u0002\u0001\u000b\u0015\u0002\u001b\t\u000f\u001d\u0004!\u0019!D\u0001Q\")A\u000e\u0001C\u0001[\")Q\u000f\u0001C\u0001m\")!\u0010\u0001C!w\")A\u0010\u0001C\tw\")Q\u0010\u0001D\t}\nI\")\u0019;dQ\u0016$')\u001e4gKJ$UmY8naJ,7o]8s\u0015\t\u0001\u0012#\u0001\u0004sCBLGm\u001d\u0006\u0003%M\tQa\u001d9be.T!\u0001F\u000b\u0002\r94\u0018\u000eZ5b\u0015\u00051\u0012aA2p[\u000e\u00011#\u0002\u0001\u001aC\u0011B\u0003C\u0001\u000e \u001b\u0005Y\"B\u0001\u000f\u001e\u0003\u0011a\u0017M\\4\u000b\u0003y\tAA[1wC&\u0011\u0001e\u0007\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005i\u0011\u0013BA\u0012\u001c\u00055\tU\u000f^8DY>\u001cX-\u00192mKB\u0011QEJ\u0007\u0002\u001f%\u0011qe\u0004\u0002\u0004\u0003Jl\u0007CA\u00152\u001b\u0005Q#BA\u0016-\u0003!Ig\u000e^3s]\u0006d'B\u0001\n.\u0015\tqs&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002a\u0005\u0019qN]4\n\u0005IR#a\u0002'pO\u001eLgnZ\u0001\u0013[\u0006D()\u0019;dQ6+Wn\u001c:z'&TX\r\u0005\u00026q5\taGC\u00018\u0003\u0015\u00198-\u00197b\u0013\tIdG\u0001\u0003M_:<\u0017AB:ue\u0016\fW\u000e\u0005\u0002=\u000b:\u0011QhQ\u0007\u0002})\u0011q\bQ\u0001\u0005GV$gM\u0003\u0002\u0011\u0003*\t!)\u0001\u0002bS&\u0011AIP\u0001\u0005\u0007V$\u0017-\u0003\u0002G\u000f\n11\u000b\u001e:fC6T!\u0001\u0012 \u0002\rqJg.\u001b;?)\rQ5\n\u0014\t\u0003K\u0001AQaM\u0002A\u0002QBQAO\u0002A\u0002m\nA\"\u001b8qkR\u0014UO\u001a4feN\u00042a\u0014+W\u001b\u0005\u0001&BA)S\u0003\u001diW\u000f^1cY\u0016T!a\u0015\u001c\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002V!\nY\u0011I\u001d:bs\n+hMZ3s!\tit+\u0003\u0002Y}\t1\")Y:f\t\u00164\u0018nY3NK6|'/\u001f\"vM\u001a,'/A\u0006ck\u001a4WM]'fi\u0006\u001c\bcA(U7B\u0011AlX\u0007\u0002;*\u0011alD\u0001\u0007M>\u0014X.\u0019;\n\u0005\u0001l&A\u0003\"vM\u001a,'/T3uC\u00069!/Z:vYR\u001c\bcA(UGB\u0011Q\bZ\u0005\u0003Kz\u0012!\u0003R3wS\u000e,W*Z7pef\u0014UO\u001a4fe\u0006a!-\u0019;dQ6+W.V:fI\u000691m\u001c3fG&#W#A5\u0011\u0005UR\u0017BA67\u0005\u0011\u0011\u0015\u0010^3\u0002+\u0005$GMQ;gM\u0016\u0014Hk\u001c#fG>l\u0007O]3tgR\u0019a.]:\u0011\u0005Uz\u0017B\u000197\u0005\u0011)f.\u001b;\t\u000bIL\u0001\u0019\u0001,\u0002\r\t,hMZ3s\u0011\u0015!\u0018\u00021\u0001\\\u0003\u0011iW\r^1\u0002\u0017\u0019Lg.[:i\u0003NLhn\u0019\u000b\u0002oB\u0019Q\u0007_2\n\u0005e4$!B!se\u0006L\u0018!B2m_N,G#\u00018\u0002\u001f\u0011,7m\\7qe\u0016\u001c8OQ1uG\"\fq\u0002Z3d_6\u0004(/Z:t\u0003NLhn\u0019\u000b\u0007o~\f\u0019!a\u0002\t\r5k\u0001\u0019AA\u0001!\r)\u0004P\u0016\u0005\u000736\u0001\r!!\u0002\u0011\u0007UB8\fC\u0003;\u001b\u0001\u00071\b")
public abstract class BatchedBufferDecompressor
implements AutoCloseable,
Arm,
Logging {
    private final long maxBatchMemorySize;
    private final Cuda.Stream stream;
    private final ArrayBuffer<BaseDeviceMemoryBuffer> inputBuffers;
    private final ArrayBuffer<BufferMeta> bufferMetas;
    private final ArrayBuffer<DeviceMemoryBuffer> results;
    private long batchMemUsed;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T r, Function1<T, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T[] r, Function1<T[], V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T, V> V withResourceIfAllowed(T r, Function1<T, V> block) {
        return (V)Arm.withResourceIfAllowed$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T[] r, Function1<T[], V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends RapidsBuffer, V> V freeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.freeOnExcept$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(CloseableHolder<T> h, Function1<CloseableHolder<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, h, block);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public abstract byte codecId();

    public void addBufferToDecompress(BaseDeviceMemoryBuffer buffer2, BufferMeta meta) {
        this.closeOnExcept(buffer2, (Function1 & Serializable & scala.Serializable)buffer -> {
            Predef$.MODULE$.require(meta.codecBufferDescrsLength() == 1);
            CodecBufferDescriptor descr = meta.codecBufferDescrs(0);
            Predef$.MODULE$.require(descr.codec() == this.codecId());
            Predef$.MODULE$.require(descr.compressedOffset() == 0L);
            Predef$.MODULE$.require(descr.compressedSize() == buffer.getLength());
            long outputNeeded = descr.uncompressedSize();
            if ($this.batchMemUsed + outputNeeded > $this.maxBatchMemorySize) {
                this.decompressBatch();
            }
            $this.batchMemUsed += outputNeeded;
            $this.bufferMetas.$plus$eq((Object)meta);
            return $this.inputBuffers.$plus$eq(buffer);
        });
    }

    /*
     * WARNING - void declaration
     */
    public DeviceMemoryBuffer[] finishAsync() {
        void var1_1;
        this.decompressBatch();
        DeviceMemoryBuffer[] resultsArray = (DeviceMemoryBuffer[])this.results.toArray(ClassTag$.MODULE$.apply(DeviceMemoryBuffer.class));
        this.results.clear();
        return var1_1;
    }

    @Override
    public void close() {
        RapidsPluginImplicits.AutoCloseableSeq qual$1 = RapidsPluginImplicits$.MODULE$.AutoCloseableSeq(this.inputBuffers);
        Throwable x$1 = qual$1.safeClose$default$1();
        qual$1.safeClose(x$1);
        this.inputBuffers.clear();
        this.bufferMetas.clear();
        RapidsPluginImplicits.AutoCloseableSeq qual$2 = RapidsPluginImplicits$.MODULE$.AutoCloseableSeq(this.results);
        Throwable x$2 = qual$2.safeClose$default$1();
        qual$2.safeClose(x$2);
        this.results.clear();
    }

    public void decompressBatch() {
        block0: {
            if (!this.inputBuffers.nonEmpty()) break block0;
            this.withResource(new NvtxRange("batch decompress", NvtxColor.ORANGE), (Function1 & Serializable & scala.Serializable)x$7 -> {
                BatchedBufferDecompressor.$anonfun$decompressBatch$1(this, x$7);
                return BoxedUnit.UNIT;
            });
        }
    }

    public abstract DeviceMemoryBuffer[] decompressAsync(BaseDeviceMemoryBuffer[] var1, BufferMeta[] var2, Cuda.Stream var3);

    public static final /* synthetic */ void $anonfun$decompressBatch$1(BatchedBufferDecompressor $this, NvtxRange x$7) {
        long startTime = System.nanoTime();
        DeviceMemoryBuffer[] uncompressedBuffers = $this.decompressAsync((BaseDeviceMemoryBuffer[])$this.inputBuffers.toArray(ClassTag$.MODULE$.apply(BaseDeviceMemoryBuffer.class)), (BufferMeta[])$this.bufferMetas.toArray(ClassTag$.MODULE$.apply(BufferMeta.class)), $this.stream);
        $this.results.$plus$plus$eq((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])uncompressedBuffers)));
        Predef$.MODULE$.require(uncompressedBuffers.length == $this.inputBuffers.length());
        if ($this.log().isDebugEnabled()) {
            float duration = System.nanoTime() - startTime;
            long inputSize = BoxesRunTime.unboxToLong((Object)((TraversableOnce)$this.inputBuffers.map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8.getLength()), ArrayBuffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            long outputSize = BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])uncompressedBuffers)).map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9.getLength()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Decompressed ").append($this.inputBuffers.length()).append(" buffers from ").append(inputSize).append(" ").append("to ").append(outputSize).append(" in ").append(duration / (float)1000000).append(" msec rate=").append((float)((double)outputSize / (double)duration)).append(" GB/s").toString());
        }
        RapidsPluginImplicits.AutoCloseableSeq qual$1 = RapidsPluginImplicits$.MODULE$.AutoCloseableSeq($this.inputBuffers);
        Throwable x$1 = qual$1.safeClose$default$1();
        qual$1.safeClose(x$1);
        $this.inputBuffers.clear();
        $this.bufferMetas.clear();
        $this.batchMemUsed = 0L;
    }

    public BatchedBufferDecompressor(long maxBatchMemorySize, Cuda.Stream stream) {
        this.maxBatchMemorySize = maxBatchMemorySize;
        this.stream = stream;
        Arm.$init$(this);
        Logging.$init$((Logging)this);
        this.inputBuffers = new ArrayBuffer();
        this.bufferMetas = new ArrayBuffer();
        this.results = new ArrayBuffer();
        this.batchMemUsed = 0L;
    }
}

