/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.rapids.shims;

import ai.rapids.cudf.BinaryOperable;
import ai.rapids.cudf.ColumnVector;
import ai.rapids.cudf.ColumnView;
import ai.rapids.cudf.DType;
import ai.rapids.cudf.RoundMode;
import ai.rapids.cudf.Scalar;
import com.nvidia.spark.rapids.Arm;
import com.nvidia.spark.rapids.BoolUtils$;
import com.nvidia.spark.rapids.CloseableHolder;
import com.nvidia.spark.rapids.RapidsBuffer;
import java.io.Serializable;
import java.math.BigInteger;
import org.apache.spark.sql.rapids.shims.RapidsErrorUtils$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class IntervalUtils$
implements Arm {
    public static IntervalUtils$ MODULE$;

    static {
        new IntervalUtils$();
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T r, Function1<T, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T[] r, Function1<T[], V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T, V> V withResourceIfAllowed(T r, Function1<T, V> block) {
        return (V)Arm.withResourceIfAllowed$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T[] r, Function1<T[], V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends RapidsBuffer, V> V freeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.freeOnExcept$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(CloseableHolder<T> h, Function1<CloseableHolder<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, h, block);
    }

    public ColumnVector castLongToIntWithOverflowCheck(ColumnView longCv) {
        return (ColumnVector)this.withResource(longCv.castTo(DType.INT32), (Function1 & Serializable & scala.Serializable)intResult -> (ColumnVector)MODULE$.withResource(longCv.notEqualTo((BinaryOperable)intResult), (Function1 & Serializable & scala.Serializable)notEquals -> {
            if (BoolUtils$.MODULE$.isAnyValidTrue((ColumnVector)notEquals)) {
                throw RapidsErrorUtils$.MODULE$.arithmeticOverflowError("overflow occurs", RapidsErrorUtils$.MODULE$.arithmeticOverflowError$default$2(), RapidsErrorUtils$.MODULE$.arithmeticOverflowError$default$3());
            }
            return intResult.incRefCount();
        }));
    }

    public void checkDecimal128CvInRange(ColumnView decimal128Cv, long minValue, long maxValue) {
        this.withResource(Scalar.fromLong((long)minValue), (Function1 & Serializable & scala.Serializable)minScalar -> {
            IntervalUtils$.MODULE$.withResource(decimal128Cv.lessThan((BinaryOperable)minScalar), (Function1 & Serializable & scala.Serializable)lessThanMin -> {
                IntervalUtils$.$anonfun$checkDecimal128CvInRange$2(lessThanMin);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        this.withResource(Scalar.fromLong((long)maxValue), (Function1 & Serializable & scala.Serializable)maxScalar -> {
            IntervalUtils$.MODULE$.withResource(decimal128Cv.greaterThan((BinaryOperable)maxScalar), (Function1 & Serializable & scala.Serializable)greaterThanMax -> {
                IntervalUtils$.$anonfun$checkDecimal128CvInRange$4(greaterThanMax);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
    }

    public ColumnVector multipleToLongWithOverflowCheck(BinaryOperable left, BinaryOperable right) {
        DType decimal128Type = DType.create((DType.DTypeEnum)DType.DTypeEnum.DECIMAL128, (int)0);
        return (ColumnVector)this.withResource(left.mul(right, decimal128Type), (Function1 & Serializable & scala.Serializable)ret -> {
            MODULE$.checkDecimal128CvInRange((ColumnView)ret, Long.MIN_VALUE, Long.MAX_VALUE);
            return ret.castTo(DType.INT64);
        });
    }

    public ColumnVector multipleToIntWithOverflowCheck(BinaryOperable left, BinaryOperable right) {
        DType decimal128Type = DType.create((DType.DTypeEnum)DType.DTypeEnum.DECIMAL128, (int)0);
        return (ColumnVector)this.withResource(left.mul(right, decimal128Type), (Function1 & Serializable & scala.Serializable)ret -> {
            MODULE$.checkDecimal128CvInRange((ColumnView)ret, Integer.MIN_VALUE, Integer.MAX_VALUE);
            return ret.castTo(DType.INT32);
        });
    }

    public void checkDoubleInfNan(ColumnVector doubleCv) {
        this.withResource(Scalar.fromDouble((double)Double.POSITIVE_INFINITY), (Function1 & Serializable & scala.Serializable)positiveInfScalar -> {
            IntervalUtils$.MODULE$.withResource(doubleCv.equalTo((BinaryOperable)positiveInfScalar), (Function1 & Serializable & scala.Serializable)equalsInfinity -> {
                IntervalUtils$.$anonfun$checkDoubleInfNan$2(equalsInfinity);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        this.withResource(Scalar.fromDouble((double)Double.NEGATIVE_INFINITY), (Function1 & Serializable & scala.Serializable)negativeInfScalar -> {
            IntervalUtils$.MODULE$.withResource(doubleCv.equalTo((BinaryOperable)negativeInfScalar), (Function1 & Serializable & scala.Serializable)equalsInfinity -> {
                IntervalUtils$.$anonfun$checkDoubleInfNan$4(equalsInfinity);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        this.withResource(doubleCv.isNan(), (Function1 & Serializable & scala.Serializable)isNan -> {
            IntervalUtils$.$anonfun$checkDoubleInfNan$5(isNan);
            return BoxedUnit.UNIT;
        });
    }

    public ColumnVector roundDoubleToIntWithOverflowCheck(ColumnVector doubleCv) {
        this.checkDoubleInfNan(doubleCv);
        return (ColumnVector)this.withResource(doubleCv.round(RoundMode.HALF_UP), (Function1 & Serializable & scala.Serializable)roundedDouble -> (ColumnVector)MODULE$.withResource(roundedDouble.castTo(DType.INT64), (Function1 & Serializable & scala.Serializable)columnVector -> MODULE$.castLongToIntWithOverflowCheck((ColumnView)columnVector)));
    }

    public ColumnVector roundDoubleToLongWithOverflowCheck(ColumnVector doubleCv) {
        this.checkDoubleInfNan(doubleCv);
        return this.roundToLongWithCheck(doubleCv);
    }

    public ColumnVector roundToLongWithCheck(ColumnVector doubleCv) {
        double MIN_LONG_AS_DOUBLE = -9.223372036854776E18;
        double MAX_LONG_AS_DOUBLE_PLUS_ONE = 9.223372036854776E18;
        return (ColumnVector)this.withResource(doubleCv.round(RoundMode.HALF_UP), (Function1 & Serializable & scala.Serializable)z -> {
            MODULE$.withResource(Scalar.fromDouble((double)MAX_LONG_AS_DOUBLE_PLUS_ONE), (Function1 & Serializable & scala.Serializable)max -> {
                IntervalUtils$.MODULE$.withResource(z.greaterOrEqualTo((BinaryOperable)max), (Function1 & Serializable & scala.Serializable)invalid -> {
                    IntervalUtils$.$anonfun$roundToLongWithCheck$3(invalid);
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            });
            MODULE$.withResource(Scalar.fromDouble((double)MIN_LONG_AS_DOUBLE), (Function1 & Serializable & scala.Serializable)min -> {
                IntervalUtils$.MODULE$.withResource(min.sub((BinaryOperable)z), (Function1 & Serializable & scala.Serializable)diff -> {
                    IntervalUtils$.MODULE$.withResource(Scalar.fromDouble((double)1.0), (Function1 & Serializable & scala.Serializable)one -> {
                        IntervalUtils$.MODULE$.withResource(diff.greaterOrEqualTo((BinaryOperable)one), (Function1 & Serializable & scala.Serializable)invalid -> {
                            IntervalUtils$.$anonfun$roundToLongWithCheck$7(invalid);
                            return BoxedUnit.UNIT;
                        });
                        return BoxedUnit.UNIT;
                    });
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            });
            return z.castTo(DType.INT64);
        });
    }

    public double getDouble(Scalar s) {
        double d;
        DType dType = s.getType();
        DType dType2 = DType.INT8;
        DType dType3 = dType;
        if (!(dType2 != null ? !dType2.equals(dType3) : dType3 != null)) {
            d = s.getByte();
        } else {
            DType dType4 = DType.INT16;
            DType dType5 = dType;
            if (!(dType4 != null ? !dType4.equals(dType5) : dType5 != null)) {
                d = s.getShort();
            } else {
                DType dType6 = DType.INT32;
                DType dType7 = dType;
                if (!(dType6 != null ? !dType6.equals(dType7) : dType7 != null)) {
                    d = s.getInt();
                } else {
                    DType dType8 = DType.INT64;
                    DType dType9 = dType;
                    if (!(dType8 != null ? !dType8.equals(dType9) : dType9 != null)) {
                        d = s.getLong();
                    } else {
                        DType dType10 = DType.FLOAT32;
                        DType dType11 = dType;
                        if (!(dType10 != null ? !dType10.equals(dType11) : dType11 != null)) {
                            d = s.getFloat();
                        } else {
                            DType dType12 = DType.FLOAT64;
                            DType dType13 = dType;
                            if (!(dType12 != null ? !dType12.equals(dType13) : dType13 != null)) {
                                d = s.getDouble();
                            } else {
                                throw new IllegalArgumentException(new StringBuilder(16).append("Unexpected type ").append(dType).toString());
                            }
                        }
                    }
                }
            }
        }
        return d;
    }

    public long getLong(Scalar s) {
        long l;
        DType dType = s.getType();
        DType dType2 = DType.INT8;
        DType dType3 = dType;
        if (!(dType2 != null ? !dType2.equals(dType3) : dType3 != null)) {
            l = s.getByte();
        } else {
            DType dType4 = DType.INT16;
            DType dType5 = dType;
            if (!(dType4 != null ? !dType4.equals(dType5) : dType5 != null)) {
                l = s.getShort();
            } else {
                DType dType6 = DType.INT32;
                DType dType7 = dType;
                if (!(dType6 != null ? !dType6.equals(dType7) : dType7 != null)) {
                    l = s.getInt();
                } else {
                    DType dType8 = DType.INT64;
                    DType dType9 = dType;
                    if (!(dType8 != null ? !dType8.equals(dType9) : dType9 != null)) {
                        l = s.getLong();
                    } else {
                        throw new IllegalArgumentException(new StringBuilder(16).append("Unexpected type ").append(dType).toString());
                    }
                }
            }
        }
        return l;
    }

    public boolean hasZero(BinaryOperable cv) {
        boolean bl;
        BinaryOperable binaryOperable = cv;
        if (binaryOperable instanceof Scalar) {
            Scalar scalar = (Scalar)binaryOperable;
            bl = this.getDouble(scalar) == 0.0;
        } else if (binaryOperable instanceof ColumnVector) {
            ColumnVector columnVector = (ColumnVector)binaryOperable;
            bl = BoxesRunTime.unboxToBoolean(this.withResource(Scalar.fromInt((int)0), (Function1 & Serializable & scala.Serializable)zero -> BoxesRunTime.boxToBoolean((boolean)IntervalUtils$.$anonfun$hasZero$1(columnVector, zero))));
        } else {
            throw new MatchError((Object)binaryOperable);
        }
        return bl;
    }

    public ColumnVector divWithHalfUpModeWithOverflowCheck(BinaryOperable p, BinaryOperable q) {
        ColumnVector columnVector;
        long l;
        if (this.hasZero(q)) {
            throw new ArithmeticException("overflow: interval / zero");
        }
        DType dType = p.getType();
        DType dType2 = DType.INT32;
        DType dType3 = dType;
        if (!(dType2 != null ? !dType2.equals(dType3) : dType3 != null)) {
            l = Integer.MIN_VALUE;
        } else {
            DType dType4 = DType.INT64;
            DType dType5 = dType;
            if (!(dType4 != null ? !dType4.equals(dType5) : dType5 != null)) {
                l = Long.MIN_VALUE;
            } else {
                throw new IllegalArgumentException(new StringBuilder(16).append("Unexpected type ").append(dType).toString());
            }
        }
        long min = l;
        this.withResource(Scalar.fromLong((long)min), (Function1 & Serializable & scala.Serializable)minScalar -> MODULE$.withResource(Scalar.fromLong((long)-1L), (Function1 & Serializable & scala.Serializable)negOneScalar -> {
            void var6_14;
            Tuple2 tuple2 = new Tuple2((Object)p, (Object)q);
            if (tuple2 != null) {
                BinaryOperable lCv = (BinaryOperable)tuple2._1();
                BinaryOperable rCv = (BinaryOperable)tuple2._2();
                if (lCv instanceof ColumnVector) {
                    ColumnVector columnVector = (ColumnVector)lCv;
                    if (rCv instanceof ColumnVector) {
                        ColumnVector columnVector2 = (ColumnVector)rCv;
                        Object v = MODULE$.withResource(columnVector.equalTo((BinaryOperable)minScalar), (Function1 & Serializable & scala.Serializable)isMin -> {
                            IntervalUtils$.MODULE$.withResource(columnVector2.equalTo((BinaryOperable)negOneScalar), (Function1 & Serializable & scala.Serializable)isNegOne -> {
                                IntervalUtils$.MODULE$.withResource(isMin.and((BinaryOperable)isNegOne), (Function1 & Serializable & scala.Serializable)invalid -> {
                                    IntervalUtils$.$anonfun$divWithHalfUpModeWithOverflowCheck$5(invalid);
                                    return BoxedUnit.UNIT;
                                });
                                return BoxedUnit.UNIT;
                            });
                            return BoxedUnit.UNIT;
                        });
                        return var6_14;
                    }
                }
            }
            if (tuple2 != null) {
                BinaryOperable lCv = (BinaryOperable)tuple2._1();
                BinaryOperable rS = (BinaryOperable)tuple2._2();
                if (lCv instanceof ColumnVector) {
                    ColumnVector columnVector = (ColumnVector)lCv;
                    if (rS instanceof Scalar) {
                        Scalar scalar = (Scalar)rS;
                        Object v = MODULE$.withResource(columnVector.equalTo((BinaryOperable)minScalar), (Function1 & Serializable & scala.Serializable)isMin -> {
                            IntervalUtils$.$anonfun$divWithHalfUpModeWithOverflowCheck$6(scalar, isMin);
                            return BoxedUnit.UNIT;
                        });
                        return var6_14;
                    }
                }
            }
            if (tuple2 != null) {
                BinaryOperable lS = (BinaryOperable)tuple2._1();
                BinaryOperable rCv = (BinaryOperable)tuple2._2();
                if (lS instanceof Scalar) {
                    Scalar scalar = (Scalar)lS;
                    if (rCv instanceof ColumnVector) {
                        ColumnVector columnVector = (ColumnVector)rCv;
                        Object v = MODULE$.withResource(columnVector.equalTo((BinaryOperable)negOneScalar), (Function1 & Serializable & scala.Serializable)isNegOne -> {
                            IntervalUtils$.$anonfun$divWithHalfUpModeWithOverflowCheck$7(scalar, min, isNegOne);
                            return BoxedUnit.UNIT;
                        });
                        return var6_14;
                    }
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            BinaryOperable lS = (BinaryOperable)tuple2._1();
            BinaryOperable rS = (BinaryOperable)tuple2._2();
            if (!(lS instanceof Scalar)) throw new MatchError((Object)tuple2);
            Scalar scalar = (Scalar)lS;
            if (!(rS instanceof Scalar)) throw new MatchError((Object)tuple2);
            Scalar scalar2 = (Scalar)rS;
            Boolean bl = BoxesRunTime.boxToBoolean((MODULE$.getLong(scalar) == min && MODULE$.getLong(scalar2) == -1L ? 1 : 0) != 0);
            return var6_14;
        }));
        DType dT = DType.create((DType.DTypeEnum)DType.DTypeEnum.DECIMAL128, (int)-1);
        BinaryOperable binaryOperable = p;
        if (binaryOperable instanceof ColumnVector) {
            ColumnVector columnVector2 = (ColumnVector)binaryOperable;
            columnVector = columnVector2.castTo(dT);
        } else if (binaryOperable instanceof Scalar) {
            Scalar scalar = (Scalar)binaryOperable;
            columnVector = Scalar.fromDecimal((int)-1, (BigInteger)new BigInteger(Long.toString(this.getLong(scalar) * 10L)));
        } else {
            throw new MatchError((Object)binaryOperable);
        }
        ColumnVector leftDecimal = columnVector;
        return (ColumnVector)this.withResource(((BinaryOperable)leftDecimal).div(q, dT), (Function1 & Serializable & scala.Serializable)t -> t.round(RoundMode.HALF_UP));
    }

    public static final /* synthetic */ void $anonfun$checkDecimal128CvInRange$2(ColumnVector lessThanMin) {
        if (BoolUtils$.MODULE$.isAnyValidTrue(lessThanMin)) {
            throw RapidsErrorUtils$.MODULE$.arithmeticOverflowError("overflow occurs", RapidsErrorUtils$.MODULE$.arithmeticOverflowError$default$2(), RapidsErrorUtils$.MODULE$.arithmeticOverflowError$default$3());
        }
    }

    public static final /* synthetic */ void $anonfun$checkDecimal128CvInRange$4(ColumnVector greaterThanMax) {
        if (BoolUtils$.MODULE$.isAnyValidTrue(greaterThanMax)) {
            throw RapidsErrorUtils$.MODULE$.arithmeticOverflowError("overflow occurs", RapidsErrorUtils$.MODULE$.arithmeticOverflowError$default$2(), RapidsErrorUtils$.MODULE$.arithmeticOverflowError$default$3());
        }
    }

    public static final /* synthetic */ void $anonfun$checkDoubleInfNan$2(ColumnVector equalsInfinity) {
        if (BoolUtils$.MODULE$.isAnyValidTrue(equalsInfinity)) {
            throw new ArithmeticException("Has infinity");
        }
    }

    public static final /* synthetic */ void $anonfun$checkDoubleInfNan$4(ColumnVector equalsInfinity) {
        if (BoolUtils$.MODULE$.isAnyValidTrue(equalsInfinity)) {
            throw new ArithmeticException("Has -infinity");
        }
    }

    public static final /* synthetic */ void $anonfun$checkDoubleInfNan$5(ColumnVector isNan) {
        if (BoolUtils$.MODULE$.isAnyValidTrue(isNan)) {
            throw new ArithmeticException("Has NaN");
        }
    }

    public static final /* synthetic */ void $anonfun$roundToLongWithCheck$3(ColumnVector invalid) {
        if (BoolUtils$.MODULE$.isAnyValidTrue(invalid)) {
            throw new ArithmeticException("Round double to long overflow");
        }
    }

    public static final /* synthetic */ void $anonfun$roundToLongWithCheck$7(ColumnVector invalid) {
        if (BoolUtils$.MODULE$.isAnyValidTrue(invalid)) {
            throw new ArithmeticException("Round double to long overflow");
        }
    }

    public static final /* synthetic */ boolean $anonfun$hasZero$1(ColumnVector x3$1, Scalar zero) {
        return BoxesRunTime.unboxToBoolean(MODULE$.withResource(x3$1.equalTo((BinaryOperable)zero), (Function1 & Serializable & scala.Serializable)isZero -> BoxesRunTime.boxToBoolean((boolean)BoolUtils$.MODULE$.isAnyValidTrue(isZero))));
    }

    public static final /* synthetic */ void $anonfun$divWithHalfUpModeWithOverflowCheck$5(ColumnVector invalid) {
        if (BoolUtils$.MODULE$.isAnyValidTrue(invalid)) {
            throw RapidsErrorUtils$.MODULE$.overflowInIntegralDivideError(RapidsErrorUtils$.MODULE$.overflowInIntegralDivideError$default$1());
        }
    }

    public static final /* synthetic */ void $anonfun$divWithHalfUpModeWithOverflowCheck$6(Scalar x5$1, ColumnVector isMin) {
        if (MODULE$.getLong(x5$1) == -1L && BoolUtils$.MODULE$.isAnyValidTrue(isMin)) {
            throw RapidsErrorUtils$.MODULE$.arithmeticOverflowError("overflow occurs", RapidsErrorUtils$.MODULE$.arithmeticOverflowError$default$2(), RapidsErrorUtils$.MODULE$.arithmeticOverflowError$default$3());
        }
    }

    public static final /* synthetic */ void $anonfun$divWithHalfUpModeWithOverflowCheck$7(Scalar x6$1, long min$1, ColumnVector isNegOne) {
        if (MODULE$.getLong(x6$1) == min$1 && BoolUtils$.MODULE$.isAnyValidTrue(isNegOne)) {
            throw RapidsErrorUtils$.MODULE$.arithmeticOverflowError("overflow occurs", RapidsErrorUtils$.MODULE$.arithmeticOverflowError$default$2(), RapidsErrorUtils$.MODULE$.arithmeticOverflowError$default$3());
        }
    }

    private IntervalUtils$() {
        MODULE$ = this;
        Arm.$init$(this);
    }
}

