/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.rapids.execution.python;

import com.nvidia.spark.rapids.Arm;
import com.nvidia.spark.rapids.CloseableHolder;
import com.nvidia.spark.rapids.GpuColumnVector;
import com.nvidia.spark.rapids.GpuMetric;
import com.nvidia.spark.rapids.RapidsBuffer;
import java.io.Serializable;
import org.apache.spark.sql.rapids.execution.python.BatchQueue;
import org.apache.spark.sql.rapids.execution.python.GpuPythonArrowOutput;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\u00054QAC\u0006\u0001\u0017eA\u0001\"\u0010\u0001\u0003\u0002\u0003\u0006IA\u0010\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005A!A1\t\u0001B\u0001B\u0003%A\t\u0003\u0005H\u0001\t\u0005\t\u0015!\u0003I\u0011!Y\u0005A!A!\u0002\u0013A\u0005\"\u0002'\u0001\t\u0003i\u0005\"\u0002+\u0001\t\u0003*\u0006\"B-\u0001\t\u0003R\u0006\"B.\u0001\t\u0013a&!E\"p[\nLg.\u001b8h\u0013R,'/\u0019;pe*\u0011A\"D\u0001\u0007af$\bn\u001c8\u000b\u00059y\u0011!C3yK\u000e,H/[8o\u0015\t\u0001\u0012#\u0001\u0004sCBLGm\u001d\u0006\u0003%M\t1a]9m\u0015\t!R#A\u0003ta\u0006\u00148N\u0003\u0002\u0017/\u00051\u0011\r]1dQ\u0016T\u0011\u0001G\u0001\u0004_J<7\u0003\u0002\u0001\u001bAM\u0002\"a\u0007\u0010\u000e\u0003qQ\u0011!H\u0001\u0006g\u000e\fG.Y\u0005\u0003?q\u0011a!\u00118z%\u00164\u0007cA\u0011+[9\u0011!\u0005\u000b\b\u0003G\u001dj\u0011\u0001\n\u0006\u0003K\u0019\na\u0001\u0010:p_Rt4\u0001A\u0005\u0002;%\u0011\u0011\u0006H\u0001\ba\u0006\u001c7.Y4f\u0013\tYCF\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0015\tIC\u0004\u0005\u0002/c5\tqF\u0003\u00021#\u0005Qa/Z2u_JL'0\u001a3\n\u0005Iz#!D\"pYVlg.\u0019:CCR\u001c\u0007\u000e\u0005\u00025w5\tQG\u0003\u0002\u0011m)\u0011Ac\u000e\u0006\u0003qe\naA\u001c<jI&\f'\"\u0001\u001e\u0002\u0007\r|W.\u0003\u0002=k\t\u0019\u0011I]7\u0002\u001f%t\u0007/\u001e;CCR\u001c\u0007.U;fk\u0016\u0004\"a\u0010!\u000e\u0003-I!!Q\u0006\u0003\u0015\t\u000bGo\u00195Rk\u0016,X-\u0001\tqsRDwN\\(viB,H/\u0013;fe\u0006\t\u0002/\u001f;i_:\f%O]8x%\u0016\fG-\u001a:\u0011\u0005}*\u0015B\u0001$\f\u0005Q9\u0005/\u001e)zi\"|g.\u0011:s_^|U\u000f\u001e9vi\u0006ia.^7PkR\u0004X\u000f\u001e*poN\u0004\"\u0001N%\n\u0005)+$!C$qk6+GO]5d\u0003AqW/\\(viB,HOQ1uG\",7/\u0001\u0004=S:LGO\u0010\u000b\u0007\u001d>\u0003\u0016KU*\u0011\u0005}\u0002\u0001\"B\u001f\u0007\u0001\u0004q\u0004\"\u0002\"\u0007\u0001\u0004\u0001\u0003\"B\"\u0007\u0001\u0004!\u0005\"B$\u0007\u0001\u0004A\u0005\"B&\u0007\u0001\u0004A\u0015a\u00025bg:+\u0007\u0010^\u000b\u0002-B\u00111dV\u0005\u00031r\u0011qAQ8pY\u0016\fg.\u0001\u0003oKb$H#A\u0017\u0002\u000f\r|WNY5oKR\u0019Q&X0\t\u000byK\u0001\u0019A\u0017\u0002\r1\u0014\u0015\r^2i\u0011\u0015\u0001\u0017\u00021\u0001.\u0003\u0019\u0011()\u0019;dQ\u0002")
public class CombiningIterator
implements Iterator<ColumnarBatch>,
Arm {
    private final BatchQueue inputBatchQueue;
    private final Iterator<ColumnarBatch> pythonOutputIter;
    private final GpuPythonArrowOutput pythonArrowReader;
    private final GpuMetric numOutputRows;
    private final GpuMetric numOutputBatches;

    @Override
    public <T extends AutoCloseable, V> V withResource(T r, Function1<T, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T[] r, Function1<T[], V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T, V> V withResourceIfAllowed(T r, Function1<T, V> block) {
        return (V)Arm.withResourceIfAllowed$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T[] r, Function1<T[], V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends RapidsBuffer, V> V freeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.freeOnExcept$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(CloseableHolder<T> h, Function1<CloseableHolder<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, h, block);
    }

    public Iterator<ColumnarBatch> seq() {
        return Iterator.seq$((Iterator)this);
    }

    public boolean isEmpty() {
        return Iterator.isEmpty$((Iterator)this);
    }

    public boolean isTraversableAgain() {
        return Iterator.isTraversableAgain$((Iterator)this);
    }

    public boolean hasDefiniteSize() {
        return Iterator.hasDefiniteSize$((Iterator)this);
    }

    public Iterator<ColumnarBatch> take(int n) {
        return Iterator.take$((Iterator)this, (int)n);
    }

    public Iterator<ColumnarBatch> drop(int n) {
        return Iterator.drop$((Iterator)this, (int)n);
    }

    public Iterator<ColumnarBatch> slice(int from, int until) {
        return Iterator.slice$((Iterator)this, (int)from, (int)until);
    }

    public Iterator<ColumnarBatch> sliceIterator(int from, int until) {
        return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
    }

    public <B> Iterator<B> map(Function1<ColumnarBatch, B> f) {
        return Iterator.map$((Iterator)this, f);
    }

    public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
        return Iterator.$plus$plus$((Iterator)this, that);
    }

    public <B> Iterator<B> flatMap(Function1<ColumnarBatch, GenTraversableOnce<B>> f) {
        return Iterator.flatMap$((Iterator)this, f);
    }

    public Iterator<ColumnarBatch> filter(Function1<ColumnarBatch, Object> p) {
        return Iterator.filter$((Iterator)this, p);
    }

    public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<ColumnarBatch, B, Object> p) {
        return Iterator.corresponds$((Iterator)this, that, p);
    }

    public Iterator<ColumnarBatch> withFilter(Function1<ColumnarBatch, Object> p) {
        return Iterator.withFilter$((Iterator)this, p);
    }

    public Iterator<ColumnarBatch> filterNot(Function1<ColumnarBatch, Object> p) {
        return Iterator.filterNot$((Iterator)this, p);
    }

    public <B> Iterator<B> collect(PartialFunction<ColumnarBatch, B> pf) {
        return Iterator.collect$((Iterator)this, pf);
    }

    public <B> Iterator<B> scanLeft(B z, Function2<B, ColumnarBatch, B> op) {
        return Iterator.scanLeft$((Iterator)this, z, op);
    }

    public <B> Iterator<B> scanRight(B z, Function2<ColumnarBatch, B, B> op) {
        return Iterator.scanRight$((Iterator)this, z, op);
    }

    public Iterator<ColumnarBatch> takeWhile(Function1<ColumnarBatch, Object> p) {
        return Iterator.takeWhile$((Iterator)this, p);
    }

    public Tuple2<Iterator<ColumnarBatch>, Iterator<ColumnarBatch>> partition(Function1<ColumnarBatch, Object> p) {
        return Iterator.partition$((Iterator)this, p);
    }

    public Tuple2<Iterator<ColumnarBatch>, Iterator<ColumnarBatch>> span(Function1<ColumnarBatch, Object> p) {
        return Iterator.span$((Iterator)this, p);
    }

    public Iterator<ColumnarBatch> dropWhile(Function1<ColumnarBatch, Object> p) {
        return Iterator.dropWhile$((Iterator)this, p);
    }

    public <B> Iterator<Tuple2<ColumnarBatch, B>> zip(Iterator<B> that) {
        return Iterator.zip$((Iterator)this, that);
    }

    public <A1> Iterator<A1> padTo(int len, A1 elem) {
        return Iterator.padTo$((Iterator)this, (int)len, elem);
    }

    public Iterator<Tuple2<ColumnarBatch, Object>> zipWithIndex() {
        return Iterator.zipWithIndex$((Iterator)this);
    }

    public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
        return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
    }

    public <U> void foreach(Function1<ColumnarBatch, U> f) {
        Iterator.foreach$((Iterator)this, f);
    }

    public boolean forall(Function1<ColumnarBatch, Object> p) {
        return Iterator.forall$((Iterator)this, p);
    }

    public boolean exists(Function1<ColumnarBatch, Object> p) {
        return Iterator.exists$((Iterator)this, p);
    }

    public boolean contains(Object elem) {
        return Iterator.contains$((Iterator)this, (Object)elem);
    }

    public Option<ColumnarBatch> find(Function1<ColumnarBatch, Object> p) {
        return Iterator.find$((Iterator)this, p);
    }

    public int indexWhere(Function1<ColumnarBatch, Object> p) {
        return Iterator.indexWhere$((Iterator)this, p);
    }

    public int indexWhere(Function1<ColumnarBatch, Object> p, int from) {
        return Iterator.indexWhere$((Iterator)this, p, (int)from);
    }

    public <B> int indexOf(B elem) {
        return Iterator.indexOf$((Iterator)this, elem);
    }

    public <B> int indexOf(B elem, int from) {
        return Iterator.indexOf$((Iterator)this, elem, (int)from);
    }

    public BufferedIterator<ColumnarBatch> buffered() {
        return Iterator.buffered$((Iterator)this);
    }

    public <B> Iterator.GroupedIterator<B> grouped(int size) {
        return Iterator.grouped$((Iterator)this, (int)size);
    }

    public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
        return Iterator.sliding$((Iterator)this, (int)size, (int)step);
    }

    public <B> int sliding$default$2() {
        return Iterator.sliding$default$2$((Iterator)this);
    }

    public int length() {
        return Iterator.length$((Iterator)this);
    }

    public Tuple2<Iterator<ColumnarBatch>, Iterator<ColumnarBatch>> duplicate() {
        return Iterator.duplicate$((Iterator)this);
    }

    public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
        return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
    }

    public <B> void copyToArray(Object xs, int start, int len) {
        Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
    }

    public boolean sameElements(Iterator<?> that) {
        return Iterator.sameElements$((Iterator)this, that);
    }

    public Traversable<ColumnarBatch> toTraversable() {
        return Iterator.toTraversable$((Iterator)this);
    }

    public Iterator<ColumnarBatch> toIterator() {
        return Iterator.toIterator$((Iterator)this);
    }

    public Stream<ColumnarBatch> toStream() {
        return Iterator.toStream$((Iterator)this);
    }

    public String toString() {
        return Iterator.toString$((Iterator)this);
    }

    public List<ColumnarBatch> reversed() {
        return TraversableOnce.reversed$((TraversableOnce)this);
    }

    public int size() {
        return TraversableOnce.size$((TraversableOnce)this);
    }

    public boolean nonEmpty() {
        return TraversableOnce.nonEmpty$((TraversableOnce)this);
    }

    public int count(Function1<ColumnarBatch, Object> p) {
        return TraversableOnce.count$((TraversableOnce)this, p);
    }

    public <B> Option<B> collectFirst(PartialFunction<ColumnarBatch, B> pf) {
        return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
    }

    public <B> B $div$colon(B z, Function2<B, ColumnarBatch, B> op) {
        return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
    }

    public <B> B $colon$bslash(B z, Function2<ColumnarBatch, B, B> op) {
        return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
    }

    public <B> B foldLeft(B z, Function2<B, ColumnarBatch, B> op) {
        return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
    }

    public <B> B foldRight(B z, Function2<ColumnarBatch, B, B> op) {
        return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
    }

    public <B> B reduceLeft(Function2<B, ColumnarBatch, B> op) {
        return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
    }

    public <B> B reduceRight(Function2<ColumnarBatch, B, B> op) {
        return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
    }

    public <B> Option<B> reduceLeftOption(Function2<B, ColumnarBatch, B> op) {
        return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
    }

    public <B> Option<B> reduceRightOption(Function2<ColumnarBatch, B, B> op) {
        return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
    }

    public <A1> A1 reduce(Function2<A1, A1, A1> op) {
        return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
    }

    public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
        return TraversableOnce.reduceOption$((TraversableOnce)this, op);
    }

    public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
        return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
    }

    public <B> B aggregate(Function0<B> z, Function2<B, ColumnarBatch, B> seqop, Function2<B, B, B> combop) {
        return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
    }

    public <B> B sum(Numeric<B> num) {
        return (B)TraversableOnce.sum$((TraversableOnce)this, num);
    }

    public <B> B product(Numeric<B> num) {
        return (B)TraversableOnce.product$((TraversableOnce)this, num);
    }

    public Object min(Ordering cmp) {
        return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
    }

    public Object max(Ordering cmp) {
        return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
    }

    public Object maxBy(Function1 f, Ordering cmp) {
        return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
    }

    public Object minBy(Function1 f, Ordering cmp) {
        return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
    }

    public <B> void copyToBuffer(Buffer<B> dest) {
        TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
    }

    public <B> void copyToArray(Object xs, int start) {
        TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
    }

    public <B> void copyToArray(Object xs) {
        TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
    }

    public <B> Object toArray(ClassTag<B> evidence$1) {
        return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
    }

    public List<ColumnarBatch> toList() {
        return TraversableOnce.toList$((TraversableOnce)this);
    }

    public Iterable<ColumnarBatch> toIterable() {
        return TraversableOnce.toIterable$((TraversableOnce)this);
    }

    public Seq<ColumnarBatch> toSeq() {
        return TraversableOnce.toSeq$((TraversableOnce)this);
    }

    public IndexedSeq<ColumnarBatch> toIndexedSeq() {
        return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
    }

    public <B> Buffer<B> toBuffer() {
        return TraversableOnce.toBuffer$((TraversableOnce)this);
    }

    public <B> Set<B> toSet() {
        return TraversableOnce.toSet$((TraversableOnce)this);
    }

    public Vector<ColumnarBatch> toVector() {
        return TraversableOnce.toVector$((TraversableOnce)this);
    }

    public <Col> Col to(CanBuildFrom<Nothing$, ColumnarBatch, Col> cbf) {
        return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
    }

    public <T, U> Map<T, U> toMap(Predef.$less$colon$less<ColumnarBatch, Tuple2<T, U>> ev) {
        return TraversableOnce.toMap$((TraversableOnce)this, ev);
    }

    public String mkString(String start, String sep, String end) {
        return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
    }

    public String mkString(String sep) {
        return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
    }

    public String mkString() {
        return TraversableOnce.mkString$((TraversableOnce)this);
    }

    public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
    }

    public StringBuilder addString(StringBuilder b, String sep) {
        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
    }

    public StringBuilder addString(StringBuilder b) {
        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
    }

    public int sizeHintIfCheap() {
        return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
    }

    public boolean hasNext() {
        return this.inputBatchQueue.hasNext() || this.pythonOutputIter.hasNext();
    }

    public ColumnarBatch next() {
        int numRows = this.inputBatchQueue.peekBatchSize();
        this.pythonArrowReader.updateMinReadTargetBatchSize(numRows);
        return (ColumnarBatch)this.withResource((AutoCloseable)this.pythonOutputIter.next(), (Function1 & Serializable & scala.Serializable)cbFromPython -> {
            Predef$.MODULE$.assert(cbFromPython.numRows() == numRows);
            return (ColumnarBatch)this.withResource($this.inputBatchQueue.remove(), (Function1 & Serializable & scala.Serializable)origBatch -> {
                $this.numOutputBatches.$plus$eq(1L);
                $this.numOutputRows.$plus$eq(numRows);
                return this.combine((ColumnarBatch)origBatch, (ColumnarBatch)cbFromPython);
            });
        });
    }

    private ColumnarBatch combine(ColumnarBatch lBatch, ColumnarBatch rBatch) {
        GpuColumnVector[] lColumns = (GpuColumnVector[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])GpuColumnVector.extractColumns(lBatch))).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.incRefCount(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(GpuColumnVector.class)));
        GpuColumnVector[] rColumns = (GpuColumnVector[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])GpuColumnVector.extractColumns(rBatch))).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.incRefCount(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(GpuColumnVector.class)));
        return new ColumnarBatch((ColumnVector[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])lColumns)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rColumns)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ColumnVector.class))), lBatch.numRows());
    }

    public CombiningIterator(BatchQueue inputBatchQueue, Iterator<ColumnarBatch> pythonOutputIter, GpuPythonArrowOutput pythonArrowReader, GpuMetric numOutputRows, GpuMetric numOutputBatches) {
        this.inputBatchQueue = inputBatchQueue;
        this.pythonOutputIter = pythonOutputIter;
        this.pythonArrowReader = pythonArrowReader;
        this.numOutputRows = numOutputRows;
        this.numOutputBatches = numOutputBatches;
        GenTraversableOnce.$init$((GenTraversableOnce)this);
        TraversableOnce.$init$((TraversableOnce)this);
        Iterator.$init$((Iterator)this);
        Arm.$init$(this);
    }
}

