/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.rapids.execution;

import ai.rapids.cudf.GatherMap;
import ai.rapids.cudf.NvtxColor;
import ai.rapids.cudf.Table;
import com.nvidia.spark.rapids.GpuBuildSide;
import com.nvidia.spark.rapids.GpuMetric;
import com.nvidia.spark.rapids.JoinGatherer;
import com.nvidia.spark.rapids.LazySpillableColumnarBatch;
import com.nvidia.spark.rapids.NvtxWithMetrics;
import com.nvidia.spark.rapids.SpillCallback;
import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.plans.FullOuter$;
import org.apache.spark.sql.catalyst.plans.InnerLike;
import org.apache.spark.sql.catalyst.plans.JoinType;
import org.apache.spark.sql.catalyst.plans.LeftAnti$;
import org.apache.spark.sql.catalyst.plans.LeftOuter$;
import org.apache.spark.sql.catalyst.plans.LeftSemi$;
import org.apache.spark.sql.catalyst.plans.RightOuter$;
import org.apache.spark.sql.rapids.execution.BaseHashJoinIterator;
import scala.Function1;
import scala.NotImplementedError;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dd\u0001B\r\u001b\u0001\u001dB\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\to\u0001\u0011)\u0019!C\u0001q!Aq\n\u0001B\u0001B\u0003%\u0011\b\u0003\u0005Q\u0001\t\u0015\r\u0011\"\u0003R\u0011!)\u0006A!A!\u0002\u0013\u0011\u0006\u0002\u0003,\u0001\u0005\u000b\u0007I\u0011\u0001\u001d\t\u0011]\u0003!\u0011!Q\u0001\neB\u0001\u0002\u0017\u0001\u0003\u0006\u0004%\t!\u0017\u0005\t=\u0002\u0011\t\u0011)A\u00055\"Aq\f\u0001BC\u0002\u0013\u0005\u0001\r\u0003\u0005f\u0001\t\u0005\t\u0015!\u0003b\u0011!1\u0007A!b\u0001\n\u00039\u0007\u0002\u00038\u0001\u0005\u0003\u0005\u000b\u0011\u00025\t\u0011=\u0004!Q1A\u0005\u0002AD\u0001\u0002\u001e\u0001\u0003\u0002\u0003\u0006I!\u001d\u0005\tk\u0002\u0011)\u0019!C\u0001m\"A!\u0010\u0001B\u0001B\u0003%q\u000f\u0003\u0005|\u0001\t\u0015\r\u0011\"\u0003}\u0011%\t\t\u0001\u0001B\u0001B\u0003%Q\u0010\u0003\u0007\u0002\u0004\u0001\u0011\t\u0011)A\u0005\u0003\u000b\tY\u0001\u0003\u0006\u0002\u0012\u0001\u0011)\u0019!C\u0005\u0003'A!\"!\u0006\u0001\u0005\u0003\u0005\u000b\u0011BA\u0003\u0011\u001d\t9\u0002\u0001C\u0001\u00033Aq!!\u000e\u0001\t#\n9D\u0001\tICND'j\\5o\u0013R,'/\u0019;pe*\u00111\u0004H\u0001\nKb,7-\u001e;j_:T!!\b\u0010\u0002\rI\f\u0007/\u001b3t\u0015\ty\u0002%A\u0002tc2T!!\t\u0012\u0002\u000bM\u0004\u0018M]6\u000b\u0005\r\"\u0013AB1qC\u000eDWMC\u0001&\u0003\ry'oZ\u0002\u0001'\t\u0001\u0001\u0006\u0005\u0002*U5\t!$\u0003\u0002,5\t!\")Y:f\u0011\u0006\u001c\bNS8j]&#XM]1u_J\fQAY;jYR\u0004\"AL\u001b\u000e\u0003=R!!\b\u0019\u000b\u0005\u0005\n$B\u0001\u001a4\u0003\u0019qg/\u001b3jC*\tA'A\u0002d_6L!AN\u0018\u000351\u000b'0_*qS2d\u0017M\u00197f\u0007>dW/\u001c8be\n\u000bGo\u00195\u0002\u001d\t|WO\u001c3Ck&dGoS3zgV\t\u0011\bE\u0002;\t\u001es!aO!\u000f\u0005qzT\"A\u001f\u000b\u0005y2\u0013A\u0002\u001fs_>$h(C\u0001A\u0003\u0015\u00198-\u00197b\u0013\t\u00115)A\u0004qC\u000e\\\u0017mZ3\u000b\u0003\u0001K!!\u0012$\u0003\u0007M+\u0017O\u0003\u0002C\u0007B\u0011\u0001*T\u0007\u0002\u0013*\u0011!jS\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002M=\u0005A1-\u0019;bYf\u001cH/\u0003\u0002O\u0013\nQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\u001f\t|WO\u001c3Ck&dGoS3zg\u0002\naa\u001d;sK\u0006lW#\u0001*\u0011\u0007i\u001aV&\u0003\u0002U\r\nA\u0011\n^3sCR|'/A\u0004tiJ,\u0017-\u001c\u0011\u0002\u001f\t|WO\u001c3TiJ,\u0017-\\&fsN\f\u0001CY8v]\u0012\u001cFO]3b[.+\u0017p\u001d\u0011\u0002!M$(/Z1n\u0003R$(/\u001b2vi\u0016\u001cX#\u0001.\u0011\u0007i\"5\f\u0005\u0002I9&\u0011Q,\u0013\u0002\n\u0003R$(/\u001b2vi\u0016\f\u0011c\u001d;sK\u0006l\u0017\t\u001e;sS\n,H/Z:!\u0003)!\u0018M]4fiNK'0Z\u000b\u0002CB\u0011!mY\u0007\u0002\u0007&\u0011Am\u0011\u0002\u0005\u0019>tw-A\u0006uCJ<W\r^*ju\u0016\u0004\u0013\u0001\u00036pS:$\u0016\u0010]3\u0016\u0003!\u0004\"!\u001b7\u000e\u0003)T!a[&\u0002\u000bAd\u0017M\\:\n\u00055T'\u0001\u0003&pS:$\u0016\u0010]3\u0002\u0013)|\u0017N\u001c+za\u0016\u0004\u0013!\u00032vS2$7+\u001b3f+\u0005\t\bC\u0001\u0018s\u0013\t\u0019xF\u0001\u0007HaV\u0014U/\u001b7e'&$W-\u0001\u0006ck&dGmU5eK\u0002\n\u0011cY8na\u0006\u0014XMT;mYN,\u0015/^1m+\u00059\bC\u00012y\u0013\tI8IA\u0004C_>dW-\u00198\u0002%\r|W\u000e]1sK:+H\u000e\\:FcV\fG\u000eI\u0001\u000egBLG\u000e\\\"bY2\u0014\u0017mY6\u0016\u0003u\u0004\"A\f@\n\u0005}|#!D*qS2d7)\u00197mE\u0006\u001c7.\u0001\bta&dGnQ1mY\n\f7m\u001b\u0011\u0002\r=\u0004H+[7f!\rq\u0013qA\u0005\u0004\u0003\u0013y#!C$qk6+GO]5d\u0013\u0011\t\u0019!!\u0004\n\u0007\u0005=qFA\fBEN$(/Y2u\u000fB,(j\\5o\u0013R,'/\u0019;pe\u0006A!n\\5o)&lW-\u0006\u0002\u0002\u0006\u0005I!n\\5o)&lW\rI\u0001\u0007y%t\u0017\u000e\u001e \u00155\u0005m\u0011QDA\u0010\u0003C\t\u0019#!\n\u0002(\u0005%\u00121FA\u0017\u0003_\t\t$a\r\u0011\u0005%\u0002\u0001\"\u0002\u0017\u0018\u0001\u0004i\u0003\"B\u001c\u0018\u0001\u0004I\u0004\"\u0002)\u0018\u0001\u0004\u0011\u0006\"\u0002,\u0018\u0001\u0004I\u0004\"\u0002-\u0018\u0001\u0004Q\u0006\"B0\u0018\u0001\u0004\t\u0007\"\u00024\u0018\u0001\u0004A\u0007\"B8\u0018\u0001\u0004\t\b\"B;\u0018\u0001\u00049\b\"B>\u0018\u0001\u0004i\bbBA\u0002/\u0001\u0007\u0011Q\u0001\u0005\b\u0003#9\u0002\u0019AA\u0003\u0003UQw.\u001b8HCRDWM]3s\u0019\u00164GOU5hQR$\"\"!\u000f\u0002F\u0005m\u0013qLA2!\u0015\u0011\u00171HA \u0013\r\tid\u0011\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u00079\n\t%C\u0002\u0002D=\u0012ABS8j]\u001e\u000bG\u000f[3sKJDq!a\u0012\u0019\u0001\u0004\tI%\u0001\u0005mK\u001a$8*Z=t!\u0011\tY%a\u0016\u000e\u0005\u00055#\u0002BA(\u0003#\nAaY;eM*\u0019Q$a\u0015\u000b\u0005\u0005U\u0013AA1j\u0013\u0011\tI&!\u0014\u0003\u000bQ\u000b'\r\\3\t\r\u0005u\u0003\u00041\u0001.\u0003!aWM\u001a;ECR\f\u0007bBA11\u0001\u0007\u0011\u0011J\u0001\ne&<\u0007\u000e^&fsNDa!!\u001a\u0019\u0001\u0004i\u0013!\u0003:jO\"$H)\u0019;b\u0001")
public class HashJoinIterator
extends BaseHashJoinIterator {
    private final Seq<Expression> boundBuiltKeys;
    private final Iterator<LazySpillableColumnarBatch> stream;
    private final Seq<Expression> boundStreamKeys;
    private final Seq<Attribute> streamAttributes;
    private final long targetSize;
    private final JoinType joinType;
    private final GpuBuildSide buildSide;
    private final boolean compareNullsEqual;
    private final SpillCallback spillCallback;
    private final GpuMetric joinTime;

    public Seq<Expression> boundBuiltKeys() {
        return this.boundBuiltKeys;
    }

    private Iterator<LazySpillableColumnarBatch> stream() {
        return this.stream;
    }

    public Seq<Expression> boundStreamKeys() {
        return this.boundStreamKeys;
    }

    public Seq<Attribute> streamAttributes() {
        return this.streamAttributes;
    }

    public long targetSize() {
        return this.targetSize;
    }

    public JoinType joinType() {
        return this.joinType;
    }

    public GpuBuildSide buildSide() {
        return this.buildSide;
    }

    public boolean compareNullsEqual() {
        return this.compareNullsEqual;
    }

    private SpillCallback spillCallback() {
        return this.spillCallback;
    }

    private GpuMetric joinTime() {
        return this.joinTime;
    }

    @Override
    public Option<JoinGatherer> joinGathererLeftRight(Table leftKeys, LazySpillableColumnarBatch leftData, Table rightKeys, LazySpillableColumnarBatch rightData) {
        return (Option)this.withResource(new NvtxWithMetrics("hash join gather map", NvtxColor.ORANGE, (Seq<GpuMetric>)Predef$.MODULE$.wrapRefArray((Object[])new GpuMetric[]{this.joinTime()})), (Function1 & Serializable & scala.Serializable)x$5 -> {
            GatherMap[] gatherMapArray;
            JoinType joinType = this.joinType();
            if (LeftOuter$.MODULE$.equals(joinType)) {
                gatherMapArray = leftKeys.leftJoinGatherMaps(rightKeys, this.compareNullsEqual());
            } else if (RightOuter$.MODULE$.equals(joinType)) {
                gatherMapArray = (GatherMap[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rightKeys.leftJoinGatherMaps(leftKeys, this.compareNullsEqual()))).reverse();
            } else if (joinType instanceof InnerLike) {
                gatherMapArray = leftKeys.innerJoinGatherMaps(rightKeys, this.compareNullsEqual());
            } else if (LeftSemi$.MODULE$.equals(joinType)) {
                gatherMapArray = (GatherMap[])((Object[])new GatherMap[]{leftKeys.leftSemiJoinGatherMap(rightKeys, this.compareNullsEqual())});
            } else if (LeftAnti$.MODULE$.equals(joinType)) {
                gatherMapArray = (GatherMap[])((Object[])new GatherMap[]{leftKeys.leftAntiJoinGatherMap(rightKeys, this.compareNullsEqual())});
            } else if (FullOuter$.MODULE$.equals(joinType)) {
                gatherMapArray = leftKeys.fullJoinGatherMaps(rightKeys, this.compareNullsEqual());
            } else {
                throw new NotImplementedError(new StringBuilder(38).append("Joint Type ").append(this.joinType().getClass()).append(" is not currently").append(" supported").toString());
            }
            GatherMap[] maps = gatherMapArray;
            return this.makeGatherer(maps, leftData, rightData, this.joinType());
        });
    }

    public HashJoinIterator(LazySpillableColumnarBatch built, Seq<Expression> boundBuiltKeys, Iterator<LazySpillableColumnarBatch> stream, Seq<Expression> boundStreamKeys, Seq<Attribute> streamAttributes, long targetSize, JoinType joinType, GpuBuildSide buildSide, boolean compareNullsEqual, SpillCallback spillCallback, GpuMetric opTime, GpuMetric joinTime) {
        this.boundBuiltKeys = boundBuiltKeys;
        this.stream = stream;
        this.boundStreamKeys = boundStreamKeys;
        this.streamAttributes = streamAttributes;
        this.targetSize = targetSize;
        this.joinType = joinType;
        this.buildSide = buildSide;
        this.compareNullsEqual = compareNullsEqual;
        this.spillCallback = spillCallback;
        this.joinTime = joinTime;
        super(built, boundBuiltKeys, stream, boundStreamKeys, streamAttributes, targetSize, joinType, buildSide, spillCallback, opTime, joinTime);
    }
}

