/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.rapids;

import ai.rapids.cudf.NvtxColor;
import ai.rapids.cudf.NvtxRange;
import com.nvidia.spark.rapids.RapidsBuffer;
import com.nvidia.spark.rapids.RapidsBufferCatalog$;
import com.nvidia.spark.rapids.RapidsConf;
import com.nvidia.spark.rapids.RapidsConf$;
import com.nvidia.spark.rapids.RapidsShuffleHeartbeatHandler;
import com.nvidia.spark.rapids.ShuffleBufferCatalog;
import com.nvidia.spark.rapids.ShuffleBufferId;
import com.nvidia.spark.rapids.ThreadFactoryBuilder;
import com.nvidia.spark.rapids.format.TableMeta;
import com.nvidia.spark.rapids.shuffle.ClientConnection;
import com.nvidia.spark.rapids.shuffle.RapidsShuffleRequestHandler;
import com.nvidia.spark.rapids.shuffle.RapidsShuffleServer;
import com.nvidia.spark.rapids.shuffle.RapidsShuffleTransport;
import com.nvidia.spark.rapids.shuffle.RapidsShuffleTransport$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.spark.ShuffleDependency;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkEnv$;
import org.apache.spark.TaskContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.shuffle.ShuffleBlockResolver;
import org.apache.spark.shuffle.ShuffleDataIOUtils$;
import org.apache.spark.shuffle.ShuffleHandle;
import org.apache.spark.shuffle.ShuffleManager;
import org.apache.spark.shuffle.ShuffleReadMetricsReporter;
import org.apache.spark.shuffle.ShuffleReader;
import org.apache.spark.shuffle.ShuffleWriteMetricsReporter;
import org.apache.spark.shuffle.ShuffleWriter;
import org.apache.spark.shuffle.api.ShuffleExecutorComponents;
import org.apache.spark.shuffle.sort.BypassMergeSortShuffleHandle;
import org.apache.spark.shuffle.sort.SortShuffleManager;
import org.apache.spark.sql.rapids.GpuShuffleDependency;
import org.apache.spark.sql.rapids.GpuShuffleEnv$;
import org.apache.spark.sql.rapids.GpuShuffleHandle;
import org.apache.spark.sql.rapids.RapidsCachingReader;
import org.apache.spark.sql.rapids.RapidsCachingWriter;
import org.apache.spark.sql.rapids.RapidsShuffleInternalManagerBase$;
import org.apache.spark.sql.rapids.ThreadSafeShuffleWriteMetricsReporter;
import org.apache.spark.sql.rapids.shims.GpuShuffleBlockResolver;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.storage.ShuffleBlockBatchId;
import org.apache.spark.storage.ShuffleBlockId;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\r\u0005r!\u0002\u001c8\u0011\u0003\u0011e!\u0002#8\u0011\u0003)\u0005\"\u0002*\u0002\t\u0003\u0019\u0006\"\u0002+\u0002\t\u0003)f\u0001\u00020\u0002\t}C\u0001\u0002\u0019\u0003\u0003\u0002\u0003\u0006I!\u0019\u0005\u0006%\u0012!\t\u0001\u001a\u0005\bQ\u0012\u0011\r\u0011\"\u0003j\u0011\u0019!H\u0001)A\u0005U\")Q\u000f\u0002C\u0001m\"9\u0011q\u0003\u0003\u0005\u0002\u0005e\u0001\"CA\u0011\u0003\u0001\u0007I\u0011BA\u0012\u0011%\t)#\u0001a\u0001\n\u0013\t9\u0003C\u0004\u0002.\u0005\u0001\u000b\u0015B1\t\u0015\u0005=\u0012\u0001#b\u0001\n\u0013\t\t\u0004C\u0005\u0002D\u0005\u0011\r\u0011\"\u0003\u0002F!A\u00111K\u0001!\u0002\u0013\t9\u0005C\u0004\u0002V\u0005!\t!a\u0016\t\u000f\u0005\u001d\u0014\u0001\"\u0001\u0002j!9\u0011qN\u0001\u0005\u0002\u0005e\u0001bBA9\u0003\u0011\u0005\u00111\u0005\u0004\u0007\t^\n\t!a\u001d\t\u0015\u0005=UC!A!\u0002\u0013\t\t\n\u0003\u0006\u0002\u001aV\u0011)\u0019!C\u0001\u00037C!\"a)\u0016\u0005\u0003\u0005\u000b\u0011BAO\u0011\u0019\u0011V\u0003\"\u0001\u0002&\"9\u0011QV\u000b\u0005\u0002\u0005=\u0006bBA_+\u0011\u0005\u0013q\u0018\u0005\n\u0003\u000b,\"\u0019!C\u0005\u0003\u000fD\u0001\"a4\u0016A\u0003%\u0011\u0011\u001a\u0005\n\u0003#,\"\u0019!C\t\u0003'D\u0001\"!9\u0016A\u0003%\u0011Q\u001b\u0005\t\u0003G,\u0002\u0015!\u0003\u0002f\"Q\u0011\u0011_\u000b\t\u0006\u0004%\t\"a=\t\u0015\u0005mX\u0003#b\u0001\n#\ti\u0010\u0003\u0006\u0003\u0006UA)\u0019!C\t\u00037C!Ba\u0002\u0016\u0011\u000b\u0007I\u0011BAX\u0011%\u0011I!\u0006a\u0001\n\u0013\tY\nC\u0005\u0003\fU\u0001\r\u0011\"\u0003\u0003\u000e!A!\u0011C\u000b!B\u0013\ti\nC\u0004\u0003\u0014U!\tB!\u0006\t\u0015\tuQ\u0003#b\u0001\n#\u0011y\u0002\u0003\u0006\u0003.UA)\u0019)C\u0005\u0005_A!B!\u0011\u0016\u0011\u000b\u0007K\u0011\u0002B\"\u0011\u001d\u0011i%\u0006C!\u0005\u001fB!Ba\u001d\u0016\u0011\u000b\u0007I\u0011\u0001B;\u0011\u001d\u0011))\u0006D\u0001\u0005\u000fCqAa0\u0016\t\u0003\u0012\t\rC\u0004\u0003XV!\tE!7\t\u000f\r%Q\u0003\"\u0001\u0004\f!91qB\u000b\u0005\u0002\rE\u0001bBB\u000b+\u0011\u00053q\u0003\u0005\b\u00077)B\u0011IB\u000f\u0011\u001d\u0019y\"\u0006C!\u00033\t\u0001EU1qS\u0012\u001c8\u000b[;gM2,\u0017J\u001c;fe:\fG.T1oC\u001e,'OQ1tK*\u0011\u0001(O\u0001\u0007e\u0006\u0004\u0018\u000eZ:\u000b\u0005iZ\u0014aA:rY*\u0011A(P\u0001\u0006gB\f'o\u001b\u0006\u0003}}\na!\u00199bG\",'\"\u0001!\u0002\u0007=\u0014xm\u0001\u0001\u0011\u0005\r\u000bQ\"A\u001c\u0003AI\u000b\u0007/\u001b3t'\",hM\u001a7f\u0013:$XM\u001d8bY6\u000bg.Y4fe\n\u000b7/Z\n\u0004\u0003\u0019c\u0005CA$K\u001b\u0005A%\"A%\u0002\u000bM\u001c\u0017\r\\1\n\u0005-C%AB!osJ+g\r\u0005\u0002N!6\taJ\u0003\u0002Pw\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002R\u001d\n9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u0001C\u00031)hn\u001e:ba\"\u000bg\u000e\u001a7f)\t1F\f\u0005\u0002X56\t\u0001L\u0003\u0002Zw\u000591\u000f[;gM2,\u0017BA.Y\u00055\u0019\u0006.\u001e4gY\u0016D\u0015M\u001c3mK\")Ql\u0001a\u0001-\u00061\u0001.\u00198eY\u0016\u0014Aa\u00157piN\u0011AAR\u0001\bg2|GOT;n!\t9%-\u0003\u0002d\u0011\n\u0019\u0011J\u001c;\u0015\u0005\u0015<\u0007C\u00014\u0005\u001b\u0005\t\u0001\"\u00021\u0007\u0001\u0004\t\u0017!\u00019\u0016\u0003)\u0004\"a\u001b:\u000e\u00031T!!\u001c8\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002pa\u0006!Q\u000f^5m\u0015\u0005\t\u0018\u0001\u00026bm\u0006L!a\u001d7\u0003\u001f\u0015CXmY;u_J\u001cVM\u001d<jG\u0016\f!\u0001\u001d\u0011\u0002\u000b=4g-\u001a:\u0016\u0005]lHc\u0001=\u0002\u000eA\u00191._>\n\u0005id'A\u0002$viV\u0014X\r\u0005\u0002}{2\u0001A!\u0002@\n\u0005\u0004y(!\u0001+\u0012\t\u0005\u0005\u0011q\u0001\t\u0004\u000f\u0006\r\u0011bAA\u0003\u0011\n9aj\u001c;iS:<\u0007cA$\u0002\n%\u0019\u00111\u0002%\u0003\u0007\u0005s\u0017\u0010C\u0004\u0002\u0010%\u0001\r!!\u0005\u0002\tQ\f7o\u001b\t\u0005W\u0006M10C\u0002\u0002\u00161\u0014\u0001bQ1mY\u0006\u0014G.Z\u0001\fg\",H\u000fZ8x]:{w\u000f\u0006\u0002\u0002\u001cA\u0019q)!\b\n\u0007\u0005}\u0001J\u0001\u0003V]&$\u0018\u0001\u00038v[Ncw\u000e^:\u0016\u0003\u0005\fAB\\;n'2|Go]0%KF$B!a\u0007\u0002*!A\u00111\u0006\u0007\u0002\u0002\u0003\u0007\u0011-A\u0002yIE\n\u0011B\\;n'2|Go\u001d\u0011\u0002\u000bMdw\u000e^:\u0016\u0005\u0005M\u0002CBA\u001b\u0003\u007f\tW-\u0004\u0002\u00028)!\u0011\u0011HA\u001e\u0003\u001diW\u000f^1cY\u0016T1!!\u0010I\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u0003\n9DA\u0004ICNDW*\u00199\u0002\u0015Mdw\u000e\u001e(v[\n,'/\u0006\u0002\u0002HA!\u0011\u0011JA(\u001b\t\tYEC\u0002\u0002N1\fa!\u0019;p[&\u001c\u0017\u0002BA)\u0003\u0017\u0012Q\"\u0011;p[&\u001c\u0017J\u001c;fO\u0016\u0014\u0018aC:m_RtU/\u001c2fe\u0002\n\u0011\"];fk\u0016$\u0016m]6\u0016\t\u0005e\u0013q\f\u000b\u0007\u00037\n\t'a\u0019\u0011\t-L\u0018Q\f\t\u0004y\u0006}C!\u0002@\u0012\u0005\u0004y\b\"\u00021\u0012\u0001\u0004\t\u0007bBA\b#\u0001\u0007\u0011Q\r\t\u0006W\u0006M\u0011QL\u0001\u0018gR\f'\u000f\u001e+ie\u0016\fG\rU8pY&3g*Z3eK\u0012$B!a\u0007\u0002l!1\u0011Q\u000e\nA\u0002\u0005\fAC\\;n\u0007>tg-[4ve\u0016$G\u000b\u001b:fC\u0012\u001c\u0018AD:u_B$\u0006N]3bIB{w\u000e\\\u0001\fO\u0016$h*\u001a=u'2|GoE\u0004\u0016\r\u0006U\u00141\u0010'\u0011\u0007]\u000b9(C\u0002\u0002za\u0013ab\u00155vM\u001adW-T1oC\u001e,'\u000f\u0005\u0003\u0002~\u0005-UBAA@\u0015\rA\u0014\u0011\u0011\u0006\u0004y\u0005\r%\u0002BAC\u0003\u000f\u000baA\u001c<jI&\f'BAAE\u0003\r\u0019w.\\\u0005\u0005\u0003\u001b\u000byHA\u000fSCBLGm]*ik\u001a4G.\u001a%fCJ$(-Z1u\u0011\u0006tG\r\\3s\u0003\u0011\u0019wN\u001c4\u0011\t\u0005M\u0015QS\u0007\u0002w%\u0019\u0011qS\u001e\u0003\u0013M\u0003\u0018M]6D_:4\u0017\u0001C5t\tJLg/\u001a:\u0016\u0005\u0005u\u0005cA$\u0002 &\u0019\u0011\u0011\u0015%\u0003\u000f\t{w\u000e\\3b]\u0006I\u0011n\u001d#sSZ,'\u000f\t\u000b\u0007\u0003O\u000bI+a+\u0011\u0005\r+\u0002bBAH3\u0001\u0007\u0011\u0011\u0013\u0005\b\u00033K\u0002\u0019AAO\u0003-9W\r^*feZ,'/\u00133\u0016\u0005\u0005E\u0006\u0003BAZ\u0003sk!!!.\u000b\u0007\u0005]6(A\u0004ti>\u0014\u0018mZ3\n\t\u0005m\u0016Q\u0017\u0002\u000f\u00052|7m['b]\u0006<WM]%e\u0003\u001d\tG\r\u001a)fKJ$B!a\u0007\u0002B\"9\u00111Y\u000eA\u0002\u0005E\u0016\u0001\u00029fKJ\f!B]1qS\u0012\u001c8i\u001c8g+\t\tI\r\u0005\u0003\u0002~\u0005-\u0017\u0002BAg\u0003\u007f\u0012!BU1qS\u0012\u001c8i\u001c8g\u0003-\u0011\u0018\r]5eg\u000e{gN\u001a\u0011\u0002\u000f]\u0014\u0018\r\u001d9fIV\u0011\u0011Q\u001b\t\u0005\u0003/\fi.\u0004\u0002\u0002Z*\u0019\u00111\u001c-\u0002\tM|'\u000f^\u0005\u0005\u0003?\fIN\u0001\nT_J$8\u000b[;gM2,W*\u00198bO\u0016\u0014\u0018\u0001C<sCB\u0004X\r\u001a\u0011\u0002/Q\u0014\u0018M\\:q_J$XI\\1cY\u0016$W*Z:tC\u001e,\u0007\u0003BAt\u0003[l!!!;\u000b\u0007\u0005-\b/\u0001\u0003mC:<\u0017\u0002BAx\u0003S\u0014aa\u0015;sS:<\u0017aA3omV\u0011\u0011Q\u001f\t\u0005\u0003'\u000b90C\u0002\u0002zn\u0012\u0001b\u00159be.,eN^\u0001\rE2|7m['b]\u0006<WM]\u000b\u0003\u0003\u007f\u0004B!a-\u0003\u0002%!!1AA[\u00051\u0011En\\2l\u001b\u0006t\u0017mZ3s\u0003u\u0019\bn\\;mI\u001a\u000bG\u000e\u001c+ie>,x\r[(o\u000bZ,'/\u001f;iS:<\u0017a\u00057pG\u0006d'\t\\8dW6\u000bg.Y4fe&#\u0017aB:u_B\u0004X\rZ\u0001\fgR|\u0007\u000f]3e?\u0012*\u0017\u000f\u0006\u0003\u0002\u001c\t=\u0001\"CA\u0016M\u0005\u0005\t\u0019AAO\u0003!\u0019Ho\u001c9qK\u0012\u0004\u0013!E4fi\u000e\u000bG/\u00197pO>\u0013H\u000b\u001b:poV\u0011!q\u0003\t\u0005\u0003{\u0012I\"\u0003\u0003\u0003\u001c\u0005}$\u0001F*ik\u001a4G.\u001a\"vM\u001a,'oQ1uC2|w-\u0001\u0005sKN|GN^3s+\t\u0011\tCE\u0003\u0003$\t\u001dBJ\u0002\u0004\u0003&\u0001\u0001!\u0011\u0005\u0002\ryI,g-\u001b8f[\u0016tGO\u0010\t\u0004/\n%\u0012b\u0001B\u00161\n!2\u000b[;gM2,'\t\\8dWJ+7o\u001c7wKJ\f\u0011\u0002\u001e:b]N\u0004xN\u001d;\u0016\u0005\tE\u0002#B$\u00034\t]\u0012b\u0001B\u001b\u0011\n1q\n\u001d;j_:\u0004BA!\u000f\u0003>5\u0011!1\b\u0006\u00043\u0006}\u0014\u0002\u0002B \u0005w\u0011aCU1qS\u0012\u001c8\u000b[;gM2,GK]1ogB|'\u000f^\u0001\u0007g\u0016\u0014h/\u001a:\u0016\u0005\t\u0015\u0003#B$\u00034\t\u001d\u0003\u0003\u0002B\u001d\u0005\u0013JAAa\u0013\u0003<\t\u0019\"+\u00199jIN\u001c\u0006.\u001e4gY\u0016\u001cVM\u001d<fe\u0006y!/Z4jgR,'o\u00155vM\u001adW-\u0006\u0005\u0003R\t\r$\u0011\u000eB8)\u00151&1\u000bB,\u0011\u0019\u0011)\u0006\fa\u0001C\u0006I1\u000f[;gM2,\u0017\n\u001a\u0005\b\u00053b\u0003\u0019\u0001B.\u0003)!W\r]3oI\u0016t7-\u001f\t\u000b\u0003'\u0013iF!\u0019\u0003h\t5\u0014b\u0001B0w\t\t2\u000b[;gM2,G)\u001a9f]\u0012,gnY=\u0011\u0007q\u0014\u0019\u0007\u0002\u0004\u0003f1\u0012\ra \u0002\u0002\u0017B\u0019AP!\u001b\u0005\r\t-DF1\u0001\u0000\u0005\u00051\u0006c\u0001?\u0003p\u00111!\u0011\u000f\u0017C\u0002}\u0014\u0011aQ\u0001\u000fKb,7mQ8na>tWM\u001c;t+\t\u00119\bE\u0003H\u0005g\u0011I\b\u0005\u0003\u0003|\t\u0005UB\u0001B?\u0015\r\u0011y\bW\u0001\u0004CBL\u0017\u0002\u0002BB\u0005{\u0012\u0011d\u00155vM\u001adW-\u0012=fGV$xN]\"p[B|g.\u001a8ug\u0006\u0001S.Y6f\u0005f\u0004\u0018m]:NKJ<WmU8siNCWO\u001a4mK^\u0013\u0018\u000e^3s+\u0019\u0011IIa%\u0003\u0018RQ!1\u0012BM\u0005C\u0013YK!.\u0011\u000f]\u0013iI!%\u0003\u0016&\u0019!q\u0012-\u0003\u001bMCWO\u001a4mK^\u0013\u0018\u000e^3s!\ra(1\u0013\u0003\u0007\u0005Kr#\u0019A@\u0011\u0007q\u00149\n\u0002\u0004\u0003l9\u0012\ra \u0005\u0007;:\u0002\rAa'\u0011\u0011\u0005]'Q\u0014BI\u0005+KAAa(\u0002Z\na\")\u001f9bgNlUM]4f'>\u0014Ho\u00155vM\u001adW\rS1oI2,\u0007b\u0002BR]\u0001\u0007!QU\u0001\u0006[\u0006\u0004\u0018\n\u001a\t\u0004\u000f\n\u001d\u0016b\u0001BU\u0011\n!Aj\u001c8h\u0011\u001d\u0011iK\fa\u0001\u0005_\u000bqaY8oi\u0016DH\u000f\u0005\u0003\u0002\u0014\nE\u0016b\u0001BZw\tYA+Y:l\u0007>tG/\u001a=u\u0011\u001d\u00119L\fa\u0001\u0005s\u000bq\"\\3ue&\u001c7OU3q_J$XM\u001d\t\u0004/\nm\u0016b\u0001B_1\nY2\u000b[;gM2,wK]5uK6+GO]5dgJ+\u0007o\u001c:uKJ\f\u0011bZ3u/JLG/\u001a:\u0016\r\t\r'\u0011\u001aBg))\u0011)Ma4\u0003R\nM'Q\u001b\t\b/\n5%q\u0019Bf!\ra(\u0011\u001a\u0003\u0007\u0005Kz#\u0019A@\u0011\u0007q\u0014i\r\u0002\u0004\u0003l=\u0012\ra \u0005\u0006;>\u0002\rA\u0016\u0005\b\u0005G{\u0003\u0019\u0001BS\u0011\u001d\u0011ik\fa\u0001\u0005_CqAa.0\u0001\u0004\u0011I,A\u0005hKR\u0014V-\u00193feV1!1\u001cBs\u0005S$\u0002C!8\u0003l\n5(\u0011\u001fB{\u0005s\u0014iPa@\u0011\u000f]\u0013yNa9\u0003h&\u0019!\u0011\u001d-\u0003\u001bMCWO\u001a4mKJ+\u0017\rZ3s!\ra(Q\u001d\u0003\u0007\u0005K\u0002$\u0019A@\u0011\u0007q\u0014I\u000f\u0002\u0004\u0003rA\u0012\ra \u0005\u0006;B\u0002\rA\u0016\u0005\u0007\u0005_\u0004\u0004\u0019A1\u0002\u001bM$\u0018M\u001d;NCBLe\u000eZ3y\u0011\u0019\u0011\u0019\u0010\ra\u0001C\u0006YQM\u001c3NCBLe\u000eZ3y\u0011\u0019\u00119\u0010\ra\u0001C\u0006q1\u000f^1siB\u000b'\u000f^5uS>t\u0007B\u0002B~a\u0001\u0007\u0011-\u0001\u0007f]\u0012\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u0003.B\u0002\rAa,\t\u000f\r\u0005\u0001\u00071\u0001\u0004\u0004\u00059Q.\u001a;sS\u000e\u001c\bcA,\u0004\u0006%\u00191q\u0001-\u00035MCWO\u001a4mKJ+\u0017\rZ'fiJL7m\u001d*fa>\u0014H/\u001a:\u0002%I,w-[:uKJ<\u0005/^*ik\u001a4G.\u001a\u000b\u0005\u00037\u0019i\u0001\u0003\u0004\u0003VE\u0002\r!Y\u0001\u0015k:\u0014XmZ5ti\u0016\u0014x\t];TQV4g\r\\3\u0015\t\u0005m11\u0003\u0005\u0007\u0005+\u0012\u0004\u0019A1\u0002#Ut'/Z4jgR,'o\u00155vM\u001adW\r\u0006\u0003\u0002\u001e\u000ee\u0001B\u0002B+g\u0001\u0007\u0011-\u0001\u000btQV4g\r\\3CY>\u001c7NU3t_24XM]\u000b\u0003\u0005O\tAa\u001d;pa\u0002")
public abstract class RapidsShuffleInternalManagerBase
implements ShuffleManager,
RapidsShuffleHeartbeatHandler,
Logging {
    private SparkEnv env;
    private BlockManager blockManager;
    private boolean shouldFallThroughOnEverything;
    private BlockManagerId localBlockManagerId;
    private ShuffleBlockResolver resolver;
    private Option<RapidsShuffleTransport> transport;
    private Option<RapidsShuffleServer> server;
    private Option<ShuffleExecutorComponents> execComponents;
    private final SparkConf conf;
    private final boolean isDriver;
    private final RapidsConf rapidsConf;
    private final SortShuffleManager wrapped;
    private final String transportEnabledMessage;
    private boolean stopped;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public static int getNextSlot() {
        return RapidsShuffleInternalManagerBase$.MODULE$.getNextSlot();
    }

    public static void stopThreadPool() {
        RapidsShuffleInternalManagerBase$.MODULE$.stopThreadPool();
    }

    public static void startThreadPoolIfNeeded(int n) {
        RapidsShuffleInternalManagerBase$.MODULE$.startThreadPoolIfNeeded(n);
    }

    public static <T> Future<T> queueTask(int n, Callable<T> callable) {
        return RapidsShuffleInternalManagerBase$.MODULE$.queueTask(n, callable);
    }

    public static ShuffleHandle unwrapHandle(ShuffleHandle shuffleHandle) {
        return RapidsShuffleInternalManagerBase$.MODULE$.unwrapHandle(shuffleHandle);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public final <K, C> ShuffleReader<K, C> getReader(ShuffleHandle handle, int startPartition, int endPartition, TaskContext context, ShuffleReadMetricsReporter metrics) {
        return ShuffleManager.getReader$((ShuffleManager)this, (ShuffleHandle)handle, (int)startPartition, (int)endPartition, (TaskContext)context, (ShuffleReadMetricsReporter)metrics);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public boolean isDriver() {
        return this.isDriver;
    }

    public BlockManagerId getServerId() {
        return (BlockManagerId)this.server().fold((Function0 & Serializable & scala.Serializable)() -> this.blockManager().blockManagerId(), (Function1 & Serializable & scala.Serializable)x$11 -> x$11.getId());
    }

    @Override
    public void addPeer(BlockManagerId peer) {
        this.transport().foreach((Function1 & Serializable & scala.Serializable)t -> {
            ClientConnection clientConnection;
            try {
                clientConnection = t.connect(peer);
            }
            catch (Exception ex) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Unable to connect to peer ").append(peer).append(", ignoring!").toString(), ex);
                clientConnection = BoxedUnit.UNIT;
            }
            return clientConnection;
        });
    }

    private RapidsConf rapidsConf() {
        return this.rapidsConf;
    }

    public SortShuffleManager wrapped() {
        return this.wrapped;
    }

    private SparkEnv env$lzycompute() {
        RapidsShuffleInternalManagerBase rapidsShuffleInternalManagerBase = this;
        synchronized (rapidsShuffleInternalManagerBase) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.env = SparkEnv$.MODULE$.get();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.env;
    }

    public SparkEnv env() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.env$lzycompute() : this.env;
    }

    private BlockManager blockManager$lzycompute() {
        RapidsShuffleInternalManagerBase rapidsShuffleInternalManagerBase = this;
        synchronized (rapidsShuffleInternalManagerBase) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.blockManager = this.env().blockManager();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.blockManager;
    }

    public BlockManager blockManager() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.blockManager$lzycompute() : this.blockManager;
    }

    private boolean shouldFallThroughOnEverything$lzycompute() {
        RapidsShuffleInternalManagerBase rapidsShuffleInternalManagerBase = this;
        synchronized (rapidsShuffleInternalManagerBase) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                ListBuffer fallThroughReasons = new ListBuffer();
                Object object = GpuShuffleEnv$.MODULE$.isExternalShuffleEnabled() ? fallThroughReasons.$plus$eq((Object)"External Shuffle Service is enabled") : BoxedUnit.UNIT;
                Object object2 = GpuShuffleEnv$.MODULE$.isSparkAuthenticateEnabled() ? fallThroughReasons.$plus$eq((Object)"Spark authentication is enabled") : BoxedUnit.UNIT;
                Object object3 = this.rapidsConf().isSqlExplainOnlyEnabled() ? fallThroughReasons.$plus$eq((Object)"Plugin is in explain only mode") : BoxedUnit.UNIT;
                if (fallThroughReasons.nonEmpty()) {
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(69).append("Rapids Shuffle Plugin is falling back to SortShuffleManager ").append("because: ").append(fallThroughReasons.mkString(", ")).toString());
                }
                this.shouldFallThroughOnEverything = fallThroughReasons.nonEmpty();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.shouldFallThroughOnEverything;
    }

    public boolean shouldFallThroughOnEverything() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.shouldFallThroughOnEverything$lzycompute() : this.shouldFallThroughOnEverything;
    }

    private BlockManagerId localBlockManagerId$lzycompute() {
        RapidsShuffleInternalManagerBase rapidsShuffleInternalManagerBase = this;
        synchronized (rapidsShuffleInternalManagerBase) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.localBlockManagerId = this.blockManager().blockManagerId();
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.localBlockManagerId;
    }

    private BlockManagerId localBlockManagerId() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.localBlockManagerId$lzycompute() : this.localBlockManagerId;
    }

    private boolean stopped() {
        return this.stopped;
    }

    private void stopped_$eq(boolean x$1) {
        this.stopped = x$1;
    }

    public ShuffleBufferCatalog getCatalogOrThrow() {
        return (ShuffleBufferCatalog)Option$.MODULE$.apply((Object)GpuShuffleEnv$.MODULE$.getCatalog()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException("The ShuffleBufferCatalog is not initialized but the RapidsShuffleManager is configured");
        });
    }

    private ShuffleBlockResolver resolver$lzycompute() {
        RapidsShuffleInternalManagerBase rapidsShuffleInternalManagerBase = this;
        synchronized (rapidsShuffleInternalManagerBase) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.resolver = this.shouldFallThroughOnEverything() || this.rapidsConf().isMultiThreadedShuffleManagerMode() ? this.wrapped().shuffleBlockResolver() : new GpuShuffleBlockResolver(this.wrapped().shuffleBlockResolver(), this.getCatalogOrThrow());
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.resolver;
    }

    public ShuffleBlockResolver resolver() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.resolver$lzycompute() : this.resolver;
    }

    private Option<RapidsShuffleTransport> transport$lzycompute() {
        RapidsShuffleInternalManagerBase rapidsShuffleInternalManagerBase = this;
        synchronized (rapidsShuffleInternalManagerBase) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.transport = this.rapidsConf().isUCXShuffleManagerMode() && !this.isDriver() ? new Some((Object)RapidsShuffleTransport$.MODULE$.makeTransport(this.blockManager().shuffleServerId(), this.rapidsConf())) : None$.MODULE$;
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
        }
        return this.transport;
    }

    private Option<RapidsShuffleTransport> transport() {
        return (byte)(this.bitmap$0 & 0x20) == 0 ? this.transport$lzycompute() : this.transport;
    }

    private Option<RapidsShuffleServer> server$lzycompute() {
        RapidsShuffleInternalManagerBase rapidsShuffleInternalManagerBase = this;
        synchronized (rapidsShuffleInternalManagerBase) {
            if ((byte)(this.bitmap$0 & 0x40) == 0) {
                None$ none$;
                if (this.rapidsConf().isGPUShuffle() && !this.isDriver()) {
                    ShuffleBufferCatalog catalog = this.getCatalogOrThrow();
                    RapidsShuffleRequestHandler requestHandler = new RapidsShuffleRequestHandler(null, catalog){
                        private final ShuffleBufferCatalog catalog$1;

                        public RapidsBuffer acquireShuffleBuffer(int tableId) {
                            ShuffleBufferId shuffleBufferId = this.catalog$1.getShuffleBufferId(tableId);
                            return this.catalog$1.acquireBuffer(shuffleBufferId);
                        }

                        public Seq<TableMeta> getShuffleBufferMetas(ShuffleBlockBatchId sbbId) {
                            return (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(sbbId.startReduceId()), sbbId.endReduceId()).flatMap((Function1 & Serializable & scala.Serializable)rid -> $anon$1.$anonfun$getShuffleBufferMetas$1(this, sbbId, BoxesRunTime.unboxToInt((Object)rid)), IndexedSeq$.MODULE$.canBuildFrom());
                        }

                        public static final /* synthetic */ Seq $anonfun$getShuffleBufferMetas$1($anon$1 $this, ShuffleBlockBatchId sbbId$1, int rid) {
                            return $this.catalog$1.blockIdToMetas(new ShuffleBlockId(sbbId$1.shuffleId(), sbbId$1.mapId(), rid));
                        }
                        {
                            this.catalog$1 = catalog$1;
                        }

                        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$getShuffleBufferMetas$1$adapted(org.apache.spark.sql.rapids.RapidsShuffleInternalManagerBase$$anon$1 org.apache.spark.storage.ShuffleBlockBatchId java.lang.Object )}, serializedLambda);
                        }
                    };
                    RapidsShuffleServer server = ((RapidsShuffleTransport)this.transport().get()).makeServer(requestHandler);
                    server.start();
                    none$ = new Some((Object)server);
                } else {
                    none$ = None$.MODULE$;
                }
                this.server = none$;
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x40);
            }
        }
        return this.server;
    }

    private Option<RapidsShuffleServer> server() {
        return (byte)(this.bitmap$0 & 0x40) == 0 ? this.server$lzycompute() : this.server;
    }

    public <K, V, C> ShuffleHandle registerShuffle(int shuffleId, ShuffleDependency<K, V, C> dependency) {
        GpuShuffleDependency gpuShuffleDependency;
        ShuffleHandle orig = this.wrapped().registerShuffle(shuffleId, dependency);
        ShuffleDependency<K, V, C> shuffleDependency = dependency;
        Object object = this.shouldFallThroughOnEverything() || this.rapidsConf().isMultiThreadedShuffleManagerMode() ? orig : (shuffleDependency instanceof GpuShuffleDependency && (gpuShuffleDependency = (GpuShuffleDependency)shuffleDependency).useGPUShuffle() ? new GpuShuffleHandle(orig, (GpuShuffleDependency)dependency) : orig);
        return object;
    }

    private Option<ShuffleExecutorComponents> execComponents$lzycompute() {
        RapidsShuffleInternalManagerBase rapidsShuffleInternalManagerBase = this;
        synchronized (rapidsShuffleInternalManagerBase) {
            if ((byte)(this.bitmap$0 & 0x80) == 0) {
                ShuffleExecutorComponents executorComponents = ShuffleDataIOUtils$.MODULE$.loadShuffleDataIO(this.conf).executor();
                scala.collection.immutable.Map extraConfigs = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.conf.getAllWithPrefix(ShuffleDataIOUtils$.MODULE$.SHUFFLE_SPARK_CONF_PREFIX()))).toMap(Predef$.MODULE$.$conforms());
                executorComponents.initializeExecutor(this.conf.getAppId(), SparkEnv$.MODULE$.get().executorId(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)extraConfigs).asJava());
                this.execComponents = new Some((Object)executorComponents);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x80);
            }
        }
        return this.execComponents;
    }

    public Option<ShuffleExecutorComponents> execComponents() {
        return (byte)(this.bitmap$0 & 0x80) == 0 ? this.execComponents$lzycompute() : this.execComponents;
    }

    public abstract <K, V> ShuffleWriter<K, V> makeBypassMergeSortShuffleWriter(BypassMergeSortShuffleHandle<K, V> var1, long var2, TaskContext var4, ShuffleWriteMetricsReporter var5);

    public <K, V> ShuffleWriter<K, V> getWriter(ShuffleHandle handle, long mapId, TaskContext context, ShuffleWriteMetricsReporter metricsReporter) {
        RapidsCachingWriter rapidsCachingWriter;
        ShuffleHandle shuffleHandle = handle;
        if (shuffleHandle instanceof GpuShuffleHandle) {
            GpuShuffleHandle gpuShuffleHandle = (GpuShuffleHandle)shuffleHandle;
            this.registerGpuShuffle(handle.shuffleId());
            rapidsCachingWriter = new RapidsCachingWriter(this.env().blockManager(), gpuShuffleHandle, mapId, metricsReporter, this.getCatalogOrThrow(), RapidsBufferCatalog$.MODULE$.getDeviceStorage(), this.server(), gpuShuffleHandle.dependency().metrics());
        } else if (shuffleHandle instanceof BypassMergeSortShuffleHandle) {
            GpuShuffleDependency gpuShuffleDependency;
            BypassMergeSortShuffleHandle bypassMergeSortShuffleHandle = (BypassMergeSortShuffleHandle)shuffleHandle;
            ShuffleDependency shuffleDependency = bypassMergeSortShuffleHandle.dependency();
            ShuffleWriter<K, V> shuffleWriter = shuffleDependency instanceof GpuShuffleDependency && (gpuShuffleDependency = (GpuShuffleDependency)shuffleDependency).useMultiThreadedShuffle() ? this.makeBypassMergeSortShuffleWriter((BypassMergeSortShuffleHandle)handle, mapId, context, (ShuffleWriteMetricsReporter)new ThreadSafeShuffleWriteMetricsReporter(metricsReporter)) : this.wrapped().getWriter(handle, mapId, context, metricsReporter);
            rapidsCachingWriter = shuffleWriter;
        } else {
            rapidsCachingWriter = this.wrapped().getWriter(handle, mapId, context, metricsReporter);
        }
        return rapidsCachingWriter;
    }

    public <K, C> ShuffleReader<K, C> getReader(ShuffleHandle handle, int startMapIndex, int endMapIndex, int startPartition, int endPartition, TaskContext context, ShuffleReadMetricsReporter metrics) {
        RapidsCachingReader rapidsCachingReader;
        ShuffleHandle shuffleHandle = handle;
        if (shuffleHandle instanceof GpuShuffleHandle) {
            Iterator iterator;
            GpuShuffleHandle gpuShuffleHandle = (GpuShuffleHandle)shuffleHandle;
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(74).append("Asking map output tracker for dependency ").append(gpuShuffleHandle.dependency()).append(", ").append("map output sizes for: ").append(gpuShuffleHandle.shuffleId()).append(", parts=").append(startPartition).append("-").append(endPartition).toString());
            if (gpuShuffleHandle.dependency().keyOrdering().isDefined()) {
                throw new IllegalStateException(new StringBuilder(82).append("A key ordering was requested for a gpu shuffle ").append("dependency ").append(gpuShuffleHandle.dependency().keyOrdering().get()).append(", this is not supported.").toString());
            }
            try (NvtxRange nvtxRange = new NvtxRange("getMapSizesByExecId", NvtxColor.CYAN);){
                iterator = SparkEnv$.MODULE$.get().mapOutputTracker().getMapSizesByExecutorId(gpuShuffleHandle.shuffleId(), startMapIndex, endMapIndex, startPartition, endPartition);
            }
            Iterator blocksByAddress = iterator;
            rapidsCachingReader = new RapidsCachingReader(this.rapidsConf(), this.localBlockManagerId(), (Iterator<Tuple2<BlockManagerId, Seq<Tuple3<BlockId, Object, Object>>>>)blocksByAddress, context, metrics, this.transport(), this.getCatalogOrThrow(), gpuShuffleHandle.dependency().sparkTypes());
        } else {
            ShuffleHandle shuffleHandle2 = RapidsShuffleInternalManagerBase$.MODULE$.unwrapHandle(shuffleHandle);
            rapidsCachingReader = this.wrapped().getReader(shuffleHandle2, startMapIndex, endMapIndex, startPartition, endPartition, context, metrics);
        }
        return rapidsCachingReader;
    }

    public void registerGpuShuffle(int shuffleId) {
        block0: {
            ShuffleBufferCatalog catalog = GpuShuffleEnv$.MODULE$.getCatalog();
            if (catalog == null) break block0;
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Registering shuffle ").append(shuffleId).toString());
            catalog.registerShuffle(shuffleId);
        }
    }

    public void unregisterGpuShuffle(int shuffleId) {
        block0: {
            ShuffleBufferCatalog catalog = GpuShuffleEnv$.MODULE$.getCatalog();
            if (catalog == null) break block0;
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Unregistering shuffle ").append(shuffleId).toString());
            catalog.unregisterShuffle(shuffleId);
        }
    }

    public boolean unregisterShuffle(int shuffleId) {
        this.unregisterGpuShuffle(shuffleId);
        return this.wrapped().unregisterShuffle(shuffleId);
    }

    public ShuffleBlockResolver shuffleBlockResolver() {
        return this.resolver();
    }

    public synchronized void stop() {
        block1: {
            this.wrapped().stop();
            if (this.stopped()) break block1;
            this.stopped_$eq(true);
            this.server().foreach((Function1 & Serializable & scala.Serializable)x$12 -> {
                x$12.close();
                return BoxedUnit.UNIT;
            });
            this.transport().foreach((Function1 & Serializable & scala.Serializable)x$13 -> {
                x$13.close();
                return BoxedUnit.UNIT;
            });
            if (!this.isDriver() && this.rapidsConf().isMultiThreadedShuffleManagerMode()) {
                RapidsShuffleInternalManagerBase$.MODULE$.stopThreadPool();
            }
        }
    }

    public RapidsShuffleInternalManagerBase(SparkConf conf, boolean isDriver) {
        this.conf = conf;
        this.isDriver = isDriver;
        ShuffleManager.$init$((ShuffleManager)this);
        Logging.$init$((Logging)this);
        this.rapidsConf = new RapidsConf(conf);
        if (!isDriver && this.rapidsConf().isMultiThreadedShuffleManagerMode()) {
            RapidsShuffleInternalManagerBase$.MODULE$.startThreadPoolIfNeeded(this.rapidsConf().shuffleMultiThreadedWriterThreads());
        }
        this.wrapped = new SortShuffleManager(conf);
        this.transportEnabledMessage = !this.rapidsConf().isUCXShuffleManagerMode() ? (this.rapidsConf().isCacheOnlyShuffleManagerMode() ? "Transport disabled (local cached blocks only)" : "Experimental threaded shuffle writer mode") : new StringBuilder(43).append("Transport enabled (remote fetches will use ").append(this.rapidsConf().shuffleTransportClassName()).toString();
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(86).append("Rapids Shuffle Plugin enabled. ").append($this.transportEnabledMessage).append(". To disable the ").append("RAPIDS Shuffle Manager set `").append(RapidsConf$.MODULE$.SHUFFLE_MANAGER_ENABLED()).append("` to false").toString());
        this.stopped = false;
    }

    private static class Slot {
        private final ExecutorService p;

        private ExecutorService p() {
            return this.p;
        }

        public <T> Future<T> offer(Callable<T> task) {
            return this.p().submit(task);
        }

        public void shutdownNow() {
            this.p().shutdownNow();
        }

        public Slot(int slotNum) {
            this.p = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat(new StringBuilder(22).append("rapids-shuffle-writer-").append(slotNum).toString()).setDaemon(true).build());
        }
    }
}

