/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.rapids;

import ai.rapids.cudf.BinaryOperable;
import ai.rapids.cudf.ColumnVector;
import ai.rapids.cudf.ColumnView;
import ai.rapids.cudf.DType;
import ai.rapids.cudf.Scalar;
import com.nvidia.spark.rapids.Arm;
import com.nvidia.spark.rapids.BoolUtils$;
import com.nvidia.spark.rapids.CloseableHolder;
import com.nvidia.spark.rapids.DateUtils$;
import com.nvidia.spark.rapids.GpuColumnVector;
import com.nvidia.spark.rapids.RapidsBuffer;
import java.io.Serializable;
import org.apache.spark.sql.rapids.ParseFormatMeta;
import org.apache.spark.sql.rapids.RegexReplace;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.runtime.BoxesRunTime;

public final class GpuToTimestamp$
implements Arm {
    public static GpuToTimestamp$ MODULE$;
    private final Map<String, ParseFormatMeta> CORRECTED_COMPATIBLE_FORMATS;
    private final Map<String, ParseFormatMeta> LEGACY_COMPATIBLE_FORMATS;
    private final RegexReplace REMOVE_WHITESPACE_FROM_MONTH_DAY;

    static {
        new GpuToTimestamp$();
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T r, Function1<T, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T[] r, Function1<T[], V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T, V> V withResourceIfAllowed(T r, Function1<T, V> block) {
        return (V)Arm.withResourceIfAllowed$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T[] r, Function1<T[], V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends RapidsBuffer, V> V freeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.freeOnExcept$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(CloseableHolder<T> h, Function1<CloseableHolder<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, h, block);
    }

    public Map<String, ParseFormatMeta> CORRECTED_COMPATIBLE_FORMATS() {
        return this.CORRECTED_COMPATIBLE_FORMATS;
    }

    public Map<String, ParseFormatMeta> LEGACY_COMPATIBLE_FORMATS() {
        return this.LEGACY_COMPATIBLE_FORMATS;
    }

    public RegexReplace REMOVE_WHITESPACE_FROM_MONTH_DAY() {
        return this.REMOVE_WHITESPACE_FROM_MONTH_DAY;
    }

    public ColumnVector daysEqual(ColumnVector col, String name) {
        return (ColumnVector)this.withResource(Scalar.fromString((String)name), (Function1 & Serializable & scala.Serializable)scalarName -> col.equalTo((BinaryOperable)scalarName));
    }

    public ColumnVector replaceSpecialDates(ColumnVector stringVector, ColumnVector chronoVector, Map<String, Function0<Scalar>> specialDates) {
        return (ColumnVector)specialDates.foldLeft((Object)chronoVector, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2;
            ColumnVector buffer;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$1, x1$1);
                    if (tuple22 == null) break block2;
                    buffer = (ColumnVector)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            String name = (String)tuple2._1();
            Function0 scalarBuilder = (Function0)tuple2._2();
            ColumnVector columnVector = (ColumnVector)MODULE$.withResource(buffer, (Function1 & Serializable & scala.Serializable)bufVector -> (ColumnVector)MODULE$.withResource(MODULE$.daysEqual(stringVector, name), (Function1 & Serializable & scala.Serializable)isMatch -> (ColumnVector)MODULE$.withResource((AutoCloseable)scalarBuilder.apply(), (Function1 & Serializable & scala.Serializable)scalar -> isMatch.ifElse(scalar, (ColumnView)bufVector))));
            return columnVector;
        });
    }

    public ColumnVector isTimestamp(ColumnVector col, String sparkFormat, String strfFormat) {
        ColumnVector columnVector;
        Option option = this.CORRECTED_COMPATIBLE_FORMATS().get((Object)sparkFormat);
        if (option instanceof Some) {
            Some some = (Some)option;
            ParseFormatMeta fmt = (ParseFormatMeta)some.value();
            columnVector = (ColumnVector)this.withResource(col.matchesRe(fmt.validRegex()), (Function1 & Serializable & scala.Serializable)matches -> (ColumnVector)MODULE$.withResource(col.isTimestamp(strfFormat), (Function1 & Serializable & scala.Serializable)isTimestamp -> isTimestamp.and((BinaryOperable)matches)));
        } else {
            columnVector = ColumnVector.fromScalar((Scalar)Scalar.fromBool((boolean)true), (int)((int)col.getRowCount()));
        }
        return columnVector;
    }

    public ColumnVector parseStringAsTimestamp(GpuColumnVector lhs, String sparkFormat, String strfFormat, DType dtype, boolean failOnError) {
        ColumnVector tsVector2 = (ColumnVector)this.withResource(this.isTimestamp(lhs.getBase(), sparkFormat, strfFormat), (Function1 & Serializable & scala.Serializable)isTs -> {
            if (failOnError && !BoolUtils$.MODULE$.isAllValidTrue((ColumnVector)isTs)) {
                throw new IllegalArgumentException("Exception occurred when parsing timestamp in ANSI mode");
            }
            return (ColumnVector)MODULE$.withResource(Scalar.fromNull((DType)dtype), (Function1 & Serializable & scala.Serializable)nullValue -> (ColumnVector)MODULE$.withResource(lhs.getBase().asTimestamp(dtype, strfFormat), (Function1 & Serializable & scala.Serializable)tsVec -> isTs.ifElse((ColumnView)tsVec, nullValue)));
        });
        return (ColumnVector)this.closeOnExcept(tsVector2, (Function1 & Serializable & scala.Serializable)tsVector -> {
            Map<String, Function0<Scalar>> map = DateUtils$.MODULE$.fetchSpecialDates(dtype);
            ColumnVector columnVector = map.nonEmpty() ? MODULE$.replaceSpecialDates(lhs.getBase(), (ColumnVector)tsVector, map) : tsVector;
            return columnVector;
        });
    }

    public ColumnVector parseStringAsTimestampWithLegacyParserPolicy(GpuColumnVector lhs, String sparkFormat, String strfFormat, DType dtype, Function2<ColumnVector, String, ColumnVector> asTimestamp) {
        Seq seq;
        Some some;
        char c;
        ParseFormatMeta format = (ParseFormatMeta)this.LEGACY_COMPATIBLE_FORMATS().getOrElse((Object)sparkFormat, (Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(19).append("Unsupported format ").append(sparkFormat).toString());
        });
        Seq regexReplaceRules = (Seq)new .colon.colon((Object)this.REMOVE_WHITESPACE_FROM_MONTH_DAY(), (List)Nil$.MODULE$);
        Option<Object> option = format.separator();
        if (option instanceof Some && '/' == (c = BoxesRunTime.unboxToChar((Object)(some = (Some)option).value()))) {
            seq = (Seq)regexReplaceRules.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                RegexReplace regexReplace = x0$1;
                if (regexReplace == null) {
                    throw new MatchError((Object)regexReplace);
                }
                String pattern = regexReplace.search();
                String backref = regexReplace.replace();
                RegexReplace regexReplace2 = new RegexReplace(pattern.replace('-', '/'), backref.replace('-', '/'));
                return regexReplace2;
            }, Seq$.MODULE$.canBuildFrom());
        } else {
            Some some2;
            char c2;
            boolean bl = option instanceof Some && '-' == (c2 = BoxesRunTime.unboxToChar((Object)(some2 = (Some)option).value())) ? true : (option instanceof Some ? true : None$.MODULE$.equals(option));
            if (bl) {
                seq = regexReplaceRules;
            } else {
                throw new MatchError(option);
            }
        }
        Seq rulesWithSeparator = seq;
        ColumnVector fixedUp = (ColumnVector)rulesWithSeparator.foldLeft((Object)this.rejectLeadingNewlineThenStrip(lhs), (Function2 & Serializable & scala.Serializable)(cv, regexRule) -> (ColumnVector)MODULE$.withResource(cv, (Function1 & Serializable & scala.Serializable)x$1 -> x$1.stringReplaceWithBackrefs(regexRule.search(), regexRule.replace())));
        return (ColumnVector)this.withResource(Scalar.fromNull((DType)dtype), (Function1 & Serializable & scala.Serializable)nullValue -> (ColumnVector)MODULE$.withResource(fixedUp.matchesRe(format.validRegex()), (Function1 & Serializable & scala.Serializable)isValidDate -> (ColumnVector)MODULE$.withResource(MODULE$.asTimestampOrNull(fixedUp, dtype, strfFormat, asTimestamp), (Function1 & Serializable & scala.Serializable)timestamp -> isValidDate.ifElse((ColumnView)timestamp, nullValue))));
    }

    private ColumnVector rejectLeadingNewlineThenStrip(GpuColumnVector lhs) {
        return (ColumnVector)this.withResource(lhs.getBase().matchesRe("\\A[ \\t]*[\\n]+"), (Function1 & Serializable & scala.Serializable)hasLeadingNewline -> (ColumnVector)MODULE$.withResource(Scalar.fromNull((DType)DType.STRING), (Function1 & Serializable & scala.Serializable)nullValue -> (ColumnVector)MODULE$.withResource(lhs.getBase().strip(), (Function1 & Serializable & scala.Serializable)stripped -> hasLeadingNewline.ifElse(nullValue, (ColumnView)stripped))));
    }

    public ColumnVector asTimestampOrNull(ColumnVector cv, DType dtype, String strfFormat, Function2<ColumnVector, String, ColumnVector> asTimestamp) {
        return (ColumnVector)this.withResource(cv, (Function1 & Serializable & scala.Serializable)x$2 -> (ColumnVector)MODULE$.withResource(Scalar.fromNull((DType)dtype), (Function1 & Serializable & scala.Serializable)nullValue -> (ColumnVector)MODULE$.withResource(cv.isTimestamp(strfFormat), (Function1 & Serializable & scala.Serializable)isTimestamp -> (ColumnVector)MODULE$.withResource((AutoCloseable)asTimestamp.apply((Object)cv, (Object)strfFormat), (Function1 & Serializable & scala.Serializable)timestamp -> isTimestamp.ifElse((ColumnView)timestamp, nullValue)))));
    }

    private GpuToTimestamp$() {
        MODULE$ = this;
        Arm.$init$(this);
        this.CORRECTED_COMPATIBLE_FORMATS = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"yyyy-MM-dd"), (Object)new ParseFormatMeta((Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToCharacter((char)'-')), false, "\\A\\d{4}-\\d{2}-\\d{2}\\Z")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"yyyy/MM/dd"), (Object)new ParseFormatMeta((Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToCharacter((char)'/')), false, "\\A\\d{4}/\\d{1,2}/\\d{1,2}\\Z")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"yyyy-MM"), (Object)new ParseFormatMeta((Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToCharacter((char)'-')), false, "\\A\\d{4}-\\d{2}\\Z")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"yyyy/MM"), (Object)new ParseFormatMeta((Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToCharacter((char)'/')), false, "\\A\\d{4}/\\d{2}\\Z")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dd/MM/yyyy"), (Object)new ParseFormatMeta((Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToCharacter((char)'/')), false, "\\A\\d{2}/\\d{2}/\\d{4}\\Z")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"yyyy-MM-dd HH:mm:ss"), (Object)new ParseFormatMeta((Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToCharacter((char)'-')), true, "\\A\\d{4}-\\d{2}-\\d{2}[ T]\\d{2}:\\d{2}:\\d{2}\\Z")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"MM-dd"), (Object)new ParseFormatMeta((Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToCharacter((char)'-')), false, "\\A\\d{2}-\\d{2}\\Z")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"MM/dd"), (Object)new ParseFormatMeta((Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToCharacter((char)'/')), false, "\\A\\d{2}/\\d{2}\\Z")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dd-MM"), (Object)new ParseFormatMeta((Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToCharacter((char)'-')), false, "\\A\\d{2}-\\d{2}\\Z")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dd/MM"), (Object)new ParseFormatMeta((Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToCharacter((char)'/')), false, "\\A\\d{2}/\\d{2}\\Z")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"MM/yyyy"), (Object)new ParseFormatMeta((Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToCharacter((char)'/')), false, "\\A\\d{2}/\\d{4}\\Z")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"MM-yyyy"), (Object)new ParseFormatMeta((Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToCharacter((char)'-')), false, "\\A\\d{2}-\\d{4}\\Z")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"MM/dd/yyyy"), (Object)new ParseFormatMeta((Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToCharacter((char)'/')), false, "\\A\\d{2}/\\d{2}/\\d{4}\\Z")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"MM-dd-yyyy"), (Object)new ParseFormatMeta((Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToCharacter((char)'-')), false, "\\A\\d{2}-\\d{2}-\\d{4}\\Z")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"MMyyyy"), (Object)new ParseFormatMeta((Option<Object>)Option$.MODULE$.empty(), false, "\\A\\d{6}\\Z"))}));
        this.LEGACY_COMPATIBLE_FORMATS = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"yyyy-MM-dd"), (Object)new ParseFormatMeta((Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToCharacter((char)'-')), false, "\\A\\d{4}-\\d{1,2}-\\d{1,2}(\\D|\\s|\\Z)")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"yyyy/MM/dd"), (Object)new ParseFormatMeta((Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToCharacter((char)'/')), false, "\\A\\d{4}/\\d{1,2}/\\d{1,2}(\\D|\\s|\\Z)")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dd-MM-yyyy"), (Object)new ParseFormatMeta((Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToCharacter((char)'-')), false, "\\A\\d{1,2}-\\d{1,2}-\\d{4}(\\D|\\s|\\Z)")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dd/MM/yyyy"), (Object)new ParseFormatMeta((Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToCharacter((char)'/')), false, "\\A\\d{1,2}/\\d{1,2}/\\d{4}(\\D|\\s|\\Z)")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"yyyy-MM-dd HH:mm:ss"), (Object)new ParseFormatMeta((Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToCharacter((char)'-')), true, "\\A\\d{4}-\\d{1,2}-\\d{1,2}[ T]\\d{1,2}:\\d{1,2}:\\d{1,2}(\\D|\\s|\\Z)")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"yyyy/MM/dd HH:mm:ss"), (Object)new ParseFormatMeta((Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToCharacter((char)'/')), true, "\\A\\d{4}/\\d{1,2}/\\d{1,2}[ T]\\d{1,2}:\\d{1,2}:\\d{1,2}(\\D|\\s|\\Z)"))}));
        this.REMOVE_WHITESPACE_FROM_MONTH_DAY = new RegexReplace("(\\A\\d+)-([ \\t]*)(\\d+)-([ \\t]*)(\\d+)", "\\1-\\3-\\5");
    }
}

