/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.rapids;

import ai.rapids.cudf.NvtxColor;
import com.nvidia.spark.rapids.Arm;
import com.nvidia.spark.rapids.CloseableHolder;
import com.nvidia.spark.rapids.GatherUtils$;
import com.nvidia.spark.rapids.GpuMetric;
import com.nvidia.spark.rapids.NvtxWithMetrics;
import com.nvidia.spark.rapids.RapidsBuffer;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.apache.spark.util.random.PoissonSampler;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001%4AAC\u0006\u0001-!Aq\u0006\u0001B\u0001B\u0003%\u0001\u0007\u0003\u00057\u0001\t\u0005\t\u0015!\u00038\u0011!Q\u0004A!A!\u0002\u0013Y\u0004\u0002\u0003 \u0001\u0005\u0003\u0005\u000b\u0011B\u001e\t\u0011}\u0002!\u0011!Q\u0001\nmBQ\u0001\u0011\u0001\u0005\u0002\u0005CQ!\u0013\u0001\u0005B)CQa\u0013\u0001\u0005B1CQa\u0013\u0001\u0005\nm\u0013\u0011c\u00129v!>L7o]8o'\u0006l\u0007\u000f\\3s\u0015\taQ\"\u0001\u0004sCBLGm\u001d\u0006\u0003\u001d=\t1a]9m\u0015\t\u0001\u0012#A\u0003ta\u0006\u00148N\u0003\u0002\u0013'\u00051\u0011\r]1dQ\u0016T\u0011\u0001F\u0001\u0004_J<7\u0001A\n\u0004\u0001])\u0003c\u0001\r\u001e?5\t\u0011D\u0003\u0002\u001b7\u00051!/\u00198e_6T!\u0001H\b\u0002\tU$\u0018\u000e\\\u0005\u0003=e\u0011a\u0002U8jgN|gnU1na2,'\u000f\u0005\u0002!G5\t\u0011E\u0003\u0002#\u001b\u0005Qa/Z2u_JL'0\u001a3\n\u0005\u0011\n#!D\"pYVlg.\u0019:CCR\u001c\u0007\u000e\u0005\u0002'[5\tqE\u0003\u0002\rQ)\u0011\u0001#\u000b\u0006\u0003U-\naA\u001c<jI&\f'\"\u0001\u0017\u0002\u0007\r|W.\u0003\u0002/O\t\u0019\u0011I]7\u0002\u0011\u0019\u0014\u0018m\u0019;j_:\u0004\"!\r\u001b\u000e\u0003IR\u0011aM\u0001\u0006g\u000e\fG.Y\u0005\u0003kI\u0012a\u0001R8vE2,\u0017\u0001G;tK\u001e\u000b\u0007oU1na2LgnZ%g!>\u001c8/\u001b2mKB\u0011\u0011\u0007O\u0005\u0003sI\u0012qAQ8pY\u0016\fg.A\u0007ok6|U\u000f\u001e9viJ{wo\u001d\t\u0003MqJ!!P\u0014\u0003\u0013\u001d\u0003X/T3ue&\u001c\u0017\u0001\u00058v[>+H\u000f];u\u0005\u0006$8\r[3t\u0003\u0019y\u0007\u000fV5nK\u00061A(\u001b8jiz\"bA\u0011#F\r\u001eC\u0005CA\"\u0001\u001b\u0005Y\u0001\"B\u0018\u0007\u0001\u0004\u0001\u0004\"\u0002\u001c\u0007\u0001\u00049\u0004\"\u0002\u001e\u0007\u0001\u0004Y\u0004\"\u0002 \u0007\u0001\u0004Y\u0004\"B \u0007\u0001\u0004Y\u0014!B2m_:,G#A\f\u0002\rM\fW\u000e\u001d7f)\ti\u0015\fE\u0002O-~q!a\u0014+\u000f\u0005A\u001bV\"A)\u000b\u0005I+\u0012A\u0002\u001fs_>$h(C\u00014\u0013\t)&'A\u0004qC\u000e\\\u0017mZ3\n\u0005]C&\u0001C%uKJ\fGo\u001c:\u000b\u0005U\u0013\u0004\"\u0002.\t\u0001\u0004i\u0015!\u00042bi\u000eD\u0017\n^3sCR|'\u000f\u0006\u0002]OB\u0019QL\u00193\u000e\u0003yS!a\u00181\u0002\u000f5,H/\u00192mK*\u0011\u0011MM\u0001\u000bG>dG.Z2uS>t\u0017BA2_\u0005-\t%O]1z\u0005V4g-\u001a:\u0011\u0005E*\u0017B\u000143\u0005\rIe\u000e\u001e\u0005\u0006Q&\u0001\r\u0001Z\u0001\b]Vl'k\\<t\u0001")
public class GpuPoissonSampler
extends PoissonSampler<ColumnarBatch>
implements Arm {
    private final double fraction;
    private final boolean useGapSamplingIfPossible;
    private final GpuMetric numOutputRows;
    private final GpuMetric numOutputBatches;
    private final GpuMetric opTime;

    @Override
    public <T extends AutoCloseable, V> V withResource(T r, Function1<T, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T[] r, Function1<T[], V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T, V> V withResourceIfAllowed(T r, Function1<T, V> block) {
        return (V)Arm.withResourceIfAllowed$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T[] r, Function1<T[], V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends RapidsBuffer, V> V freeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.freeOnExcept$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(CloseableHolder<T> h, Function1<CloseableHolder<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, h, block);
    }

    public PoissonSampler<ColumnarBatch> clone() {
        return new GpuPoissonSampler(this.fraction, this.useGapSamplingIfPossible, this.numOutputRows, this.numOutputBatches, this.opTime);
    }

    public Iterator<ColumnarBatch> sample(Iterator<ColumnarBatch> batchIterator) {
        return this.fraction <= 0.0 ? package$.MODULE$.Iterator().empty() : batchIterator.map((Function1 & java.io.Serializable & Serializable)columnarBatch -> (ColumnarBatch)this.withResource(new NvtxWithMetrics("Sample Exec", NvtxColor.YELLOW, (Seq<GpuMetric>)Predef$.MODULE$.wrapRefArray((Object[])new GpuMetric[]{$this.opTime})), (Function1 & java.io.Serializable & Serializable)x$1 -> (ColumnarBatch)this.withResource(columnarBatch, (Function1 & java.io.Serializable & Serializable)cb -> {
            ArrayBuffer<Object> sampledRows = this.sample(cb.numRows());
            $this.numOutputBatches.$plus$eq(1L);
            $this.numOutputRows.$plus$eq(sampledRows.length());
            return GatherUtils$.MODULE$.gather((ColumnarBatch)cb, sampledRows);
        })));
    }

    /*
     * WARNING - void declaration
     */
    private ArrayBuffer<Object> sample(int numRows) {
        void var2_2;
        ArrayBuffer buf = new ArrayBuffer();
        for (int rowIdx = 0; rowIdx < numRows; ++rowIdx) {
            int rowCount = super.sample();
            if (rowCount <= 0) continue;
            for (int i = 0; i < rowCount; ++i) {
                buf.$plus$eq((Object)BoxesRunTime.boxToInteger((int)rowIdx));
            }
        }
        return var2_2;
    }

    public GpuPoissonSampler(double fraction, boolean useGapSamplingIfPossible, GpuMetric numOutputRows, GpuMetric numOutputBatches, GpuMetric opTime) {
        this.fraction = fraction;
        this.useGapSamplingIfPossible = useGapSamplingIfPossible;
        this.numOutputRows = numOutputRows;
        this.numOutputBatches = numOutputBatches;
        this.opTime = opTime;
        super(fraction, useGapSamplingIfPossible);
        Arm.$init$(this);
    }
}

