/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.json.rapids;

import com.nvidia.spark.rapids.FileFormatChecks$;
import com.nvidia.spark.rapids.GpuTextBasedDateUtils$;
import com.nvidia.spark.rapids.JsonFormatType$;
import com.nvidia.spark.rapids.RapidsConf$;
import com.nvidia.spark.rapids.RapidsMeta;
import com.nvidia.spark.rapids.ReadFileOp$;
import com.nvidia.spark.rapids.ScanMeta;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.json.GpuJsonUtils$;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JSONOptionsInRead;
import org.apache.spark.sql.catalyst.json.rapids.GpuJsonScan;
import org.apache.spark.sql.catalyst.util.ParseMode;
import org.apache.spark.sql.catalyst.util.PermissiveMode$;
import org.apache.spark.sql.execution.datasources.PartitioningAwareFileIndex;
import org.apache.spark.sql.execution.datasources.v2.json.JsonScan;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple10;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class GpuJsonScan$
implements scala.Serializable {
    public static GpuJsonScan$ MODULE$;

    static {
        new GpuJsonScan$();
    }

    public void tagSupport(ScanMeta<JsonScan> scanMeta) {
        JsonScan scan = (JsonScan)scanMeta.wrapped();
        this.tagSupport(scan.sparkSession(), scan.dataSchema(), scan.readDataSchema(), (scala.collection.immutable.Map<String, String>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)scan.options()).asScala()).toMap(Predef$.MODULE$.$conforms()), scanMeta);
    }

    public void tagSupport(SparkSession sparkSession, StructType dataSchema, StructType readSchema, scala.collection.immutable.Map<String, String> options, RapidsMeta<?, ?, ?> meta) {
        JSONOptionsInRead parsedOptions = new JSONOptionsInRead(options, sparkSession.sessionState().conf().sessionLocalTimeZone(), sparkSession.sessionState().conf().columnNameOfCorruptRecord());
        if (!meta.conf().isJsonEnabled()) {
            meta.willNotWorkOnGpu(new StringBuilder(63).append("JSON input and output has been disabled. To enable set ").append(RapidsConf$.MODULE$.ENABLE_JSON()).append(" to true").toString());
        }
        if (!meta.conf().isJsonReadEnabled()) {
            meta.willNotWorkOnGpu(new StringBuilder(199).append("JSON input has been disabled. To enable set ").append(RapidsConf$.MODULE$.ENABLE_JSON_READ()).append(" to true. Please note that, currently json reader does ").append("not support column prune, so user must specify the full schema or just let spark to ").append("infer the schema").toString());
        }
        if (parsedOptions.multiLine()) {
            meta.willNotWorkOnGpu("GpuJsonScan does not support multiLine");
        }
        if (parsedOptions.allowComments()) {
            meta.willNotWorkOnGpu("GpuJsonScan does not support allowComments");
        }
        if (parsedOptions.allowUnquotedFieldNames()) {
            meta.willNotWorkOnGpu("GpuJsonScan does not support allowUnquotedFieldNames");
        }
        if (BoxesRunTime.unboxToBoolean((Object)options.get((Object)"allowSingleQuotes").map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)GpuJsonScan$.$anonfun$tagSupport$1(x$1))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false))) {
            meta.willNotWorkOnGpu("GpuJsonScan does not support allowSingleQuotes");
        }
        if (parsedOptions.allowBackslashEscapingAnyCharacter()) {
            meta.willNotWorkOnGpu("GpuJsonScan does not support allowBackslashEscapingAnyCharacter");
        }
        if (parsedOptions.dropFieldIfAllNull()) {
            meta.willNotWorkOnGpu("GpuJsonScan does not support dropFieldIfAllNull");
        }
        ParseMode parseMode = parsedOptions.parseMode();
        PermissiveMode$ permissiveMode$ = PermissiveMode$.MODULE$;
        if (parseMode == null ? permissiveMode$ != null : !parseMode.equals(permissiveMode$)) {
            meta.willNotWorkOnGpu("GpuJsonScan only supports Permissive JSON parsing");
        }
        Object object = parsedOptions.lineSeparator().getOrElse((Function0 & Serializable & scala.Serializable)() -> "\n");
        String string = "\n";
        if (object == null ? string != null : !object.equals(string)) {
            meta.willNotWorkOnGpu("GpuJsonScan only supports \"\\n\" as a line separator");
        }
        parsedOptions.encoding().foreach((Function1 & Serializable & scala.Serializable)enc -> {
            GpuJsonScan$.$anonfun$tagSupport$4(meta, enc);
            return BoxedUnit.UNIT;
        });
        Seq types = (Seq)readSchema.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.dataType(), Seq$.MODULE$.canBuildFrom());
        if (types.contains((Object)DateType$.MODULE$)) {
            GpuTextBasedDateUtils$.MODULE$.tagCudfFormat(meta, GpuJsonUtils$.MODULE$.dateFormatInRead((JSONOptions)parsedOptions), true);
        }
        if (types.contains((Object)TimestampType$.MODULE$)) {
            meta.checkTimeZoneId(parsedOptions.zoneId());
            GpuTextBasedDateUtils$.MODULE$.tagCudfFormat(meta, GpuJsonUtils$.MODULE$.timestampFormatInRead((JSONOptions)parsedOptions), true);
        }
        if (!meta.conf().isJsonFloatReadEnabled() && types.contains((Object)FloatType$.MODULE$)) {
            meta.willNotWorkOnGpu(new StringBuilder(90).append("JSON reading is not 100% compatible when reading floats. ").append("To enable it please set ").append(RapidsConf$.MODULE$.ENABLE_READ_JSON_FLOATS()).append(" to true.").toString());
        }
        if (!meta.conf().isJsonDoubleReadEnabled() && types.contains((Object)DoubleType$.MODULE$)) {
            meta.willNotWorkOnGpu(new StringBuilder(91).append("JSON reading is not 100% compatible when reading doubles. ").append("To enable it please set ").append(RapidsConf$.MODULE$.ENABLE_READ_JSON_DOUBLES()).append(" to true.").toString());
        }
        if (!meta.conf().isJsonDecimalReadEnabled() && types.exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)GpuJsonScan$.$anonfun$tagSupport$6(x$3)))) {
            meta.willNotWorkOnGpu(new StringBuilder(92).append("JSON reading is not 100% compatible when reading decimals. ").append("To enable it please set ").append(RapidsConf$.MODULE$.ENABLE_READ_JSON_DECIMALS()).append(" to true.").toString());
        }
        dataSchema.getFieldIndex(parsedOptions.columnNameOfCorruptRecord()).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)corruptFieldIndex -> {
            block0: {
                StructField f = dataSchema.apply(corruptFieldIndex);
                DataType dataType = f.dataType();
                StringType$ stringType$ = StringType$.MODULE$;
                if (!(dataType != null ? !dataType.equals(stringType$) : stringType$ != null) && f.nullable()) break block0;
                meta.willNotWorkOnGpu("GpuJsonScan does not support Corrupt Record which must be string type and nullable");
            }
        });
        if (readSchema.length() == 1) {
            String string2 = ((StructField)readSchema.head()).name();
            String string3 = parsedOptions.columnNameOfCorruptRecord();
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                meta.willNotWorkOnGpu("GpuJsonScan does not support Corrupt Record");
            }
        }
        FileFormatChecks$.MODULE$.tag(meta, readSchema, JsonFormatType$.MODULE$, ReadFileOp$.MODULE$);
    }

    public GpuJsonScan apply(SparkSession sparkSession, PartitioningAwareFileIndex fileIndex, StructType dataSchema, StructType readDataSchema, StructType readPartitionSchema, CaseInsensitiveStringMap options, Seq<Expression> partitionFilters2, Seq<Expression> dataFilters, Integer maxReaderBatchSizeRows, long maxReaderBatchSizeBytes) {
        return new GpuJsonScan(sparkSession, fileIndex, dataSchema, readDataSchema, readPartitionSchema, options, partitionFilters2, dataFilters, maxReaderBatchSizeRows, maxReaderBatchSizeBytes);
    }

    public Option<Tuple10<SparkSession, PartitioningAwareFileIndex, StructType, StructType, StructType, CaseInsensitiveStringMap, Seq<Expression>, Seq<Expression>, Integer, Object>> unapply(GpuJsonScan x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple10((Object)x$0.sparkSession(), (Object)x$0.fileIndex(), (Object)x$0.dataSchema(), (Object)x$0.readDataSchema(), (Object)x$0.readPartitionSchema(), (Object)x$0.options(), x$0.partitionFilters(), x$0.dataFilters(), (Object)x$0.maxReaderBatchSizeRows(), (Object)BoxesRunTime.boxToLong((long)x$0.maxReaderBatchSizeBytes())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$tagSupport$1(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toBoolean();
    }

    public static final /* synthetic */ void $anonfun$tagSupport$4(RapidsMeta meta$1, String enc) {
        block1: {
            String string = enc;
            String string2 = StandardCharsets.UTF_8.name();
            if (!(string == null ? string2 != null : !string.equals(string2))) break block1;
            String string3 = enc;
            String string4 = StandardCharsets.US_ASCII.name();
            if (string3 == null ? string4 != null : !string3.equals(string4)) {
                meta$1.willNotWorkOnGpu("GpuJsonScan only supports UTF8 or US-ASCII encoded data");
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$tagSupport$6(DataType x$3) {
        return x$3 instanceof DecimalType;
    }

    private GpuJsonScan$() {
        MODULE$ = this;
    }
}

