/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.rapids.shims;

import java.io.Serializable;
import org.apache.spark.MapOutputTrackerMaster;
import org.apache.spark.Partition;
import org.apache.spark.ShuffleDependency;
import org.apache.spark.SparkEnv$;
import org.apache.spark.TaskContext;
import org.apache.spark.shuffle.ShuffleReadMetricsReporter;
import org.apache.spark.shuffle.ShuffleReader;
import org.apache.spark.sql.execution.CoalescedMapperPartitionSpec;
import org.apache.spark.sql.execution.CoalescedPartitionSpec;
import org.apache.spark.sql.execution.PartialMapperPartitionSpec;
import org.apache.spark.sql.execution.PartialReducerPartitionSpec;
import org.apache.spark.sql.execution.ShufflePartitionSpec;
import org.apache.spark.sql.execution.metric.SQLShuffleReadMetricsReporter;
import org.apache.spark.sql.rapids.execution.ShuffledBatchRDDPartition;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq$;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;

public final class ShuffledBatchRDDUtil$ {
    public static ShuffledBatchRDDUtil$ MODULE$;

    static {
        new ShuffledBatchRDDUtil$();
    }

    public Seq<String> preferredLocations(Partition partition, ShuffleDependency<Object, ColumnarBatch, ColumnarBatch> dependency) {
        Seq seq;
        MapOutputTrackerMaster tracker = (MapOutputTrackerMaster)SparkEnv$.MODULE$.get().mapOutputTracker();
        ShufflePartitionSpec shufflePartitionSpec = ((ShuffledBatchRDDPartition)partition).spec();
        if (shufflePartitionSpec instanceof CoalescedPartitionSpec) {
            CoalescedPartitionSpec coalescedPartitionSpec = (CoalescedPartitionSpec)shufflePartitionSpec;
            int startReducerIndex = coalescedPartitionSpec.startReducerIndex();
            int endReducerIndex = coalescedPartitionSpec.endReducerIndex();
            seq = (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(startReducerIndex), endReducerIndex).flatMap((Function1 & Serializable & scala.Serializable)reducerIndex -> tracker.getPreferredLocationsForShuffle(dependency, BoxesRunTime.unboxToInt((Object)reducerIndex)), IndexedSeq$.MODULE$.canBuildFrom());
        } else if (shufflePartitionSpec instanceof PartialReducerPartitionSpec) {
            PartialReducerPartitionSpec partialReducerPartitionSpec = (PartialReducerPartitionSpec)shufflePartitionSpec;
            int startMapIndex = partialReducerPartitionSpec.startMapIndex();
            int endMapIndex = partialReducerPartitionSpec.endMapIndex();
            seq = tracker.getMapLocation(dependency, startMapIndex, endMapIndex);
        } else if (shufflePartitionSpec instanceof PartialMapperPartitionSpec) {
            PartialMapperPartitionSpec partialMapperPartitionSpec = (PartialMapperPartitionSpec)shufflePartitionSpec;
            int mapIndex = partialMapperPartitionSpec.mapIndex();
            seq = tracker.getMapLocation(dependency, mapIndex, mapIndex + 1);
        } else if (shufflePartitionSpec instanceof CoalescedMapperPartitionSpec) {
            CoalescedMapperPartitionSpec coalescedMapperPartitionSpec = (CoalescedMapperPartitionSpec)shufflePartitionSpec;
            int startMapIndex = coalescedMapperPartitionSpec.startMapIndex();
            int endMapIndex = coalescedMapperPartitionSpec.endMapIndex();
            seq = tracker.getMapLocation(dependency, startMapIndex, endMapIndex);
        } else {
            throw new MatchError((Object)shufflePartitionSpec);
        }
        return seq;
    }

    public Tuple2<ShuffleReader<Nothing$, Nothing$>, Object> getReaderAndPartSize(Partition split, TaskContext context, ShuffleDependency<Object, ColumnarBatch, ColumnarBatch> dependency, SQLShuffleReadMetricsReporter sqlMetricsReporter) {
        Tuple2 tuple2;
        ShufflePartitionSpec shufflePartitionSpec = ((ShuffledBatchRDDPartition)split).spec();
        if (shufflePartitionSpec instanceof CoalescedPartitionSpec) {
            CoalescedPartitionSpec coalescedPartitionSpec = (CoalescedPartitionSpec)shufflePartitionSpec;
            int startReducerIndex = coalescedPartitionSpec.startReducerIndex();
            int endReducerIndex = coalescedPartitionSpec.endReducerIndex();
            ShuffleReader reader = SparkEnv$.MODULE$.get().shuffleManager().getReader(dependency.shuffleHandle(), startReducerIndex, endReducerIndex, context, (ShuffleReadMetricsReporter)sqlMetricsReporter);
            Iterator blocksByAddress = SparkEnv$.MODULE$.get().mapOutputTracker().getMapSizesByExecutorId(dependency.shuffleHandle().shuffleId(), 0, Integer.MAX_VALUE, startReducerIndex, endReducerIndex);
            long partitionSize = BoxesRunTime.unboxToLong((Object)blocksByAddress.flatMap((Function1 & Serializable & scala.Serializable)x$1 -> (Seq)x$1._2()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)ShuffledBatchRDDUtil$.$anonfun$getReaderAndPartSize$2(x$2))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            tuple2 = new Tuple2((Object)reader, (Object)BoxesRunTime.boxToLong((long)partitionSize));
        } else if (shufflePartitionSpec instanceof PartialReducerPartitionSpec) {
            PartialReducerPartitionSpec partialReducerPartitionSpec = (PartialReducerPartitionSpec)shufflePartitionSpec;
            int reducerIndex = partialReducerPartitionSpec.reducerIndex();
            int startMapIndex = partialReducerPartitionSpec.startMapIndex();
            int endMapIndex = partialReducerPartitionSpec.endMapIndex();
            ShuffleReader reader = SparkEnv$.MODULE$.get().shuffleManager().getReader(dependency.shuffleHandle(), startMapIndex, endMapIndex, reducerIndex, reducerIndex + 1, context, (ShuffleReadMetricsReporter)sqlMetricsReporter);
            Iterator blocksByAddress = SparkEnv$.MODULE$.get().mapOutputTracker().getMapSizesByExecutorId(dependency.shuffleHandle().shuffleId(), 0, Integer.MAX_VALUE, reducerIndex, reducerIndex + 1);
            long partitionSize = BoxesRunTime.unboxToLong((Object)blocksByAddress.flatMap((Function1 & Serializable & scala.Serializable)x$3 -> (Seq)x$3._2()).filter((Function1 & Serializable & scala.Serializable)tuple -> BoxesRunTime.boxToBoolean((boolean)ShuffledBatchRDDUtil$.$anonfun$getReaderAndPartSize$4(startMapIndex, endMapIndex, tuple))).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)ShuffledBatchRDDUtil$.$anonfun$getReaderAndPartSize$5(x$4))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            tuple2 = new Tuple2((Object)reader, (Object)BoxesRunTime.boxToLong((long)partitionSize));
        } else if (shufflePartitionSpec instanceof PartialMapperPartitionSpec) {
            PartialMapperPartitionSpec partialMapperPartitionSpec = (PartialMapperPartitionSpec)shufflePartitionSpec;
            int mapIndex = partialMapperPartitionSpec.mapIndex();
            int startReducerIndex = partialMapperPartitionSpec.startReducerIndex();
            int endReducerIndex = partialMapperPartitionSpec.endReducerIndex();
            ShuffleReader reader = SparkEnv$.MODULE$.get().shuffleManager().getReader(dependency.shuffleHandle(), mapIndex, mapIndex + 1, startReducerIndex, endReducerIndex, context, (ShuffleReadMetricsReporter)sqlMetricsReporter);
            Iterator blocksByAddress = SparkEnv$.MODULE$.get().mapOutputTracker().getMapSizesByExecutorId(dependency.shuffleHandle().shuffleId(), 0, Integer.MAX_VALUE, startReducerIndex, endReducerIndex);
            long partitionSize = BoxesRunTime.unboxToLong((Object)blocksByAddress.flatMap((Function1 & Serializable & scala.Serializable)x$5 -> (Seq)x$5._2()).filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ShuffledBatchRDDUtil$.$anonfun$getReaderAndPartSize$7(mapIndex, x$6))).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)ShuffledBatchRDDUtil$.$anonfun$getReaderAndPartSize$8(x$7))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            tuple2 = new Tuple2((Object)reader, (Object)BoxesRunTime.boxToLong((long)partitionSize));
        } else if (shufflePartitionSpec instanceof CoalescedMapperPartitionSpec) {
            CoalescedMapperPartitionSpec coalescedMapperPartitionSpec = (CoalescedMapperPartitionSpec)shufflePartitionSpec;
            int startMapIndex = coalescedMapperPartitionSpec.startMapIndex();
            int endMapIndex = coalescedMapperPartitionSpec.endMapIndex();
            int numReducers = coalescedMapperPartitionSpec.numReducers();
            ShuffleReader reader = SparkEnv$.MODULE$.get().shuffleManager().getReader(dependency.shuffleHandle(), startMapIndex, endMapIndex, 0, numReducers, context, (ShuffleReadMetricsReporter)sqlMetricsReporter);
            Iterator blocksByAddress = SparkEnv$.MODULE$.get().mapOutputTracker().getMapSizesByExecutorId(dependency.shuffleHandle().shuffleId(), startMapIndex, endMapIndex, 0, numReducers);
            long partitionSize = BoxesRunTime.unboxToLong((Object)blocksByAddress.flatMap((Function1 & Serializable & scala.Serializable)x$8 -> (Seq)x$8._2()).filter((Function1 & Serializable & scala.Serializable)tuple -> BoxesRunTime.boxToBoolean((boolean)ShuffledBatchRDDUtil$.$anonfun$getReaderAndPartSize$10(startMapIndex, endMapIndex, tuple))).map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)ShuffledBatchRDDUtil$.$anonfun$getReaderAndPartSize$11(x$9))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            tuple2 = new Tuple2((Object)reader, (Object)BoxesRunTime.boxToLong((long)partitionSize));
        } else {
            throw new MatchError((Object)shufflePartitionSpec);
        }
        return tuple2;
    }

    public static final /* synthetic */ long $anonfun$getReaderAndPartSize$2(Tuple3 x$2) {
        return BoxesRunTime.unboxToLong((Object)x$2._2());
    }

    public static final /* synthetic */ boolean $anonfun$getReaderAndPartSize$4(int startMapIndex$1, int endMapIndex$1, Tuple3 tuple) {
        return BoxesRunTime.unboxToInt((Object)tuple._3()) >= startMapIndex$1 && BoxesRunTime.unboxToInt((Object)tuple._3()) < endMapIndex$1;
    }

    public static final /* synthetic */ long $anonfun$getReaderAndPartSize$5(Tuple3 x$4) {
        return BoxesRunTime.unboxToLong((Object)x$4._2());
    }

    public static final /* synthetic */ boolean $anonfun$getReaderAndPartSize$7(int mapIndex$1, Tuple3 x$6) {
        return BoxesRunTime.unboxToInt((Object)x$6._3()) == mapIndex$1;
    }

    public static final /* synthetic */ long $anonfun$getReaderAndPartSize$8(Tuple3 x$7) {
        return BoxesRunTime.unboxToLong((Object)x$7._2());
    }

    public static final /* synthetic */ boolean $anonfun$getReaderAndPartSize$10(int startMapIndex$2, int endMapIndex$2, Tuple3 tuple) {
        return BoxesRunTime.unboxToInt((Object)tuple._3()) >= startMapIndex$2 && BoxesRunTime.unboxToInt((Object)tuple._3()) < endMapIndex$2;
    }

    public static final /* synthetic */ long $anonfun$getReaderAndPartSize$11(Tuple3 x$9) {
        return BoxesRunTime.unboxToLong((Object)x$9._2());
    }

    private ShuffledBatchRDDUtil$() {
        MODULE$ = this;
    }
}

