/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.MultiValuedColumnVector;

public class MapColumnVector
extends MultiValuedColumnVector {
    public ColumnVector keys;
    public ColumnVector values;

    public MapColumnVector() {
        this(1024, null, null);
    }

    public MapColumnVector(int len, ColumnVector keys, ColumnVector values) {
        super(ColumnVector.Type.MAP, len);
        this.keys = keys;
        this.values = values;
    }

    @Override
    protected void childFlatten(boolean useSelected, int[] selected, int size) {
        this.keys.flatten(useSelected, selected, size);
        this.values.flatten(useSelected, selected, size);
    }

    @Override
    public void setElement(int outputElementNum, int inputElementNum, ColumnVector inputColVector) {
        if (this.isRepeating && outputElementNum != 0) {
            throw new RuntimeException("Output column number expected to be 0 when isRepeating");
        }
        if (inputColVector.isRepeating) {
            inputElementNum = 0;
        }
        if (!this.noNulls && this.isNull[outputElementNum]) {
            return;
        }
        if (inputColVector.noNulls || !inputColVector.isNull[inputElementNum]) {
            MapColumnVector input = (MapColumnVector)inputColVector;
            this.isNull[outputElementNum] = false;
            int offset = this.childCount;
            int length = (int)input.lengths[inputElementNum];
            int inputOffset = (int)input.offsets[inputElementNum];
            this.offsets[outputElementNum] = offset;
            this.childCount += length;
            this.lengths[outputElementNum] = length;
            this.keys.ensureSize(this.childCount, true);
            this.values.ensureSize(this.childCount, true);
            for (int i = 0; i < length; ++i) {
                int inputIndex = inputOffset + i;
                int outputIndex = i + offset;
                this.keys.isNull[outputIndex] = false;
                this.keys.setElement(outputIndex, inputIndex, input.keys);
                this.values.isNull[outputIndex] = false;
                this.values.setElement(outputIndex, inputIndex, input.values);
            }
        } else {
            this.isNull[outputElementNum] = true;
            this.noNulls = false;
        }
    }

    @Override
    public void stringifyValue(StringBuilder buffer, int row) {
        if (this.isRepeating) {
            row = 0;
        }
        if (this.noNulls || !this.isNull[row]) {
            buffer.append('[');
            boolean isFirst = true;
            for (long i = this.offsets[row]; i < this.offsets[row] + this.lengths[row]; ++i) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    buffer.append(", ");
                }
                buffer.append("{\"key\": ");
                this.keys.stringifyValue(buffer, (int)i);
                buffer.append(", \"value\": ");
                this.values.stringifyValue(buffer, (int)i);
                buffer.append('}');
            }
            buffer.append(']');
        } else {
            buffer.append("null");
        }
    }

    @Override
    public void init() {
        super.init();
        this.keys.init();
        this.values.init();
    }

    @Override
    public void reset() {
        super.reset();
        this.keys.reset();
        this.values.reset();
    }

    @Override
    public void unFlatten() {
        super.unFlatten();
        if (!this.isRepeating || this.noNulls || !this.isNull[0]) {
            this.keys.unFlatten();
            this.values.unFlatten();
        }
    }

    @Override
    public void copySelected(boolean selectedInUse, int[] sel, int size, ColumnVector outputColVector) {
        MapColumnVector output2 = (MapColumnVector)outputColVector;
        boolean[] outputIsNull = output2.isNull;
        output2.isRepeating = false;
        if (this.isRepeating) {
            if (this.noNulls || !this.isNull[0]) {
                outputIsNull[0] = false;
                outputColVector.setElement(0, 0, this);
            } else {
                outputIsNull[0] = true;
                output2.noNulls = false;
            }
            output2.isRepeating = true;
            return;
        }
        if (this.noNulls) {
            if (selectedInUse) {
                if (!outputColVector.noNulls) {
                    for (int j = 0; j != size; ++j) {
                        int i = sel[j];
                        outputIsNull[i] = false;
                        outputColVector.setElement(i, i, this);
                    }
                } else {
                    for (int j = 0; j != size; ++j) {
                        int i = sel[j];
                        outputColVector.setElement(i, i, this);
                    }
                }
            } else {
                if (!outputColVector.noNulls) {
                    Arrays.fill(outputIsNull, false);
                    outputColVector.noNulls = true;
                }
                this.keys.shallowCopyTo(output2.keys);
                this.values.shallowCopyTo(output2.values);
                System.arraycopy(this.offsets, 0, output2.offsets, 0, size);
                System.arraycopy(this.lengths, 0, output2.lengths, 0, size);
                output2.childCount = this.childCount;
            }
        } else {
            output2.noNulls = false;
            if (selectedInUse) {
                for (int j = 0; j < size; ++j) {
                    int i = sel[j];
                    output2.isNull[i] = this.isNull[i];
                    outputColVector.setElement(i, i, this);
                }
            } else {
                this.keys.shallowCopyTo(output2.keys);
                this.values.shallowCopyTo(output2.values);
                System.arraycopy(this.isNull, 0, output2.isNull, 0, size);
                System.arraycopy(this.offsets, 0, output2.offsets, 0, size);
                System.arraycopy(this.lengths, 0, output2.lengths, 0, size);
                output2.childCount = this.childCount;
            }
        }
    }

    @Override
    public void shallowCopyTo(ColumnVector otherCv) {
        MapColumnVector other = (MapColumnVector)otherCv;
        super.shallowCopyTo(other);
        this.keys.shallowCopyTo(other.keys);
        this.values.shallowCopyTo(other.values);
    }
}

