/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.compress.snappy;

import io.airlift.compress.snappy.UnsafeUtil;
import java.util.Arrays;

public final class SnappyRawCompressor {
    private static final int BLOCK_LOG = 16;
    private static final int BLOCK_SIZE = 65536;
    private static final int INPUT_MARGIN_BYTES = 15;
    private static final int MAX_HASH_TABLE_BITS = 14;
    public static final int MAX_HASH_TABLE_SIZE = 16384;
    private static final int HIGH_BIT_MASK = 128;

    private SnappyRawCompressor() {
    }

    public static int maxCompressedLength(int sourceLength) {
        return 32 + sourceLength + sourceLength / 6;
    }

    public static int compress(Object inputBase, long inputAddress, long inputLimit, Object outputBase, long outputAddress, long outputLimit, short[] table) {
        int maxCompressedLength = SnappyRawCompressor.maxCompressedLength((int)(inputLimit - inputAddress));
        if (outputLimit - outputAddress < (long)maxCompressedLength) {
            throw new IllegalArgumentException("Output buffer must be at least " + maxCompressedLength + " bytes");
        }
        long output2 = SnappyRawCompressor.writeUncompressedLength(outputBase, outputAddress, (int)(inputLimit - inputAddress));
        for (long blockAddress = inputAddress; blockAddress < inputLimit; blockAddress += 65536L) {
            long blockLimit = Math.min(inputLimit, blockAddress + 65536L);
            long input = blockAddress;
            assert (blockLimit - blockAddress <= 65536L);
            int blockHashTableSize = SnappyRawCompressor.getHashTableSize((int)(blockLimit - blockAddress));
            Arrays.fill(table, 0, blockHashTableSize, (short)0);
            int shift = 32 - SnappyRawCompressor.log2Floor(blockHashTableSize);
            assert ((blockHashTableSize & blockHashTableSize - 1) == 0) : "table must be power of two";
            assert (-1 >>> shift == blockHashTableSize - 1);
            long nextEmitAddress = input;
            long fastInputLimit = blockLimit - 15L;
            while (input <= fastInputLimit) {
                int inputBytes;
                assert (nextEmitAddress <= input);
                int skip = 32;
                long candidateIndex = 0L;
                ++input;
                while (input + (long)(skip >>> 5) <= fastInputLimit) {
                    int currentInt = UnsafeUtil.UNSAFE.getInt(inputBase, input);
                    int hash = SnappyRawCompressor.hashBytes(currentInt, shift);
                    candidateIndex = blockAddress + (long)(table[hash] & 0xFFFF);
                    assert (candidateIndex >= 0L);
                    assert (candidateIndex < input);
                    table[hash] = (short)(input - blockAddress);
                    if (currentInt == UnsafeUtil.UNSAFE.getInt(inputBase, candidateIndex)) break;
                    input += (long)(skip++ >>> 5);
                }
                if (input + (long)(skip >>> 5) > fastInputLimit) break;
                assert (nextEmitAddress + 16L <= blockLimit);
                int literalLength = (int)(input - nextEmitAddress);
                output2 = SnappyRawCompressor.emitLiteralLength(outputBase, output2, literalLength);
                output2 = SnappyRawCompressor.fastCopy(inputBase, nextEmitAddress, outputBase, output2, literalLength);
                do {
                    assert (blockLimit >= input + 4L);
                    int matched = SnappyRawCompressor.count(inputBase, input + 4L, candidateIndex + 4L, blockLimit);
                    output2 = SnappyRawCompressor.emitCopy(outputBase, output2, input, candidateIndex, matched += 4);
                    if ((input += (long)matched) >= fastInputLimit) break;
                    long longValue = UnsafeUtil.UNSAFE.getLong(inputBase, input - 1L);
                    int prevInt = (int)longValue;
                    inputBytes = (int)(longValue >>> 8);
                    int prevHash = SnappyRawCompressor.hashBytes(prevInt, shift);
                    table[prevHash] = (short)(input - blockAddress - 1L);
                    int curHash = SnappyRawCompressor.hashBytes(inputBytes, shift);
                    candidateIndex = blockAddress + (long)(table[curHash] & 0xFFFF);
                    table[curHash] = (short)(input - blockAddress);
                } while (inputBytes == UnsafeUtil.UNSAFE.getInt(inputBase, candidateIndex));
                nextEmitAddress = input;
            }
            if (nextEmitAddress >= blockLimit) continue;
            int literalLength = (int)(blockLimit - nextEmitAddress);
            output2 = SnappyRawCompressor.emitLiteralLength(outputBase, output2, literalLength);
            UnsafeUtil.UNSAFE.copyMemory(inputBase, nextEmitAddress, outputBase, output2, literalLength);
            output2 += (long)literalLength;
        }
        return (int)(output2 - outputAddress);
    }

    private static int count(Object inputBase, long start, long matchStart, long matchLimit) {
        long current = start;
        while (current < matchLimit - 7L) {
            long diff = UnsafeUtil.UNSAFE.getLong(inputBase, matchStart) ^ UnsafeUtil.UNSAFE.getLong(inputBase, current);
            if (diff != 0L) {
                return (int)((current += (long)(Long.numberOfTrailingZeros(diff) >> 3)) - start);
            }
            current += 8L;
            matchStart += 8L;
        }
        if (current < matchLimit - 3L && UnsafeUtil.UNSAFE.getInt(inputBase, matchStart) == UnsafeUtil.UNSAFE.getInt(inputBase, current)) {
            current += 4L;
            matchStart += 4L;
        }
        if (current < matchLimit - 1L && UnsafeUtil.UNSAFE.getShort(inputBase, matchStart) == UnsafeUtil.UNSAFE.getShort(inputBase, current)) {
            current += 2L;
            matchStart += 2L;
        }
        if (current < matchLimit && UnsafeUtil.UNSAFE.getByte(inputBase, matchStart) == UnsafeUtil.UNSAFE.getByte(inputBase, current)) {
            ++current;
        }
        return (int)(current - start);
    }

    private static long emitLiteralLength(Object outputBase, long output2, int literalLength) {
        int n = literalLength - 1;
        if (n < 60) {
            UnsafeUtil.UNSAFE.putByte(outputBase, output2++, (byte)(n << 2));
        } else {
            int bytes;
            if (n < 256) {
                UnsafeUtil.UNSAFE.putByte(outputBase, output2++, (byte)-16);
                bytes = 1;
            } else if (n < 65536) {
                UnsafeUtil.UNSAFE.putByte(outputBase, output2++, (byte)-12);
                bytes = 2;
            } else if (n < 0x1000000) {
                UnsafeUtil.UNSAFE.putByte(outputBase, output2++, (byte)-8);
                bytes = 3;
            } else {
                UnsafeUtil.UNSAFE.putByte(outputBase, output2++, (byte)-4);
                bytes = 4;
            }
            UnsafeUtil.UNSAFE.putInt(outputBase, output2, n);
            output2 += (long)bytes;
        }
        return output2;
    }

    private static long fastCopy(Object inputBase, long input, Object outputBase, long output2, int literalLength) {
        long outputLimit = output2 + (long)literalLength;
        do {
            UnsafeUtil.UNSAFE.putLong(outputBase, output2, UnsafeUtil.UNSAFE.getLong(inputBase, input));
            input += 8L;
        } while ((output2 += 8L) < outputLimit);
        return outputLimit;
    }

    private static long emitCopy(Object outputBase, long output2, long input, long matchIndex, int matchLength) {
        long offset = input - matchIndex;
        while (matchLength >= 68) {
            UnsafeUtil.UNSAFE.putByte(outputBase, output2++, (byte)-2);
            UnsafeUtil.UNSAFE.putShort(outputBase, output2, (short)offset);
            output2 += 2L;
            matchLength -= 64;
        }
        if (matchLength > 64) {
            UnsafeUtil.UNSAFE.putByte(outputBase, output2++, (byte)-18);
            UnsafeUtil.UNSAFE.putShort(outputBase, output2, (short)offset);
            output2 += 2L;
            matchLength -= 60;
        }
        if (matchLength < 12 && offset < 2048L) {
            int lenMinus4 = matchLength - 4;
            UnsafeUtil.UNSAFE.putByte(outputBase, output2++, (byte)((long)(1 + (lenMinus4 << 2)) + (offset >>> 8 << 5)));
            UnsafeUtil.UNSAFE.putByte(outputBase, output2++, (byte)offset);
        } else {
            UnsafeUtil.UNSAFE.putByte(outputBase, output2++, (byte)(2 + (matchLength - 1 << 2)));
            UnsafeUtil.UNSAFE.putShort(outputBase, output2, (short)offset);
            output2 += 2L;
        }
        return output2;
    }

    private static int getHashTableSize(int inputSize) {
        int target = Integer.highestOneBit(inputSize - 1) << 1;
        return Math.max(Math.min(target, 16384), 256);
    }

    private static int hashBytes(int value, int shift) {
        return value * 506832829 >>> shift;
    }

    private static int log2Floor(int n) {
        return n == 0 ? -1 : 0x1F ^ Integer.numberOfLeadingZeros(n);
    }

    private static long writeUncompressedLength(Object outputBase, long outputAddress, int uncompressedLength) {
        if (uncompressedLength < 128 && uncompressedLength >= 0) {
            UnsafeUtil.UNSAFE.putByte(outputBase, outputAddress++, (byte)uncompressedLength);
        } else if (uncompressedLength < 16384 && uncompressedLength > 0) {
            UnsafeUtil.UNSAFE.putByte(outputBase, outputAddress++, (byte)(uncompressedLength | 0x80));
            UnsafeUtil.UNSAFE.putByte(outputBase, outputAddress++, (byte)(uncompressedLength >>> 7));
        } else if (uncompressedLength < 0x200000 && uncompressedLength > 0) {
            UnsafeUtil.UNSAFE.putByte(outputBase, outputAddress++, (byte)(uncompressedLength | 0x80));
            UnsafeUtil.UNSAFE.putByte(outputBase, outputAddress++, (byte)(uncompressedLength >>> 7 | 0x80));
            UnsafeUtil.UNSAFE.putByte(outputBase, outputAddress++, (byte)(uncompressedLength >>> 14));
        } else if (uncompressedLength < 0x10000000 && uncompressedLength > 0) {
            UnsafeUtil.UNSAFE.putByte(outputBase, outputAddress++, (byte)(uncompressedLength | 0x80));
            UnsafeUtil.UNSAFE.putByte(outputBase, outputAddress++, (byte)(uncompressedLength >>> 7 | 0x80));
            UnsafeUtil.UNSAFE.putByte(outputBase, outputAddress++, (byte)(uncompressedLength >>> 14 | 0x80));
            UnsafeUtil.UNSAFE.putByte(outputBase, outputAddress++, (byte)(uncompressedLength >>> 21));
        } else {
            UnsafeUtil.UNSAFE.putByte(outputBase, outputAddress++, (byte)(uncompressedLength | 0x80));
            UnsafeUtil.UNSAFE.putByte(outputBase, outputAddress++, (byte)(uncompressedLength >>> 7 | 0x80));
            UnsafeUtil.UNSAFE.putByte(outputBase, outputAddress++, (byte)(uncompressedLength >>> 14 | 0x80));
            UnsafeUtil.UNSAFE.putByte(outputBase, outputAddress++, (byte)(uncompressedLength >>> 21 | 0x80));
            UnsafeUtil.UNSAFE.putByte(outputBase, outputAddress++, (byte)(uncompressedLength >>> 28));
        }
        return outputAddress;
    }
}

