/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.compress.lzo;

import io.airlift.compress.lzo.UnsafeUtil;
import java.util.Arrays;

public final class LzoRawCompressor {
    public static final int LAST_LITERAL_SIZE = 5;
    public static final int MIN_MATCH = 4;
    private static final int MAX_INPUT_SIZE = 0x7E000000;
    private static final int HASH_LOG = 12;
    private static final int MIN_TABLE_SIZE = 16;
    public static final int MAX_TABLE_SIZE = 4096;
    private static final int COPY_LENGTH = 8;
    private static final int MATCH_FIND_LIMIT = 12;
    private static final int MIN_LENGTH = 13;
    private static final int ML_BITS = 4;
    private static final int RUN_BITS = 4;
    private static final int RUN_MASK = 15;
    private static final int MAX_DISTANCE = 49151;
    private static final int SKIP_TRIGGER = 6;

    private LzoRawCompressor() {
    }

    private static int hash(long value, int mask) {
        return (int)(value * 889523592379L >>> 28 & (long)mask);
    }

    public static int maxCompressedLength(int sourceLength) {
        return sourceLength + sourceLength / 255 + 16;
    }

    public static int compress(Object inputBase, long inputAddress, int inputLength, Object outputBase, long outputAddress, long maxOutputLength, int[] table) {
        int tableSize = LzoRawCompressor.computeTableSize(inputLength);
        Arrays.fill(table, 0, tableSize, 0);
        int mask = tableSize - 1;
        if (inputLength > 0x7E000000) {
            throw new IllegalArgumentException("Max input length exceeded");
        }
        if (maxOutputLength < (long)LzoRawCompressor.maxCompressedLength(inputLength)) {
            throw new IllegalArgumentException("Max output length must be larger than " + LzoRawCompressor.maxCompressedLength(inputLength));
        }
        if (inputLength == 0) {
            return 0;
        }
        long input = inputAddress;
        long output2 = outputAddress;
        long inputLimit = inputAddress + (long)inputLength;
        long matchFindLimit = inputLimit - 12L;
        long matchLimit = inputLimit - 5L;
        if (inputLength < 13) {
            output2 = LzoRawCompressor.emitLastLiteral(true, outputBase, output2, inputBase, input, inputLimit - input);
            return (int)(output2 - outputAddress);
        }
        long anchor = input;
        table[LzoRawCompressor.hash((long)UnsafeUtil.UNSAFE.getLong((Object)inputBase, (long)input), (int)mask)] = (int)(input - inputAddress);
        int nextHash = LzoRawCompressor.hash(UnsafeUtil.UNSAFE.getLong(inputBase, ++input), mask);
        boolean done = false;
        boolean firstLiteral = true;
        block0: do {
            long matchIndex;
            long nextInputIndex = input;
            int findMatchAttempts = 64;
            int step = 1;
            do {
                int hash = nextHash;
                input = nextInputIndex;
                if ((nextInputIndex += (long)(step = findMatchAttempts++ >>> 6)) > matchFindLimit) {
                    output2 = LzoRawCompressor.emitLastLiteral(firstLiteral, outputBase, output2, inputBase, anchor, inputLimit - anchor);
                    return (int)(output2 - outputAddress);
                }
                nextHash = LzoRawCompressor.hash(UnsafeUtil.UNSAFE.getLong(inputBase, nextInputIndex), mask);
                table[hash] = (int)(input - inputAddress);
            } while (UnsafeUtil.UNSAFE.getInt(inputBase, matchIndex) != UnsafeUtil.UNSAFE.getInt(inputBase, input) || matchIndex + 49151L < input);
            for (matchIndex = inputAddress + (long)table[hash]; input > anchor && matchIndex > inputAddress && UnsafeUtil.UNSAFE.getByte(inputBase, input - 1L) == UnsafeUtil.UNSAFE.getByte(inputBase, matchIndex - 1L); --input, --matchIndex) {
            }
            int literalLength = (int)(input - anchor);
            output2 = LzoRawCompressor.emitLiteral(firstLiteral, inputBase, anchor, outputBase, output2, literalLength);
            firstLiteral = false;
            do {
                int offset = (int)(input - matchIndex);
                int matchLength = LzoRawCompressor.count(inputBase, input += 4L, matchIndex + 4L, matchLimit);
                output2 = LzoRawCompressor.emitCopy(outputBase, output2, offset, matchLength + 4);
                anchor = input += (long)matchLength;
                if (input > matchFindLimit) {
                    done = true;
                    continue block0;
                }
                long position = input - 2L;
                table[LzoRawCompressor.hash((long)UnsafeUtil.UNSAFE.getLong((Object)inputBase, (long)position), (int)mask)] = (int)(position - inputAddress);
                int hash = LzoRawCompressor.hash(UnsafeUtil.UNSAFE.getLong(inputBase, input), mask);
                matchIndex = inputAddress + (long)table[hash];
                table[hash] = (int)(input - inputAddress);
            } while (matchIndex + 49151L >= input && UnsafeUtil.UNSAFE.getInt(inputBase, matchIndex) == UnsafeUtil.UNSAFE.getInt(inputBase, input));
            nextHash = LzoRawCompressor.hash(UnsafeUtil.UNSAFE.getLong(inputBase, ++input), mask);
        } while (!done);
        output2 = LzoRawCompressor.emitLastLiteral(false, outputBase, output2, inputBase, anchor, inputLimit - anchor);
        return (int)(output2 - outputAddress);
    }

    private static int count(Object inputBase, long start, long matchStart, long matchLimit) {
        long current = start;
        while (current < matchLimit - 7L) {
            long diff = UnsafeUtil.UNSAFE.getLong(inputBase, matchStart) ^ UnsafeUtil.UNSAFE.getLong(inputBase, current);
            if (diff != 0L) {
                return (int)((current += (long)(Long.numberOfTrailingZeros(diff) >> 3)) - start);
            }
            current += 8L;
            matchStart += 8L;
        }
        if (current < matchLimit - 3L && UnsafeUtil.UNSAFE.getInt(inputBase, matchStart) == UnsafeUtil.UNSAFE.getInt(inputBase, current)) {
            current += 4L;
            matchStart += 4L;
        }
        if (current < matchLimit - 1L && UnsafeUtil.UNSAFE.getShort(inputBase, matchStart) == UnsafeUtil.UNSAFE.getShort(inputBase, current)) {
            current += 2L;
            matchStart += 2L;
        }
        if (current < matchLimit && UnsafeUtil.UNSAFE.getByte(inputBase, matchStart) == UnsafeUtil.UNSAFE.getByte(inputBase, current)) {
            ++current;
        }
        return (int)(current - start);
    }

    private static long emitLastLiteral(boolean firstLiteral, Object outputBase, long output2, Object inputBase, long inputAddress, long literalLength) {
        output2 = LzoRawCompressor.encodeLiteralLength(firstLiteral, outputBase, output2, literalLength);
        UnsafeUtil.UNSAFE.copyMemory(inputBase, inputAddress, outputBase, output2, literalLength);
        output2 += literalLength;
        UnsafeUtil.UNSAFE.putByte(outputBase, output2++, (byte)17);
        UnsafeUtil.UNSAFE.putShort(outputBase, output2, (short)0);
        return output2 += 2L;
    }

    private static long emitLiteral(boolean firstLiteral, Object inputBase, long input, Object outputBase, long output2, int literalLength) {
        output2 = LzoRawCompressor.encodeLiteralLength(firstLiteral, outputBase, output2, literalLength);
        long outputLimit = output2 + (long)literalLength;
        do {
            UnsafeUtil.UNSAFE.putLong(outputBase, output2, UnsafeUtil.UNSAFE.getLong(inputBase, input));
            input += 8L;
        } while ((output2 += 8L) < outputLimit);
        return outputLimit;
    }

    private static long encodeLiteralLength(boolean firstLiteral, Object outBase, long output2, long length) {
        if (firstLiteral && length < 238L) {
            UnsafeUtil.UNSAFE.putByte(outBase, output2++, (byte)(length + 17L));
        } else if (length < 4L) {
            UnsafeUtil.UNSAFE.putByte(outBase, output2 - 2L, (byte)((long)UnsafeUtil.UNSAFE.getByte(outBase, output2 - 2L) | length));
        } else if ((length -= 3L) > 15L) {
            long remaining;
            UnsafeUtil.UNSAFE.putByte(outBase, output2++, (byte)0);
            for (remaining = length - 15L; remaining > 255L; remaining -= 255L) {
                UnsafeUtil.UNSAFE.putByte(outBase, output2++, (byte)0);
            }
            UnsafeUtil.UNSAFE.putByte(outBase, output2++, (byte)remaining);
        } else {
            UnsafeUtil.UNSAFE.putByte(outBase, output2++, (byte)length);
        }
        return output2;
    }

    private static long emitCopy(Object outputBase, long output2, int matchOffset, int matchLength) {
        if (matchOffset > 49151 || matchOffset < 1) {
            throw new IllegalArgumentException("Unsupported copy offset: " + matchOffset);
        }
        if (matchLength <= 8 && matchOffset <= 2048) {
            UnsafeUtil.UNSAFE.putByte(outputBase, output2++, (byte)(--matchLength << 5 | (--matchOffset & 7) << 2));
            UnsafeUtil.UNSAFE.putByte(outputBase, output2++, (byte)(matchOffset >>> 3));
            return output2;
        }
        matchLength -= 2;
        if (matchOffset >= 32768) {
            output2 = LzoRawCompressor.encodeMatchLength(outputBase, output2, matchLength, 7, 24);
        } else if (matchOffset > 16384) {
            output2 = LzoRawCompressor.encodeMatchLength(outputBase, output2, matchLength, 7, 16);
        } else {
            output2 = LzoRawCompressor.encodeMatchLength(outputBase, output2, matchLength, 31, 32);
            --matchOffset;
        }
        output2 = LzoRawCompressor.encodeOffset(outputBase, output2, matchOffset);
        return output2;
    }

    private static long encodeOffset(Object outputBase, long outputAddress, int offset) {
        UnsafeUtil.UNSAFE.putShort(outputBase, outputAddress, (short)(offset << 2));
        return outputAddress + 2L;
    }

    private static long encodeMatchLength(Object outputBase, long output2, int matchLength, int baseMatchLength, int command) {
        if (matchLength <= baseMatchLength) {
            UnsafeUtil.UNSAFE.putByte(outputBase, output2++, (byte)(command | matchLength));
        } else {
            long remaining;
            UnsafeUtil.UNSAFE.putByte(outputBase, output2++, (byte)command);
            for (remaining = (long)(matchLength - baseMatchLength); remaining > 510L; remaining -= 510L) {
                UnsafeUtil.UNSAFE.putShort(outputBase, output2, (short)0);
                output2 += 2L;
            }
            if (remaining > 255L) {
                UnsafeUtil.UNSAFE.putByte(outputBase, output2++, (byte)0);
                remaining -= 255L;
            }
            UnsafeUtil.UNSAFE.putByte(outputBase, output2++, (byte)remaining);
        }
        return output2;
    }

    private static int computeTableSize(int inputSize) {
        int target = Integer.highestOneBit(inputSize - 1) << 1;
        return Math.max(Math.min(target, 4096), 16);
    }
}

