/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids.shuffle.ucx;

import ai.rapids.cudf.BaseDeviceMemoryBuffer;
import ai.rapids.cudf.CudaMemoryBuffer;
import ai.rapids.cudf.DeviceMemoryBuffer;
import ai.rapids.cudf.HostMemoryBuffer;
import ai.rapids.cudf.MemoryBuffer;
import com.nvidia.spark.rapids.GpuDeviceManager$;
import com.nvidia.spark.rapids.HashedPriorityQueue;
import com.nvidia.spark.rapids.RapidsConf;
import com.nvidia.spark.rapids.RapidsConf$;
import com.nvidia.spark.rapids.ThreadFactoryBuilder;
import com.nvidia.spark.rapids.shuffle.BounceBuffer;
import com.nvidia.spark.rapids.shuffle.BounceBufferManager;
import com.nvidia.spark.rapids.shuffle.BufferReceiveState;
import com.nvidia.spark.rapids.shuffle.BufferReceiveState$;
import com.nvidia.spark.rapids.shuffle.ClientConnection;
import com.nvidia.spark.rapids.shuffle.DirectByteBufferPool;
import com.nvidia.spark.rapids.shuffle.MessageType$;
import com.nvidia.spark.rapids.shuffle.PendingTransferRequest;
import com.nvidia.spark.rapids.shuffle.RapidsShuffleClient;
import com.nvidia.spark.rapids.shuffle.RapidsShuffleClient$;
import com.nvidia.spark.rapids.shuffle.RapidsShuffleFetchHandler;
import com.nvidia.spark.rapids.shuffle.RapidsShuffleRequestHandler;
import com.nvidia.spark.rapids.shuffle.RapidsShuffleServer;
import com.nvidia.spark.rapids.shuffle.RapidsShuffleTransport;
import com.nvidia.spark.rapids.shuffle.RapidsShuffleTransport$;
import com.nvidia.spark.rapids.shuffle.RefCountedDirectByteBuffer;
import com.nvidia.spark.rapids.shuffle.SendBounceBuffers;
import com.nvidia.spark.rapids.shuffle.Transaction;
import com.nvidia.spark.rapids.shuffle.TransportBuffer;
import com.nvidia.spark.rapids.shuffle.TransportUtils$;
import com.nvidia.spark.rapids.shuffle.ucx.UCX;
import com.nvidia.spark.rapids.shuffle.ucx.UCXConnection$;
import com.nvidia.spark.rapids.shuffle.ucx.UCXShuffleTransport$ClientAndBufferReceiveState$;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.spark.internal.Logging;
import org.apache.spark.storage.BlockManagerId;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0011Ma\u0001B+W\u0001\rD\u0001b\u001f\u0001\u0003\u0002\u0003\u0006I\u0001 \u0005\u000b\u0003\u000b\u0001!\u0011!Q\u0001\n\u0005\u001d\u0001bBA\b\u0001\u0011\u0005\u0011\u0011\u0003\u0005\t\u00037\u0001\u0001\u0015)\u0003\u0002\u001e!A\u0011\u0011\u0006\u0001!\u0002\u0013\ti\u0002C\u0004\u0002,\u0001\u0001\u000b\u0011\u00023\t\u0011\u00055\u0002\u0001)Q\u0005\u0003_A\u0001\"!\u000e\u0001A\u0003%\u0011q\u0007\u0005\t\u0003{\u0001\u0001\u0015!\u0003\u0002\u001e!A\u0011q\b\u0001!\u0002\u0013\t\t\u0005\u0003\u0005\u0002H\u0001\u0001\u000b\u0011BA!\u0011!\tI\u0005\u0001Q!\n\u0005-\u0003\u0002CA2\u0001\u0001\u0006K!!\u001a\t\u0011\u00055\u0004\u0001)Q\u0005\u0003\u0017B\u0001\"a\u001c\u0001A\u0003%\u0011\u0011\u000f\u0005\n/\u0002A)\u0019)C\u0005\u0003\u000fC\u0011\"a$\u0001\u0005\u0004%I!!%\t\u0011\u0005}\u0005\u0001)A\u0005\u0003'C\u0011\"!)\u0001\u0005\u0004%\t!a)\t\u0011\u0005m\u0006\u0001)A\u0005\u0003KCq!!0\u0001\t\u0003\ny\fC\u0004\u0002L\u0002!\t!!4\t\u000f\u0005m\u0007\u0001\"\u0001\u0002^\"9\u0011q\u001c\u0001\u0005\n\u0005\u0005\bbBAv\u0001\u0011\u0005\u0013Q\u001e\u0005\b\u0005#\u0001A\u0011\tB\n\u0011\u001d\u0011\t\u0003\u0001C\u0005\u0005GAqA!\u0014\u0001\t\u0003\u0012yE\u0002\u0004\u0003\\\u0001\u0001!Q\f\u0005\b\u0003\u001fiB\u0011\u0001B7\u0011\u001d\u0011\u0019(\bC!\u0005kB\u0001Ba#\u0001A\u0003%!Q\u0011\u0005\t\u0005\u001b\u0003\u0001\u0015!\u0003\u0003\u0010\"9!Q\u0013\u0001\u0005B\t]\u0005\u0002\u0003BO\u0001\u0001\u0006IAa$\t\u0011\t}\u0005\u0001)A\u0005\u0005\u001fC\u0001B!)\u0001A\u0003%!q\u0012\u0005\b\u0005G\u0003A\u0011\tBS\u0011\u001d\u00119\f\u0001C\u0005\u0005sCqAa0\u0001\t\u0013\u0011\t\rC\u0004\u0003F\u0002!\tEa2\t\u0011\t5\u0007\u0001)A\u0005\u0005\u001f3aAa4\u0001\u0001\tE\u0007B\u0003BmW\t\u0015\r\u0011\"\u0001\u0003\\\"Q!Q\\\u0016\u0003\u0002\u0003\u0006IAa\u0006\t\u000f\u0005=1\u0006\"\u0001\u0003`\"I!Q]\u0016C\u0002\u0013\u0005!q\u001d\u0005\t\u0005_\\\u0003\u0015!\u0003\u0003j\"I!\u0011_\u0016A\u0002\u0013\u0005!1\u001f\u0005\n\u0005k\\\u0003\u0019!C\u0001\u0005oD\u0001B!@,A\u0003&\u0011Q\u0004\u0005\b\u0005\u007f\\C\u0011AB\u0001\r\u0019\u00199\u0001\u0001#\u0004\n!Q1qC\u001b\u0003\u0016\u0004%\ta!\u0007\t\u0015\rmQG!E!\u0002\u0013\t\t\t\u0003\u0006\u0004\u001eU\u0012)\u001a!C\u0001\u0007?A!ba\n6\u0005#\u0005\u000b\u0011BB\u0011\u0011\u001d\ty!\u000eC\u0001\u0007SA\u0011b!\r6\u0003\u0003%\taa\r\t\u0013\reR'%A\u0005\u0002\rm\u0002\"CB)kE\u0005I\u0011AB*\u0011%\u00199&NA\u0001\n\u0003\u001aI\u0006C\u0005\u0004bU\n\t\u0011\"\u0001\u0004d!I1QM\u001b\u0002\u0002\u0013\u00051q\r\u0005\n\u0007c*\u0014\u0011!C!\u0007gB\u0011b! 6\u0003\u0003%\taa \t\u0013\r\rU'!A\u0005B\r\u0015\u0005\"CBDk\u0005\u0005I\u0011IBE\u0011%\u0019Y)NA\u0001\n\u0003\u001aiiB\u0005\u0004\u0012\u0002\t\t\u0011#\u0003\u0004\u0014\u001aI1q\u0001\u0001\u0002\u0002#%1Q\u0013\u0005\b\u0003\u001f9E\u0011ABR\u0011%\u00199iRA\u0001\n\u000b\u001aI\tC\u0005\u0004&\u001e\u000b\t\u0011\"!\u0004(\"I1QV$\u0002\u0002\u0013\u00055q\u0016\u0005\n\u0007\u0003\u0004!\u0019!C\u0005\u0007\u0007D\u0001ba2\u0001A\u0003%1Q\u0019\u0005\b\u0007\u0013\u0004A\u0011ABf\u0011\u001d\u0019\u0019\u000f\u0001C\u0001\u0007KDqa!=\u0001\t\u0003\u0019\u0019\u0010C\u0004\u0004x\u0002!\te!?\t\u000f\u0011\u0005\u0001\u0001\"\u0011\u0005\u0004!9A\u0011\u0002\u0001\u0005B\u0005u\u0007b\u0002C\u0006\u0001\u0011\u0005AQ\u0002\u0002\u0014+\u000eC6\u000b[;gM2,GK]1ogB|'\u000f\u001e\u0006\u0003/b\u000b1!^2y\u0015\tI&,A\u0004tQV4g\r\\3\u000b\u0005mc\u0016A\u0002:ba&$7O\u0003\u0002^=\u0006)1\u000f]1sW*\u0011q\fY\u0001\u0007]ZLG-[1\u000b\u0003\u0005\f1aY8n\u0007\u0001\u0019B\u0001\u00013maB\u0011QM[\u0007\u0002M*\u0011q\r[\u0001\u0005Y\u0006twMC\u0001j\u0003\u0011Q\u0017M^1\n\u0005-4'AB(cU\u0016\u001cG\u000f\u0005\u0002n]6\t\u0001,\u0003\u0002p1\n1\"+\u00199jIN\u001c\u0006.\u001e4gY\u0016$&/\u00198ta>\u0014H\u000f\u0005\u0002rs6\t!O\u0003\u0002ti\u0006A\u0011N\u001c;fe:\fGN\u0003\u0002^k*\u0011ao^\u0001\u0007CB\f7\r[3\u000b\u0003a\f1a\u001c:h\u0013\tQ(OA\u0004M_\u001e<\u0017N\\4\u0002\u001fMDWO\u001a4mKN+'O^3s\u0013\u0012\u00042!`A\u0001\u001b\u0005q(BA@u\u0003\u001d\u0019Ho\u001c:bO\u0016L1!a\u0001\u007f\u00059\u0011En\\2l\u001b\u0006t\u0017mZ3s\u0013\u0012\f!B]1qS\u0012\u001c8i\u001c8g!\u0011\tI!a\u0003\u000e\u0003iK1!!\u0004[\u0005)\u0011\u0016\r]5eg\u000e{gNZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\r\u0005M\u0011qCA\r!\r\t)\u0002A\u0007\u0002-\")1p\u0001a\u0001y\"9\u0011QA\u0002A\u0002\u0005\u001d\u0011\u0001D5oM2Lw\r\u001b;TSj,\u0007\u0003BA\u0010\u0003Ki!!!\t\u000b\u0005\u0005\r\u0012!B:dC2\f\u0017\u0002BA\u0014\u0003C\u0011A\u0001T8oO\u0006i\u0011N\u001c4mS\u001eDG\u000fT5nSR\fq\"\u001b8gY&<\u0007\u000e^'p]&$xN]\u0001\u0010S:4G.[4iiN#\u0018M\u001d;fIB!\u0011qDA\u0019\u0013\u0011\t\u0019$!\t\u0003\u000f\t{w\u000e\\3b]\u0006\u00192\u000f[;gM2,W*\u001a;bI\u0006$\u0018\rU8pYB\u0019Q.!\u000f\n\u0007\u0005m\u0002L\u0001\u000bESJ,7\r\u001e\"zi\u0016\u0014UO\u001a4feB{w\u000e\\\u0001\u0011E>,hnY3Ck\u001a4WM]*ju\u0016\f\u0001\u0003Z3wS\u000e,g*^7Ck\u001a4WM]:\u0011\t\u0005}\u00111I\u0005\u0005\u0003\u000b\n\tCA\u0002J]R\fa\u0002[8ti:+XNQ;gM\u0016\u00148/A\teKZL7-Z*f]\u0012\u0014UO\u001a4NOJ\u0004R!\\A'\u0003#J1!a\u0014Y\u0005M\u0011u.\u001e8dK\n+hMZ3s\u001b\u0006t\u0017mZ3s!\u0011\t\u0019&a\u0018\u000e\u0005\u0005U#\u0002BA,\u00033\nAaY;eM*\u00191,a\u0017\u000b\u0005\u0005u\u0013AA1j\u0013\u0011\t\t'!\u0016\u0003-\t\u000b7/\u001a#fm&\u001cW-T3n_JL()\u001e4gKJ\fq\u0002[8tiN+g\u000e\u001a\"vM\u001aluM\u001d\t\u0006[\u00065\u0013q\r\t\u0005\u0003'\nI'\u0003\u0003\u0002l\u0005U#\u0001\u0005%pgRlU-\\8ss\n+hMZ3s\u0003Q!WM^5dKJ+7-Z5wK\n+hMZ'he\u000691\r\\5f]R\u001c\b\u0003CA:\u0003{\ni\"!!\u000e\u0005\u0005U$\u0002BA<\u0003s\n!bY8oGV\u0014(/\u001a8u\u0015\r\tY\b[\u0001\u0005kRLG.\u0003\u0003\u0002\u0000\u0005U$!E\"p]\u000e,(O]3oi\"\u000b7\u000f['baB\u0019Q.a!\n\u0007\u0005\u0015\u0005LA\nSCBLGm]*ik\u001a4G.Z\"mS\u0016tG/\u0006\u0002\u0002\nB!\u0011QCAF\u0013\r\tiI\u0016\u0002\u0004+\u000eC\u0016aB1mi2K7\u000f^\u000b\u0003\u0003'\u0003b!!\u0003\u0002\u0016\u0006e\u0015bAAL5\n\u0019\u0002*Y:iK\u0012\u0004&/[8sSRL\u0018+^3vKB\u0019Q.a'\n\u0007\u0005u\u0005L\u0001\fQK:$\u0017N\\4Ue\u0006t7OZ3s%\u0016\fX/Z:u\u0003!\tG\u000e\u001e'jgR\u0004\u0013!\u0004<bY&$\u0007*\u00198eY\u0016\u00148/\u0006\u0002\u0002&B1\u0011qUAY\u0003kk!!!+\u000b\t\u0005-\u0016QV\u0001\b[V$\u0018M\u00197f\u0015\u0011\ty+!\t\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u00024\u0006%&a\u0002%bg\"\u001cV\r\u001e\t\u0004[\u0006]\u0016bAA]1\nI\"+\u00199jIN\u001c\u0006.\u001e4gY\u00164U\r^2i\u0011\u0006tG\r\\3s\u000391\u0018\r\\5e\u0011\u0006tG\r\\3sg\u0002\n1cZ3u\t&\u0014Xm\u0019;CsR,')\u001e4gKJ$B!!1\u0002HB\u0019Q.a1\n\u0007\u0005\u0015\u0007L\u0001\u000eSK\u001a\u001cu.\u001e8uK\u0012$\u0015N]3di\nKH/\u001a\"vM\u001a,'\u000fC\u0004\u0002JV\u0001\r!!\b\u0002\tML'0Z\u0001\u0016S:LGOQ8v]\u000e,')\u001e4gKJ\u0004vn\u001c7t)!\ty-!6\u0002X\u0006e\u0007\u0003BA\u0010\u0003#LA!a5\u0002\"\t!QK\\5u\u0011\u001d\tiD\u0006a\u0001\u0003;Aq!a\u0010\u0017\u0001\u0004\t\t\u0005C\u0004\u0002HY\u0001\r!!\u0011\u0002+\u0019\u0014X-\u001a\"pk:\u001cWMQ;gM\u0016\u0014\bk\\8mgR\u0011\u0011qZ\u0001\u0014O\u0016$h*^7C_Vt7-\u001a\"vM\u001a,'o\u001d\u000b\u0007\u0003\u0003\n\u0019/a:\t\u000f\u0005\u0015\b\u00041\u0001\u0002\u001e\u0005I!/Z7bS:Lgn\u001a\u0005\b\u0003SD\u0002\u0019AA!\u00035!x\u000e^1m%\u0016\fX/\u001b:fI\u00069BO]=HKR\u001cVM\u001c3C_Vt7-\u001a\"vM\u001a,'o\u001d\u000b\u0007\u0003_\u0014iAa\u0004\u0011\r\u0005E(\u0011\u0001B\u0004\u001d\u0011\t\u00190!@\u000f\t\u0005U\u00181`\u0007\u0003\u0003oT1!!?c\u0003\u0019a$o\\8u}%\u0011\u00111E\u0005\u0005\u0003\u007f\f\t#A\u0004qC\u000e\\\u0017mZ3\n\t\t\r!Q\u0001\u0002\u0004'\u0016\f(\u0002BA\u0000\u0003C\u00012!\u001cB\u0005\u0013\r\u0011Y\u0001\u0017\u0002\u0012'\u0016tGMQ8v]\u000e,')\u001e4gKJ\u001c\bbBAs3\u0001\u0007\u0011Q\u0004\u0005\b\u0003SL\u0002\u0019AA!\u0003i!(/_$fiJ+7-Z5wK\n{WO\\2f\u0005V4g-\u001a:t)\u0019\u0011)B!\b\u0003 A1\u0011\u0011\u001fB\u0001\u0005/\u00012!\u001cB\r\u0013\r\u0011Y\u0002\u0017\u0002\r\u0005>,hnY3Ck\u001a4WM\u001d\u0005\b\u0003KT\u0002\u0019AA\u000f\u0011\u001d\tIO\u0007a\u0001\u0003\u0003\nq\u0003\u001e:z\u0003\u000e\fX/\u001b:f\u0005>,hnY3Ck\u001a4WM]:\u0016\t\t\u0015\"\u0011\u0007\u000b\u0007\u0005+\u00119Ca\u0011\t\u000f\t%2\u00041\u0001\u0003,\u0005i!m\\;oG\u0016\u0014UO\u001a4NOJ\u0004R!\\A'\u0005[\u0001BAa\f\u000321\u0001Aa\u0002B\u001a7\t\u0007!Q\u0007\u0002\u0002)F!!q\u0007B\u001f!\u0011\tyB!\u000f\n\t\tm\u0012\u0011\u0005\u0002\b\u001d>$\b.\u001b8h!\u0011\t\u0019Fa\u0010\n\t\t\u0005\u0013Q\u000b\u0002\r\u001b\u0016lwN]=Ck\u001a4WM\u001d\u0005\b\u0005\u000bZ\u0002\u0019\u0001B$\u0003!qW/\u001c\"vM\u001a\u001c\bcA3\u0003J%\u0019!1\n4\u0003\u000f%sG/Z4fe\u000691m\u001c8oK\u000e$H\u0003\u0002B)\u0005/\u00022!\u001cB*\u0013\r\u0011)\u0006\u0017\u0002\u0011\u00072LWM\u001c;D_:tWm\u0019;j_:DaA!\u0017\u001d\u0001\u0004a\u0018A\u00059fKJ\u0014En\\2l\u001b\u0006t\u0017mZ3s\u0013\u0012\u0014\u0011cQ1mY\u0016\u0014(+\u001e8t\u0003:$Gj\\4t'\ri\"q\f\t\u0005\u0005C\u00129G\u0004\u0003\u0002t\t\r\u0014\u0002\u0002B3\u0003k\n!\u0003\u00165sK\u0006$\u0007k\\8m\u000bb,7-\u001e;pe&!!\u0011\u000eB6\u0005A\u0019\u0015\r\u001c7feJ+hn\u001d)pY&\u001c\u0017P\u0003\u0003\u0003f\u0005UDC\u0001B8!\r\u0011\t(H\u0007\u0002\u0001\u0005\t\"/\u001a6fGR,G-\u0012=fGV$\u0018n\u001c8\u0015\r\u0005='q\u000fBA\u0011\u001d\u0011Ih\ba\u0001\u0005w\n\u0001B];o]\u0006\u0014G.\u001a\t\u0004K\nu\u0014b\u0001B@M\nA!+\u001e8oC\ndW\rC\u0004\u0003\u0004~\u0001\rA!\"\u0002%QD'/Z1e!>|G.\u0012=fGV$xN\u001d\t\u0005\u0003g\u00129)\u0003\u0003\u0003\n\u0006U$A\u0005+ie\u0016\fG\rU8pY\u0016CXmY;u_J\fab\u00197jK:$X\t_3dkR|'/\u0001\ndY&,g\u000e^\"paf,\u00050Z2vi>\u0014\b\u0003BA:\u0005#KAAa%\u0002v\tyQ\t_3dkR|'oU3sm&\u001cW-\u0001\u0006nC.,7\t\\5f]R$B!!!\u0003\u001a\"1!1\u0014\u0012A\u0002q\faB\u00197pG.l\u0015M\\1hKJLE-\u0001\btKJ4XM]#yK\u000e,Ho\u001c:\u0002%M,'O^3s\u0007>\u0004\u00180\u0012=fGV$xN]\u0001\fEN\u001cX\t_3dkR|'/\u0001\u0006nC.,7+\u001a:wKJ$BAa*\u0003.B\u0019QN!+\n\u0007\t-\u0006LA\nSCBLGm]*ik\u001a4G.Z*feZ,'\u000fC\u0004\u00030\u001a\u0002\rA!-\u0002\u001dI,\u0017/^3ti\"\u000bg\u000e\u001a7feB\u0019QNa-\n\u0007\tU\u0006LA\u000eSCBLGm]*ik\u001a4G.\u001a*fcV,7\u000f\u001e%b]\u0012dWM]\u0001\u0012[\u0006\u00148NQ=uKNLeN\u00127jO\"$H\u0003BAh\u0005wCqA!0(\u0001\u0004\ti\"\u0001\u0007oK\u0016$W\rZ!n_VtG/A\u000bx_VdGMR5u\u0013:4E.[4ii2KW.\u001b;\u0015\t\u0005=\"1\u0019\u0005\b\u0005{C\u0003\u0019AA\u000f\u0003E!wN\\3CsR,7/\u00138GY&<\u0007\u000e\u001e\u000b\u0005\u0003\u001f\u0014I\rC\u0004\u0003L&\u0002\r!!\b\u0002\u001d\tLH/Z:D_6\u0004H.\u001a;fI\u0006!Q\r_3d\u0005Y\u0001VM]\"mS\u0016tGOU3bIf\u0014V-];fgR\u001c8cA\u0016\u0003TB!\u0011q\u0004Bk\u0013\u0011\u00119.!\t\u0003\r\u0005s\u0017PU3g\u00031\u0011w.\u001e8dK\n+hMZ3s+\t\u00119\"A\u0007c_Vt7-\u001a\"vM\u001a,'\u000f\t\u000b\u0005\u0005C\u0014\u0019\u000fE\u0002\u0003r-BqA!7/\u0001\u0004\u00119\"\u0001\tue\u0006t7OZ3s%\u0016\fX/Z:ugV\u0011!\u0011\u001e\t\u0007\u0003O\u0013Y/!'\n\t\t5\u0018\u0011\u0016\u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'/A\tue\u0006t7OZ3s%\u0016\fX/Z:ug\u0002\n1B];o]&twmU5{KV\u0011\u0011QD\u0001\u0010eVtg.\u001b8h'&TXm\u0018\u0013fcR!\u0011q\u001aB}\u0011%\u0011YPMA\u0001\u0002\u0004\ti\"A\u0002yIE\nAB];o]&twmU5{K\u0002\n!\"\u00193e%\u0016\fX/Z:u)\u0011\tyma\u0001\t\u000f\r\u0015A\u00071\u0001\u0002\u001a\u0006\u0019!/Z9\u00037\rc\u0017.\u001a8u\u0003:$')\u001e4gKJ\u0014VmY3jm\u0016\u001cF/\u0019;f'\u001d)$1[B\u0006\u0007#\u0001B!a\b\u0004\u000e%!1qBA\u0011\u0005\u001d\u0001&o\u001c3vGR\u0004B!a\b\u0004\u0014%!1QCA\u0011\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0019\u0019G.[3oiV\u0011\u0011\u0011Q\u0001\bG2LWM\u001c;!\u0003\r\u0011'o]\u000b\u0003\u0007C\u00012!\\B\u0012\u0013\r\u0019)\u0003\u0017\u0002\u0013\u0005V4g-\u001a:SK\u000e,\u0017N^3Ti\u0006$X-\u0001\u0003ceN\u0004CCBB\u0016\u0007[\u0019y\u0003E\u0002\u0003rUBqaa\u0006;\u0001\u0004\t\t\tC\u0004\u0004\u001ei\u0002\ra!\t\u0002\t\r|\u0007/\u001f\u000b\u0007\u0007W\u0019)da\u000e\t\u0013\r]1\b%AA\u0002\u0005\u0005\u0005\"CB\u000fwA\u0005\t\u0019AB\u0011\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"a!\u0010+\t\u0005\u00055qH\u0016\u0003\u0007\u0003\u0002Baa\u0011\u0004N5\u00111Q\t\u0006\u0005\u0007\u000f\u001aI%A\u0005v]\u000eDWmY6fI*!11JA\u0011\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0007\u001f\u001a)EA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0004V)\"1\u0011EB \u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u001111\f\t\u0004K\u000eu\u0013bAB0M\n11\u000b\u001e:j]\u001e\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\u0011\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!1\u0011NB8!\u0011\tyba\u001b\n\t\r5\u0014\u0011\u0005\u0002\u0004\u0003:L\b\"\u0003B~\u0001\u0006\u0005\t\u0019AA!\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAB;!\u0019\u00199h!\u001f\u0004j5\u0011\u0011QV\u0005\u0005\u0007w\niK\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA\u0018\u0007\u0003C\u0011Ba?C\u0003\u0003\u0005\ra!\u001b\u0002\u0011!\f7\u000f[\"pI\u0016$\"!!\u0011\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"aa\u0017\u0002\r\u0015\fX/\u00197t)\u0011\tyca$\t\u0013\tmX)!AA\u0002\r%\u0014aG\"mS\u0016tG/\u00118e\u0005V4g-\u001a:SK\u000e,\u0017N^3Ti\u0006$X\rE\u0002\u0003r\u001d\u001bRaRBL\u0007#\u0001\"b!'\u0004 \u0006\u00055\u0011EB\u0016\u001b\t\u0019YJ\u0003\u0003\u0004\u001e\u0006\u0005\u0012a\u0002:v]RLW.Z\u0005\u0005\u0007C\u001bYJA\tBEN$(/Y2u\rVt7\r^5p]J\"\"aa%\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\r\r-2\u0011VBV\u0011\u001d\u00199B\u0013a\u0001\u0003\u0003Cqa!\bK\u0001\u0004\u0019\t#A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\rE6Q\u0018\t\u0007\u0003?\u0019\u0019la.\n\t\rU\u0016\u0011\u0005\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0011\u0005}1\u0011XAA\u0007CIAaa/\u0002\"\t1A+\u001e9mKJB\u0011ba0L\u0003\u0003\u0005\raa\u000b\u0002\u0007a$\u0003'\u0001\u0006qK:$\u0017N\\4CeN,\"a!2\u0011\u0011\u0005M\u0014QPA\u000f\u0007W\t1\u0002]3oI&twM\u0011:tA\u0005\u0019\u0002.\u00198eY\u0016\u0014UO\u001a4feJ+7-Z5wKRA\u0011qZBg\u0007\u001f\u001c\u0019\u000eC\u0004\u0002J:\u0003\r!!\b\t\u000f\rEg\n1\u0001\u0002\u001e\u00051\u0001.Z1eKJDqa!6O\u0001\u0004\u00199.\u0001\u0006gS:\fG.\u001b>f\u0007\n\u0004\u0002\"a\b\u0004Z\u000eu\u0017qZ\u0005\u0005\u00077\f\tCA\u0005Gk:\u001cG/[8ocA\u0019Qna8\n\u0007\r\u0005\bLA\bUe\u0006t7\u000f]8si\n+hMZ3s\u0003]A\u0017M\u001c3mK\n+hMZ3s)J\fgn]1di&|g\u000e\u0006\u0003\u0002P\u000e\u001d\bbBBu\u001f\u0002\u000711^\u0001\u0003ib\u00042!\\Bw\u0013\r\u0019y\u000f\u0017\u0002\f)J\fgn]1di&|g.\u0001\u000eck\u001a4WM\u001d*fG\u0016Lg/Z*uCR,7i\\7qY\u0016$X\r\u0006\u0003\u0002P\u000eU\bbBBi!\u0002\u0007\u0011QD\u0001\rcV,W/\u001a)f]\u0012Lgn\u001a\u000b\u0005\u0003\u001f\u001cY\u0010C\u0004\u0004~F\u0003\raa@\u0002\tI,\u0017o\u001d\t\u0007\u0003c\u0014\t!!'\u0002\u001b\r\fgnY3m!\u0016tG-\u001b8h)\u0011\ty\r\"\u0002\t\u000f\u0011\u001d!\u000b1\u0001\u00026\u00069\u0001.\u00198eY\u0016\u0014\u0018!B2m_N,\u0017AE:ikR$wn\u001e8D_:tWm\u0019;j_:$B!a4\u0005\u0010!9A\u0011\u0003+A\u0002\tE\u0013\u0001B2p]:\u0004")
public class UCXShuffleTransport
implements RapidsShuffleTransport,
Logging {
    private UCX ucx;
    private volatile UCXShuffleTransport$ClientAndBufferReceiveState$ ClientAndBufferReceiveState$module;
    private final BlockManagerId shuffleServerId;
    private final RapidsConf rapidsConf;
    private long inflightSize;
    private final long inflightLimit;
    private final Object inflightMonitor;
    private boolean inflightStarted;
    private final DirectByteBufferPool shuffleMetadataPool;
    private final long bounceBufferSize;
    private final int deviceNumBuffers;
    private final int hostNumBuffers;
    private BounceBufferManager<BaseDeviceMemoryBuffer> deviceSendBuffMgr;
    private BounceBufferManager<HostMemoryBuffer> hostSendBuffMgr;
    private BounceBufferManager<BaseDeviceMemoryBuffer> deviceReceiveBuffMgr;
    private final ConcurrentHashMap<Object, RapidsShuffleClient> clients;
    private final HashedPriorityQueue<PendingTransferRequest> altList;
    private final HashSet<RapidsShuffleFetchHandler> validHandlers;
    private final ThreadPoolExecutor clientExecutor;
    private final ExecutorService clientCopyExecutor;
    private final ExecutorService serverExecutor;
    private final ExecutorService serverCopyExecutor;
    private final ExecutorService bssExecutor;
    private final ExecutorService exec;
    private final ConcurrentHashMap<Object, ClientAndBufferReceiveState> pendingBrs;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    private UCXShuffleTransport$ClientAndBufferReceiveState$ ClientAndBufferReceiveState() {
        if (this.ClientAndBufferReceiveState$module == null) {
            this.ClientAndBufferReceiveState$lzycompute$1();
        }
        return this.ClientAndBufferReceiveState$module;
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    /*
     * WARNING - void declaration
     */
    private UCX ucx$lzycompute() {
        UCXShuffleTransport uCXShuffleTransport = this;
        synchronized (uCXShuffleTransport) {
            if (!this.bitmap$0) {
                void var2_2;
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "UCX Shuffle Transport Enabled");
                UCX ucxImpl = new UCX(this, this.shuffleServerId, this.rapidsConf);
                ucxImpl.init();
                this.initBounceBufferPools(this.bounceBufferSize, this.deviceNumBuffers, this.hostNumBuffers);
                Seq mgrs = (Seq)new .colon.colon(this.deviceSendBuffMgr, (List)new .colon.colon(this.deviceReceiveBuffMgr, (List)new .colon.colon(this.hostSendBuffMgr, (List)Nil$.MODULE$)));
                ucxImpl.register((Seq<MemoryBuffer>)((Seq)mgrs.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getRootBuffer(), Seq$.MODULE$.canBuildFrom())), ex -> {
                    block0: {
                        if (!ex.isDefined()) break block0;
                        this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error registering bounce buffers", (Throwable)ex.get());
                        ucxImpl.close();
                    }
                });
                this.ucx = var2_2;
                this.bitmap$0 = true;
            }
        }
        return this.ucx;
    }

    private UCX ucx() {
        return !this.bitmap$0 ? this.ucx$lzycompute() : this.ucx;
    }

    private HashedPriorityQueue<PendingTransferRequest> altList() {
        return this.altList;
    }

    public HashSet<RapidsShuffleFetchHandler> validHandlers() {
        return this.validHandlers;
    }

    @Override
    public RefCountedDirectByteBuffer getDirectByteBuffer(long size) {
        RefCountedDirectByteBuffer refCountedDirectByteBuffer;
        if (size > this.rapidsConf.shuffleMaxMetadataSize()) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(73).append("Large metadata message size ").append(size).append(" B, larger ").append("than ").append($this.rapidsConf.shuffleMaxMetadataSize()).append(" B. ").append("Consider setting ").append(RapidsConf$.MODULE$.SHUFFLE_MAX_METADATA_SIZE().key()).append(" higher.").toString());
            refCountedDirectByteBuffer = new RefCountedDirectByteBuffer(ByteBuffer.allocateDirect((int)size), (Option<DirectByteBufferPool>)None$.MODULE$);
        } else {
            refCountedDirectByteBuffer = this.shuffleMetadataPool.getBuffer(size);
        }
        return refCountedDirectByteBuffer;
    }

    public void initBounceBufferPools(long bounceBufferSize, int deviceNumBuffers, int hostNumBuffers) {
        Function1 & Serializable & scala.Serializable deviceAllocator = (Function1 & Serializable & scala.Serializable)size -> UCXShuffleTransport.$anonfun$initBounceBufferPools$1(this, BoxesRunTime.unboxToLong((Object)size));
        this.deviceSendBuffMgr = new BounceBufferManager("device-send", bounceBufferSize, deviceNumBuffers, deviceAllocator);
        this.deviceReceiveBuffMgr = new BounceBufferManager("device-receive", bounceBufferSize, deviceNumBuffers, deviceAllocator);
        this.hostSendBuffMgr = new BounceBufferManager("host-send", bounceBufferSize, hostNumBuffers, (Function1 & Serializable & scala.Serializable)size -> UCXShuffleTransport.$anonfun$initBounceBufferPools$2(BoxesRunTime.unboxToLong((Object)size)));
    }

    public void freeBounceBufferPools() {
        ((IterableLike)new .colon.colon(this.deviceSendBuffMgr, (List)new .colon.colon(this.deviceReceiveBuffMgr, (List)new .colon.colon(this.hostSendBuffMgr, (List)Nil$.MODULE$)))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.close();
            return BoxedUnit.UNIT;
        });
    }

    private int getNumBounceBuffers(long remaining, int totalRequired) {
        long numBuffers = (remaining + this.bounceBufferSize - 1L) / this.bounceBufferSize;
        return (int)Math.min(numBuffers, (long)totalRequired);
    }

    @Override
    public Seq<SendBounceBuffers> tryGetSendBounceBuffers(long remaining, int totalRequired) {
        Seq<BounceBuffer> hostBuffer;
        int numBuffs = this.getNumBounceBuffers(remaining, totalRequired);
        Seq<BounceBuffer> deviceBuffer = this.tryAcquireBounceBuffers(this.deviceSendBuffMgr, Predef$.MODULE$.int2Integer(numBuffs));
        return deviceBuffer.nonEmpty() ? ((hostBuffer = this.tryAcquireBounceBuffers(this.hostSendBuffMgr, Predef$.MODULE$.int2Integer(numBuffs))).nonEmpty() ? (Seq)((TraversableLike)deviceBuffer.zip(hostBuffer, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            BounceBuffer d = (BounceBuffer)tuple2._1();
            BounceBuffer h = (BounceBuffer)tuple2._2();
            SendBounceBuffers sendBounceBuffers = new SendBounceBuffers(d, (Option<BounceBuffer>)new Some((Object)h));
            return sendBounceBuffers;
        }, Seq$.MODULE$.canBuildFrom()) : (Seq)deviceBuffer.map((Function1 & Serializable & scala.Serializable)d -> new SendBounceBuffers((BounceBuffer)d, (Option<BounceBuffer>)None$.MODULE$), Seq$.MODULE$.canBuildFrom())) : (Seq)Nil$.MODULE$;
    }

    @Override
    public Seq<BounceBuffer> tryGetReceiveBounceBuffers(long remaining, int totalRequired) {
        int numBuffs = this.getNumBounceBuffers(remaining, totalRequired);
        return this.tryAcquireBounceBuffers(this.deviceReceiveBuffMgr, Predef$.MODULE$.int2Integer(numBuffs));
    }

    private <T extends MemoryBuffer> Seq<BounceBuffer> tryAcquireBounceBuffers(BounceBufferManager<T> bounceBuffMgr, Integer numBuffs) {
        int possibleNumBuffers = Math.min(bounceBuffMgr.numBuffers(), Predef$.MODULE$.Integer2int(numBuffs));
        Seq<BounceBuffer> bounceBuffers = bounceBuffMgr.acquireBuffersNonBlocking(possibleNumBuffers);
        this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Got ").append(bounceBuffers.size()).append(" bounce buffers from pool ").append("out of ").append(numBuffs).append(" requested.").toString());
        return bounceBuffers;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ClientConnection connect(BlockManagerId peerBlockManagerId) {
        void var3_5;
        String[] topoParts;
        Option topo = peerBlockManagerId.topologyInfo();
        if (topo.isDefined()) {
            topoParts = ((String)topo.get()).split("=");
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])topoParts)).size() != 2 || !topoParts[0].equalsIgnoreCase(RapidsShuffleTransport$.MODULE$.BLOCK_MANAGER_ID_TOPO_PREFIX())) {
                throw new IllegalStateException(new StringBuilder(48).append("Invalid block manager id for the rapids ").append("shuffle ").append(peerBlockManagerId).toString());
            }
        } else {
            throw new IllegalStateException(new StringBuilder(48).append("Invalid block manager id for the rapids ").append("shuffle ").append(peerBlockManagerId).toString());
        }
        int peerExecutorId = new StringOps(Predef$.MODULE$.augmentString(peerBlockManagerId.executorId())).toInt();
        ClientConnection connection = this.ucx().getConnection(peerExecutorId, peerBlockManagerId.host(), new StringOps(Predef$.MODULE$.augmentString(topoParts[1])).toInt());
        return var3_5;
    }

    @Override
    public RapidsShuffleClient makeClient(BlockManagerId blockManagerId) {
        long peerExecutorId = new StringOps(Predef$.MODULE$.augmentString(blockManagerId.executorId())).toLong();
        ClientConnection clientConnection = this.connect(blockManagerId);
        return this.clients.computeIfAbsent(BoxesRunTime.boxToLong((long)peerExecutorId), x$3 -> UCXShuffleTransport.$anonfun$makeClient$1(this, clientConnection, BoxesRunTime.unboxToLong((Object)x$3)));
    }

    @Override
    public RapidsShuffleServer makeServer(RapidsShuffleRequestHandler requestHandler) {
        return new RapidsShuffleServer(this, this.ucx().getServerConnection(), this.shuffleServerId, requestHandler, this.serverExecutor, this.bssExecutor, this.rapidsConf);
    }

    private void markBytesInFlight(long neededAmount) {
        Object object = this.inflightMonitor;
        synchronized (object) {
            Predef$.MODULE$.require(this.wouldFitInFlightLimit(neededAmount), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Inflight limit can't allow this size ").append(neededAmount).append(" of request").toString());
            this.inflightSize += neededAmount;
        }
    }

    private boolean wouldFitInFlightLimit(long neededAmount) {
        boolean bl;
        Object object = this.inflightMonitor;
        synchronized (object) {
            bl = this.inflightSize + neededAmount <= this.inflightLimit || this.inflightSize == 0L;
        }
        return bl;
    }

    @Override
    public void doneBytesInFlight(long bytesCompleted) {
        Object object = this.inflightMonitor;
        synchronized (object) {
            this.inflightSize -= bytesCompleted;
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Done with ").append(bytesCompleted).append(" bytes inflight, ").append("new inflightSize is ").append($this.inflightSize).toString());
            this.inflightMonitor.notifyAll();
        }
    }

    private ConcurrentHashMap<Object, ClientAndBufferReceiveState> pendingBrs() {
        return this.pendingBrs;
    }

    public void handleBufferReceive(long size, long header, Function1<TransportBuffer, BoxedUnit> finalizeCb) {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Handling: ").append(TransportUtils$.MODULE$.toHex(header)).append(" with size ").append(size).toString());
        ClientAndBufferReceiveState clientAndBrs = this.pendingBrs().get(BoxesRunTime.boxToLong((long)header));
        Predef$.MODULE$.require(clientAndBrs != null, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Unknown header for a buffer receive: ").append(TransportUtils$.MODULE$.toHex(header)).toString());
        clientAndBrs.brs().getBufferWhenReady(finalizeCb, size);
    }

    public void handleBufferTransaction(Transaction tx) {
        long header = tx.getHeader();
        ClientAndBufferReceiveState clientAndBrs = this.pendingBrs().get(BoxesRunTime.boxToLong((long)header));
        Predef$.MODULE$.require(clientAndBrs != null, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Unknown header for a buffer receive: ").append(TransportUtils$.MODULE$.toHex(header)).toString());
        RapidsShuffleClient client = clientAndBrs.client();
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Handling for peer ").append(client.connection().getPeerExecutorId()).append(", ").append("handling ").append(TransportUtils$.MODULE$.toHex(header)).append(", SUCCESS").toString());
        client.handleBufferReceive(tx, clientAndBrs.brs());
    }

    public void bufferReceiveStateComplete(long header) {
        ClientAndBufferReceiveState existing = this.pendingBrs().remove(BoxesRunTime.boxToLong((long)header));
        Predef$.MODULE$.require(existing != null, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Unknown header ").append(TransportUtils$.MODULE$.toHex(header)).append(" for a `BufferReceiveState`").toString());
    }

    @Override
    public void queuePending(Seq<PendingTransferRequest> reqs) {
        HashedPriorityQueue<PendingTransferRequest> hashedPriorityQueue = this.altList();
        synchronized (hashedPriorityQueue) {
            this.validHandlers().add((Object)((PendingTransferRequest)reqs.head()).handler());
            this.altList().addAll((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(reqs).asJava());
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("THROTTLING ").append(this.altList().size()).append(" queued requests").toString());
            this.altList().notifyAll();
        }
    }

    @Override
    public void cancelPending(RapidsShuffleFetchHandler handler) {
        HashedPriorityQueue<PendingTransferRequest> hashedPriorityQueue = this.altList();
        synchronized (hashedPriorityQueue) {
            Object object;
            if (this.validHandlers().contains((Object)handler)) {
                if (!this.altList().isEmpty()) {
                    java.util.Iterator<PendingTransferRequest> it = this.altList().iterator();
                    ArrayBuffer toRemove = new ArrayBuffer();
                    while (it.hasNext()) {
                        PendingTransferRequest pending = it.next();
                        RapidsShuffleFetchHandler rapidsShuffleFetchHandler = pending.handler();
                        RapidsShuffleFetchHandler rapidsShuffleFetchHandler2 = handler;
                        if (rapidsShuffleFetchHandler != null ? !rapidsShuffleFetchHandler.equals(rapidsShuffleFetchHandler2) : rapidsShuffleFetchHandler2 != null) continue;
                        toRemove.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PendingTransferRequest[]{pending}));
                    }
                    if (toRemove.nonEmpty()) {
                        toRemove.foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)UCXShuffleTransport.$anonfun$cancelPending$1(this, x$1)));
                    }
                }
                object = BoxesRunTime.boxToBoolean((boolean)this.validHandlers().remove((Object)handler));
            } else {
                object = BoxedUnit.UNIT;
            }
        }
    }

    @Override
    public void close() {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "UCX transport closing");
        this.ucx().shuttingDown();
        this.exec.shutdown();
        this.bssExecutor.shutdown();
        this.clientExecutor.shutdown();
        this.serverExecutor.shutdown();
        HashedPriorityQueue<PendingTransferRequest> hashedPriorityQueue = this.altList();
        synchronized (hashedPriorityQueue) {
            this.inflightStarted = false;
            this.altList().notifyAll();
        }
        if (!this.exec.awaitTermination(500L, TimeUnit.MILLISECONDS)) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "UCX Shuffle Transport throttle failed to terminate correctly");
        }
        if (!this.clientExecutor.awaitTermination(500L, TimeUnit.MILLISECONDS)) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "UCX Shuffle Client failed to terminate correctly");
        }
        if (!this.serverExecutor.awaitTermination(500L, TimeUnit.MILLISECONDS)) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "UCX Shuffle Server main executor failed to terminate correctly");
        }
        if (!this.bssExecutor.awaitTermination(500L, TimeUnit.MILLISECONDS)) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "UCX Shuffle Server BufferSendState executor failed to terminate correctly");
        }
        this.ucx().close();
        this.freeBounceBufferPools();
    }

    public void shutdownConnection(ClientConnection conn) {
        block0: {
            RapidsShuffleClient client = this.clients.remove(BoxesRunTime.boxToLong((long)conn.getPeerExecutorId()));
            if (client == null) break block0;
            client.close();
        }
    }

    private final void ClientAndBufferReceiveState$lzycompute$1() {
        UCXShuffleTransport uCXShuffleTransport = this;
        synchronized (uCXShuffleTransport) {
            if (this.ClientAndBufferReceiveState$module == null) {
                this.ClientAndBufferReceiveState$module = new UCXShuffleTransport$ClientAndBufferReceiveState$(this);
            }
        }
    }

    public static final /* synthetic */ BaseDeviceMemoryBuffer $anonfun$initBounceBufferPools$1(UCXShuffleTransport $this, long size) {
        return $this.rapidsConf.rmmPool().equalsIgnoreCase("ASYNC") ? CudaMemoryBuffer.allocate((long)size) : DeviceMemoryBuffer.allocate((long)size);
    }

    public static final /* synthetic */ HostMemoryBuffer $anonfun$initBounceBufferPools$2(long size) {
        return HostMemoryBuffer.allocate((long)size);
    }

    public static final /* synthetic */ RapidsShuffleClient $anonfun$makeClient$1(UCXShuffleTransport $this, ClientConnection clientConnection$1, long x$3) {
        RapidsShuffleClient client = new RapidsShuffleClient(clientConnection$1, $this, $this.clientExecutor, $this.clientCopyExecutor, RapidsShuffleClient$.MODULE$.$lessinit$greater$default$5(), RapidsShuffleClient$.MODULE$.$lessinit$greater$default$6());
        clientConnection$1.registerReceiveHandler(MessageType$.MODULE$.Buffer());
        return client;
    }

    public static final /* synthetic */ void $anonfun$new$5(UCXShuffleTransport $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        RapidsShuffleClient client = (RapidsShuffleClient)tuple2._1();
        PerClientReadyRequests perClientRequests = (PerClientReadyRequests)tuple2._2();
        long brsId = UCXConnection$.MODULE$.composeBufferHeader(client.connection().getPeerExecutorId(), $this.ucx().assignUniqueId());
        BufferReceiveState brs = new BufferReceiveState(brsId, perClientRequests.bounceBuffer(), (Seq<PendingTransferRequest>)perClientRequests.transferRequests(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.bufferReceiveStateComplete(brsId), BufferReceiveState$.MODULE$.$lessinit$greater$default$5());
        $this.pendingBrs().put(BoxesRunTime.boxToLong((long)brs.id()), new ClientAndBufferReceiveState($this, client, brs));
        client.issueBufferReceives(brs);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$cancelPending$1(UCXShuffleTransport $this, Object x$1) {
        return $this.altList().remove(x$1);
    }

    public UCXShuffleTransport(BlockManagerId shuffleServerId, RapidsConf rapidsConf) {
        this.shuffleServerId = shuffleServerId;
        this.rapidsConf = rapidsConf;
        Logging.$init$((Logging)this);
        this.inflightSize = 0L;
        this.inflightLimit = rapidsConf.shuffleTransportMaxReceiveInflightBytes();
        this.inflightMonitor = new Object();
        this.inflightStarted = true;
        this.shuffleMetadataPool = new DirectByteBufferPool(rapidsConf.shuffleMaxMetadataSize());
        this.bounceBufferSize = rapidsConf.shuffleUcxBounceBuffersSize();
        this.deviceNumBuffers = rapidsConf.shuffleUcxDeviceBounceBuffersCount();
        this.hostNumBuffers = rapidsConf.shuffleUcxHostBounceBuffersCount();
        this.deviceSendBuffMgr = null;
        this.hostSendBuffMgr = null;
        this.deviceReceiveBuffMgr = null;
        this.clients = new ConcurrentHashMap();
        this.altList = new HashedPriorityQueue(1000, (t, t1) -> Long.compare(t.getLength(), t1.getLength()));
        this.validHandlers = new HashSet();
        this.clientExecutor = new ThreadPoolExecutor(1, rapidsConf.shuffleMaxClientThreads(), rapidsConf.shuffleClientThreadKeepAliveTime(), TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(1), GpuDeviceManager$.MODULE$.wrapThreadFactory(new ThreadFactoryBuilder().setNameFormat("shuffle-transport-client-exec-%d").setDaemon(true).build()), new CallerRunsAndLogs());
        this.clientCopyExecutor = Executors.newSingleThreadExecutor(GpuDeviceManager$.MODULE$.wrapThreadFactory(new ThreadFactoryBuilder().setNameFormat("shuffle-client-copy-thread-%d").setDaemon(true).build()));
        this.serverExecutor = Executors.newSingleThreadExecutor(GpuDeviceManager$.MODULE$.wrapThreadFactory(new ThreadFactoryBuilder().setNameFormat(new StringBuilder(30).append("shuffle-server-conn-thread-").append(shuffleServerId.executorId()).append("-%d").toString()).setDaemon(true).build()));
        this.serverCopyExecutor = Executors.newSingleThreadExecutor(GpuDeviceManager$.MODULE$.wrapThreadFactory(new ThreadFactoryBuilder().setNameFormat("shuffle-server-copy-thread-%d").setDaemon(true).build()));
        this.bssExecutor = Executors.newSingleThreadExecutor(GpuDeviceManager$.MODULE$.wrapThreadFactory(new ThreadFactoryBuilder().setNameFormat("shuffle-server-bss-thread-%d").setDaemon(true).build()));
        this.exec = Executors.newSingleThreadExecutor(GpuDeviceManager$.MODULE$.wrapThreadFactory(new ThreadFactoryBuilder().setNameFormat("shuffle-transport-throttle-monitor").setDaemon(true).build()));
        this.pendingBrs = new ConcurrentHashMap();
        this.exec.execute(() -> {
            while ($this.inflightStarted) {
                try {
                    PendingTransferRequest req = null;
                    ArrayBuffer requestsToHandle = new ArrayBuffer();
                    HashedPriorityQueue<PendingTransferRequest> hashedPriorityQueue = this.altList();
                    synchronized (hashedPriorityQueue) {
                        req = this.altList().poll();
                        while ($this.inflightStarted && req == null) {
                            this.altList().wait(100L);
                            req = this.altList().poll();
                        }
                        while (req != null) {
                            requestsToHandle.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PendingTransferRequest[]{req}));
                            req = this.altList().poll();
                        }
                    }
                    int requestIx = 0;
                    while (requestIx < requestsToHandle.size()) {
                        boolean hasBounceBuffers = true;
                        boolean fitsInFlight = true;
                        Map perClientReq = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
                        ObjectRef reqToHandle = ObjectRef.create(null);
                        ArrayBuffer putBack = new ArrayBuffer();
                        while (requestIx < requestsToHandle.size() && fitsInFlight) {
                            reqToHandle.elem = (PendingTransferRequest)requestsToHandle.apply(requestIx);
                            if (this.wouldFitInFlightLimit(((PendingTransferRequest)reqToHandle.elem).getLength())) {
                                Option existingReq = perClientReq.get((Object)((PendingTransferRequest)reqToHandle.elem).client());
                                if (existingReq.isEmpty()) {
                                    Seq<BounceBuffer> bbs = this.tryGetReceiveBounceBuffers(1L, 1);
                                    if (bbs.nonEmpty()) {
                                        this.markBytesInFlight(((PendingTransferRequest)reqToHandle.elem).getLength());
                                        PerClientReadyRequests perClientReadyRequests = new PerClientReadyRequests(this, (BounceBuffer)bbs.head());
                                        perClientReadyRequests.addRequest((PendingTransferRequest)reqToHandle.elem);
                                        perClientReq.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)((PendingTransferRequest)reqToHandle.elem).client()), (Object)perClientReadyRequests));
                                        ++requestIx;
                                        continue;
                                    }
                                    this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Can't acquire bounce buffers for receive.");
                                    hasBounceBuffers = false;
                                    putBack.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PendingTransferRequest[]{(PendingTransferRequest)reqToHandle.elem}));
                                    ++requestIx;
                                    continue;
                                }
                                if (((PerClientReadyRequests)existingReq.get()).runningSize() < $this.bounceBufferSize) {
                                    this.markBytesInFlight(((PendingTransferRequest)reqToHandle.elem).getLength());
                                    existingReq.foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                                        x$4.addRequest((PendingTransferRequest)reqToHandle.elem);
                                        return BoxedUnit.UNIT;
                                    });
                                    ++requestIx;
                                    continue;
                                }
                                ++requestIx;
                                putBack.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PendingTransferRequest[]{(PendingTransferRequest)reqToHandle.elem}));
                                continue;
                            }
                            fitsInFlight = false;
                        }
                        HashedPriorityQueue<PendingTransferRequest> hashedPriorityQueue2 = this.altList();
                        synchronized (hashedPriorityQueue2) {
                            putBack.foreach((Function1 & Serializable & scala.Serializable)pb -> this.validHandlers().contains((Object)pb.handler()) ? BoxesRunTime.boxToBoolean((boolean)this.altList().add(pb)) : BoxedUnit.UNIT);
                        }
                        if (perClientReq.nonEmpty()) {
                            perClientReq.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                                UCXShuffleTransport.$anonfun$new$5(this, x0$1);
                                return BoxedUnit.UNIT;
                            });
                            continue;
                        }
                        if (!hasBounceBuffers) {
                            BounceBufferManager<BaseDeviceMemoryBuffer> bounceBufferManager = $this.deviceReceiveBuffMgr;
                            synchronized (bounceBufferManager) {
                                while ($this.deviceReceiveBuffMgr.numFree() == 0) {
                                    $this.deviceReceiveBuffMgr.wait(100L);
                                }
                                continue;
                            }
                        }
                        if (!putBack.isEmpty()) continue;
                        Object object = $this.inflightMonitor;
                        synchronized (object) {
                            while (!this.wouldFitInFlightLimit(((PendingTransferRequest)reqToHandle.elem).getLength())) {
                                $this.inflightMonitor.wait(100L);
                            }
                        }
                    }
                }
                catch (Throwable t) {
                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error in the UCX throttle loop", t);
                }
            }
        });
    }

    public class CallerRunsAndLogs
    extends ThreadPoolExecutor.CallerRunsPolicy {
        @Override
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
            this.com$nvidia$spark$rapids$shuffle$ucx$UCXShuffleTransport$CallerRunsAndLogs$$$outer().logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Rejected execution for ").append(threadPoolExecutor).append(", running in caller's thread.").toString());
            super.rejectedExecution(runnable, threadPoolExecutor);
        }

        public /* synthetic */ UCXShuffleTransport com$nvidia$spark$rapids$shuffle$ucx$UCXShuffleTransport$CallerRunsAndLogs$$$outer() {
            return UCXShuffleTransport.this;
        }

        public CallerRunsAndLogs() {
            if (UCXShuffleTransport.this == null) {
                throw null;
            }
        }
    }

    private class ClientAndBufferReceiveState
    implements Product,
    scala.Serializable {
        private final RapidsShuffleClient client;
        private final BufferReceiveState brs;
        public final /* synthetic */ UCXShuffleTransport $outer;

        public RapidsShuffleClient client() {
            return this.client;
        }

        public BufferReceiveState brs() {
            return this.brs;
        }

        public ClientAndBufferReceiveState copy(RapidsShuffleClient client, BufferReceiveState brs) {
            return new ClientAndBufferReceiveState(this.com$nvidia$spark$rapids$shuffle$ucx$UCXShuffleTransport$ClientAndBufferReceiveState$$$outer(), client, brs);
        }

        public RapidsShuffleClient copy$default$1() {
            return this.client();
        }

        public BufferReceiveState copy$default$2() {
            return this.brs();
        }

        public String productPrefix() {
            return "ClientAndBufferReceiveState";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Logging logging;
            int n = x$1;
            switch (n) {
                case 0: {
                    logging = this.client();
                    break;
                }
                case 1: {
                    logging = this.brs();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(Integer.toString(x$1));
                }
            }
            return logging;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ClientAndBufferReceiveState;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ClientAndBufferReceiveState)) return false;
            if (((ClientAndBufferReceiveState)object).com$nvidia$spark$rapids$shuffle$ucx$UCXShuffleTransport$ClientAndBufferReceiveState$$$outer() != this.com$nvidia$spark$rapids$shuffle$ucx$UCXShuffleTransport$ClientAndBufferReceiveState$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            ClientAndBufferReceiveState clientAndBufferReceiveState = (ClientAndBufferReceiveState)x$1;
            RapidsShuffleClient rapidsShuffleClient = this.client();
            RapidsShuffleClient rapidsShuffleClient2 = clientAndBufferReceiveState.client();
            if (rapidsShuffleClient == null) {
                if (rapidsShuffleClient2 != null) {
                    return false;
                }
            } else if (!rapidsShuffleClient.equals(rapidsShuffleClient2)) return false;
            BufferReceiveState bufferReceiveState = this.brs();
            BufferReceiveState bufferReceiveState2 = clientAndBufferReceiveState.brs();
            if (bufferReceiveState == null) {
                if (bufferReceiveState2 != null) {
                    return false;
                }
            } else if (!bufferReceiveState.equals(bufferReceiveState2)) return false;
            if (!clientAndBufferReceiveState.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ UCXShuffleTransport com$nvidia$spark$rapids$shuffle$ucx$UCXShuffleTransport$ClientAndBufferReceiveState$$$outer() {
            return this.$outer;
        }

        public ClientAndBufferReceiveState(UCXShuffleTransport $outer, RapidsShuffleClient client, BufferReceiveState brs) {
            this.client = client;
            this.brs = brs;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }

    public class PerClientReadyRequests {
        private final BounceBuffer bounceBuffer;
        private final ArrayBuffer<PendingTransferRequest> transferRequests;
        private long runningSize;
        public final /* synthetic */ UCXShuffleTransport $outer;

        public BounceBuffer bounceBuffer() {
            return this.bounceBuffer;
        }

        public ArrayBuffer<PendingTransferRequest> transferRequests() {
            return this.transferRequests;
        }

        public long runningSize() {
            return this.runningSize;
        }

        public void runningSize_$eq(long x$1) {
            this.runningSize = x$1;
        }

        public void addRequest(PendingTransferRequest req) {
            this.transferRequests().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PendingTransferRequest[]{req}));
            this.runningSize_$eq(this.runningSize() + req.getLength());
        }

        public /* synthetic */ UCXShuffleTransport com$nvidia$spark$rapids$shuffle$ucx$UCXShuffleTransport$PerClientReadyRequests$$$outer() {
            return this.$outer;
        }

        public PerClientReadyRequests(UCXShuffleTransport $outer, BounceBuffer bounceBuffer) {
            this.bounceBuffer = bounceBuffer;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.transferRequests = new ArrayBuffer();
            this.runningSize = 0L;
        }
    }
}

