/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids.shuffle.ucx;

import com.nvidia.spark.rapids.shuffle.TransportUtils$;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class UCXConnection$
implements Logging {
    public static UCXConnection$ MODULE$;
    private final long bufferMsgType;
    private final long msgTypeMask;
    private final int amRequestMask;
    private final int amSendMask;
    private final int amSendFlag;
    private final long lowerBitsMask;
    private final long upperBitsMask;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new UCXConnection$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private final long bufferMsgType() {
        return this.bufferMsgType;
    }

    private final long msgTypeMask() {
        return this.msgTypeMask;
    }

    private final int amRequestMask() {
        return this.amRequestMask;
    }

    private final int amSendMask() {
        return this.amSendMask;
    }

    private final int amSendFlag() {
        return this.amSendFlag;
    }

    private final long lowerBitsMask() {
        return this.lowerBitsMask;
    }

    public final long upperBitsMask() {
        return this.upperBitsMask;
    }

    public long composeBufferHeader(long peerClientId, long uniqueId) {
        long shiftedUniqueId = uniqueId << 16;
        return this.composeHeader(this.composeUpperBits(peerClientId, this.bufferMsgType()), shiftedUniqueId);
    }

    public int composeRequestAmId(Enumeration.Value messageType) {
        return this.composeBaseAmId(messageType);
    }

    public int composeResponseAmId(Enumeration.Value messageType) {
        return this.composeSendAmId(messageType);
    }

    /*
     * WARNING - void declaration
     */
    private int composeBaseAmId(Enumeration.Value messageType) {
        void var2_2;
        int amId = messageType.id();
        if ((amId & this.amRequestMask()) != amId) {
            throw new IllegalArgumentException(new StringBuilder(41).append("Invalid request amId, it must be 4 bits: ").append(TransportUtils$.MODULE$.toHex(amId)).toString());
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public int composeSendAmId(Enumeration.Value messageType) {
        void var2_2;
        int amId = this.amSendFlag() | this.composeBaseAmId(messageType);
        if ((amId & this.amSendMask()) != amId) {
            throw new IllegalArgumentException(new StringBuilder(33).append("Invalid amId, it must be 5 bits: ").append(TransportUtils$.MODULE$.toHex(amId)).toString());
        }
        return (int)var2_2;
    }

    public long composeHeader(long upperBits, long lowerBits) {
        if ((upperBits & this.upperBitsMask()) != upperBits) {
            throw new IllegalArgumentException(new StringBuilder(39).append("Invalid header, upperBits would alias: ").append(TransportUtils$.MODULE$.toHex(upperBits)).toString());
        }
        return upperBits | lowerBits & this.lowerBitsMask();
    }

    private long composeUpperBits(long peerClientId, long msgType) {
        if ((peerClientId & this.lowerBitsMask()) != peerClientId) {
            throw new IllegalArgumentException(new StringBuilder(42).append("Invalid header, peerClientId would alias: ").append(TransportUtils$.MODULE$.toHex(peerClientId)).toString());
        }
        if ((msgType & this.msgTypeMask()) != msgType) {
            throw new IllegalArgumentException(new StringBuilder(37).append("Invalid header, msgType would alias: ").append(TransportUtils$.MODULE$.toHex(msgType)).toString());
        }
        return peerClientId << 36 | msgType << 32;
    }

    public long composeRequestHeader(long executorId, long txId) {
        Predef$.MODULE$.require(executorId >= 0L, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Attempted to pack negative ").append(executorId).toString());
        Predef$.MODULE$.require((executorId & this.lowerBitsMask()) == executorId, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("ExecutorId would alias: ").append(TransportUtils$.MODULE$.toHex(executorId)).toString());
        return this.composeHeader(executorId << 32, txId);
    }

    public long extractExecutorId(long header) {
        return header >> 32 & this.lowerBitsMask();
    }

    public Tuple2<Object, Seq<ByteBuffer>> unpackHandshake(ByteBuffer buff) {
        long remoteExecutorId = buff.getLong();
        int numRkeys = buff.getInt();
        IndexedSeq rkeys = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRkeys).map((Function1 & Serializable & scala.Serializable)x$1 -> UCXConnection$.$anonfun$unpackHandshake$1(buff, BoxesRunTime.unboxToInt((Object)x$1)), IndexedSeq$.MODULE$.canBuildFrom());
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)remoteExecutorId), (Object)rkeys);
    }

    public ByteBuffer packHandshake(long localExecutorId, Seq<ByteBuffer> rkeys) {
        int size = 12 + 4 * rkeys.size() + BoxesRunTime.unboxToInt((Object)((TraversableOnce)rkeys.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.capacity()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        ByteBuffer hsBuff = ByteBuffer.allocateDirect(size);
        hsBuff.putLong(localExecutorId);
        hsBuff.putInt(rkeys.size());
        rkeys.foreach((Function1 & Serializable & scala.Serializable)rkey -> {
            hsBuff.putInt(rkey.capacity());
            return hsBuff.put((ByteBuffer)rkey);
        });
        hsBuff.flip();
        return hsBuff;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ ByteBuffer $anonfun$unpackHandshake$1(ByteBuffer buff$1, int x$1) {
        void var3_3;
        int rkeySize = buff$1.getInt();
        ByteBuffer rkeySlice = buff$1.slice();
        rkeySlice.limit(rkeySize);
        buff$1.position(buff$1.position() + rkeySize);
        return var3_3;
    }

    private UCXConnection$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.bufferMsgType = 11L;
        this.msgTypeMask = 15L;
        this.amRequestMask = 15;
        this.amSendMask = 31;
        this.amSendFlag = 16;
        this.lowerBitsMask = 0xFFFFFFFFL;
        this.upperBitsMask = -4294967296L;
    }
}

