/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids.shuffle;

import com.nvidia.spark.rapids.shuffle.RefCountedDirectByteBuffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001i3A!\u0003\u0006\u0001+!Aq\u0005\u0001B\u0001B\u0003%\u0001\u0006C\u0003,\u0001\u0011\u0005A\u0006C\u00041\u0001\t\u0007I\u0011A\u0019\t\r\t\u0003\u0001\u0015!\u00033\u0011\u001d\u0019\u0005A1A\u0005\u0002\u0011Caa\u0013\u0001!\u0002\u0013)\u0005\"\u0002'\u0001\t\u0003i\u0005\"B*\u0001\t\u0003!&\u0001\u0006#je\u0016\u001cGOQ=uK\n+hMZ3s!>|GN\u0003\u0002\f\u0019\u000591\u000f[;gM2,'BA\u0007\u000f\u0003\u0019\u0011\u0018\r]5eg*\u0011q\u0002E\u0001\u0006gB\f'o\u001b\u0006\u0003#I\taA\u001c<jI&\f'\"A\n\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u00011B\u0004\u0005\u0002\u001855\t\u0001DC\u0001\u001a\u0003\u0015\u00198-\u00197b\u0013\tY\u0002D\u0001\u0004B]f\u0014VM\u001a\t\u0003;\u0015j\u0011A\b\u0006\u0003?\u0001\n\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u001f\u0005R!AI\u0012\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0013aA8sO&\u0011aE\b\u0002\b\u0019><w-\u001b8h\u0003)\u0011WO\u001a4feNK'0\u001a\t\u0003/%J!A\u000b\r\u0003\t1{gnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00055z\u0003C\u0001\u0018\u0001\u001b\u0005Q\u0001\"B\u0014\u0003\u0001\u0004A\u0013a\u00022vM\u001a,'o]\u000b\u0002eA\u00191G\u000f\u001f\u000e\u0003QR!!\u000e\u001c\u0002\u0015\r|gnY;se\u0016tGO\u0003\u00028q\u0005!Q\u000f^5m\u0015\u0005I\u0014\u0001\u00026bm\u0006L!a\u000f\u001b\u0003+\r{gnY;se\u0016tG\u000fT5oW\u0016$\u0017+^3vKB\u0011Q\bQ\u0007\u0002})\u0011q\bO\u0001\u0004]&|\u0017BA!?\u0005)\u0011\u0015\u0010^3Ck\u001a4WM]\u0001\tEV4g-\u001a:tA\u0005!\u0001.[4i+\u0005)\u0005C\u0001$J\u001b\u00059%B\u0001%5\u0003\u0019\tGo\\7jG&\u0011!j\u0012\u0002\u000e\u0003R|W.[2J]R,w-\u001a:\u0002\u000b!Lw\r\u001b\u0011\u0002\u0013\u001d,GOQ;gM\u0016\u0014HC\u0001(R!\tqs*\u0003\u0002Q\u0015\tQ\"+\u001a4D_VtG/\u001a3ESJ,7\r\u001e\"zi\u0016\u0014UO\u001a4fe\")!k\u0002a\u0001Q\u0005!1/\u001b>f\u00035\u0011X\r\\3bg\u0016\u0014UO\u001a4feR\u0011Q\u000b\u0017\t\u0003/YK!a\u0016\r\u0003\u000f\t{w\u000e\\3b]\")\u0011\f\u0003a\u0001\u001d\u0006!!-\u001e4g\u0001")
public class DirectByteBufferPool
implements Logging {
    private final long bufferSize;
    private final ConcurrentLinkedQueue<ByteBuffer> buffers;
    private final AtomicInteger high;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public ConcurrentLinkedQueue<ByteBuffer> buffers() {
        return this.buffers;
    }

    public AtomicInteger high() {
        return this.high;
    }

    public RefCountedDirectByteBuffer getBuffer(long size) {
        RefCountedDirectByteBuffer refCountedDirectByteBuffer;
        if (size > this.bufferSize) {
            throw new IllegalStateException(new StringBuilder(56).append("Buffers of size ").append(this.bufferSize).append(" are the only ones supported, ").append("asked for ").append(size).toString());
        }
        ByteBuffer buff = this.buffers().poll();
        if (buff == null) {
            this.high().incrementAndGet();
            this.logDebug((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(47).append("Allocating new direct buffer, high watermark = ").append(this.high()).toString());
            refCountedDirectByteBuffer = new RefCountedDirectByteBuffer(ByteBuffer.allocateDirect((int)this.bufferSize), (Option<DirectByteBufferPool>)Option$.MODULE$.apply((Object)this));
        } else {
            buff.clear();
            buff.order(ByteOrder.BIG_ENDIAN);
            refCountedDirectByteBuffer = new RefCountedDirectByteBuffer(buff, (Option<DirectByteBufferPool>)Option$.MODULE$.apply((Object)this));
        }
        return refCountedDirectByteBuffer;
    }

    public boolean releaseBuffer(RefCountedDirectByteBuffer buff) {
        this.logDebug((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(20).append("Free direct buffers ").append(this.buffers().size()).toString());
        buff.getBuffer().clear();
        return this.buffers().offer(buff.getBuffer());
    }

    public DirectByteBufferPool(long bufferSize) {
        this.bufferSize = bufferSize;
        Logging.$init$((Logging)this);
        this.buffers = new ConcurrentLinkedQueue();
        this.high = new AtomicInteger(0);
    }
}

