/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids.shims;

import ai.rapids.cudf.ColumnView;
import ai.rapids.cudf.DType;
import ai.rapids.cudf.HostColumnVector;
import ai.rapids.cudf.Scalar;
import com.nvidia.spark.rapids.ColumnarCopyHelper;
import com.nvidia.spark.rapids.GpuRowToColumnConverter;
import com.nvidia.spark.rapids.GpuRowToColumnConverter$IntConverter$;
import com.nvidia.spark.rapids.GpuRowToColumnConverter$LongConverter$;
import com.nvidia.spark.rapids.GpuRowToColumnConverter$NotNullIntConverter$;
import com.nvidia.spark.rapids.GpuRowToColumnConverter$NotNullLongConverter$;
import com.nvidia.spark.rapids.TypeSig;
import com.nvidia.spark.rapids.TypeSig$;
import com.nvidia.spark.rapids.shims.GpuIntervalUtils$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import org.apache.spark.sql.vectorized.ColumnVector;
import scala.Tuple2;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class GpuTypeShims$ {
    public static GpuTypeShims$ MODULE$;

    static {
        new GpuTypeShims$();
    }

    public boolean hasConverterForType(DataType otherType) {
        DataType dataType = otherType;
        boolean bl = dataType instanceof DayTimeIntervalType ? true : dataType instanceof YearMonthIntervalType;
        return bl;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public GpuRowToColumnConverter.TypeConverter getConverterForType(DataType t, boolean nullable) {
        void var3_10;
        Tuple2 tuple2 = new Tuple2((Object)t, (Object)BoxesRunTime.boxToBoolean((boolean)nullable));
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            boolean bl = tuple2._2$mcZ$sp();
            if (dataType instanceof DayTimeIntervalType && bl) {
                GpuRowToColumnConverter$LongConverter$ gpuRowToColumnConverter$LongConverter$ = GpuRowToColumnConverter$LongConverter$.MODULE$;
                return var3_10;
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            boolean bl = tuple2._2$mcZ$sp();
            if (dataType instanceof DayTimeIntervalType && !bl) {
                GpuRowToColumnConverter$NotNullLongConverter$ gpuRowToColumnConverter$NotNullLongConverter$ = GpuRowToColumnConverter$NotNullLongConverter$.MODULE$;
                return var3_10;
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            boolean bl = tuple2._2$mcZ$sp();
            if (dataType instanceof YearMonthIntervalType && bl) {
                GpuRowToColumnConverter$IntConverter$ gpuRowToColumnConverter$IntConverter$ = GpuRowToColumnConverter$IntConverter$.MODULE$;
                return var3_10;
            }
        }
        if (tuple2 == null) throw new RuntimeException(new StringBuilder(32).append("No converter is found for type ").append(t).append(".").toString());
        DataType dataType = (DataType)tuple2._1();
        boolean bl = tuple2._2$mcZ$sp();
        if (!(dataType instanceof YearMonthIntervalType)) throw new RuntimeException(new StringBuilder(32).append("No converter is found for type ").append(t).append(".").toString());
        if (false != bl) throw new RuntimeException(new StringBuilder(32).append("No converter is found for type ").append(t).append(".").toString());
        GpuRowToColumnConverter$NotNullIntConverter$ gpuRowToColumnConverter$NotNullIntConverter$ = GpuRowToColumnConverter$NotNullIntConverter$.MODULE$;
        return var3_10;
    }

    public DType toRapidsOrNull(DataType t) {
        DataType dataType = t;
        Object object = dataType instanceof DayTimeIntervalType ? DType.INT64 : (dataType instanceof YearMonthIntervalType ? DType.INT32 : null);
        return object;
    }

    public boolean isColumnarCopySupportedForType(DataType colType) {
        DataType dataType = colType;
        boolean bl = dataType instanceof DayTimeIntervalType ? true : dataType instanceof YearMonthIntervalType;
        return bl;
    }

    public void columnarCopy(ColumnVector cv, HostColumnVector.ColumnBuilder b, int rows) {
        DataType dataType = cv.dataType();
        if (dataType instanceof DayTimeIntervalType) {
            ColumnarCopyHelper.longCopy(cv, b, rows);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (dataType instanceof YearMonthIntervalType) {
            ColumnarCopyHelper.intCopy(cv, b, rows);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new UnsupportedOperationException(new StringBuilder(43).append("Converting to GPU for ").append(dataType).append(" is not supported yet").toString());
        }
    }

    public boolean isParquetColumnarWriterSupportedForType(DataType colType) {
        DataType dataType = colType;
        boolean bl = dataType instanceof DayTimeIntervalType ? true : dataType instanceof YearMonthIntervalType;
        return bl;
    }

    public boolean supportToScalarForType(DataType t) {
        DataType dataType = t;
        boolean bl = dataType instanceof YearMonthIntervalType ? true : dataType instanceof DayTimeIntervalType;
        return bl;
    }

    public Scalar toScalarForType(DataType t, Object v) {
        Scalar scalar;
        DataType dataType = t;
        if (dataType instanceof YearMonthIntervalType) {
            Object object = v;
            if (!(object instanceof Integer)) {
                throw new IllegalArgumentException(new StringBuilder(48).append("'").append(v).append(": ").append(v.getClass()).append("' is not supported").append(" for IntType, expecting int").toString());
            }
            int n = BoxesRunTime.unboxToInt((Object)object);
            Scalar scalar2 = Scalar.fromInt((int)n);
            scalar = scalar2;
        } else if (dataType instanceof DayTimeIntervalType) {
            Object object = v;
            if (!(object instanceof Long)) {
                throw new IllegalArgumentException(new StringBuilder(50).append("'").append(v).append(": ").append(v.getClass()).append("' is not supported").append(" for LongType, expecting Long").toString());
            }
            long l = BoxesRunTime.unboxToLong((Object)object);
            Scalar scalar3 = Scalar.fromLong((long)l);
            scalar = scalar3;
        } else {
            throw new RuntimeException(new StringBuilder(37).append("Can not convert ").append(v).append(" to scalar for type ").append(t).append(".").toString());
        }
        return scalar;
    }

    public boolean supportCsvRead(DataType dt) {
        DataType dataType = dt;
        boolean bl = dataType instanceof DayTimeIntervalType;
        return bl;
    }

    public ai.rapids.cudf.ColumnVector csvRead(ai.rapids.cudf.ColumnVector cv, DataType dt) {
        DataType dataType = dt;
        if (!(dataType instanceof DayTimeIntervalType)) {
            throw new RuntimeException(new StringBuilder(18).append("Not support type ").append(dt).append(".").toString());
        }
        DayTimeIntervalType dayTimeIntervalType = (DayTimeIntervalType)dataType;
        ai.rapids.cudf.ColumnVector columnVector = GpuIntervalUtils$.MODULE$.castStringToDTInterval((ColumnView)cv, dayTimeIntervalType);
        return columnVector;
    }

    public boolean isSupportedDayTimeType(DataType dt) {
        return dt instanceof DayTimeIntervalType;
    }

    public boolean isSupportedYearMonthType(DataType dt) {
        return dt instanceof YearMonthIntervalType;
    }

    public TypeSig additionalArithmeticSupportedTypes() {
        return TypeSig$.MODULE$.ansiIntervals();
    }

    public TypeSig additionalPredicateSupportedTypes() {
        return TypeSig$.MODULE$.DAYTIME();
    }

    public TypeSig additionalCsvSupportedTypes() {
        return TypeSig$.MODULE$.DAYTIME();
    }

    public TypeSig typesDayTimeCanCastTo() {
        return TypeSig$.MODULE$.DAYTIME().$plus(TypeSig$.MODULE$.STRING()).$plus(TypeSig$.MODULE$.integral());
    }

    public TypeSig typesYearMonthCanCastTo() {
        return TypeSig$.MODULE$.integral();
    }

    public TypeSig typesDayTimeCanCastToOnSpark() {
        return TypeSig$.MODULE$.DAYTIME().$plus(TypeSig$.MODULE$.STRING()).$plus(TypeSig$.MODULE$.integral());
    }

    public TypeSig typesYearMonthCanCastToOnSpark() {
        return TypeSig$.MODULE$.YEARMONTH().$plus(TypeSig$.MODULE$.STRING()).$plus(TypeSig$.MODULE$.integral());
    }

    public TypeSig additionalTypesIntegralCanCastTo() {
        return TypeSig$.MODULE$.YEARMONTH().$plus(TypeSig$.MODULE$.DAYTIME());
    }

    public TypeSig additionalTypesStringCanCastTo() {
        return TypeSig$.MODULE$.DAYTIME();
    }

    public TypeSig additionalParquetSupportedTypes() {
        return TypeSig$.MODULE$.ansiIntervals();
    }

    public TypeSig additionalCommonOperatorSupportedTypes() {
        return TypeSig$.MODULE$.ansiIntervals();
    }

    public boolean hasSideEffectsIfCastIntToYearMonth(DataType ym) {
        return ((YearMonthIntervalType)ym).endField() == YearMonthIntervalType$.MODULE$.YEAR();
    }

    public boolean hasSideEffectsIfCastIntToDayTime(DataType dt) {
        return ((DayTimeIntervalType)dt).endField() == DayTimeIntervalType$.MODULE$.DAY();
    }

    public boolean hasSideEffectsIfCastFloatToTimestamp() {
        return true;
    }

    private GpuTypeShims$() {
        MODULE$ = this;
    }
}

