/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids.shims;

import ai.rapids.cudf.BinaryOperable;
import ai.rapids.cudf.ColumnVector;
import ai.rapids.cudf.ColumnView;
import ai.rapids.cudf.DType;
import ai.rapids.cudf.Scalar;
import com.nvidia.spark.rapids.Arm;
import com.nvidia.spark.rapids.BoolUtils$;
import com.nvidia.spark.rapids.CloseableHolder;
import com.nvidia.spark.rapids.FloatUtils$;
import com.nvidia.spark.rapids.GpuColumnVector;
import com.nvidia.spark.rapids.RapidsBuffer;
import java.io.Serializable;
import org.apache.spark.rapids.ShimTrampolineUtil$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class AnsiUtil$
implements Arm {
    public static AnsiUtil$ MODULE$;

    static {
        new AnsiUtil$();
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T r, Function1<T, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T[] r, Function1<T[], V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T, V> V withResourceIfAllowed(T r, Function1<T, V> block) {
        return (V)Arm.withResourceIfAllowed$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T[] r, Function1<T[], V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends RapidsBuffer, V> V freeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.freeOnExcept$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(CloseableHolder<T> h, Function1<CloseableHolder<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, h, block);
    }

    public boolean supportsAnsiCastFloatToTimestamp() {
        return true;
    }

    public ColumnVector castFloatToTimestampAnsi(ColumnView floatInput, DataType toType) {
        return floatInput.getType().equals((Object)DType.FLOAT32) ? (ColumnVector)this.withResource(floatInput.castTo(DType.FLOAT64), (Function1 & Serializable & scala.Serializable)d -> MODULE$.castDoubleToTimestampAnsi((ColumnView)d, toType)) : this.castDoubleToTimestampAnsi(floatInput, toType);
    }

    private ColumnVector castDoubleToTimestampAnsi(ColumnView doubleInput, DataType toType) {
        String msg = new StringBuilder(129).append("The column contains out-of-range values. To return NULL instead, use ").append("'try_cast'. If necessary set ").append(SQLConf$.MODULE$.ANSI_ENABLED().key()).append(" to false to bypass this error.").toString();
        String errorClass = "CAST_INVALID_INPUT";
        String[] messageParameters = (String[])((Object[])new String[]{"DOUBLE", "TIMESTAMP", SQLConf$.MODULE$.ANSI_ENABLED().key()});
        this.withResource(doubleInput.isNan(), (Function1 & Serializable & scala.Serializable)hasNan -> {
            AnsiUtil$.$anonfun$castDoubleToTimestampAnsi$1(errorClass, messageParameters, hasNan);
            return BoxedUnit.UNIT;
        });
        this.withResource(FloatUtils$.MODULE$.getInfinityVector(doubleInput.getType()), (Function1 & Serializable & scala.Serializable)inf -> {
            AnsiUtil$.MODULE$.withResource(doubleInput.contains((ColumnView)inf), (Function1 & Serializable & scala.Serializable)hasInf -> {
                AnsiUtil$.$anonfun$castDoubleToTimestampAnsi$3(errorClass$1, messageParameters$1, hasInf);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        return (ColumnVector)this.withResource(Scalar.fromLong((long)1000000L), (Function1 & Serializable & scala.Serializable)microsPerSecondS -> (ColumnVector)MODULE$.withResource(doubleInput.mul((BinaryOperable)microsPerSecondS), (Function1 & Serializable & scala.Serializable)mul -> {
            MODULE$.withResource(Scalar.fromLong((long)Long.MAX_VALUE), (Function1 & Serializable & scala.Serializable)maxLongS -> {
                AnsiUtil$.MODULE$.withResource(mul.floor(), (Function1 & Serializable & scala.Serializable)floorCv -> {
                    AnsiUtil$.MODULE$.withResource(floorCv.greaterThan((BinaryOperable)maxLongS), (Function1 & Serializable & scala.Serializable)invalid -> {
                        AnsiUtil$.$anonfun$castDoubleToTimestampAnsi$8(msg$1, invalid);
                        return BoxedUnit.UNIT;
                    });
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            });
            MODULE$.withResource(Scalar.fromLong((long)Long.MIN_VALUE), (Function1 & Serializable & scala.Serializable)minLongS -> {
                AnsiUtil$.MODULE$.withResource(mul.ceil(), (Function1 & Serializable & scala.Serializable)ceil -> {
                    AnsiUtil$.MODULE$.withResource(ceil.lessThan((BinaryOperable)minLongS), (Function1 & Serializable & scala.Serializable)invalid -> {
                        AnsiUtil$.$anonfun$castDoubleToTimestampAnsi$11(msg$1, invalid);
                        return BoxedUnit.UNIT;
                    });
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            });
            return (ColumnVector)MODULE$.withResource(mul.castTo(DType.INT64), (Function1 & Serializable & scala.Serializable)inputTimesMicrosCv -> inputTimesMicrosCv.castTo(GpuColumnVector.getNonNestedRapidsType(toType)));
        }));
    }

    private static final void throwSparkDateTimeException$1(String infOrNan, String errorClass$1, String[] messageParameters$1) {
        throw ShimTrampolineUtil$.MODULE$.dateTimeException(errorClass$1, (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{infOrNan})).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])messageParameters$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
    }

    private static final void throwOverflowException$1(String msg$1) {
        throw new ArithmeticException(msg$1);
    }

    public static final /* synthetic */ void $anonfun$castDoubleToTimestampAnsi$1(String errorClass$1, String[] messageParameters$1, ColumnVector hasNan) {
        block0: {
            if (!BoolUtils$.MODULE$.isAnyValidTrue(hasNan)) break block0;
            AnsiUtil$.throwSparkDateTimeException$1("NaN", errorClass$1, messageParameters$1);
        }
    }

    public static final /* synthetic */ void $anonfun$castDoubleToTimestampAnsi$3(String errorClass$1, String[] messageParameters$1, ColumnVector hasInf) {
        block0: {
            if (!BoolUtils$.MODULE$.isAnyValidTrue(hasInf)) break block0;
            AnsiUtil$.throwSparkDateTimeException$1("Infinity", errorClass$1, messageParameters$1);
        }
    }

    public static final /* synthetic */ void $anonfun$castDoubleToTimestampAnsi$8(String msg$1, ColumnVector invalid) {
        block0: {
            if (!BoolUtils$.MODULE$.isAnyValidTrue(invalid)) break block0;
            AnsiUtil$.throwOverflowException$1(msg$1);
        }
    }

    public static final /* synthetic */ void $anonfun$castDoubleToTimestampAnsi$11(String msg$1, ColumnVector invalid) {
        block0: {
            if (!BoolUtils$.MODULE$.isAnyValidTrue(invalid)) break block0;
            AnsiUtil$.throwOverflowException$1(msg$1);
        }
    }

    private AnsiUtil$() {
        MODULE$ = this;
        Arm.$init$(this);
    }
}

