/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids.iceberg.spark.source;

import com.nvidia.spark.rapids.GpuMetric;
import com.nvidia.spark.rapids.RapidsConf;
import com.nvidia.spark.rapids.ScanWithMetricsWrapper;
import com.nvidia.spark.rapids.iceberg.spark.Spark3Util;
import com.nvidia.spark.rapids.iceberg.spark.SparkReadConf;
import com.nvidia.spark.rapids.iceberg.spark.SparkSchemaUtil;
import com.nvidia.spark.rapids.iceberg.spark.SparkUtil;
import com.nvidia.spark.rapids.iceberg.spark.source.GpuBatchDataReader;
import com.nvidia.spark.rapids.iceberg.spark.source.SparkBatch;
import com.nvidia.spark.rapids.iceberg.spark.source.Stats;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.hadoop.HadoopInputFile;
import org.apache.iceberg.hadoop.Util;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.read.Batch;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.PartitionReader;
import org.apache.spark.sql.connector.read.PartitionReaderFactory;
import org.apache.spark.sql.connector.read.Scan;
import org.apache.spark.sql.connector.read.Statistics;
import org.apache.spark.sql.connector.read.SupportsReportStatistics;
import org.apache.spark.sql.connector.read.streaming.MicroBatchStream;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.apache.spark.util.SerializableConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class GpuSparkScan
extends ScanWithMetricsWrapper
implements Scan,
SupportsReportStatistics {
    private static final Logger LOG = LoggerFactory.getLogger(GpuSparkScan.class);
    private final JavaSparkContext sparkContext;
    private final Table table;
    private final SparkReadConf readConf;
    private final boolean caseSensitive;
    private final Schema expectedSchema;
    private final List<Expression> filterExpressions;
    private final boolean readTimestampWithoutZone;
    private final RapidsConf rapidsConf;
    private StructType readSchema = null;

    GpuSparkScan(SparkSession spark, Table table, SparkReadConf readConf, Schema expectedSchema, List<Expression> filters, RapidsConf rapidsConf) {
        SparkSchemaUtil.validateMetadataColumnReferences(table.schema(), expectedSchema);
        this.sparkContext = JavaSparkContext.fromSparkContext((SparkContext)spark.sparkContext());
        this.table = table;
        this.readConf = readConf;
        this.caseSensitive = readConf.caseSensitive();
        this.expectedSchema = expectedSchema;
        this.filterExpressions = filters != null ? filters : Collections.emptyList();
        this.readTimestampWithoutZone = readConf.handleTimestampWithoutZone();
        this.rapidsConf = rapidsConf;
    }

    protected Table table() {
        return this.table;
    }

    protected boolean caseSensitive() {
        return this.caseSensitive;
    }

    protected Schema expectedSchema() {
        return this.expectedSchema;
    }

    protected List<Expression> filterExpressions() {
        return this.filterExpressions;
    }

    protected abstract List<CombinedScanTask> tasks();

    public Batch toBatch() {
        return new SparkBatch(this.sparkContext, this.table, this.readConf, this.tasks(), this.expectedSchema, this.rapidsConf, this);
    }

    public MicroBatchStream toMicroBatchStream(String checkpointLocation) {
        throw new IllegalStateException("Unexpected micro batch stream read");
    }

    public StructType readSchema() {
        if (this.readSchema == null) {
            Preconditions.checkArgument((this.readTimestampWithoutZone || !SparkUtil.hasTimestampWithoutZone(this.expectedSchema) ? 1 : 0) != 0, (Object)SparkUtil.TIMESTAMP_WITHOUT_TIMEZONE_ERROR);
            this.readSchema = SparkSchemaUtil.convert(this.expectedSchema);
        }
        return this.readSchema;
    }

    public Statistics estimateStatistics() {
        return this.estimateStatistics(this.table.currentSnapshot());
    }

    protected Statistics estimateStatistics(Snapshot snapshot) {
        if (snapshot == null) {
            return new Stats(0L, 0L);
        }
        if (!this.table.spec().isUnpartitioned() && this.filterExpressions.isEmpty()) {
            LOG.debug("using table metadata to estimate table statistics");
            long totalRecords = PropertyUtil.propertyAsLong((Map)snapshot.summary(), (String)"total-records", (long)Long.MAX_VALUE);
            return new Stats(SparkSchemaUtil.estimateSize(this.readSchema(), totalRecords), totalRecords);
        }
        long numRows = 0L;
        for (CombinedScanTask task : this.tasks()) {
            for (FileScanTask file : task.files()) {
                double fractionOfFileScanned = (double)file.length() / (double)file.file().fileSizeInBytes();
                numRows = (long)((double)numRows + fractionOfFileScanned * (double)file.file().recordCount());
            }
        }
        long sizeInBytes = SparkSchemaUtil.estimateSize(this.readSchema(), numRows);
        return new Stats(sizeInBytes, numRows);
    }

    public String description() {
        String filters = this.filterExpressions.stream().map(Spark3Util::describe).collect(Collectors.joining(", "));
        return String.format("%s [filters=%s]", this.table, filters);
    }

    static class ReadTask
    implements InputPartition,
    Serializable {
        private final CombinedScanTask task;
        private final Broadcast<Table> tableBroadcast;
        private final String expectedSchemaString;
        private final boolean caseSensitive;
        private final Broadcast<SerializableConfiguration> confBroadcast;
        private final int maxBatchSizeRows;
        private final long maxBatchSizeBytes;
        private final String parquetDebugDumpPrefix;
        private transient Schema expectedSchema = null;
        private transient String[] preferredLocations = null;

        ReadTask(CombinedScanTask task, Broadcast<Table> tableBroadcast, String expectedSchemaString, boolean caseSensitive, boolean localityPreferred, RapidsConf rapidsConf, Broadcast<SerializableConfiguration> confBroadcast) {
            this.task = task;
            this.tableBroadcast = tableBroadcast;
            this.expectedSchemaString = expectedSchemaString;
            this.caseSensitive = caseSensitive;
            if (localityPreferred) {
                Table table = (Table)tableBroadcast.value();
                this.preferredLocations = Util.blockLocations((FileIO)table.io(), (CombinedScanTask)task);
            } else {
                this.preferredLocations = HadoopInputFile.NO_LOCATION_PREFERENCE;
            }
            this.confBroadcast = confBroadcast;
            this.maxBatchSizeRows = rapidsConf.maxReadBatchSizeRows();
            this.maxBatchSizeBytes = rapidsConf.maxReadBatchSizeBytes();
            this.parquetDebugDumpPrefix = rapidsConf.parquetDebugDumpPrefix();
        }

        public String[] preferredLocations() {
            return this.preferredLocations;
        }

        public Collection<FileScanTask> files() {
            return this.task.files();
        }

        public Table table() {
            return (Table)this.tableBroadcast.value();
        }

        public boolean isCaseSensitive() {
            return this.caseSensitive;
        }

        public Configuration getConfiguration() {
            return ((SerializableConfiguration)this.confBroadcast.value()).value();
        }

        public int getMaxBatchSizeRows() {
            return this.maxBatchSizeRows;
        }

        public long getMaxBatchSizeBytes() {
            return this.maxBatchSizeBytes;
        }

        public String getParquetDebugDumpPrefix() {
            return this.parquetDebugDumpPrefix;
        }

        private Schema expectedSchema() {
            if (this.expectedSchema == null) {
                this.expectedSchema = SchemaParser.fromJson((String)this.expectedSchemaString);
            }
            return this.expectedSchema;
        }
    }

    private static class BatchReader
    extends GpuBatchDataReader
    implements PartitionReader<ColumnarBatch> {
        BatchReader(ReadTask task, scala.collection.immutable.Map<String, GpuMetric> metrics) {
            super(task.task, task.table(), task.expectedSchema(), task.isCaseSensitive(), task.getConfiguration(), task.getMaxBatchSizeRows(), task.getMaxBatchSizeBytes(), task.getParquetDebugDumpPrefix(), metrics);
        }
    }

    static class ReaderFactory
    implements PartitionReaderFactory {
        private final scala.collection.immutable.Map<String, GpuMetric> metrics;

        public ReaderFactory(scala.collection.immutable.Map<String, GpuMetric> metrics) {
            this.metrics = metrics;
        }

        public PartitionReader<InternalRow> createReader(InputPartition partition) {
            throw new IllegalStateException("non-columnar read");
        }

        public PartitionReader<ColumnarBatch> createColumnarReader(InputPartition partition) {
            if (partition instanceof ReadTask) {
                return new BatchReader((ReadTask)partition, this.metrics);
            }
            throw new UnsupportedOperationException("Incorrect input partition type: " + partition);
        }

        public boolean supportColumnarReads(InputPartition partition) {
            return true;
        }
    }
}

