/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids.iceberg.spark;

import com.nvidia.spark.rapids.iceberg.spark.TypeToSparkType;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.Schema;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.relocated.com.google.common.math.LongMath;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;

public class SparkSchemaUtil {
    private SparkSchemaUtil() {
    }

    public static StructType convert(Schema schema) {
        return (StructType)TypeUtil.visit((Schema)schema, (TypeUtil.SchemaVisitor)new TypeToSparkType());
    }

    public static DataType convert(Type type) {
        return (DataType)TypeUtil.visit((Type)type, (TypeUtil.SchemaVisitor)new TypeToSparkType());
    }

    public static long estimateSize(StructType tableSchema, long totalRecords) {
        long result;
        if (totalRecords == Long.MAX_VALUE) {
            return totalRecords;
        }
        try {
            result = LongMath.checkedMultiply((long)tableSchema.defaultSize(), (long)totalRecords);
        }
        catch (ArithmeticException e) {
            result = Long.MAX_VALUE;
        }
        return result;
    }

    public static void validateMetadataColumnReferences(Schema tableSchema, Schema readSchema) {
        List conflictingColumnNames = readSchema.columns().stream().map(Types.NestedField::name).filter(name -> MetadataColumns.isMetadataColumn((String)name) && tableSchema.findField(name) != null).collect(Collectors.toList());
        ValidationException.check((boolean)conflictingColumnNames.isEmpty(), (String)"Table column names conflict with names reserved for Iceberg metadata columns: %s.\nPlease, use ALTER TABLE statements to rename the conflicting table columns.", (Object[])new Object[]{conflictingColumnNames});
    }

    public static Map<Integer, String> indexQuotedNameById(Schema schema) {
        Function<String, String> quotingFunc = name -> String.format("`%s`", name.replace("`", "``"));
        return TypeUtil.indexQuotedNameById((Types.StructType)schema.asStruct(), quotingFunc);
    }
}

