/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids.iceberg.spark;

import com.nvidia.spark.rapids.iceberg.spark.SparkConfParser;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.iceberg.Table;
import org.apache.iceberg.hadoop.HadoopInputFile;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.spark.sql.SparkSession;

public class SparkReadConf {
    private static final Set<String> LOCALITY_WHITELIST_FS = ImmutableSet.of((Object)"hdfs");
    private final SparkSession spark;
    private final Table table;
    private final Map<String, String> readOptions;
    private final SparkConfParser confParser;

    public static SparkReadConf fromReflect(Object obj) throws IllegalAccessException {
        SparkSession spark = SparkSession.active();
        Table table = (Table)FieldUtils.readField(obj, "table", true);
        Map readOptions = (Map)FieldUtils.readField(obj, "readOptions", true);
        return new SparkReadConf(spark, table, readOptions);
    }

    public SparkReadConf(SparkSession spark, Table table, Map<String, String> readOptions) {
        this.spark = spark;
        this.table = table;
        this.readOptions = readOptions;
        this.confParser = new SparkConfParser(spark, table, readOptions);
    }

    public boolean caseSensitive() {
        return Boolean.parseBoolean(this.spark.conf().get("spark.sql.caseSensitive"));
    }

    public boolean localityEnabled() {
        InputFile file = this.table.io().newInputFile(this.table.location());
        if (file instanceof HadoopInputFile) {
            String scheme = ((HadoopInputFile)file).getFileSystem().getScheme();
            boolean defaultValue = LOCALITY_WHITELIST_FS.contains(scheme);
            return PropertyUtil.propertyAsBoolean(this.readOptions, (String)"locality", (boolean)defaultValue);
        }
        return false;
    }

    public Long snapshotId() {
        return ((SparkConfParser.LongConfParser)this.confParser.longConf().option("snapshot-id")).parseOptional();
    }

    public Long asOfTimestamp() {
        return ((SparkConfParser.LongConfParser)this.confParser.longConf().option("as-of-timestamp")).parseOptional();
    }

    public Long startSnapshotId() {
        return ((SparkConfParser.LongConfParser)this.confParser.longConf().option("start-snapshot-id")).parseOptional();
    }

    public Long endSnapshotId() {
        return ((SparkConfParser.LongConfParser)this.confParser.longConf().option("end-snapshot-id")).parseOptional();
    }

    public String fileScanTaskSetId() {
        return ((SparkConfParser.StringConfParser)this.confParser.stringConf().option("file-scan-task-set-id")).parseOptional();
    }

    public boolean streamingSkipDeleteSnapshots() {
        return ((SparkConfParser.BooleanConfParser)this.confParser.booleanConf().option("streaming-skip-delete-snapshots")).defaultValue(false).parse();
    }

    public boolean parquetVectorizationEnabled() {
        return ((SparkConfParser.BooleanConfParser)((SparkConfParser.BooleanConfParser)((SparkConfParser.BooleanConfParser)this.confParser.booleanConf().option("vectorization-enabled")).sessionConf("spark.sql.iceberg.vectorization.enabled")).tableProperty("read.parquet.vectorization.enabled")).defaultValue(false).parse();
    }

    public int parquetBatchSize() {
        return ((SparkConfParser.IntConfParser)((SparkConfParser.IntConfParser)this.confParser.intConf().option("batch-size")).tableProperty("read.parquet.vectorization.batch-size")).defaultValue(5000).parse();
    }

    public boolean orcVectorizationEnabled() {
        return ((SparkConfParser.BooleanConfParser)((SparkConfParser.BooleanConfParser)((SparkConfParser.BooleanConfParser)this.confParser.booleanConf().option("vectorization-enabled")).sessionConf("spark.sql.iceberg.vectorization.enabled")).tableProperty("read.orc.vectorization.enabled")).defaultValue(false).parse();
    }

    public int orcBatchSize() {
        return ((SparkConfParser.IntConfParser)((SparkConfParser.IntConfParser)this.confParser.intConf().option("batch-size")).tableProperty("read.orc.vectorization.batch-size")).defaultValue(5000).parse();
    }

    public Long splitSizeOption() {
        return ((SparkConfParser.LongConfParser)this.confParser.longConf().option("split-size")).parseOptional();
    }

    public long splitSize() {
        return ((SparkConfParser.LongConfParser)((SparkConfParser.LongConfParser)this.confParser.longConf().option("split-size")).tableProperty("read.split.target-size")).defaultValue(0x8000000L).parse();
    }

    public Integer splitLookbackOption() {
        return ((SparkConfParser.IntConfParser)this.confParser.intConf().option("lookback")).parseOptional();
    }

    public int splitLookback() {
        return ((SparkConfParser.IntConfParser)((SparkConfParser.IntConfParser)this.confParser.intConf().option("lookback")).tableProperty("read.split.planning-lookback")).defaultValue(10).parse();
    }

    public Long splitOpenFileCostOption() {
        return ((SparkConfParser.LongConfParser)this.confParser.longConf().option("file-open-cost")).parseOptional();
    }

    public long splitOpenFileCost() {
        return ((SparkConfParser.LongConfParser)((SparkConfParser.LongConfParser)this.confParser.longConf().option("file-open-cost")).tableProperty("read.split.open-file-cost")).defaultValue(0x400000L).parse();
    }

    public boolean handleTimestampWithoutZone() {
        return ((SparkConfParser.BooleanConfParser)((SparkConfParser.BooleanConfParser)this.confParser.booleanConf().option("handle-timestamp-without-timezone")).sessionConf("spark.sql.iceberg.handle-timestamp-without-timezone")).defaultValue(false).parse();
    }

    public Long streamFromTimestamp() {
        return ((SparkConfParser.LongConfParser)this.confParser.longConf().option("stream-from-timestamp")).defaultValue(Long.MIN_VALUE).parse();
    }
}

