/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids.iceberg.parquet;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.iceberg.hadoop.HadoopInputFile;
import org.apache.iceberg.io.DelegatingInputStream;
import org.apache.parquet.hadoop.util.HadoopStreams;
import org.apache.parquet.io.DelegatingSeekableInputStream;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.SeekableInputStream;

public class ParquetIO {
    private ParquetIO() {
    }

    static InputFile file(org.apache.iceberg.io.InputFile file) {
        if (file instanceof HadoopInputFile) {
            HadoopInputFile hfile = (HadoopInputFile)file;
            try {
                return org.apache.parquet.hadoop.util.HadoopInputFile.fromStatus((FileStatus)hfile.getStat(), (Configuration)hfile.getConf());
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to create Parquet input file for " + file, e);
            }
        }
        return new ParquetInputFile(file);
    }

    static SeekableInputStream stream(org.apache.iceberg.io.SeekableInputStream stream) {
        InputStream wrapped;
        if (stream instanceof DelegatingInputStream && (wrapped = ((DelegatingInputStream)stream).getDelegate()) instanceof FSDataInputStream) {
            return HadoopStreams.wrap((FSDataInputStream)((FSDataInputStream)wrapped));
        }
        return new ParquetInputStreamAdapter(stream);
    }

    private static class ParquetInputFile
    implements InputFile {
        private final org.apache.iceberg.io.InputFile file;

        private ParquetInputFile(org.apache.iceberg.io.InputFile file) {
            this.file = file;
        }

        public long getLength() throws IOException {
            return this.file.getLength();
        }

        public SeekableInputStream newStream() throws IOException {
            return ParquetIO.stream(this.file.newStream());
        }
    }

    private static class ParquetInputStreamAdapter
    extends DelegatingSeekableInputStream {
        private final org.apache.iceberg.io.SeekableInputStream delegate;

        private ParquetInputStreamAdapter(org.apache.iceberg.io.SeekableInputStream delegate) {
            super((InputStream)delegate);
            this.delegate = delegate;
        }

        public long getPos() throws IOException {
            return this.delegate.getPos();
        }

        public void seek(long newPos) throws IOException {
            this.delegate.seek(newPos);
        }
    }
}

