/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids.iceberg.parquet;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import org.apache.iceberg.types.Type;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.PrimitiveType;

public class ParquetConversions {
    private ParquetConversions() {
    }

    static Function<Object, Object> converterFromParquet(PrimitiveType parquetType, Type icebergType) {
        Function<Object, Object> fromParquet = ParquetConversions.converterFromParquet(parquetType);
        if (icebergType != null) {
            if (icebergType.typeId() == Type.TypeID.LONG && parquetType.getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.INT32) {
                return value -> ((Integer)fromParquet.apply(value)).longValue();
            }
            if (icebergType.typeId() == Type.TypeID.DOUBLE && parquetType.getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.FLOAT) {
                return value -> ((Float)fromParquet.apply(value)).doubleValue();
            }
        }
        return fromParquet;
    }

    static Function<Object, Object> converterFromParquet(PrimitiveType type) {
        if (type.getOriginalType() != null) {
            switch (type.getOriginalType()) {
                case UTF8: {
                    return binary -> StandardCharsets.UTF_8.decode(((Binary)binary).toByteBuffer());
                }
                case DECIMAL: {
                    int scale = type.getDecimalMetadata().getScale();
                    switch (type.getPrimitiveTypeName()) {
                        case INT32: 
                        case INT64: {
                            return num -> BigDecimal.valueOf(((Number)num).longValue(), scale);
                        }
                        case FIXED_LEN_BYTE_ARRAY: 
                        case BINARY: {
                            return bin -> new BigDecimal(new BigInteger(((Binary)bin).getBytes()), scale);
                        }
                    }
                    throw new IllegalArgumentException("Unsupported primitive type for decimal: " + type.getPrimitiveTypeName());
                }
            }
        }
        switch (type.getPrimitiveTypeName()) {
            case FIXED_LEN_BYTE_ARRAY: 
            case BINARY: {
                return binary -> ByteBuffer.wrap(((Binary)binary).getBytes());
            }
        }
        return obj -> obj;
    }
}

