/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids.format;

import com.nvidia.shaded.spark.com.google.flatbuffers.FlatBufferBuilder;
import com.nvidia.shaded.spark.com.google.flatbuffers.Table;
import com.nvidia.spark.rapids.format.BufferMeta;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class TableMeta
extends Table {
    public static TableMeta getRootAsTableMeta(ByteBuffer _bb) {
        return TableMeta.getRootAsTableMeta(_bb, new TableMeta());
    }

    public static TableMeta getRootAsTableMeta(ByteBuffer _bb, TableMeta obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.bb_pos = _i;
        this.bb = _bb;
        this.vtable_start = this.bb_pos - this.bb.getInt(this.bb_pos);
        this.vtable_size = this.bb.getShort(this.vtable_start);
    }

    public TableMeta __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public BufferMeta bufferMeta() {
        return this.bufferMeta(new BufferMeta());
    }

    public BufferMeta bufferMeta(BufferMeta obj) {
        int o = this.__offset(4);
        return o != 0 ? obj.__assign(this.__indirect(o + this.bb_pos), this.bb) : null;
    }

    public long rowCount() {
        int o = this.__offset(6);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public boolean mutateRowCount(long row_count) {
        int o = this.__offset(6);
        if (o != 0) {
            this.bb.putLong(o + this.bb_pos, row_count);
            return true;
        }
        return false;
    }

    public byte packedMeta(int j) {
        int o = this.__offset(8);
        return o != 0 ? this.bb.get(this.__vector(o) + j * 1) : (byte)0;
    }

    public int packedMetaLength() {
        int o = this.__offset(8);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public ByteBuffer packedMetaAsByteBuffer() {
        return this.__vector_as_bytebuffer(8, 1);
    }

    public ByteBuffer packedMetaInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 8, 1);
    }

    public boolean mutatePackedMeta(int j, byte packed_meta) {
        int o = this.__offset(8);
        if (o != 0) {
            this.bb.put(this.__vector(o) + j * 1, packed_meta);
            return true;
        }
        return false;
    }

    public static int createTableMeta(FlatBufferBuilder builder, int buffer_metaOffset, long row_count, int packed_metaOffset) {
        builder.startObject(3);
        TableMeta.addRowCount(builder, row_count);
        TableMeta.addPackedMeta(builder, packed_metaOffset);
        TableMeta.addBufferMeta(builder, buffer_metaOffset);
        return TableMeta.endTableMeta(builder);
    }

    public static void startTableMeta(FlatBufferBuilder builder) {
        builder.startObject(3);
    }

    public static void addBufferMeta(FlatBufferBuilder builder, int bufferMetaOffset) {
        builder.addOffset(0, bufferMetaOffset, 0);
    }

    public static void addRowCount(FlatBufferBuilder builder, long rowCount) {
        builder.addLong(1, rowCount, 0L);
    }

    public static void addPackedMeta(FlatBufferBuilder builder, int packedMetaOffset) {
        builder.addOffset(2, packedMetaOffset, 0);
    }

    public static int createPackedMetaVector(FlatBufferBuilder builder, byte[] data) {
        builder.startVector(1, data.length, 1);
        for (int i = data.length - 1; i >= 0; --i) {
            builder.addByte(data[i]);
        }
        return builder.endVector();
    }

    public static void startPackedMetaVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(1, numElems, 1);
    }

    public static int endTableMeta(FlatBufferBuilder builder) {
        int o = builder.endObject();
        return o;
    }
}

