/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids.format;

import com.nvidia.shaded.spark.com.google.flatbuffers.FlatBufferBuilder;
import com.nvidia.shaded.spark.com.google.flatbuffers.Table;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class CodecBufferDescriptor
extends Table {
    public static CodecBufferDescriptor getRootAsCodecBufferDescriptor(ByteBuffer _bb) {
        return CodecBufferDescriptor.getRootAsCodecBufferDescriptor(_bb, new CodecBufferDescriptor());
    }

    public static CodecBufferDescriptor getRootAsCodecBufferDescriptor(ByteBuffer _bb, CodecBufferDescriptor obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.bb_pos = _i;
        this.bb = _bb;
        this.vtable_start = this.bb_pos - this.bb.getInt(this.bb_pos);
        this.vtable_size = this.bb.getShort(this.vtable_start);
    }

    public CodecBufferDescriptor __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public byte codec() {
        int o = this.__offset(4);
        return o != 0 ? this.bb.get(o + this.bb_pos) : (byte)0;
    }

    public boolean mutateCodec(byte codec) {
        int o = this.__offset(4);
        if (o != 0) {
            this.bb.put(o + this.bb_pos, codec);
            return true;
        }
        return false;
    }

    public long compressedOffset() {
        int o = this.__offset(6);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public boolean mutateCompressedOffset(long compressed_offset) {
        int o = this.__offset(6);
        if (o != 0) {
            this.bb.putLong(o + this.bb_pos, compressed_offset);
            return true;
        }
        return false;
    }

    public long compressedSize() {
        int o = this.__offset(8);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public boolean mutateCompressedSize(long compressed_size) {
        int o = this.__offset(8);
        if (o != 0) {
            this.bb.putLong(o + this.bb_pos, compressed_size);
            return true;
        }
        return false;
    }

    public long uncompressedOffset() {
        int o = this.__offset(10);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public boolean mutateUncompressedOffset(long uncompressed_offset) {
        int o = this.__offset(10);
        if (o != 0) {
            this.bb.putLong(o + this.bb_pos, uncompressed_offset);
            return true;
        }
        return false;
    }

    public long uncompressedSize() {
        int o = this.__offset(12);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public boolean mutateUncompressedSize(long uncompressed_size) {
        int o = this.__offset(12);
        if (o != 0) {
            this.bb.putLong(o + this.bb_pos, uncompressed_size);
            return true;
        }
        return false;
    }

    public static int createCodecBufferDescriptor(FlatBufferBuilder builder, byte codec, long compressed_offset, long compressed_size, long uncompressed_offset, long uncompressed_size) {
        builder.startObject(5);
        CodecBufferDescriptor.addUncompressedSize(builder, uncompressed_size);
        CodecBufferDescriptor.addUncompressedOffset(builder, uncompressed_offset);
        CodecBufferDescriptor.addCompressedSize(builder, compressed_size);
        CodecBufferDescriptor.addCompressedOffset(builder, compressed_offset);
        CodecBufferDescriptor.addCodec(builder, codec);
        return CodecBufferDescriptor.endCodecBufferDescriptor(builder);
    }

    public static void startCodecBufferDescriptor(FlatBufferBuilder builder) {
        builder.startObject(5);
    }

    public static void addCodec(FlatBufferBuilder builder, byte codec) {
        builder.addByte(0, codec, 0);
    }

    public static void addCompressedOffset(FlatBufferBuilder builder, long compressedOffset) {
        builder.addLong(1, compressedOffset, 0L);
    }

    public static void addCompressedSize(FlatBufferBuilder builder, long compressedSize) {
        builder.addLong(2, compressedSize, 0L);
    }

    public static void addUncompressedOffset(FlatBufferBuilder builder, long uncompressedOffset) {
        builder.addLong(3, uncompressedOffset, 0L);
    }

    public static void addUncompressedSize(FlatBufferBuilder builder, long uncompressedSize) {
        builder.addLong(4, uncompressedSize, 0L);
    }

    public static int endCodecBufferDescriptor(FlatBufferBuilder builder) {
        int o = builder.endObject();
        return o;
    }
}

