/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import ai.rapids.cudf.ContiguousTable;
import ai.rapids.cudf.DeviceMemoryBuffer;
import ai.rapids.cudf.Table;
import com.nvidia.spark.rapids.Arm;
import com.nvidia.spark.rapids.CloseableHolder;
import com.nvidia.spark.rapids.GpuColumnVector;
import com.nvidia.spark.rapids.GpuColumnVectorFromBuffer;
import com.nvidia.spark.rapids.GpuCompressedColumnVector;
import com.nvidia.spark.rapids.GpuPackedTableColumn;
import com.nvidia.spark.rapids.JustRowsColumnarBatch;
import com.nvidia.spark.rapids.RapidsBuffer;
import com.nvidia.spark.rapids.RapidsBufferCatalog$;
import com.nvidia.spark.rapids.RapidsBufferId;
import com.nvidia.spark.rapids.SpillCallback;
import com.nvidia.spark.rapids.SpillableColumnarBatch;
import com.nvidia.spark.rapids.SpillableColumnarBatchImpl;
import java.io.Serializable;
import org.apache.spark.sql.rapids.TempSpillBufferId;
import org.apache.spark.sql.rapids.TempSpillBufferId$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class SpillableColumnarBatch$
implements Arm {
    public static SpillableColumnarBatch$ MODULE$;

    static {
        new SpillableColumnarBatch$();
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T r, Function1<T, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T[] r, Function1<T[], V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T, V> V withResourceIfAllowed(T r, Function1<T, V> block) {
        return (V)Arm.withResourceIfAllowed$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T[] r, Function1<T[], V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends RapidsBuffer, V> V freeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.freeOnExcept$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(CloseableHolder<T> h, Function1<CloseableHolder<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, h, block);
    }

    public SpillableColumnarBatch apply(ColumnarBatch batch, long priority, SpillCallback spillCallback) {
        SpillableColumnarBatch spillableColumnarBatch;
        int numRows = batch.numRows();
        if (batch.numCols() <= 0) {
            batch.close();
            spillableColumnarBatch = new JustRowsColumnarBatch(numRows, spillCallback.semaphoreWaitTime());
        } else {
            DataType[] types = GpuColumnVector.extractTypes(batch);
            TempSpillBufferId id = TempSpillBufferId$.MODULE$.apply();
            this.addBatch(id, batch, priority, spillCallback);
            spillableColumnarBatch = new SpillableColumnarBatchImpl(id, numRows, types, spillCallback.semaphoreWaitTime());
        }
        return spillableColumnarBatch;
    }

    public SpillableColumnarBatch apply(ContiguousTable ct, DataType[] sparkTypes, long priority, SpillCallback spillCallback) {
        TempSpillBufferId id = TempSpillBufferId$.MODULE$.apply();
        RapidsBufferCatalog$.MODULE$.addContiguousTable(id, ct, priority, spillCallback);
        return new SpillableColumnarBatchImpl(id, (int)ct.getRowCount(), sparkTypes, spillCallback.semaphoreWaitTime());
    }

    private void addBatch(RapidsBufferId id, ColumnarBatch batch2, long initialSpillPriority, SpillCallback spillCallback) {
        this.withResource(batch2, (Function1 & Serializable & scala.Serializable)batch -> {
            SpillableColumnarBatch$.$anonfun$addBatch$1(id, initialSpillPriority, spillCallback, batch);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$addBatch$4(RapidsBufferId id$1, long initialSpillPriority$1, SpillCallback spillCallback$1, ContiguousTable[] contigTables) {
        Predef$.MODULE$.require(contigTables.length == 1, (Function0 & Serializable & scala.Serializable)() -> "Unexpected number of contiguous spit tables");
        RapidsBufferCatalog$.MODULE$.addContiguousTable(id$1, (ContiguousTable)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])contigTables)).head(), initialSpillPriority$1, spillCallback$1);
    }

    public static final /* synthetic */ void $anonfun$addBatch$1(RapidsBufferId id$1, long initialSpillPriority$1, SpillCallback spillCallback$1, ColumnarBatch batch) {
        int numColumns = batch.numCols();
        if (GpuCompressedColumnVector.isBatchCompressed(batch)) {
            GpuCompressedColumnVector cv = (GpuCompressedColumnVector)batch.column(0);
            DeviceMemoryBuffer buff = cv.getTableBuffer();
            buff.incRefCount();
            RapidsBufferCatalog$.MODULE$.addBuffer(id$1, buff, cv.getTableMeta(), initialSpillPriority$1, spillCallback$1);
        } else if (GpuPackedTableColumn.isBatchPacked(batch)) {
            GpuPackedTableColumn cv = (GpuPackedTableColumn)batch.column(0);
            RapidsBufferCatalog$.MODULE$.addContiguousTable(id$1, cv.getContiguousTable(), initialSpillPriority$1, spillCallback$1);
        } else if (numColumns > 0 && RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numColumns).forall((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> batch.column(i) instanceof GpuColumnVectorFromBuffer)) {
            GpuColumnVectorFromBuffer cv = (GpuColumnVectorFromBuffer)batch.column(0);
            Table table = GpuColumnVector.from(batch);
            DeviceMemoryBuffer buff = cv.getBuffer();
            buff.incRefCount();
            RapidsBufferCatalog$.MODULE$.addTable(id$1, table, buff, cv.getTableMeta(), initialSpillPriority$1, spillCallback$1);
        } else {
            MODULE$.withResource(GpuColumnVector.from(batch), (Function1 & Serializable & scala.Serializable)tmpTable -> {
                SpillableColumnarBatch$.MODULE$.withResource((AutoCloseable)((AutoCloseable[])tmpTable.contiguousSplit(new int[0])), (Function1)(Function1 & Serializable & scala.Serializable)contigTables -> {
                    SpillableColumnarBatch$.$anonfun$addBatch$4(id$1, initialSpillPriority$1, spillCallback$1, contigTables);
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            });
        }
    }

    private SpillableColumnarBatch$() {
        MODULE$ = this;
        Arm.$init$(this);
    }
}

