/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import ai.rapids.cudf.ColumnVector;
import ai.rapids.cudf.ColumnView;
import ai.rapids.cudf.Table;
import com.nvidia.spark.rapids.Arm;
import com.nvidia.spark.rapids.CloseableHolder;
import com.nvidia.spark.rapids.GpuColumnVector;
import com.nvidia.spark.rapids.GpuSemaphore$;
import com.nvidia.spark.rapids.GpuSorter;
import com.nvidia.spark.rapids.RapidsBuffer;
import com.nvidia.spark.rapids.RapidsBuffer$;
import com.nvidia.spark.rapids.SpillPriorities$;
import com.nvidia.spark.rapids.SpillableColumnarBatch;
import com.nvidia.spark.rapids.SpillableColumnarBatch$;
import com.nvidia.spark.rapids.XORShiftRandom;
import java.io.Serializable;
import java.util.Random;
import org.apache.spark.TaskContext$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

public final class SamplingUtils$
implements Arm {
    public static SamplingUtils$ MODULE$;

    static {
        new SamplingUtils$();
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T r, Function1<T, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T[] r, Function1<T[], V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T, V> V withResourceIfAllowed(T r, Function1<T, V> block) {
        return (V)Arm.withResourceIfAllowed$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T[] r, Function1<T[], V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends RapidsBuffer, V> V freeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.freeOnExcept$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(CloseableHolder<T> h, Function1<CloseableHolder<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, h, block);
    }

    private Table selectWithoutReplacementFrom(int count, scala.util.Random rand, ColumnarBatch cb) {
        Table table;
        int rows = cb.numRows();
        Predef$.MODULE$.assert(count <= rows);
        if (rows == count) {
            table = GpuColumnVector.from(cb);
        } else if (count < rows / 2) {
            Set selected = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
            while (selected.size() < count) {
                selected.$plus$eq((Object)BoxesRunTime.boxToInteger((int)rand.nextInt(rows)));
            }
            table = (Table)this.withResource(ColumnVector.fromInts((int[])((int[])selected.toSeq().toArray(ClassTag$.MODULE$.Int()))), (Function1 & Serializable & scala.Serializable)gatherMap -> (Table)MODULE$.withResource(GpuColumnVector.from(cb), (Function1 & Serializable & scala.Serializable)tab -> tab.gather((ColumnView)gatherMap)));
        } else {
            int toRemove = rows - count;
            Set notSelected = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
            while (notSelected.size() < toRemove) {
                notSelected.$plus$eq((Object)BoxesRunTime.boxToInteger((int)rand.nextInt(rows)));
            }
            IndexedSeq selected = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), rows).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)elem -> notSelected.contains((Object)BoxesRunTime.boxToInteger((int)elem)));
            table = (Table)this.withResource(ColumnVector.fromInts((int[])((int[])selected.toArray(ClassTag$.MODULE$.Int()))), (Function1 & Serializable & scala.Serializable)gatherMap -> (Table)MODULE$.withResource(GpuColumnVector.from(cb), (Function1 & Serializable & scala.Serializable)tab -> tab.gather((ColumnView)gatherMap)));
        }
        return table;
    }

    public InternalRow[] randomResample(Iterator<ColumnarBatch> input, double fraction, GpuSorter sorter, Function1<Iterator<ColumnarBatch>, Iterator<InternalRow>> converter, long seed) {
        XORShiftRandom jRand = new XORShiftRandom(seed);
        scala.util.Random rand = new scala.util.Random((Random)jRand);
        ObjectRef runningCb = ObjectRef.create(null);
        LongRef totalRowsSeen = LongRef.create((long)0L);
        LongRef totalRowsCollected = LongRef.create((long)0L);
        while (input.hasNext()) {
            this.withResource((AutoCloseable)input.next(), (Function1 & Serializable & scala.Serializable)cb -> {
                SamplingUtils$.$anonfun$randomResample$1(totalRowsSeen, fraction, totalRowsCollected, rand, runningCb, cb);
                return BoxedUnit.UNIT;
            });
            GpuSemaphore$.MODULE$.releaseIfNecessary(TaskContext$.MODULE$.get());
        }
        if ((SpillableColumnarBatch)runningCb.elem == null) {
            return (InternalRow[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(InternalRow.class));
        }
        ColumnarBatch cb2 = (ColumnarBatch)this.withResource((SpillableColumnarBatch)runningCb.elem, (Function1 & Serializable & scala.Serializable)spb -> {
            runningCb$1.elem = null;
            return spb.getColumnarBatch();
        });
        ColumnarBatch withSortColumns = (ColumnarBatch)this.withResource(cb2, (Function1 & Serializable & scala.Serializable)cb -> sorter.appendProjectedColumns((ColumnarBatch)cb));
        Iterator retIterator = ((Iterator)converter.apply((Object)new Iterator<ColumnarBatch>(withSortColumns){
            private boolean read;
            private final ColumnarBatch withSortColumns$1;

            public Iterator<ColumnarBatch> seq() {
                return Iterator.seq$((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.isEmpty$((Iterator)this);
            }

            public boolean isTraversableAgain() {
                return Iterator.isTraversableAgain$((Iterator)this);
            }

            public boolean hasDefiniteSize() {
                return Iterator.hasDefiniteSize$((Iterator)this);
            }

            public Iterator<ColumnarBatch> take(int n) {
                return Iterator.take$((Iterator)this, (int)n);
            }

            public Iterator<ColumnarBatch> drop(int n) {
                return Iterator.drop$((Iterator)this, (int)n);
            }

            public Iterator<ColumnarBatch> slice(int from, int until) {
                return Iterator.slice$((Iterator)this, (int)from, (int)until);
            }

            public Iterator<ColumnarBatch> sliceIterator(int from, int until) {
                return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<B> map(Function1<ColumnarBatch, B> f) {
                return Iterator.map$((Iterator)this, f);
            }

            public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                return Iterator.$plus$plus$((Iterator)this, that);
            }

            public <B> Iterator<B> flatMap(Function1<ColumnarBatch, GenTraversableOnce<B>> f) {
                return Iterator.flatMap$((Iterator)this, f);
            }

            public Iterator<ColumnarBatch> filter(Function1<ColumnarBatch, Object> p) {
                return Iterator.filter$((Iterator)this, p);
            }

            public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<ColumnarBatch, B, Object> p) {
                return Iterator.corresponds$((Iterator)this, that, p);
            }

            public Iterator<ColumnarBatch> withFilter(Function1<ColumnarBatch, Object> p) {
                return Iterator.withFilter$((Iterator)this, p);
            }

            public Iterator<ColumnarBatch> filterNot(Function1<ColumnarBatch, Object> p) {
                return Iterator.filterNot$((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<ColumnarBatch, B> pf) {
                return Iterator.collect$((Iterator)this, pf);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, ColumnarBatch, B> op) {
                return Iterator.scanLeft$((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<ColumnarBatch, B, B> op) {
                return Iterator.scanRight$((Iterator)this, z, op);
            }

            public Iterator<ColumnarBatch> takeWhile(Function1<ColumnarBatch, Object> p) {
                return Iterator.takeWhile$((Iterator)this, p);
            }

            public Tuple2<Iterator<ColumnarBatch>, Iterator<ColumnarBatch>> partition(Function1<ColumnarBatch, Object> p) {
                return Iterator.partition$((Iterator)this, p);
            }

            public Tuple2<Iterator<ColumnarBatch>, Iterator<ColumnarBatch>> span(Function1<ColumnarBatch, Object> p) {
                return Iterator.span$((Iterator)this, p);
            }

            public Iterator<ColumnarBatch> dropWhile(Function1<ColumnarBatch, Object> p) {
                return Iterator.dropWhile$((Iterator)this, p);
            }

            public <B> Iterator<Tuple2<ColumnarBatch, B>> zip(Iterator<B> that) {
                return Iterator.zip$((Iterator)this, that);
            }

            public <A1> Iterator<A1> padTo(int len, A1 elem) {
                return Iterator.padTo$((Iterator)this, (int)len, elem);
            }

            public Iterator<Tuple2<ColumnarBatch, Object>> zipWithIndex() {
                return Iterator.zipWithIndex$((Iterator)this);
            }

            public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
            }

            public <U> void foreach(Function1<ColumnarBatch, U> f) {
                Iterator.foreach$((Iterator)this, f);
            }

            public boolean forall(Function1<ColumnarBatch, Object> p) {
                return Iterator.forall$((Iterator)this, p);
            }

            public boolean exists(Function1<ColumnarBatch, Object> p) {
                return Iterator.exists$((Iterator)this, p);
            }

            public boolean contains(Object elem) {
                return Iterator.contains$((Iterator)this, (Object)elem);
            }

            public Option<ColumnarBatch> find(Function1<ColumnarBatch, Object> p) {
                return Iterator.find$((Iterator)this, p);
            }

            public int indexWhere(Function1<ColumnarBatch, Object> p) {
                return Iterator.indexWhere$((Iterator)this, p);
            }

            public int indexWhere(Function1<ColumnarBatch, Object> p, int from) {
                return Iterator.indexWhere$((Iterator)this, p, (int)from);
            }

            public <B> int indexOf(B elem) {
                return Iterator.indexOf$((Iterator)this, elem);
            }

            public <B> int indexOf(B elem, int from) {
                return Iterator.indexOf$((Iterator)this, elem, (int)from);
            }

            public BufferedIterator<ColumnarBatch> buffered() {
                return Iterator.buffered$((Iterator)this);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.grouped$((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.sliding$((Iterator)this, (int)size, (int)step);
            }

            public <B> int sliding$default$2() {
                return Iterator.sliding$default$2$((Iterator)this);
            }

            public int length() {
                return Iterator.length$((Iterator)this);
            }

            public Tuple2<Iterator<ColumnarBatch>, Iterator<ColumnarBatch>> duplicate() {
                return Iterator.duplicate$((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
            }

            public boolean sameElements(Iterator<?> that) {
                return Iterator.sameElements$((Iterator)this, that);
            }

            public Traversable<ColumnarBatch> toTraversable() {
                return Iterator.toTraversable$((Iterator)this);
            }

            public Iterator<ColumnarBatch> toIterator() {
                return Iterator.toIterator$((Iterator)this);
            }

            public Stream<ColumnarBatch> toStream() {
                return Iterator.toStream$((Iterator)this);
            }

            public String toString() {
                return Iterator.toString$((Iterator)this);
            }

            public List<ColumnarBatch> reversed() {
                return TraversableOnce.reversed$((TraversableOnce)this);
            }

            public int size() {
                return TraversableOnce.size$((TraversableOnce)this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.nonEmpty$((TraversableOnce)this);
            }

            public int count(Function1<ColumnarBatch, Object> p) {
                return TraversableOnce.count$((TraversableOnce)this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<ColumnarBatch, B> pf) {
                return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, ColumnarBatch, B> op) {
                return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<ColumnarBatch, B, B> op) {
                return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, ColumnarBatch, B> op) {
                return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
            }

            public <B> B foldRight(B z, Function2<ColumnarBatch, B, B> op) {
                return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
            }

            public <B> B reduceLeft(Function2<B, ColumnarBatch, B> op) {
                return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
            }

            public <B> B reduceRight(Function2<ColumnarBatch, B, B> op) {
                return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, ColumnarBatch, B> op) {
                return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<ColumnarBatch, B, B> op) {
                return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.reduceOption$((TraversableOnce)this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, ColumnarBatch, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.sum$((TraversableOnce)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.product$((TraversableOnce)this, num);
            }

            public Object min(Ordering cmp) {
                return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
            }

            public Object max(Ordering cmp) {
                return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
            }

            public List<ColumnarBatch> toList() {
                return TraversableOnce.toList$((TraversableOnce)this);
            }

            public Iterable<ColumnarBatch> toIterable() {
                return TraversableOnce.toIterable$((TraversableOnce)this);
            }

            public Seq<ColumnarBatch> toSeq() {
                return TraversableOnce.toSeq$((TraversableOnce)this);
            }

            public IndexedSeq<ColumnarBatch> toIndexedSeq() {
                return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.toBuffer$((TraversableOnce)this);
            }

            public <B> scala.collection.immutable.Set<B> toSet() {
                return TraversableOnce.toSet$((TraversableOnce)this);
            }

            public Vector<ColumnarBatch> toVector() {
                return TraversableOnce.toVector$((TraversableOnce)this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, ColumnarBatch, Col> cbf) {
                return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
            }

            public <T, U> Map<T, U> toMap(Predef.$less$colon$less<ColumnarBatch, Tuple2<T, U>> ev) {
                return TraversableOnce.toMap$((TraversableOnce)this, ev);
            }

            public String mkString(String start, String sep, String end) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
            }

            public String mkString(String sep) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
            }

            public String mkString() {
                return TraversableOnce.mkString$((TraversableOnce)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
            }

            public int sizeHintIfCheap() {
                return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
            }

            private boolean read() {
                return this.read;
            }

            private void read_$eq(boolean x$1) {
                this.read = x$1;
            }

            public boolean hasNext() {
                return !this.read();
            }

            public ColumnarBatch next() {
                this.read_$eq(true);
                return this.withSortColumns$1;
            }
            {
                this.withSortColumns$1 = withSortColumns$1;
                GenTraversableOnce.$init$((GenTraversableOnce)this);
                TraversableOnce.$init$((TraversableOnce)this);
                Iterator.$init$((Iterator)this);
                this.read = false;
            }
        })).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.copy());
        return (InternalRow[])retIterator.toArray(ClassTag$.MODULE$.apply(InternalRow.class));
    }

    public long randomResample$default$5() {
        return Random$.MODULE$.nextLong();
    }

    public Tuple2<InternalRow[], Object> reservoirSampleAndCount(Iterator<ColumnarBatch> input, int k, GpuSorter sorter, Function1<Iterator<ColumnarBatch>, Iterator<InternalRow>> converter, long seed) {
        XORShiftRandom jRand = new XORShiftRandom(seed);
        scala.util.Random rand = new scala.util.Random((Random)jRand);
        ObjectRef runningCb = ObjectRef.create(null);
        LongRef numTotalRows = LongRef.create((long)0L);
        LongRef rowsSaved = LongRef.create((long)0L);
        while (input.hasNext()) {
            this.withResource((AutoCloseable)input.next(), (Function1 & Serializable & scala.Serializable)cb -> {
                SamplingUtils$.$anonfun$reservoirSampleAndCount$1(numTotalRows, k, rand, runningCb, rowsSaved, cb);
                return BoxedUnit.UNIT;
            });
            GpuSemaphore$.MODULE$.releaseIfNecessary(TaskContext$.MODULE$.get());
        }
        if ((SpillableColumnarBatch)runningCb.elem == null) {
            return new Tuple2(Array$.MODULE$.empty(ClassTag$.MODULE$.apply(InternalRow.class)), (Object)BoxesRunTime.boxToLong((long)numTotalRows.elem));
        }
        ColumnarBatch cb2 = (ColumnarBatch)this.withResource((SpillableColumnarBatch)runningCb.elem, (Function1 & Serializable & scala.Serializable)spb -> {
            runningCb$2.elem = null;
            return spb.getColumnarBatch();
        });
        ColumnarBatch withSortColumns = (ColumnarBatch)this.withResource(cb2, (Function1 & Serializable & scala.Serializable)cb -> sorter.appendProjectedColumns((ColumnarBatch)cb));
        Iterator retIterator = ((Iterator)converter.apply((Object)new Iterator<ColumnarBatch>(withSortColumns){
            private boolean read;
            private final ColumnarBatch withSortColumns$2;

            public Iterator<ColumnarBatch> seq() {
                return Iterator.seq$((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.isEmpty$((Iterator)this);
            }

            public boolean isTraversableAgain() {
                return Iterator.isTraversableAgain$((Iterator)this);
            }

            public boolean hasDefiniteSize() {
                return Iterator.hasDefiniteSize$((Iterator)this);
            }

            public Iterator<ColumnarBatch> take(int n) {
                return Iterator.take$((Iterator)this, (int)n);
            }

            public Iterator<ColumnarBatch> drop(int n) {
                return Iterator.drop$((Iterator)this, (int)n);
            }

            public Iterator<ColumnarBatch> slice(int from, int until) {
                return Iterator.slice$((Iterator)this, (int)from, (int)until);
            }

            public Iterator<ColumnarBatch> sliceIterator(int from, int until) {
                return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<B> map(Function1<ColumnarBatch, B> f) {
                return Iterator.map$((Iterator)this, f);
            }

            public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                return Iterator.$plus$plus$((Iterator)this, that);
            }

            public <B> Iterator<B> flatMap(Function1<ColumnarBatch, GenTraversableOnce<B>> f) {
                return Iterator.flatMap$((Iterator)this, f);
            }

            public Iterator<ColumnarBatch> filter(Function1<ColumnarBatch, Object> p) {
                return Iterator.filter$((Iterator)this, p);
            }

            public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<ColumnarBatch, B, Object> p) {
                return Iterator.corresponds$((Iterator)this, that, p);
            }

            public Iterator<ColumnarBatch> withFilter(Function1<ColumnarBatch, Object> p) {
                return Iterator.withFilter$((Iterator)this, p);
            }

            public Iterator<ColumnarBatch> filterNot(Function1<ColumnarBatch, Object> p) {
                return Iterator.filterNot$((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<ColumnarBatch, B> pf) {
                return Iterator.collect$((Iterator)this, pf);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, ColumnarBatch, B> op) {
                return Iterator.scanLeft$((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<ColumnarBatch, B, B> op) {
                return Iterator.scanRight$((Iterator)this, z, op);
            }

            public Iterator<ColumnarBatch> takeWhile(Function1<ColumnarBatch, Object> p) {
                return Iterator.takeWhile$((Iterator)this, p);
            }

            public Tuple2<Iterator<ColumnarBatch>, Iterator<ColumnarBatch>> partition(Function1<ColumnarBatch, Object> p) {
                return Iterator.partition$((Iterator)this, p);
            }

            public Tuple2<Iterator<ColumnarBatch>, Iterator<ColumnarBatch>> span(Function1<ColumnarBatch, Object> p) {
                return Iterator.span$((Iterator)this, p);
            }

            public Iterator<ColumnarBatch> dropWhile(Function1<ColumnarBatch, Object> p) {
                return Iterator.dropWhile$((Iterator)this, p);
            }

            public <B> Iterator<Tuple2<ColumnarBatch, B>> zip(Iterator<B> that) {
                return Iterator.zip$((Iterator)this, that);
            }

            public <A1> Iterator<A1> padTo(int len, A1 elem) {
                return Iterator.padTo$((Iterator)this, (int)len, elem);
            }

            public Iterator<Tuple2<ColumnarBatch, Object>> zipWithIndex() {
                return Iterator.zipWithIndex$((Iterator)this);
            }

            public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
            }

            public <U> void foreach(Function1<ColumnarBatch, U> f) {
                Iterator.foreach$((Iterator)this, f);
            }

            public boolean forall(Function1<ColumnarBatch, Object> p) {
                return Iterator.forall$((Iterator)this, p);
            }

            public boolean exists(Function1<ColumnarBatch, Object> p) {
                return Iterator.exists$((Iterator)this, p);
            }

            public boolean contains(Object elem) {
                return Iterator.contains$((Iterator)this, (Object)elem);
            }

            public Option<ColumnarBatch> find(Function1<ColumnarBatch, Object> p) {
                return Iterator.find$((Iterator)this, p);
            }

            public int indexWhere(Function1<ColumnarBatch, Object> p) {
                return Iterator.indexWhere$((Iterator)this, p);
            }

            public int indexWhere(Function1<ColumnarBatch, Object> p, int from) {
                return Iterator.indexWhere$((Iterator)this, p, (int)from);
            }

            public <B> int indexOf(B elem) {
                return Iterator.indexOf$((Iterator)this, elem);
            }

            public <B> int indexOf(B elem, int from) {
                return Iterator.indexOf$((Iterator)this, elem, (int)from);
            }

            public BufferedIterator<ColumnarBatch> buffered() {
                return Iterator.buffered$((Iterator)this);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.grouped$((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.sliding$((Iterator)this, (int)size, (int)step);
            }

            public <B> int sliding$default$2() {
                return Iterator.sliding$default$2$((Iterator)this);
            }

            public int length() {
                return Iterator.length$((Iterator)this);
            }

            public Tuple2<Iterator<ColumnarBatch>, Iterator<ColumnarBatch>> duplicate() {
                return Iterator.duplicate$((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
            }

            public boolean sameElements(Iterator<?> that) {
                return Iterator.sameElements$((Iterator)this, that);
            }

            public Traversable<ColumnarBatch> toTraversable() {
                return Iterator.toTraversable$((Iterator)this);
            }

            public Iterator<ColumnarBatch> toIterator() {
                return Iterator.toIterator$((Iterator)this);
            }

            public Stream<ColumnarBatch> toStream() {
                return Iterator.toStream$((Iterator)this);
            }

            public String toString() {
                return Iterator.toString$((Iterator)this);
            }

            public List<ColumnarBatch> reversed() {
                return TraversableOnce.reversed$((TraversableOnce)this);
            }

            public int size() {
                return TraversableOnce.size$((TraversableOnce)this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.nonEmpty$((TraversableOnce)this);
            }

            public int count(Function1<ColumnarBatch, Object> p) {
                return TraversableOnce.count$((TraversableOnce)this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<ColumnarBatch, B> pf) {
                return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, ColumnarBatch, B> op) {
                return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<ColumnarBatch, B, B> op) {
                return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, ColumnarBatch, B> op) {
                return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
            }

            public <B> B foldRight(B z, Function2<ColumnarBatch, B, B> op) {
                return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
            }

            public <B> B reduceLeft(Function2<B, ColumnarBatch, B> op) {
                return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
            }

            public <B> B reduceRight(Function2<ColumnarBatch, B, B> op) {
                return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, ColumnarBatch, B> op) {
                return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<ColumnarBatch, B, B> op) {
                return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.reduceOption$((TraversableOnce)this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, ColumnarBatch, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.sum$((TraversableOnce)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.product$((TraversableOnce)this, num);
            }

            public Object min(Ordering cmp) {
                return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
            }

            public Object max(Ordering cmp) {
                return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
            }

            public List<ColumnarBatch> toList() {
                return TraversableOnce.toList$((TraversableOnce)this);
            }

            public Iterable<ColumnarBatch> toIterable() {
                return TraversableOnce.toIterable$((TraversableOnce)this);
            }

            public Seq<ColumnarBatch> toSeq() {
                return TraversableOnce.toSeq$((TraversableOnce)this);
            }

            public IndexedSeq<ColumnarBatch> toIndexedSeq() {
                return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.toBuffer$((TraversableOnce)this);
            }

            public <B> scala.collection.immutable.Set<B> toSet() {
                return TraversableOnce.toSet$((TraversableOnce)this);
            }

            public Vector<ColumnarBatch> toVector() {
                return TraversableOnce.toVector$((TraversableOnce)this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, ColumnarBatch, Col> cbf) {
                return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
            }

            public <T, U> Map<T, U> toMap(Predef.$less$colon$less<ColumnarBatch, Tuple2<T, U>> ev) {
                return TraversableOnce.toMap$((TraversableOnce)this, ev);
            }

            public String mkString(String start, String sep, String end) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
            }

            public String mkString(String sep) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
            }

            public String mkString() {
                return TraversableOnce.mkString$((TraversableOnce)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
            }

            public int sizeHintIfCheap() {
                return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
            }

            private boolean read() {
                return this.read;
            }

            private void read_$eq(boolean x$1) {
                this.read = x$1;
            }

            public boolean hasNext() {
                return !this.read();
            }

            public ColumnarBatch next() {
                this.read_$eq(true);
                return this.withSortColumns$2;
            }
            {
                this.withSortColumns$2 = withSortColumns$2;
                GenTraversableOnce.$init$((GenTraversableOnce)this);
                TraversableOnce.$init$((TraversableOnce)this);
                Iterator.$init$((Iterator)this);
                this.read = false;
            }
        })).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.copy());
        return new Tuple2(retIterator.toArray(ClassTag$.MODULE$.apply(InternalRow.class)), (Object)BoxesRunTime.boxToLong((long)numTotalRows.elem));
    }

    public long reservoirSampleAndCount$default$5() {
        return Random$.MODULE$.nextLong();
    }

    public static final /* synthetic */ void $anonfun$randomResample$2(LongRef totalRowsCollected$1, ObjectRef runningCb$1, ColumnarBatch cb$2, Table selected) {
        totalRowsCollected$1.elem += selected.getRowCount();
        if ((SpillableColumnarBatch)runningCb$1.elem == null) {
            runningCb$1.elem = SpillableColumnarBatch$.MODULE$.apply(GpuColumnVector.from(selected, GpuColumnVector.extractTypes(cb$2)), SpillPriorities$.MODULE$.ACTIVE_ON_DECK_PRIORITY(), RapidsBuffer$.MODULE$.defaultSpillCallback());
        } else {
            Table concat2 = (Table)MODULE$.withResource((SpillableColumnarBatch)runningCb$1.elem, (Function1 & Serializable & scala.Serializable)spb -> {
                runningCb$1.elem = null;
                return (Table)MODULE$.withResource(spb.getColumnarBatch(), (Function1 & Serializable & scala.Serializable)cb -> (Table)MODULE$.withResource(GpuColumnVector.from(cb), (Function1 & Serializable & scala.Serializable)table -> Table.concatenate((Table[])new Table[]{selected, table})));
            });
            MODULE$.withResource(concat2, (Function1 & Serializable & scala.Serializable)concat -> {
                runningCb$1.elem = SpillableColumnarBatch$.MODULE$.apply(GpuColumnVector.from(concat, GpuColumnVector.extractTypes(cb$2)), SpillPriorities$.MODULE$.ACTIVE_ON_DECK_PRIORITY(), RapidsBuffer$.MODULE$.defaultSpillCallback());
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ void $anonfun$randomResample$1(LongRef totalRowsSeen$1, double fraction$1, LongRef totalRowsCollected$1, scala.util.Random rand$1, ObjectRef runningCb$1, ColumnarBatch cb) {
        int rowsInBatch = cb.numRows();
        totalRowsSeen$1.elem += (long)rowsInBatch;
        long totalRowsWanted = (long)((double)totalRowsSeen$1.elem * fraction$1);
        int numRowsToSelectFromBatch = (int)(totalRowsWanted - totalRowsCollected$1.elem);
        MODULE$.withResource(MODULE$.selectWithoutReplacementFrom(numRowsToSelectFromBatch, rand$1, cb), (Function1 & Serializable & scala.Serializable)selected -> {
            SamplingUtils$.$anonfun$randomResample$2(totalRowsCollected$1, runningCb$1, cb, selected);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$reservoirSampleAndCount$6(LongRef rowsSaved$1, ObjectRef runningCb$2, ColumnarBatch cb$4, Table concat) {
        rowsSaved$1.elem = concat.getRowCount();
        runningCb$2.elem = SpillableColumnarBatch$.MODULE$.apply(GpuColumnVector.from(concat, GpuColumnVector.extractTypes(cb$4)), SpillPriorities$.MODULE$.ACTIVE_ON_DECK_PRIORITY(), RapidsBuffer$.MODULE$.defaultSpillCallback());
    }

    public static final /* synthetic */ void $anonfun$reservoirSampleAndCount$4(int rowsToDrop$1, scala.util.Random rand$2, Table selected$2, LongRef rowsSaved$1, ObjectRef runningCb$2, ColumnarBatch cb) {
        Table filtered2 = rowsToDrop$1 > 0 ? MODULE$.selectWithoutReplacementFrom(cb.numRows() - rowsToDrop$1, rand$2, cb) : GpuColumnVector.from(cb);
        Table concat2 = (Table)MODULE$.withResource(filtered2, (Function1 & Serializable & scala.Serializable)filtered -> Table.concatenate((Table[])new Table[]{selected$2, filtered}));
        MODULE$.withResource(concat2, (Function1 & Serializable & scala.Serializable)concat -> {
            SamplingUtils$.$anonfun$reservoirSampleAndCount$6(rowsSaved$1, runningCb$2, cb, concat);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$reservoirSampleAndCount$3(ObjectRef runningCb$2, int rowsToDrop$1, scala.util.Random rand$2, Table selected$2, LongRef rowsSaved$1, SpillableColumnarBatch spb) {
        runningCb$2.elem = null;
        MODULE$.withResource(spb.getColumnarBatch(), (Function1 & Serializable & scala.Serializable)cb -> {
            SamplingUtils$.$anonfun$reservoirSampleAndCount$4(rowsToDrop$1, rand$2, selected$2, rowsSaved$1, runningCb$2, cb);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$reservoirSampleAndCount$2(ObjectRef runningCb$2, LongRef rowsSaved$1, ColumnarBatch cb$3, int rowsToDrop$1, scala.util.Random rand$2, Table selected) {
        if ((SpillableColumnarBatch)runningCb$2.elem == null) {
            rowsSaved$1.elem = selected.getRowCount();
            runningCb$2.elem = SpillableColumnarBatch$.MODULE$.apply(GpuColumnVector.from(selected, GpuColumnVector.extractTypes(cb$3)), SpillPriorities$.MODULE$.ACTIVE_ON_DECK_PRIORITY(), RapidsBuffer$.MODULE$.defaultSpillCallback());
        } else {
            MODULE$.withResource((SpillableColumnarBatch)runningCb$2.elem, (Function1 & Serializable & scala.Serializable)spb -> {
                SamplingUtils$.$anonfun$reservoirSampleAndCount$3(runningCb$2, rowsToDrop$1, rand$2, selected, rowsSaved$1, spb);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ void $anonfun$reservoirSampleAndCount$1(LongRef numTotalRows$1, int k$1, scala.util.Random rand$2, ObjectRef runningCb$2, LongRef rowsSaved$1, ColumnarBatch cb) {
        Tuple2.mcII.sp sp2;
        Tuple2.mcII.sp sp3;
        int rowsInBatch = cb.numRows();
        if (numTotalRows$1.elem == 0L) {
            sp3 = new Tuple2.mcII.sp(Math.min(k$1, rowsInBatch), 0);
        } else if (numTotalRows$1.elem + (long)rowsInBatch < (long)k$1) {
            sp3 = new Tuple2.mcII.sp(rowsInBatch, 0);
        } else {
            int v = (int)((double)k$1 * (double)rowsInBatch / (double)(numTotalRows$1.elem + (long)rowsInBatch));
            sp3 = sp2 = new Tuple2.mcII.sp(v, v);
        }
        if (sp2 == null) {
            throw new MatchError((Object)sp2);
        }
        int numRowsToSelectFromBatch = sp2._1$mcI$sp();
        int rowsToDrop = sp2._2$mcI$sp();
        Tuple2.mcII.sp sp4 = new Tuple2.mcII.sp(numRowsToSelectFromBatch, rowsToDrop);
        Tuple2.mcII.sp sp5 = sp4;
        int numRowsToSelectFromBatch2 = sp5._1$mcI$sp();
        int rowsToDrop2 = sp5._2$mcI$sp();
        numTotalRows$1.elem += (long)rowsInBatch;
        MODULE$.withResource(MODULE$.selectWithoutReplacementFrom(numRowsToSelectFromBatch2, rand$2, cb), (Function1 & Serializable & scala.Serializable)selected -> {
            SamplingUtils$.$anonfun$reservoirSampleAndCount$2(runningCb$2, rowsSaved$1, cb, rowsToDrop2, rand$2, selected);
            return BoxedUnit.UNIT;
        });
    }

    private SamplingUtils$() {
        MODULE$ = this;
        Arm.$init$(this);
    }
}

