/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import com.nvidia.spark.rapids.GpuKryoRegistrator;
import com.nvidia.spark.rapids.PluginException;
import com.nvidia.spark.rapids.RapidsConf;
import com.nvidia.spark.rapids.RapidsConf$;
import com.nvidia.spark.rapids.SQLExecPlugin;
import java.io.InputStream;
import java.io.Serializable;
import java.time.ZoneId;
import java.util.Properties;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.serializer.JavaSerializer;
import org.apache.spark.serializer.KryoSerializer;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class RapidsPluginUtils$
implements Logging {
    public static RapidsPluginUtils$ MODULE$;
    private final String CUDF_PROPS_FILENAME;
    private final String JNI_PROPS_FILENAME;
    private final String PLUGIN_PROPS_FILENAME;
    private final String SQL_PLUGIN_NAME;
    private final String UDF_PLUGIN_NAME;
    private final String SQL_PLUGIN_CONF_KEY;
    private final String SERIALIZER_CONF_KEY;
    private final String JAVA_SERIALIZER_NAME;
    private final String KRYO_SERIALIZER_NAME;
    private final String KRYO_REGISTRATOR_KEY;
    private final String KRYO_REGISTRATOR_NAME;
    private final String EXECUTOR_CORES_KEY;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new RapidsPluginUtils$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String CUDF_PROPS_FILENAME() {
        return this.CUDF_PROPS_FILENAME;
    }

    public String JNI_PROPS_FILENAME() {
        return this.JNI_PROPS_FILENAME;
    }

    public String PLUGIN_PROPS_FILENAME() {
        return this.PLUGIN_PROPS_FILENAME;
    }

    private String SQL_PLUGIN_NAME() {
        return this.SQL_PLUGIN_NAME;
    }

    private String UDF_PLUGIN_NAME() {
        return this.UDF_PLUGIN_NAME;
    }

    private String SQL_PLUGIN_CONF_KEY() {
        return this.SQL_PLUGIN_CONF_KEY;
    }

    private String SERIALIZER_CONF_KEY() {
        return this.SERIALIZER_CONF_KEY;
    }

    private String JAVA_SERIALIZER_NAME() {
        return this.JAVA_SERIALIZER_NAME;
    }

    private String KRYO_SERIALIZER_NAME() {
        return this.KRYO_SERIALIZER_NAME;
    }

    private String KRYO_REGISTRATOR_KEY() {
        return this.KRYO_REGISTRATOR_KEY;
    }

    private String KRYO_REGISTRATOR_NAME() {
        return this.KRYO_REGISTRATOR_NAME;
    }

    private String EXECUTOR_CORES_KEY() {
        return this.EXECUTOR_CORES_KEY;
    }

    public void logPluginMode(RapidsConf conf) {
        block5: {
            if (conf.isSqlEnabled() && conf.isSqlExecuteOnGPU()) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(70).append("RAPIDS Accelerator is enabled, to disable GPU ").append("support set `").append(RapidsConf$.MODULE$.SQL_ENABLED()).append("` to false.").toString());
                String string = conf.explain();
                String string2 = "NONE";
                if (string == null ? string2 != null : !string.equals(string2)) {
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(129).append("spark.rapids.sql.explain is set to `").append(conf.explain()).append("`. Set it to 'NONE' to ").append("suppress the diagnostics logging about the query placement on the GPU.").toString());
                }
            } else if (conf.isSqlEnabled() && conf.isSqlExplainOnlyEnabled()) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(130).append("RAPIDS Accelerator is in explain only mode, to disable ").append("set `").append(RapidsConf$.MODULE$.SQL_ENABLED()).append("` to false. To change the mode, ").append("restart the application and change `").append(RapidsConf$.MODULE$.SQL_MODE()).append("`.").toString());
            } else {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(69).append("RAPIDS Accelerator is disabled, to enable GPU ").append("support set `").append(RapidsConf$.MODULE$.SQL_ENABLED()).append("` to true.").toString());
            }
            if (!conf.isUdfCompilerEnabled()) break block5;
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(255).append("Experimental RAPIDS UDF compiler is enabled, in case of related failures ").append("disable it by setting `").append(RapidsConf$.MODULE$.UDF_COMPILER_ENABLED()).append("` to false. ").append("More information is available at https://nvidia.github.io/spark-rapids/docs/FAQ.html#").append("automatic-translation-of-scala-udfs-to-apache-spark-operations").toString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void fixupConfigs(SparkConf conf) {
        BoxedUnit boxedUnit;
        if (conf.contains(this.SQL_PLUGIN_CONF_KEY())) {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{this.SQL_PLUGIN_NAME(), this.UDF_PLUGIN_NAME()})).foreach((Function1 & Serializable & scala.Serializable)pluginName -> {
                String[] previousValue = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])conf.get(MODULE$.SQL_PLUGIN_CONF_KEY()).split(","))).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                return !new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])previousValue)).contains(pluginName) ? conf.set(MODULE$.SQL_PLUGIN_CONF_KEY(), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])previousValue)).$colon$plus(pluginName, ClassTag$.MODULE$.apply(String.class)))).mkString(",")) : conf.set(MODULE$.SQL_PLUGIN_CONF_KEY(), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])previousValue)).mkString(","));
            });
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = conf.set(this.SQL_PLUGIN_CONF_KEY(), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{this.SQL_PLUGIN_NAME(), this.UDF_PLUGIN_NAME()})).mkString(","));
        }
        String serializer = conf.get(this.SERIALIZER_CONF_KEY(), this.JAVA_SERIALIZER_NAME());
        if (this.KRYO_SERIALIZER_NAME().equals(serializer)) {
            if (!conf.contains(this.KRYO_REGISTRATOR_KEY())) throw new UnsupportedOperationException(new StringBuilder(153).append("The RAPIDS Accelerator when used with Kryo needs to register some serializers. Please set the spark config ").append(this.KRYO_REGISTRATOR_KEY()).append(" to ").append(this.KRYO_REGISTRATOR_NAME()).append(" or some operations may not work ").append("properly.").toString());
            if (!this.KRYO_REGISTRATOR_NAME().equals(conf.get(this.KRYO_REGISTRATOR_KEY()))) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(156).append("The RAPIDS Accelerator when used with Kryo needs to register some ").append("serializers using ").append(MODULE$.KRYO_REGISTRATOR_NAME()).append(". Please call it from your registrator ").append(" to let the plugin work properly.").toString());
            }
        } else if (!this.JAVA_SERIALIZER_NAME().equals(serializer)) {
            throw new UnsupportedOperationException(new StringBuilder(132).append(serializer).append(" is not a supported serializer for ").append("the RAPIDS Accelerator. Please disable the RAPIDS Accelerator or use a supported ").append("serializer (").append(this.JAVA_SERIALIZER_NAME()).append(", ").append(this.KRYO_SERIALIZER_NAME()).append(").").toString());
        }
        conf.set(RapidsConf$.MODULE$.DRIVER_TIMEZONE().key(), ZoneId.systemDefault().normalized().toString());
        String numThreadsKey = RapidsConf$.MODULE$.MULTITHREAD_READ_NUM_THREADS().key();
        if (conf.contains(numThreadsKey) || !conf.contains(this.EXECUTOR_CORES_KEY())) return;
        String numThreads = Integer.toString(Math.max(RapidsConf$.MODULE$.MULTITHREAD_READ_NUM_THREADS_DEFAULT(), new StringOps(Predef$.MODULE$.augmentString(conf.get(this.EXECUTOR_CORES_KEY()))).toInt()));
        conf.set(numThreadsKey, numThreads);
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(12).append(numThreadsKey).append(" is set to ").append(numThreads).append(".").toString());
    }

    public Properties loadProps(String resourceName) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream resource = classLoader.getResourceAsStream(resourceName);
        if (resource == null) {
            throw new PluginException(new StringBuilder(48).append("Could not find properties file ").append(resourceName).append(" in the classpath").toString());
        }
        Properties props = new Properties();
        props.load(resource);
        return props;
    }

    private RapidsPluginUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.CUDF_PROPS_FILENAME = "cudf-java-version-info.properties";
        this.JNI_PROPS_FILENAME = "spark-rapids-jni-version-info.properties";
        this.PLUGIN_PROPS_FILENAME = "rapids4spark-version-info.properties";
        this.SQL_PLUGIN_NAME = SQLExecPlugin.class.getName();
        this.UDF_PLUGIN_NAME = "com.nvidia.spark.udf.Plugin";
        this.SQL_PLUGIN_CONF_KEY = StaticSQLConf$.MODULE$.SPARK_SESSION_EXTENSIONS().key();
        this.SERIALIZER_CONF_KEY = "spark.serializer";
        this.JAVA_SERIALIZER_NAME = JavaSerializer.class.getName();
        this.KRYO_SERIALIZER_NAME = KryoSerializer.class.getName();
        this.KRYO_REGISTRATOR_KEY = "spark.kryo.registrator";
        this.KRYO_REGISTRATOR_NAME = GpuKryoRegistrator.class.getName();
        this.EXECUTOR_CORES_KEY = "spark.executor.cores";
        Properties pluginProps = this.loadProps(this.PLUGIN_PROPS_FILENAME());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("RAPIDS Accelerator build: ").append(pluginProps).toString());
        Properties jniProps = this.loadProps(this.JNI_PROPS_FILENAME());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("RAPIDS Accelerator JNI build: ").append(jniProps).toString());
        Properties cudfProps = this.loadProps(this.CUDF_PROPS_FILENAME());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(12).append("cudf build: ").append(cudfProps).toString());
        String pluginVersion = pluginProps.getProperty("version", "UNKNOWN");
        String cudfVersion = cudfProps.getProperty("version", "UNKNOWN");
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("RAPIDS Accelerator ").append(pluginVersion).append(" using cudf ").append(cudfVersion).append(".").toString());
    }
}

