/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import ai.rapids.cudf.HostColumnVector;
import ai.rapids.cudf.HostColumnVectorCore;
import com.nvidia.spark.rapids.RapidsHostColumnVectorCore;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.vectorized.ColumnarBatch;

public final class RapidsHostColumnVector
extends RapidsHostColumnVectorCore {
    private final HostColumnVector cudfCv;

    public static HostColumnVector[] extractBases(ColumnarBatch batch) {
        int numColumns = batch.numCols();
        HostColumnVector[] vectors = new HostColumnVector[numColumns];
        for (int i = 0; i < vectors.length; ++i) {
            vectors[i] = ((RapidsHostColumnVector)batch.column(i)).getBase();
        }
        return vectors;
    }

    public static RapidsHostColumnVector[] extractColumns(ColumnarBatch batch) {
        int numColumns = batch.numCols();
        RapidsHostColumnVector[] vectors = new RapidsHostColumnVector[numColumns];
        for (int i = 0; i < vectors.length; ++i) {
            vectors[i] = (RapidsHostColumnVector)batch.column(i);
        }
        return vectors;
    }

    public RapidsHostColumnVector(DataType type, HostColumnVector cudfCv) {
        super(type, (HostColumnVectorCore)cudfCv);
        this.cudfCv = cudfCv;
    }

    public final RapidsHostColumnVector incRefCount() {
        this.cudfCv.incRefCount();
        return this;
    }

    public final HostColumnVector getBase() {
        return this.cudfCv;
    }
}

