/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import ai.rapids.cudf.ContiguousTable;
import ai.rapids.cudf.DeviceMemoryBuffer;
import ai.rapids.cudf.Rmm;
import ai.rapids.cudf.RmmEventHandler;
import ai.rapids.cudf.Table;
import com.nvidia.spark.rapids.Arm;
import com.nvidia.spark.rapids.CloseableHolder;
import com.nvidia.spark.rapids.DeviceMemoryEventHandler;
import com.nvidia.spark.rapids.RapidsBuffer;
import com.nvidia.spark.rapids.RapidsBuffer$;
import com.nvidia.spark.rapids.RapidsBufferCatalog;
import com.nvidia.spark.rapids.RapidsBufferId;
import com.nvidia.spark.rapids.RapidsConf;
import com.nvidia.spark.rapids.RapidsDeviceMemoryStore;
import com.nvidia.spark.rapids.RapidsDeviceMemoryStore$;
import com.nvidia.spark.rapids.RapidsDiskStore;
import com.nvidia.spark.rapids.RapidsDiskStore$;
import com.nvidia.spark.rapids.RapidsGdsStore;
import com.nvidia.spark.rapids.RapidsGdsStore$;
import com.nvidia.spark.rapids.RapidsHostMemoryStore;
import com.nvidia.spark.rapids.RapidsHostMemoryStore$;
import com.nvidia.spark.rapids.SpillCallback;
import com.nvidia.spark.rapids.format.TableMeta;
import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.rapids.RapidsDiskBlockManager;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;

public final class RapidsBufferCatalog$
implements Logging,
Arm {
    public static RapidsBufferCatalog$ MODULE$;
    private SparkConf conf;
    private final int com$nvidia$spark$rapids$RapidsBufferCatalog$$MAX_BUFFER_LOOKUP_ATTEMPTS;
    private final RapidsBufferCatalog singleton;
    private RapidsDeviceMemoryStore deviceStorage;
    private RapidsHostMemoryStore hostStorage;
    private RapidsDiskStore diskStorage;
    private RapidsGdsStore gdsStorage;
    private DeviceMemoryEventHandler memoryEventHandler;
    private boolean _shouldUnspill;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    static {
        new RapidsBufferCatalog$();
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T r, Function1<T, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T[] r, Function1<T[], V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T, V> V withResourceIfAllowed(T r, Function1<T, V> block) {
        return (V)Arm.withResourceIfAllowed$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T[] r, Function1<T[], V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends RapidsBuffer, V> V freeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.freeOnExcept$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(CloseableHolder<T> h, Function1<CloseableHolder<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, h, block);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public int com$nvidia$spark$rapids$RapidsBufferCatalog$$MAX_BUFFER_LOOKUP_ATTEMPTS() {
        return this.com$nvidia$spark$rapids$RapidsBufferCatalog$$MAX_BUFFER_LOOKUP_ATTEMPTS;
    }

    public RapidsBufferCatalog singleton() {
        return this.singleton;
    }

    private RapidsDeviceMemoryStore deviceStorage() {
        return this.deviceStorage;
    }

    private void deviceStorage_$eq(RapidsDeviceMemoryStore x$1) {
        this.deviceStorage = x$1;
    }

    private RapidsHostMemoryStore hostStorage() {
        return this.hostStorage;
    }

    private void hostStorage_$eq(RapidsHostMemoryStore x$1) {
        this.hostStorage = x$1;
    }

    private RapidsDiskStore diskStorage() {
        return this.diskStorage;
    }

    private void diskStorage_$eq(RapidsDiskStore x$1) {
        this.diskStorage = x$1;
    }

    private RapidsGdsStore gdsStorage() {
        return this.gdsStorage;
    }

    private void gdsStorage_$eq(RapidsGdsStore x$1) {
        this.gdsStorage = x$1;
    }

    private DeviceMemoryEventHandler memoryEventHandler() {
        return this.memoryEventHandler;
    }

    private void memoryEventHandler_$eq(DeviceMemoryEventHandler x$1) {
        this.memoryEventHandler = x$1;
    }

    private boolean _shouldUnspill() {
        return this._shouldUnspill;
    }

    private void _shouldUnspill_$eq(boolean x$1) {
        this._shouldUnspill = x$1;
    }

    private SparkConf conf$lzycompute() {
        RapidsBufferCatalog$ rapidsBufferCatalog$ = this;
        synchronized (rapidsBufferCatalog$) {
            if (!this.bitmap$0) {
                SparkEnv env = SparkEnv$.MODULE$.get();
                this.conf = env != null ? env.conf() : new SparkConf();
                this.bitmap$0 = true;
            }
        }
        return this.conf;
    }

    private SparkConf conf() {
        return !this.bitmap$0 ? this.conf$lzycompute() : this.conf;
    }

    public void init(RapidsConf rapidsConf) {
        this.closeImpl();
        Predef$.MODULE$.assert(this.memoryEventHandler() == null);
        this.deviceStorage_$eq(new RapidsDeviceMemoryStore(RapidsDeviceMemoryStore$.MODULE$.$lessinit$greater$default$1()));
        RapidsDiskBlockManager diskBlockManager = new RapidsDiskBlockManager(this.conf());
        if (rapidsConf.isGdsSpillEnabled()) {
            this.gdsStorage_$eq(new RapidsGdsStore(diskBlockManager, rapidsConf.gdsSpillBatchWriteBufferSize(), RapidsGdsStore$.MODULE$.$lessinit$greater$default$3()));
            this.deviceStorage().setSpillStore(this.gdsStorage());
        } else {
            long hostSpillStorageSize = rapidsConf.hostSpillStorageSize() == -1L ? rapidsConf.pinnedPoolSize() + rapidsConf.pageablePoolSize() : rapidsConf.hostSpillStorageSize();
            this.hostStorage_$eq(new RapidsHostMemoryStore(hostSpillStorageSize, rapidsConf.pageablePoolSize(), RapidsHostMemoryStore$.MODULE$.$lessinit$greater$default$3(), RapidsHostMemoryStore$.MODULE$.$lessinit$greater$default$4()));
            this.diskStorage_$eq(new RapidsDiskStore(diskBlockManager, RapidsDiskStore$.MODULE$.$lessinit$greater$default$2(), RapidsDiskStore$.MODULE$.$lessinit$greater$default$3()));
            this.deviceStorage().setSpillStore(this.hostStorage());
            this.hostStorage().setSpillStore(this.diskStorage());
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Installing GPU memory handler for spill");
        this.memoryEventHandler_$eq(new DeviceMemoryEventHandler(this.deviceStorage(), rapidsConf.gpuOomDumpDir(), rapidsConf.isGdsSpillEnabled()));
        Rmm.setEventHandler((RmmEventHandler)this.memoryEventHandler());
        this._shouldUnspill_$eq(rapidsConf.isUnspillEnabled());
    }

    public void close() {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Closing storage");
        this.closeImpl();
    }

    private void closeImpl() {
        block4: {
            if (this.memoryEventHandler() != null) {
                this.memoryEventHandler_$eq(null);
            }
            if (this.deviceStorage() != null) {
                this.deviceStorage().close();
                this.deviceStorage_$eq(null);
            }
            if (this.hostStorage() != null) {
                this.hostStorage().close();
                this.hostStorage_$eq(null);
            }
            if (this.diskStorage() != null) {
                this.diskStorage().close();
                this.diskStorage_$eq(null);
            }
            if (this.gdsStorage() == null) break block4;
            this.gdsStorage().close();
            this.gdsStorage_$eq(null);
        }
    }

    public RapidsDeviceMemoryStore getDeviceStorage() {
        return this.deviceStorage();
    }

    public boolean shouldUnspill() {
        return this._shouldUnspill();
    }

    public void addTable(RapidsBufferId id, Table table, DeviceMemoryBuffer contigBuffer, TableMeta tableMeta, long initialSpillPriority, SpillCallback spillCallback) {
        this.deviceStorage().addTable(id, table, contigBuffer, tableMeta, initialSpillPriority, spillCallback);
    }

    public SpillCallback addTable$default$6() {
        return RapidsBuffer$.MODULE$.defaultSpillCallback();
    }

    public void addContiguousTable(RapidsBufferId id, ContiguousTable contigTable, long initialSpillPriority, SpillCallback spillCallback) {
        RapidsDeviceMemoryStore qual$1 = this.deviceStorage();
        RapidsBufferId x$1 = id;
        ContiguousTable x$2 = contigTable;
        long x$3 = initialSpillPriority;
        SpillCallback x$4 = spillCallback;
        boolean x$5 = qual$1.addContiguousTable$default$5();
        qual$1.addContiguousTable(x$1, x$2, x$3, x$4, x$5);
    }

    public SpillCallback addContiguousTable$default$4() {
        return RapidsBuffer$.MODULE$.defaultSpillCallback();
    }

    public void addBuffer(RapidsBufferId id, DeviceMemoryBuffer buffer, TableMeta tableMeta, long initialSpillPriority, SpillCallback spillCallback) {
        RapidsDeviceMemoryStore qual$1 = this.deviceStorage();
        RapidsBufferId x$1 = id;
        DeviceMemoryBuffer x$2 = buffer;
        TableMeta x$3 = tableMeta;
        long x$4 = initialSpillPriority;
        SpillCallback x$5 = spillCallback;
        boolean x$6 = qual$1.addBuffer$default$6();
        qual$1.addBuffer(x$1, x$2, x$3, x$4, x$5, x$6);
    }

    public SpillCallback addBuffer$default$5() {
        return RapidsBuffer$.MODULE$.defaultSpillCallback();
    }

    public RapidsBuffer acquireBuffer(RapidsBufferId id) {
        return this.singleton().acquireBuffer(id);
    }

    public void removeBuffer(RapidsBufferId id) {
        this.singleton().removeBuffer(id);
    }

    private RapidsBufferCatalog$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        Arm.$init$(this);
        this.com$nvidia$spark$rapids$RapidsBufferCatalog$$MAX_BUFFER_LOOKUP_ATTEMPTS = 100;
        this.singleton = new RapidsBufferCatalog();
    }
}

