/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import com.nvidia.spark.rapids.ShimLoader$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.adaptive.AdaptiveSparkPlanExec;
import org.apache.spark.sql.execution.adaptive.BroadcastQueryStageExec;
import org.apache.spark.sql.execution.adaptive.ShuffleQueryStageExec;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.mutable.ListBuffer;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

public final class PlanUtils$ {
    public static PlanUtils$ MODULE$;

    static {
        new PlanUtils$();
    }

    public String getBaseNameFromClass(String planClassStr) {
        int firstDotIndex = planClassStr.lastIndexOf(".");
        return firstDotIndex != -1 ? planClassStr.substring(firstDotIndex + 1) : planClassStr;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean sameClass(SparkPlan plan, String fallbackCpuClass) {
        String execNameWithoutPackage;
        Class planClass = plan.getClass();
        String string = execNameWithoutPackage = this.getBaseNameFromClass(planClass.getName());
        String string2 = fallbackCpuClass;
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = plan.getClass().getName();
        String string4 = fallbackCpuClass;
        if (string3 == null) {
            if (string4 == null) return true;
        } else if (string3.equals(string4)) return true;
        if (!BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0 & java.io.Serializable & Serializable)() -> ShimLoader$.MODULE$.loadClass(fallbackCpuClass)).map((Function1 & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isAssignableFrom(planClass))).getOrElse((Function0)(JFunction0.mcZ.sp & java.io.Serializable & Serializable)() -> false))) return false;
        return true;
    }

    public Seq<Expression> findExpressions(Expression exp, Function1<Expression, Object> predicate) {
        return PlanUtils$.recurse$1(exp, predicate, new ListBuffer());
    }

    public Seq<SparkPlan> findOperators(SparkPlan plan, Function1<SparkPlan, Object> predicate) {
        return PlanUtils$.recurse$2(plan, predicate, new ListBuffer());
    }

    private static final Seq recurse$1(Expression exp, Function1 predicate, ListBuffer accum) {
        Option option;
        Expression expression = exp;
        if (BoxesRunTime.unboxToBoolean((Object)predicate.apply((Object)exp))) {
            accum.$plus$eq((Object)exp);
            option = ((TraversableLike)exp.children().flatMap((Function1 & java.io.Serializable & Serializable)p -> PlanUtils$.recurse$1(p, predicate, accum), Seq$.MODULE$.canBuildFrom())).headOption();
        } else {
            option = ((TraversableLike)expression.children().flatMap((Function1 & java.io.Serializable & Serializable)p -> PlanUtils$.recurse$1(p, predicate, accum), Seq$.MODULE$.canBuildFrom())).headOption();
        }
        return accum;
    }

    private static final Seq recurse$2(SparkPlan plan, Function1 predicate, ListBuffer accum) {
        Seq seq;
        SparkPlan sparkPlan = plan;
        if (BoxesRunTime.unboxToBoolean((Object)predicate.apply((Object)plan))) {
            accum.$plus$eq((Object)plan);
            seq = ((TraversableLike)plan.children().flatMap((Function1 & java.io.Serializable & Serializable)p -> PlanUtils$.recurse$2(p, predicate, accum), Seq$.MODULE$.canBuildFrom())).headOption();
        } else if (sparkPlan instanceof AdaptiveSparkPlanExec) {
            AdaptiveSparkPlanExec adaptiveSparkPlanExec = (AdaptiveSparkPlanExec)sparkPlan;
            seq = PlanUtils$.recurse$2(adaptiveSparkPlanExec.executedPlan(), predicate, accum);
        } else if (sparkPlan instanceof BroadcastQueryStageExec) {
            BroadcastQueryStageExec broadcastQueryStageExec = (BroadcastQueryStageExec)sparkPlan;
            seq = PlanUtils$.recurse$2((SparkPlan)broadcastQueryStageExec.broadcast(), predicate, accum);
        } else if (sparkPlan instanceof ShuffleQueryStageExec) {
            ShuffleQueryStageExec shuffleQueryStageExec = (ShuffleQueryStageExec)sparkPlan;
            seq = PlanUtils$.recurse$2((SparkPlan)shuffleQueryStageExec.shuffle(), predicate, accum);
        } else {
            seq = ((TraversableLike)sparkPlan.children().flatMap((Function1 & java.io.Serializable & Serializable)p -> PlanUtils$.recurse$2(p, predicate, accum), Seq$.MODULE$.canBuildFrom())).headOption();
        }
        return accum;
    }

    private PlanUtils$() {
        MODULE$ = this;
    }
}

