/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import ai.rapids.cudf.NvtxColor;
import ai.rapids.cudf.NvtxRange;
import ai.rapids.cudf.OutOfBoundsPolicy;
import com.nvidia.spark.rapids.Arm;
import com.nvidia.spark.rapids.CloseableHolder;
import com.nvidia.spark.rapids.JoinGatherer;
import com.nvidia.spark.rapids.JoinGathererImpl;
import com.nvidia.spark.rapids.LazySpillableColumnarBatch;
import com.nvidia.spark.rapids.LazySpillableGatherMap;
import com.nvidia.spark.rapids.MultiJoinGather;
import com.nvidia.spark.rapids.RapidsBuffer;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.runtime.BoxesRunTime;

public final class JoinGatherer$
implements Arm {
    public static JoinGatherer$ MODULE$;

    static {
        new JoinGatherer$();
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T r, Function1<T, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T[] r, Function1<T[], V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T, V> V withResourceIfAllowed(T r, Function1<T, V> block) {
        return (V)Arm.withResourceIfAllowed$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T[] r, Function1<T[], V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends RapidsBuffer, V> V freeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.freeOnExcept$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(CloseableHolder<T> h, Function1<CloseableHolder<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, h, block);
    }

    public JoinGatherer apply(LazySpillableGatherMap gatherMap, LazySpillableColumnarBatch inputData, OutOfBoundsPolicy outOfBoundsPolicy) {
        return new JoinGathererImpl(gatherMap, inputData, outOfBoundsPolicy);
    }

    public JoinGatherer apply(LazySpillableGatherMap leftMap, LazySpillableColumnarBatch leftData, LazySpillableGatherMap rightMap, LazySpillableColumnarBatch rightData, OutOfBoundsPolicy outOfBoundsPolicyLeft, OutOfBoundsPolicy outOfBoundsPolicyRight) {
        JoinGatherer left = this.apply(leftMap, leftData, outOfBoundsPolicyLeft);
        JoinGatherer right = this.apply(rightMap, rightData, outOfBoundsPolicyRight);
        return new MultiJoinGather(left, right);
    }

    public int getRowsInNextBatch(JoinGatherer gatherer, long targetSize) {
        return BoxesRunTime.unboxToInt(this.withResource(new NvtxRange("calc gather size", NvtxColor.YELLOW), (Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)JoinGatherer$.$anonfun$getRowsInNextBatch$1(gatherer, targetSize, x$1))));
    }

    public static final /* synthetic */ int $anonfun$getRowsInNextBatch$1(JoinGatherer gatherer$1, long targetSize$2, NvtxRange x$1) {
        long l;
        long rowsLeft = gatherer$1.numRowsLeft();
        Option<Object> option = gatherer$1.getFixedWidthBitSize();
        if (option instanceof Some) {
            Some some = (Some)option;
            int fixedBitSize = BoxesRunTime.unboxToInt((Object)some.value());
            l = Math.max(1L, targetSize$2 / (long)fixedBitSize * 8L);
        } else if (None$.MODULE$.equals(option)) {
            l = (double)rowsLeft * gatherer$1.realCheapPerRowSizeEstimate() <= (double)targetSize$2 * 0.75 ? rowsLeft : (long)gatherer$1.gatherRowEstimate(targetSize$2);
        } else {
            throw new MatchError(option);
        }
        long rowEstimate = l;
        return (int)Math.min(Math.min(rowEstimate, rowsLeft), Integer.MAX_VALUE);
    }

    private JoinGatherer$() {
        MODULE$ = this;
        Arm.$init$(this);
    }
}

