/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import ai.rapids.cudf.Cuda;
import com.nvidia.spark.rapids.GpuDeviceManager$;
import java.io.Serializable;
import java.util.Optional;
import org.apache.spark.SparkConf;
import org.apache.spark.api.resource.ResourceDiscoveryPlugin;
import org.apache.spark.internal.Logging;
import org.apache.spark.resource.ResourceInformation;
import org.apache.spark.resource.ResourceRequest;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u00153Aa\u0001\u0003\t\u001b!)\u0011\u0006\u0001C\u0001U!)Q\u0006\u0001C!]\t9\u0013J\u001c;fe:\fG.\u0012=dYV\u001c\u0018N^3N_\u0012,w\t];ESN\u001cwN^3ssBcWoZ5o\u0015\t)a!\u0001\u0004sCBLGm\u001d\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r94\u0018\u000eZ5b\u0015\u0005Y\u0011aA2p[\u000e\u00011\u0003\u0002\u0001\u000f-\r\u0002\"a\u0004\u000b\u000e\u0003AQ!!\u0005\n\u0002\t1\fgn\u001a\u0006\u0002'\u0005!!.\u0019<b\u0013\t)\u0002C\u0001\u0004PE*,7\r\u001e\t\u0003/\u0005j\u0011\u0001\u0007\u0006\u00033i\t\u0001B]3t_V\u00148-\u001a\u0006\u00037q\t1!\u00199j\u0015\t9QD\u0003\u0002\u001f?\u00051\u0011\r]1dQ\u0016T\u0011\u0001I\u0001\u0004_J<\u0017B\u0001\u0012\u0019\u0005]\u0011Vm]8ve\u000e,G)[:d_Z,'/\u001f)mk\u001eLg\u000e\u0005\u0002%O5\tQE\u0003\u0002'9\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002)K\t9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u0001,!\ta\u0003!D\u0001\u0005\u0003A!\u0017n]2pm\u0016\u0014(+Z:pkJ\u001cW\rF\u00020u}\u00022\u0001M\u001a6\u001b\u0005\t$B\u0001\u001a\u0013\u0003\u0011)H/\u001b7\n\u0005Q\n$\u0001C(qi&|g.\u00197\u0011\u0005YBT\"A\u001c\u000b\u0005ea\u0012BA\u001d8\u0005M\u0011Vm]8ve\u000e,\u0017J\u001c4pe6\fG/[8o\u0011\u0015Y$\u00011\u0001=\u0003\u001d\u0011X-];fgR\u0004\"AN\u001f\n\u0005y:$a\u0004*fg>,(oY3SKF,Xm\u001d;\t\u000b\u0001\u0013\u0001\u0019A!\u0002\u0013M\u0004\u0018M]6d_:4\u0007C\u0001\"D\u001b\u0005a\u0012B\u0001#\u001d\u0005%\u0019\u0006/\u0019:l\u0007>tg\r")
public class InternalExclusiveModeGpuDiscoveryPlugin
implements ResourceDiscoveryPlugin,
Logging {
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Optional<ResourceInformation> discoverResource(ResourceRequest request, SparkConf sparkconf) {
        String resourceName = request.id().resourceName();
        if (!resourceName.equals("gpu")) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(71).append("ExclusiveModeGpuDiscoveryPlugin only handles gpu allocations, ").append("skipping ").append(resourceName).toString());
            return Optional.empty();
        }
        long ngpusRequested = request.amount();
        int deviceCount = Cuda.getDeviceCount();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(76).append("Running ExclusiveModeGpuDiscoveryPlugin to acquire ").append(ngpusRequested).append(" GPU(s), ").append("host has ").append(deviceCount).append(" GPU(s)").toString());
        ArrayBuffer allocatedAddrs = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ArrayBuffer addrsToTry = ((ArrayBuffer)ArrayBuffer$.MODULE$.empty()).$plus$plus$eq((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), deviceCount));
        for (int numRetries = 2; numRetries > 0 && (long)allocatedAddrs.size() < ngpusRequested && addrsToTry.nonEmpty(); --numRetries) {
            int allAddrs = addrsToTry.size();
            for (int addrLoc = 0; addrLoc < allAddrs && (long)allocatedAddrs.size() < ngpusRequested; ++addrLoc) {
                int addr = BoxesRunTime.unboxToInt((Object)addrsToTry.apply(addrLoc));
                Object object = GpuDeviceManager$.MODULE$.tryToSetGpuDeviceAndAcquire(addr) ? allocatedAddrs.$plus$eq((Object)Integer.toString(addr)) : BoxedUnit.UNIT;
            }
            addrsToTry.$minus$minus$eq((TraversableOnce)allocatedAddrs.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)InternalExclusiveModeGpuDiscoveryPlugin.$anonfun$discoverResource$3(x$1)), ArrayBuffer$.MODULE$.canBuildFrom()));
        }
        if ((long)allocatedAddrs.size() < ngpusRequested) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(77).append("ExclusiveModeGpuDiscoveryPlugin did not find enough gpus, ").append("requested: ").append(ngpusRequested).append(" found: ").append(allocatedAddrs.size()).toString());
        }
        return Optional.of(new ResourceInformation("gpu", (String[])allocatedAddrs.toArray(ClassTag$.MODULE$.apply(String.class))));
    }

    public static final /* synthetic */ int $anonfun$discoverResource$3(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toInt();
    }

    public InternalExclusiveModeGpuDiscoveryPlugin() {
        Logging.$init$((Logging)this);
    }
}

