/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import java.util.AbstractQueue;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.lang3.mutable.MutableInt;

public final class HashedPriorityQueue<T>
extends AbstractQueue<T> {
    private static final int DEFAULT_INITIAL_HEAP_SIZE = 16;
    private final Comparator<? super T> comparator;
    private T[] heap;
    private int size;
    private final HashMap<T, MutableInt> locationMap = new HashMap();

    public HashedPriorityQueue(Comparator<? super T> comparator) {
        this(16, comparator);
    }

    public HashedPriorityQueue(int initialHeapSize, Comparator<? super T> comparator) {
        this.comparator = comparator;
        this.heap = new Object[initialHeapSize];
        this.size = 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean offer(T obj) {
        this.ensureCapacityToInsert();
        MutableInt location = new MutableInt(this.size);
        this.locationMap.put(obj, location);
        ++this.size;
        this.siftUp(obj, location);
        return true;
    }

    @Override
    public T poll() {
        if (this.size == 0) {
            return null;
        }
        T result = this.heap[0];
        if (this.locationMap.remove(result) == null) {
            throw new IllegalStateException("Object in heap without an index: " + result);
        }
        this.fillHoleWithLast(0);
        return result;
    }

    @Override
    public T peek() {
        return this.heap[0];
    }

    @Override
    public boolean contains(Object obj) {
        return this.locationMap.containsKey(obj);
    }

    @Override
    public boolean remove(Object o) {
        Object obj = o;
        MutableInt location = this.locationMap.remove(obj);
        if (location == null) {
            return false;
        }
        int heapIndex = location.getValue();
        this.fillHoleWithLast(heapIndex);
        return true;
    }

    @Override
    public void clear() {
        Arrays.fill(this.heap, 0, this.size, null);
        this.locationMap.clear();
        this.size = 0;
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.heap, this.size);
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        if (a.length > this.size) {
            System.arraycopy(this.heap, 0, a, 0, this.size);
            return a;
        }
        return Arrays.copyOf(this.heap, this.size, a.getClass());
    }

    @Override
    public Iterator<T> iterator() {
        return Arrays.asList(Arrays.copyOf(this.heap, this.size)).iterator();
    }

    public void priorityUpdated(T obj) {
        MutableInt location = this.locationMap.get(obj);
        if (location != null && !this.siftUp(obj, location)) {
            this.siftDown(obj, location);
        }
    }

    private int getParentIndex(int heapIndex) {
        return heapIndex - 1 >>> 1;
    }

    private MutableInt getLocation(T obj) {
        MutableInt location = this.locationMap.get(obj);
        if (location == null) {
            throw new IllegalStateException("Object in heap without a corresponding index: " + obj);
        }
        return location;
    }

    private void updateHeapIndex(T obj, int heapIndex) {
        this.updateHeapIndex(obj, this.getLocation(obj), heapIndex);
    }

    private void updateHeapIndex(T obj, MutableInt location, int heapIndex) {
        this.heap[heapIndex] = obj;
        location.setValue(heapIndex);
    }

    private T popLastElement() {
        --this.size;
        T obj = this.heap[this.size];
        this.heap[this.size] = null;
        return obj;
    }

    private void ensureCapacityToInsert() {
        if (this.heap.length == Integer.MAX_VALUE) {
            throw new OutOfMemoryError("heap exceeded maximum array size");
        }
        int needed = this.size + 1;
        if (this.heap.length <= needed) {
            long newSize = Math.min((long)this.heap.length * 2L, Integer.MAX_VALUE);
            this.heap = Arrays.copyOf(this.heap, (int)newSize);
        }
    }

    private boolean siftUp(T obj, MutableInt location) {
        int parentIndex;
        T parent;
        boolean sifted = false;
        int heapIndex = location.getValue();
        while (heapIndex > 0 && this.comparator.compare(obj, parent = this.heap[parentIndex = this.getParentIndex(heapIndex)]) < 0) {
            sifted = true;
            this.updateHeapIndex(parent, heapIndex);
            heapIndex = parentIndex;
        }
        this.updateHeapIndex(obj, location, heapIndex);
        return sifted;
    }

    private boolean siftDown(T obj, MutableInt location) {
        boolean sifted = false;
        int heapIndex = location.getValue();
        int parentIndexEnd = this.getParentIndex(this.size + 1);
        while (heapIndex < parentIndexEnd) {
            T rightChild;
            int leftChildIndex = 2 * heapIndex + 1;
            int rightChildIndex = leftChildIndex + 1;
            T leastChild = this.heap[leftChildIndex];
            int leastChildIndex = leftChildIndex;
            if (rightChildIndex < this.size && this.comparator.compare(leastChild, rightChild = this.heap[rightChildIndex]) > 0) {
                leastChild = rightChild;
                leastChildIndex = rightChildIndex;
            }
            if (this.comparator.compare(obj, leastChild) <= 0) break;
            sifted = true;
            this.updateHeapIndex(leastChild, heapIndex);
            heapIndex = leastChildIndex;
        }
        this.updateHeapIndex(obj, location, heapIndex);
        return sifted;
    }

    private void fillHoleWithLast(int holeIndex) {
        T obj = this.popLastElement();
        if (holeIndex < this.size) {
            MutableInt location = this.getLocation(obj);
            location.setValue(holeIndex);
            if (!this.siftDown(obj, location)) {
                this.siftUp(obj, location);
            }
        }
    }
}

