/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import com.nvidia.spark.rapids.DateUtils;
import com.nvidia.spark.rapids.DateUtils$;
import com.nvidia.spark.rapids.GpuOverrides$;
import com.nvidia.spark.rapids.RapidsConf$;
import com.nvidia.spark.rapids.RapidsMeta;
import java.io.Serializable;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.rapids.GpuToTimestamp$;
import org.apache.spark.sql.rapids.LegacyTimeParserPolicy$;
import org.apache.spark.sql.rapids.TimeParserPolicy;
import scala.Function1;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class GpuTextBasedDateUtils$ {
    public static GpuTextBasedDateUtils$ MODULE$;
    private final Set<String> supportedDateFormats;
    private final Set<String> supportedTsPortionFormats;

    static {
        new GpuTextBasedDateUtils$();
    }

    private Set<String> supportedDateFormats() {
        return this.supportedDateFormats;
    }

    private Set<String> supportedTsPortionFormats() {
        return this.supportedTsPortionFormats;
    }

    public void tagCudfFormat(RapidsMeta<?, ?, ?> meta, String sparkFormat, boolean parseString) {
        block11: {
            TimeParserPolicy timeParserPolicy = GpuOverrides$.MODULE$.getTimeParserPolicy();
            LegacyTimeParserPolicy$ legacyTimeParserPolicy$ = LegacyTimeParserPolicy$.MODULE$;
            if (!(timeParserPolicy != null ? !timeParserPolicy.equals(legacyTimeParserPolicy$) : legacyTimeParserPolicy$ != null)) {
                try {
                    this.toCudfFormats(sparkFormat, parseString);
                    if (GpuToTimestamp$.MODULE$.LEGACY_COMPATIBLE_FORMATS().contains((Object)sparkFormat)) {
                        if (SQLConf$.MODULE$.get().ansiEnabled()) {
                            meta.willNotWorkOnGpu("LEGACY format in ANSI mode is not supported on the GPU");
                            break block11;
                        }
                        if (meta.conf().incompatDateFormats()) break block11;
                        meta.willNotWorkOnGpu(new StringBuilder(119).append("LEGACY format '").append(sparkFormat).append("' on the GPU is not guaranteed ").append("to produce the same results as Spark on CPU. Set ").append(RapidsConf$.MODULE$.INCOMPATIBLE_DATE_FORMATS().key()).append("=true to force onto GPU.").toString());
                        break block11;
                    }
                    meta.willNotWorkOnGpu(new StringBuilder(45).append("LEGACY format '").append(sparkFormat).append("' is not supported on the GPU.").toString());
                }
                catch (DateUtils.TimestampFormatConversionException e) {
                    meta.willNotWorkOnGpu(new StringBuilder(19).append("Failed to convert ").append(e.reason()).append(" ").append(e.getMessage()).toString());
                }
            } else {
                String[] parts = sparkFormat.split("'T'", 2);
                if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])parts)).isEmpty()) {
                    meta.willNotWorkOnGpu(new StringBuilder(40).append("the timestamp format '").append(sparkFormat).append("' is not supported").toString());
                }
                if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])parts)).headOption().exists((Function1 & Serializable & scala.Serializable)h -> BoxesRunTime.boxToBoolean((boolean)GpuTextBasedDateUtils$.$anonfun$tagCudfFormat$1(h)))) {
                    meta.willNotWorkOnGpu(new StringBuilder(40).append("the timestamp format '").append(sparkFormat).append("' is not supported").toString());
                }
                if (parts.length > 1 && !this.supportedTsPortionFormats().contains((Object)parts[1])) {
                    meta.willNotWorkOnGpu(new StringBuilder(40).append("the timestamp format '").append(sparkFormat).append("' is not supported").toString());
                }
                try {
                    this.toCudfFormats(sparkFormat, parseString);
                }
                catch (DateUtils.TimestampFormatConversionException e) {
                    meta.willNotWorkOnGpu(new StringBuilder(19).append("Failed to convert ").append(e.reason()).append(" ").append(e.getMessage()).toString());
                }
            }
        }
    }

    public Seq<String> toCudfFormats(String sparkFormat, boolean parseString) {
        Seq seq;
        boolean hasZsuffix = sparkFormat.endsWith("Z");
        String formatRoot = hasZsuffix ? sparkFormat.substring(0, sparkFormat.length() - 1) : sparkFormat;
        String cudfSupportedFormat = formatRoot.replace("'T'", "T").replace("[.SSSXXX]", "").replace("[.SSS][XXX]", "").replace("[.SSS]", "").replace("[.SSSSSS]", "").replace(".SSSXXX", "").replace(".SSS", "").replace("[:ss]", "");
        String cudfFormat = DateUtils$.MODULE$.toStrf(cudfSupportedFormat, parseString);
        String suffix = hasZsuffix ? "Z" : "";
        Seq optionalFractional = (Seq)new .colon.colon((Object)"[.SSS][XXX]", (List)new .colon.colon((Object)"[.SSS]", (List)new .colon.colon((Object)"[.SSSSSS]", (List)new .colon.colon((Object)"[.SSS][XXX]", (List)new .colon.colon((Object)".SSSXXX", (List)new .colon.colon((Object)".SSS", (List)Nil$.MODULE$))))));
        if (optionalFractional.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)formatRoot.endsWith(x$1)))) {
            String cudfFormat1 = new StringBuilder(0).append(cudfFormat).append(suffix).toString();
            String cudfFormat2 = new StringBuilder(3).append(cudfFormat).append(".%f").append(suffix).toString();
            seq = (Seq)new .colon.colon((Object)cudfFormat1, (List)new .colon.colon((Object)cudfFormat2, (List)Nil$.MODULE$));
        } else {
            seq = formatRoot.endsWith("[:ss]") ? (Seq)new .colon.colon((Object)new StringBuilder(3).append(cudfFormat).append(":%S").append(suffix).toString(), (List)Nil$.MODULE$) : (Seq)new .colon.colon((Object)cudfFormat, (List)Nil$.MODULE$);
        }
        Seq baseFormats = seq;
        int pos = ((String)baseFormats.head()).indexOf(84);
        Seq formatsIncludingDateOnly = pos == -1 ? baseFormats : (Seq)((TraversableLike)new .colon.colon((Object)((String)baseFormats.head()).substring(0, pos), (List)Nil$.MODULE$)).$plus$plus((GenTraversableOnce)baseFormats, Seq$.MODULE$.canBuildFrom());
        ListBuffer formats = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        formatsIncludingDateOnly.foreach((Function1 & Serializable & scala.Serializable)fmt -> {
            Object object = fmt.contains(":%S") && !fmt.contains("%f") ? formats.$plus$eq((Object)fmt.replace(":%S", "")) : BoxedUnit.UNIT;
            return formats.$plus$eq(fmt);
        });
        return formats;
    }

    public static final /* synthetic */ boolean $anonfun$tagCudfFormat$1(String h) {
        return !MODULE$.supportedDateFormats().contains((Object)h);
    }

    private GpuTextBasedDateUtils$() {
        MODULE$ = this;
        this.supportedDateFormats = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"yyyy-MM-dd", "yyyy/MM/dd", "yyyy-MM", "yyyy/MM", "MM-yyyy", "MM/yyyy", "MM-dd-yyyy", "MM/dd/yyyy", "dd-MM-yyyy", "dd/MM/yyyy"}));
        this.supportedTsPortionFormats = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"HH:mm:ss.SSSXXX", "HH:mm:ss[.SSS][XXX]", "HH:mm:ss[.SSSXXX]", "HH:mm", "HH:mm:ss", "HH:mm[:ss]", "HH:mm:ss.SSS", "HH:mm:ss[.SSS]"}));
    }
}

