/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import ai.rapids.cudf.JCudfSerialization;
import ai.rapids.cudf.NvtxColor;
import ai.rapids.cudf.NvtxRange;
import com.nvidia.spark.rapids.Arm;
import com.nvidia.spark.rapids.CloseableHolder;
import com.nvidia.spark.rapids.CoalesceSizeGoal;
import com.nvidia.spark.rapids.ConcatAndConsumeAll$;
import com.nvidia.spark.rapids.GpuBuildSide;
import com.nvidia.spark.rapids.GpuCoalesceIterator;
import com.nvidia.spark.rapids.GpuMetric;
import com.nvidia.spark.rapids.GpuMetric$;
import com.nvidia.spark.rapids.GpuSemaphore$;
import com.nvidia.spark.rapids.GpuShuffleCoalesceIterator;
import com.nvidia.spark.rapids.GpuShuffledHashJoinExec;
import com.nvidia.spark.rapids.HostShuffleCoalesceIterator;
import com.nvidia.spark.rapids.NoopMetric$;
import com.nvidia.spark.rapids.RapidsBuffer;
import com.nvidia.spark.rapids.SerializedTableColumn;
import com.nvidia.spark.rapids.SpillCallback;
import com.nvidia.spark.rapids.cudf_utils.HostConcatResultUtil$;
import java.io.Serializable;
import org.apache.spark.TaskContext$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.plans.JoinType;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple8;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class GpuShuffledHashJoinExec$
implements Arm,
scala.Serializable {
    public static GpuShuffledHashJoinExec$ MODULE$;

    static {
        new GpuShuffledHashJoinExec$();
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T r, Function1<T, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T[] r, Function1<T[], V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T, V> V withResourceIfAllowed(T r, Function1<T, V> block) {
        return (V)Arm.withResourceIfAllowed$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T[] r, Function1<T[], V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends RapidsBuffer, V> V freeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.freeOnExcept$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(CloseableHolder<T> h, Function1<CloseableHolder<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, h, block);
    }

    public Tuple2<ColumnarBatch, Iterator<ColumnarBatch>> getBuiltBatchAndStreamIter(CoalesceSizeGoal buildGoal, long hostTargetBatchSize, Seq<Attribute> buildOutput, Iterator<ColumnarBatch> buildIter, Iterator<ColumnarBatch> streamIter, SpillCallback spillCallback, Map<String, GpuMetric> coalesceMetricsMap) {
        GpuMetric semWait = (GpuMetric)coalesceMetricsMap.apply((Object)GpuMetric$.MODULE$.SEMAPHORE_WAIT_TIME());
        GpuMetric buildTime = (GpuMetric)coalesceMetricsMap.apply((Object)GpuMetric$.MODULE$.BUILD_TIME());
        ObjectRef bufferedBuildIterator = ObjectRef.create(null);
        return (Tuple2)this.closeOnExcept((GpuShuffledHashJoinExec.CloseableBufferedIterator)bufferedBuildIterator.elem, (Function1 & Serializable & scala.Serializable)x$18 -> {
            Tuple2 tuple2;
            boolean firstBatchIsSerialized;
            boolean bl;
            long startTime = System.nanoTime();
            if (!buildIter.hasNext()) {
                bl = false;
            } else {
                bufferedBuildIterator$1.elem = new GpuShuffledHashJoinExec.CloseableBufferedIterator(buildIter.buffered());
                ColumnarBatch firstBatch = (ColumnarBatch)((GpuShuffledHashJoinExec.CloseableBufferedIterator)bufferedBuildIterator$1.elem).head();
                bl = firstBatchIsSerialized = firstBatch.numCols() != 1 ? false : firstBatch.column(0) instanceof SerializedTableColumn;
            }
            if (!firstBatchIsSerialized) {
                ColumnarBatch builtBatch = ConcatAndConsumeAll$.MODULE$.getSingleBatchWithVerification((Iterator<ColumnarBatch>)((Iterator)Option$.MODULE$.apply((Object)((GpuShuffledHashJoinExec.CloseableBufferedIterator)bufferedBuildIterator$1.elem)).getOrElse((Function0 & Serializable & scala.Serializable)() -> buildIter)), buildOutput);
                long delta = System.nanoTime() - startTime;
                buildTime.$plus$eq(delta);
                tuple2 = new Tuple2((Object)builtBatch, (Object)streamIter);
            } else {
                DataType[] dataTypes = (DataType[])((TraversableOnce)buildOutput.map((Function1 & Serializable & scala.Serializable)x$19 -> x$19.dataType(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(DataType.class));
                HostShuffleCoalesceIterator hostConcatIter = new HostShuffleCoalesceIterator((Iterator<ColumnarBatch>)((GpuShuffledHashJoinExec.CloseableBufferedIterator)bufferedBuildIterator$1.elem), hostTargetBatchSize, dataTypes, coalesceMetricsMap);
                tuple2 = (Tuple2)MODULE$.withResource(hostConcatIter, (Function1 & Serializable & scala.Serializable)x$20 -> (Tuple2)MODULE$.closeOnExcept(hostConcatIter.next(), (Function1 & Serializable & scala.Serializable)hostConcatResult -> {
                    Tuple2 tuple2;
                    if (!hostConcatIter.hasNext()) {
                        buildTime.$plus$eq(System.nanoTime() - startTime);
                        GpuShuffledHashJoinExec.CloseableBufferedIterator bufferedStreamIter = new GpuShuffledHashJoinExec.CloseableBufferedIterator(streamIter.buffered());
                        tuple2 = (Tuple2)MODULE$.closeOnExcept(bufferedStreamIter, (Function1 & Serializable & scala.Serializable)x$21 -> {
                            MODULE$.withResource(new NvtxRange("first stream batch", NvtxColor.RED), (Function1 & Serializable & scala.Serializable)x$22 -> {
                                Object object;
                                if (bufferedStreamIter.hasNext()) {
                                    object = bufferedStreamIter.head();
                                } else {
                                    GpuSemaphore$.MODULE$.acquireIfNecessary(TaskContext$.MODULE$.get(), semWait);
                                    object = BoxedUnit.UNIT;
                                }
                                return object;
                            });
                            ColumnarBatch buildBatch = MODULE$.getBuildBatchOptimized((JCudfSerialization.HostConcatResult)hostConcatResult, buildOutput, buildTime);
                            return new Tuple2((Object)buildBatch, (Object)bufferedStreamIter);
                        });
                    } else {
                        ColumnarBatch buildBatch = MODULE$.getBuildBatchFromUnfinished(buildGoal, (Iterator<JCudfSerialization.HostConcatResult>)((IterableLike)new .colon.colon(hostConcatResult, (List)Nil$.MODULE$)).iterator().$plus$plus((Function0 & Serializable & scala.Serializable)() -> hostConcatIter), buildOutput, spillCallback, coalesceMetricsMap);
                        buildTime.$plus$eq(System.nanoTime() - startTime);
                        tuple2 = new Tuple2((Object)buildBatch, (Object)streamIter);
                    }
                    return tuple2;
                }));
            }
            return tuple2;
        });
    }

    private ColumnarBatch getBuildBatchFromUnfinished(CoalesceSizeGoal buildGoal, Iterator<JCudfSerialization.HostConcatResult> iterWithPrior, Seq<Attribute> buildOutput, SpillCallback spillCallback, Map<String, GpuMetric> coalesceMetricsMap) {
        DataType[] dataTypes = (DataType[])((TraversableOnce)buildOutput.map((Function1 & Serializable & scala.Serializable)x$23 -> x$23.dataType(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(DataType.class));
        GpuShuffleCoalesceIterator shuffleCoalesce = new GpuShuffleCoalesceIterator(iterWithPrior, dataTypes, coalesceMetricsMap);
        ColumnarBatch res = ConcatAndConsumeAll$.MODULE$.getSingleBatchWithVerification(new GpuCoalesceIterator(shuffleCoalesce, dataTypes, buildGoal, NoopMetric$.MODULE$, NoopMetric$.MODULE$, NoopMetric$.MODULE$, NoopMetric$.MODULE$, NoopMetric$.MODULE$, (GpuMetric)coalesceMetricsMap.apply((Object)GpuMetric$.MODULE$.CONCAT_TIME()), (GpuMetric)coalesceMetricsMap.apply((Object)GpuMetric$.MODULE$.OP_TIME()), (GpuMetric)coalesceMetricsMap.apply((Object)GpuMetric$.MODULE$.PEAK_DEVICE_MEMORY()), spillCallback, "build batch"), buildOutput);
        return res;
    }

    private ColumnarBatch getBuildBatchOptimized(JCudfSerialization.HostConcatResult hostConcatResult, Seq<Attribute> buildOutput, GpuMetric buildTime) {
        DataType[] dataTypes = (DataType[])((TraversableOnce)buildOutput.map((Function1 & Serializable & scala.Serializable)x$24 -> x$24.dataType(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(DataType.class));
        return (ColumnarBatch)this.withResource(hostConcatResult, (Function1 & Serializable & scala.Serializable)x$25 -> (ColumnarBatch)buildTime.ns((Function0 & Serializable & scala.Serializable)() -> HostConcatResultUtil$.MODULE$.getColumnarBatch(hostConcatResult, dataTypes)));
    }

    public GpuShuffledHashJoinExec apply(Seq<Expression> leftKeys, Seq<Expression> rightKeys, JoinType joinType, GpuBuildSide buildSide, Option<Expression> condition, SparkPlan left, SparkPlan right, boolean isSkewJoin, Seq<Expression> cpuLeftKeys, Seq<Expression> cpuRightKeys) {
        return new GpuShuffledHashJoinExec(leftKeys, rightKeys, joinType, buildSide, condition, left, right, isSkewJoin, cpuLeftKeys, cpuRightKeys);
    }

    public Option<Tuple8<Seq<Expression>, Seq<Expression>, JoinType, GpuBuildSide, Option<Expression>, SparkPlan, SparkPlan, Object>> unapply(GpuShuffledHashJoinExec x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple8(x$0.leftKeys(), x$0.rightKeys(), (Object)x$0.joinType(), (Object)x$0.buildSide(), x$0.condition(), (Object)x$0.left(), (Object)x$0.right(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.isSkewJoin())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private GpuShuffledHashJoinExec$() {
        MODULE$ = this;
        Arm.$init$(this);
    }
}

