/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import com.nvidia.spark.rapids.GpuColumnarToRowExec$;
import com.nvidia.spark.rapids.GpuRangePartitioner;
import com.nvidia.spark.rapids.GpuSorter;
import com.nvidia.spark.rapids.NoopMetric$;
import com.nvidia.spark.rapids.SamplingUtils$;
import java.io.Serializable;
import org.apache.spark.rdd.PartitionPruningRDD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.codegen.LazilyGeneratedOrdering;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class GpuRangePartitioner$
implements scala.Serializable {
    public static GpuRangePartitioner$ MODULE$;

    static {
        new GpuRangePartitioner$();
    }

    private Tuple2<Object, Tuple3<Object, Object, InternalRow[]>[]> sketch(RDD<ColumnarBatch> rdd, int sampleSizePerPartition, GpuSorter sorter) {
        int shift = rdd.id();
        Function1<Iterator<ColumnarBatch>, Iterator<InternalRow>> toRowConverter = GpuColumnarToRowExec$.MODULE$.makeIteratorFunc(sorter.projectedBatchSchema(), NoopMetric$.MODULE$, NoopMetric$.MODULE$, NoopMetric$.MODULE$, NoopMetric$.MODULE$);
        Tuple3[] sketched = (Tuple3[])rdd.mapPartitionsWithIndex((Function2 & Serializable & scala.Serializable)(idx, iter) -> GpuRangePartitioner$.$anonfun$sketch$1(shift, sampleSizePerPartition, sorter, toRowConverter, BoxesRunTime.unboxToInt((Object)idx), iter), rdd.mapPartitionsWithIndex$default$2(), ClassTag$.MODULE$.apply(Tuple3.class)).collect();
        long numItems = BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sketched)).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)GpuRangePartitioner$.$anonfun$sketch$2(x$2)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)numItems), (Object)sketched);
    }

    private InternalRow[] randomResample(RDD<ColumnarBatch> rdd, double fraction, int seed, GpuSorter sorter) {
        Function1<Iterator<ColumnarBatch>, Iterator<InternalRow>> toRowConverter = GpuColumnarToRowExec$.MODULE$.makeIteratorFunc(sorter.projectedBatchSchema(), NoopMetric$.MODULE$, NoopMetric$.MODULE$, NoopMetric$.MODULE$, NoopMetric$.MODULE$);
        return (InternalRow[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rdd.mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            InternalRow[] sample = SamplingUtils$.MODULE$.randomResample((Iterator<ColumnarBatch>)iter, fraction, sorter, toRowConverter, seed);
            return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InternalRow[][]{sample}));
        }, rdd.mapPartitions$default$2(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(InternalRow.class))).collect())).flatten((Function1 & Serializable & scala.Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs), ClassTag$.MODULE$.apply(InternalRow.class));
    }

    private InternalRow[] determineBounds(ArrayBuffer<Tuple2<InternalRow, Object>> candidates, int partitions, Ordering<InternalRow> ordering) {
        ArrayBuffer ordered = (ArrayBuffer)candidates.sortBy((Function1 & Serializable & scala.Serializable)x$3 -> (InternalRow)x$3._1(), ordering);
        int numCandidates = ordered.size();
        double sumWeights = BoxesRunTime.unboxToDouble((Object)((TraversableOnce)ordered.map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToDouble((double)GpuRangePartitioner$.$anonfun$determineBounds$2(x$4)), ArrayBuffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        double step = sumWeights / (double)partitions;
        double cumWeight = 0.0;
        double target = step;
        ArrayBuffer bounds = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        int j = 0;
        Option previousBound = Option$.MODULE$.empty();
        for (int i = 0; i < numCandidates && j < partitions - 1; ++i) {
            Tuple2 tuple2 = (Tuple2)ordered.apply(i);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            InternalRow key = (InternalRow)tuple2._1();
            float weight = BoxesRunTime.unboxToFloat((Object)tuple2._2());
            Tuple2 tuple22 = new Tuple2((Object)key, (Object)BoxesRunTime.boxToFloat((float)weight));
            Tuple2 tuple23 = tuple22;
            InternalRow key2 = (InternalRow)tuple23._1();
            float weight2 = BoxesRunTime.unboxToFloat((Object)tuple23._2());
            cumWeight += (double)weight2;
            if (!(cumWeight >= target) || !previousBound.isEmpty() && !ordering.gt((Object)key2, previousBound.get())) continue;
            bounds.$plus$eq((Object)key2);
            target += step;
            ++j;
            previousBound = new Some((Object)key2);
        }
        return (InternalRow[])bounds.toArray(ClassTag$.MODULE$.apply(InternalRow.class));
    }

    public InternalRow[] createRangeBounds(int partitions, GpuSorter sorter, RDD<ColumnarBatch> rdd, int samplePointsPerPartitionHint) {
        InternalRow[] internalRowArray;
        Predef$.MODULE$.require(partitions >= 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Number of partitions cannot be negative but found ").append(partitions).append(".").toString());
        Predef$.MODULE$.require(samplePointsPerPartitionHint > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Sample points per partition must be greater than 0 but found ").append(samplePointsPerPartitionHint).toString());
        LazilyGeneratedOrdering ordering = new LazilyGeneratedOrdering(sorter.cpuOrdering());
        if (partitions < 1) {
            internalRowArray = (InternalRow[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(InternalRow.class));
        } else {
            double sampleSize = scala.math.package$.MODULE$.min((double)samplePointsPerPartitionHint * (double)partitions, 1000000.0);
            int sampleSizePerPartition = (int)scala.math.package$.MODULE$.ceil(3.0 * sampleSize / (double)rdd.partitions().length);
            Tuple2<Object, Tuple3<Object, Object, InternalRow[]>[]> tuple2 = this.sketch(rdd, sampleSizePerPartition, sorter);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            long numItems = tuple2._1$mcJ$sp();
            Tuple3[] sketched = (Tuple3[])tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)numItems), (Object)sketched);
            Tuple2 tuple23 = tuple22;
            long numItems2 = tuple23._1$mcJ$sp();
            Tuple3[] sketched2 = (Tuple3[])tuple23._2();
            if (numItems2 == 0L) {
                internalRowArray = (InternalRow[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(InternalRow.class));
            } else {
                BoxedUnit boxedUnit;
                double fraction = scala.math.package$.MODULE$.min(sampleSize / (double)scala.math.package$.MODULE$.max(numItems2, 1L), 1.0);
                ArrayBuffer candidates = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
                ObjectRef imbalancedPartitions = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sketched2)).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    GpuRangePartitioner$.$anonfun$createRangeBounds$3(fraction, sampleSizePerPartition, imbalancedPartitions, candidates, x0$1);
                    return BoxedUnit.UNIT;
                });
                if (((Set)imbalancedPartitions.elem).nonEmpty()) {
                    Set set = (Set)imbalancedPartitions.elem;
                    PartitionPruningRDD imbalanced = new PartitionPruningRDD(rdd, (Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)elem -> set.contains((Object)BoxesRunTime.boxToInteger((int)elem)), ClassTag$.MODULE$.apply(ColumnarBatch.class));
                    int seed = scala.util.hashing.package$.MODULE$.byteswap32(-rdd.id() - 1);
                    InternalRow[] reSampled = this.randomResample((RDD<ColumnarBatch>)imbalanced, fraction, seed, sorter);
                    float weight = (float)(1.0 / fraction);
                    boxedUnit = candidates.$plus$plus$eq((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])reSampled)).map((Function1 & Serializable & scala.Serializable)x -> new Tuple2(x, (Object)BoxesRunTime.boxToFloat((float)weight)), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit())));
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                internalRowArray = this.determineBounds((ArrayBuffer<Tuple2<InternalRow, Object>>)candidates, scala.math.package$.MODULE$.min(partitions, candidates.size()), (Ordering<InternalRow>)ordering);
            }
        }
        InternalRow[] rangeBounds = internalRowArray;
        return rangeBounds;
    }

    public GpuRangePartitioner apply(InternalRow[] rangeBounds, GpuSorter sorter) {
        return new GpuRangePartitioner(rangeBounds, sorter);
    }

    public Option<Tuple2<InternalRow[], GpuSorter>> unapply(GpuRangePartitioner x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2((Object)x$0.rangeBounds(), (Object)x$0.sorter()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ Iterator $anonfun$sketch$1(int shift$1, int sampleSizePerPartition$1, GpuSorter sorter$1, Function1 toRowConverter$1, int idx, Iterator iter) {
        int seed = scala.util.hashing.package$.MODULE$.byteswap32(idx ^ shift$1 << 16);
        Tuple2<InternalRow[], Object> tuple2 = SamplingUtils$.MODULE$.reservoirSampleAndCount((Iterator<ColumnarBatch>)iter, sampleSizePerPartition$1, sorter$1, (Function1<Iterator<ColumnarBatch>, Iterator<InternalRow>>)toRowConverter$1, seed);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        InternalRow[] sample = (InternalRow[])tuple2._1();
        long n = tuple2._2$mcJ$sp();
        Tuple2 tuple22 = new Tuple2((Object)sample, (Object)BoxesRunTime.boxToLong((long)n));
        Tuple2 tuple23 = tuple22;
        InternalRow[] sample2 = (InternalRow[])tuple23._1();
        long n2 = tuple23._2$mcJ$sp();
        return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)idx), (Object)BoxesRunTime.boxToLong((long)n2), (Object)sample2)}));
    }

    public static final /* synthetic */ long $anonfun$sketch$2(Tuple3 x$2) {
        return BoxesRunTime.unboxToLong((Object)x$2._2());
    }

    public static final /* synthetic */ double $anonfun$determineBounds$2(Tuple2 x$4) {
        return BoxesRunTime.unboxToFloat((Object)x$4._2());
    }

    public static final /* synthetic */ void $anonfun$createRangeBounds$3(double fraction$2, int sampleSizePerPartition$2, ObjectRef imbalancedPartitions$1, ArrayBuffer candidates$1, Tuple3 x0$1) {
        BoxedUnit boxedUnit;
        Tuple3 tuple3 = x0$1;
        if (tuple3 != null) {
            int idx = BoxesRunTime.unboxToInt((Object)tuple3._1());
            long n = BoxesRunTime.unboxToLong((Object)tuple3._2());
            InternalRow[] sample = (InternalRow[])tuple3._3();
            if (fraction$2 * (double)n > (double)sampleSizePerPartition$2) {
                imbalancedPartitions$1.elem = (Set)((Set)imbalancedPartitions$1.elem).$plus((Object)BoxesRunTime.boxToInteger((int)idx));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                float weight = (float)((double)n / (double)sample.length);
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sample)).foreach((Function1 & Serializable & scala.Serializable)key -> candidates$1.$plus$eq((Object)new Tuple2(key, (Object)BoxesRunTime.boxToFloat((float)weight))));
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple3);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    private GpuRangePartitioner$() {
        MODULE$ = this;
    }
}

