/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import ai.rapids.cudf.NvtxColor;
import com.nvidia.spark.rapids.Arm;
import com.nvidia.spark.rapids.CloseableHolder;
import com.nvidia.spark.rapids.GpuAlias;
import com.nvidia.spark.rapids.GpuBoundReference;
import com.nvidia.spark.rapids.GpuColumnVector;
import com.nvidia.spark.rapids.GpuExpressionsUtils$;
import com.nvidia.spark.rapids.GpuMetric;
import com.nvidia.spark.rapids.GpuProjectExec;
import com.nvidia.spark.rapids.NvtxWithMetrics;
import com.nvidia.spark.rapids.RapidsBuffer;
import com.nvidia.spark.rapids.RapidsPluginImplicits$;
import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class GpuProjectExec$
implements Arm,
scala.Serializable {
    public static GpuProjectExec$ MODULE$;

    static {
        new GpuProjectExec$();
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T r, Function1<T, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T[] r, Function1<T[], V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T, V> V withResourceIfAllowed(T r, Function1<T, V> block) {
        return (V)Arm.withResourceIfAllowed$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T[] r, Function1<T[], V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends RapidsBuffer, V> V freeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.freeOnExcept$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(CloseableHolder<T> h, Function1<CloseableHolder<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, h, block);
    }

    public <A extends Expression> ColumnarBatch projectAndClose(ColumnarBatch cb, Seq<A> boundExprs, GpuMetric opTime) {
        ColumnarBatch columnarBatch;
        NvtxWithMetrics nvtxRange = new NvtxWithMetrics("ProjectExec", NvtxColor.CYAN, (Seq<GpuMetric>)Predef$.MODULE$.wrapRefArray((Object[])new GpuMetric[]{opTime}));
        try {
            columnarBatch = this.project(cb, boundExprs);
        }
        finally {
            cb.close();
            nvtxRange.close();
        }
        return columnarBatch;
    }

    private Option<Object> extractSingleBoundIndex(Expression expr) {
        None$ none$;
        Expression expression;
        while ((expression = expr) instanceof GpuAlias) {
            GpuAlias gpuAlias = (GpuAlias)expression;
            expr = gpuAlias.child();
        }
        if (expression instanceof GpuBoundReference) {
            GpuBoundReference gpuBoundReference = (GpuBoundReference)expression;
            none$ = new Some((Object)BoxesRunTime.boxToInteger((int)gpuBoundReference.ordinal()));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private Seq<Option<Object>> extractSingleBoundIndex(Seq<Expression> boundExprs) {
        return (Seq)boundExprs.map((Function1 & Serializable & scala.Serializable)expr -> MODULE$.extractSingleBoundIndex((Expression)expr), Seq$.MODULE$.canBuildFrom());
    }

    public boolean isNoopProject(ColumnarBatch cb, Seq<Expression> boundExprs) {
        return boundExprs.length() == cb.numCols() ? ((IterableLike)this.extractSingleBoundIndex(boundExprs).zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), cb.numCols()), Seq$.MODULE$.canBuildFrom())).forall((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)GpuProjectExec$.$anonfun$isNoopProject$1(x0$1))) : false;
    }

    public GpuColumnVector projectSingle(ColumnarBatch cb, Expression boundExpr) {
        return GpuExpressionsUtils$.MODULE$.columnarEvalToColumn(boundExpr, cb);
    }

    public ColumnarBatch project(ColumnarBatch cb, Seq<Expression> boundExprs) {
        ColumnarBatch columnarBatch;
        if (this.isNoopProject(cb, boundExprs)) {
            columnarBatch = GpuColumnVector.incRefCounts(cb);
        } else {
            ColumnVector[] newColumns = (ColumnVector[])RapidsPluginImplicits$.MODULE$.AutoCloseableProducingSeq(boundExprs).safeMap((Function1 & Serializable & scala.Serializable)expr -> MODULE$.projectSingle(cb, (Expression)expr)).toArray(ClassTag$.MODULE$.apply(ColumnVector.class));
            columnarBatch = new ColumnarBatch(newColumns, cb.numRows());
        }
        return columnarBatch;
    }

    public GpuProjectExec apply(List<NamedExpression> projectList, SparkPlan child) {
        return new GpuProjectExec(projectList, child);
    }

    public Option<Tuple2<List<NamedExpression>, SparkPlan>> unapply(GpuProjectExec x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2(x$0.projectList(), (Object)x$0.child()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$isNoopProject$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) return false;
        Option option = (Option)tuple2._1();
        int expectedIndex = tuple2._2$mcI$sp();
        if (!(option instanceof Some)) return false;
        Some some = (Some)option;
        int foundIndex = BoxesRunTime.unboxToInt((Object)some.value());
        if (foundIndex != expectedIndex) return false;
        return true;
    }

    private GpuProjectExec$() {
        MODULE$ = this;
        Arm.$init$(this);
    }
}

