/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import ai.rapids.cudf.CompressionType;
import com.nvidia.spark.rapids.FileFormatChecks$;
import com.nvidia.spark.rapids.GpuParquetFileFormat;
import com.nvidia.spark.rapids.ParquetFormatType$;
import com.nvidia.spark.rapids.RapidsConf$;
import com.nvidia.spark.rapids.RapidsMeta;
import com.nvidia.spark.rapids.WriteFileOp$;
import com.nvidia.spark.rapids.shims.SparkShimImpl$;
import java.io.Serializable;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOptions;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.rapids.execution.TrampolineUtil$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Map;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class GpuParquetFileFormat$ {
    public static GpuParquetFileFormat$ MODULE$;

    static {
        new GpuParquetFileFormat$();
    }

    public Option<GpuParquetFileFormat> tagGpuSupport(RapidsMeta<?, ?, ?> meta, SparkSession spark, Map<String, String> options, StructType schema) {
        boolean schemaHasTimestamps;
        SQLConf sqlConf = spark.sessionState().conf();
        ParquetOptions parquetOptions = new ParquetOptions(options, sqlConf);
        String columnEncryption = (String)options.getOrElse((Object)"parquet.encryption.column.keys", (Function0 & Serializable & scala.Serializable)() -> "");
        String footerEncryption = (String)options.getOrElse((Object)"parquet.encryption.footer.key", (Function0 & Serializable & scala.Serializable)() -> "");
        if (!columnEncryption.isEmpty() || !footerEncryption.isEmpty()) {
            meta.willNotWorkOnGpu("Encryption is not yet supported on GPU. If encrypted Parquet writes are not required unset the \"parquet.encryption.column.keys\" and \"parquet.encryption.footer.key\" in Parquet options");
        }
        if (!meta.conf().isParquetEnabled()) {
            meta.willNotWorkOnGpu(new StringBuilder(65).append("Parquet input and output has been disabled. To enable set").append(RapidsConf$.MODULE$.ENABLE_PARQUET()).append(" to true").toString());
        }
        if (!meta.conf().isParquetWriteEnabled()) {
            meta.willNotWorkOnGpu(new StringBuilder(55).append("Parquet output has been disabled. To enable set").append(RapidsConf$.MODULE$.ENABLE_PARQUET_WRITE()).append(" to true").toString());
        }
        FileFormatChecks$.MODULE$.tag(meta, schema, ParquetFormatType$.MODULE$, WriteFileOp$.MODULE$);
        this.parseCompressionType(parquetOptions.compressionCodecClassName()).getOrElse((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> meta.willNotWorkOnGpu(new StringBuilder(35).append("compression codec ").append(parquetOptions.compressionCodecClassName()).append(" is not supported").toString()));
        if (sqlConf.writeLegacyParquetFormat()) {
            meta.willNotWorkOnGpu("Spark legacy format is not supported");
        }
        if (!meta.conf().isParquetInt96WriteEnabled()) {
            Enumeration.Value value = sqlConf.parquetOutputTimestampType();
            Enumeration.Value value2 = SQLConf.ParquetOutputTimestampType$.MODULE$.INT96();
            if (!(value != null ? !value.equals(value2) : value2 != null)) {
                meta.willNotWorkOnGpu(new StringBuilder(183).append("Writing INT96 is disabled, if you want to enable it turn it on by ").append("setting the ").append(RapidsConf$.MODULE$.ENABLE_PARQUET_INT96_WRITE()).append(" to true. NOTE: check ").append("out the compatibility.md to know about the limitations associated with INT96 writer").toString());
            }
        }
        if ((schemaHasTimestamps = schema.exists((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)TrampolineUtil$.MODULE$.dataTypeExistsRecursively(field.dataType(), (Function1<DataType, Object>)(Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)GpuParquetFileFormat$.$anonfun$tagGpuSupport$5(x$1)))))) && !this.isOutputTimestampTypeSupported(sqlConf.parquetOutputTimestampType())) {
            meta.willNotWorkOnGpu(new StringBuilder(39).append("Output timestamp type ").append(sqlConf.parquetOutputTimestampType()).append(" is not supported").toString());
        }
        boolean schemaHasDates = schema.exists((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)TrampolineUtil$.MODULE$.dataTypeExistsRecursively(field.dataType(), (Function1<DataType, Object>)(Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)GpuParquetFileFormat$.$anonfun$tagGpuSupport$7(x$2)))));
        String string = SparkShimImpl$.MODULE$.int96ParquetRebaseWrite(sqlConf);
        if ("EXCEPTION".equals(string)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("CORRECTED".equals(string)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("LEGACY".equals(string)) {
            BoxedUnit boxedUnit;
            if (schemaHasTimestamps) {
                meta.willNotWorkOnGpu("LEGACY rebase mode for int96 timestamps is not supported");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            meta.willNotWorkOnGpu(new StringBuilder(41).append(string).append(" is not a supported rebase mode for int96").toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        String string2 = SparkShimImpl$.MODULE$.parquetRebaseWrite(sqlConf);
        if ("EXCEPTION".equals(string2)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("CORRECTED".equals(string2)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("LEGACY".equals(string2)) {
            BoxedUnit boxedUnit;
            if (schemaHasDates || schemaHasTimestamps) {
                meta.willNotWorkOnGpu("LEGACY rebase mode for dates and timestamps is not supported");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit;
        } else {
            meta.willNotWorkOnGpu(new StringBuilder(31).append(string2).append(" is not a supported rebase mode").toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        return meta.canThisBeReplaced() ? new Some((Object)new GpuParquetFileFormat()) : None$.MODULE$;
    }

    public Option<CompressionType> parseCompressionType(String compressionType) {
        String string = compressionType;
        boolean bl = "NONE".equals(string) ? true : "UNCOMPRESSED".equals(string);
        Object object = bl ? new Some((Object)CompressionType.NONE) : ("SNAPPY".equals(string) ? new Some((Object)CompressionType.SNAPPY) : None$.MODULE$);
        return object;
    }

    public boolean isOutputTimestampTypeSupported(Enumeration.Value outputTimestampType) {
        boolean bl;
        Enumeration.Value value = outputTimestampType;
        Enumeration.Value value2 = SQLConf.ParquetOutputTimestampType$.MODULE$.TIMESTAMP_MICROS();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            bl = true;
        } else {
            Enumeration.Value value4 = SQLConf.ParquetOutputTimestampType$.MODULE$.TIMESTAMP_MILLIS();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                bl = true;
            } else {
                Enumeration.Value value6 = SQLConf.ParquetOutputTimestampType$.MODULE$.INT96();
                Enumeration.Value value7 = value;
                bl = !(value6 != null ? !value6.equals(value7) : value7 != null);
            }
        }
        boolean bl2 = bl;
        return bl2;
    }

    public static final /* synthetic */ boolean $anonfun$tagGpuSupport$5(DataType x$1) {
        return x$1 instanceof TimestampType;
    }

    public static final /* synthetic */ boolean $anonfun$tagGpuSupport$7(DataType x$2) {
        return x$2 instanceof DateType;
    }

    private GpuParquetFileFormat$() {
        MODULE$ = this;
    }
}

