/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import ai.rapids.cudf.ContiguousTable;
import ai.rapids.cudf.DeviceMemoryBuffer;
import com.nvidia.spark.rapids.GpuColumnVectorBase;
import com.nvidia.spark.rapids.WithTableBuffer;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarBatch;

public final class GpuPackedTableColumn
extends GpuColumnVectorBase
implements WithTableBuffer {
    private static final String BAD_ACCESS_MSG = "Column is packed";
    private final ContiguousTable contigTable;

    public static ColumnarBatch from(ContiguousTable contigTable) {
        GpuPackedTableColumn column = new GpuPackedTableColumn(contigTable);
        return new ColumnarBatch(new ColumnVector[]{column}, (int)contigTable.getRowCount());
    }

    public static boolean isBatchPacked(ColumnarBatch batch) {
        return batch.numCols() == 1 && batch.column(0) instanceof GpuPackedTableColumn;
    }

    GpuPackedTableColumn(ContiguousTable contigTable) {
        super(DataTypes.NullType);
        this.contigTable = contigTable;
    }

    public ContiguousTable getContiguousTable() {
        return this.contigTable;
    }

    @Override
    public DeviceMemoryBuffer getTableBuffer() {
        return this.contigTable.getBuffer();
    }

    public void close() {
        this.contigTable.close();
    }

    public boolean hasNull() {
        throw new IllegalStateException(BAD_ACCESS_MSG);
    }

    public int numNulls() {
        throw new IllegalStateException(BAD_ACCESS_MSG);
    }
}

