/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import ai.rapids.cudf.ColumnVector;
import ai.rapids.cudf.ColumnView;
import ai.rapids.cudf.DType;
import ai.rapids.cudf.Scalar;
import ai.rapids.cudf.Table;
import com.nvidia.spark.rapids.Arm;
import com.nvidia.spark.rapids.CloseableHolder;
import com.nvidia.spark.rapids.GpuListUtils$;
import com.nvidia.spark.rapids.GpuScalar$;
import com.nvidia.spark.rapids.RapidsBuffer;
import com.nvidia.spark.rapids.RapidsPluginImplicits;
import com.nvidia.spark.rapids.RapidsPluginImplicits$;
import java.io.Serializable;
import java.util.Optional;
import org.apache.spark.sql.catalyst.trees.Origin;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.rapids.shims.RapidsErrorUtils$;
import org.apache.spark.sql.types.DataType;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction1;

public final class GpuMapUtils$
implements Arm {
    public static GpuMapUtils$ MODULE$;
    private final int KEY_INDEX;
    private final int VALUE_INDEX;

    static {
        new GpuMapUtils$();
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T r, Function1<T, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T[] r, Function1<T[], V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T, V> V withResourceIfAllowed(T r, Function1<T, V> block) {
        return (V)Arm.withResourceIfAllowed$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T[] r, Function1<T[], V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends RapidsBuffer, V> V freeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.freeOnExcept$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(CloseableHolder<T> h, Function1<CloseableHolder<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, h, block);
    }

    public int KEY_INDEX() {
        return this.KEY_INDEX;
    }

    public int VALUE_INDEX() {
        return this.VALUE_INDEX;
    }

    private ColumnView pullChildOutAsListView(ColumnView input, int index) {
        return (ColumnView)this.withResource(input.getChildColumnView(0), (Function1 & Serializable & scala.Serializable)structView -> (ColumnView)MODULE$.withResource(structView.getChildColumnView(index), (Function1 & Serializable & scala.Serializable)keyView -> GpuListUtils$.MODULE$.replaceListDataColumnAsView(input, (ColumnView)keyView)));
    }

    public ColumnVector getMapValueOrThrow(ColumnVector map, ColumnVector indices, DataType dtype, Origin origin) {
        return (ColumnVector)this.withResource(map.getMapKeyExistence((ColumnView)indices), (Function1 & Serializable & scala.Serializable)keyExists -> (ColumnVector)MODULE$.withResource(keyExists.all(), (Function1 & Serializable & scala.Serializable)exist -> {
            if (!exist.isValid() || !exist.getBoolean()) {
                String firstFalseKey = MODULE$.getFirstFalseKey(indices, (ColumnVector)keyExists);
                throw RapidsErrorUtils$.MODULE$.mapKeyNotExistError(firstFalseKey, dtype, origin);
            }
            return map.getMapValue((ColumnView)indices);
        }));
    }

    private String getFirstFalseKey(ColumnVector indices, ColumnVector keyExists) {
        return (String)this.withResource(new Table((ColumnVector[])((Object[])new ColumnVector[]{indices, keyExists})), (Function1 & Serializable & scala.Serializable)table -> (String)MODULE$.withResource(keyExists.not(), (Function1 & Serializable & scala.Serializable)keyNotExist -> (String)MODULE$.withResource(table.filter((ColumnView)keyNotExist), (Function1 & Serializable & scala.Serializable)tableWithBadKeys -> {
            ColumnVector badKeys = tableWithBadKeys.getColumn(0);
            return (String)MODULE$.withResource(badKeys.getScalarElement(0), (Function1 & Serializable & scala.Serializable)firstBadKey -> {
                Object key = GpuScalar$.MODULE$.extract((Scalar)firstBadKey);
                return key != null ? key.toString() : "null";
            });
        })));
    }

    public ColumnView getKeysAsListView(ColumnView input) {
        return this.pullChildOutAsListView(input, this.KEY_INDEX());
    }

    public ColumnView getValuesAsListView(ColumnView input) {
        return this.pullChildOutAsListView(input, this.VALUE_INDEX());
    }

    private ColumnView replaceStructChild(ColumnView structView, ColumnView toReplace, int index) {
        return (ColumnView)this.withResource(structView.getValid(), (Function1 & Serializable & scala.Serializable)validity -> {
            ColumnView columnView;
            ColumnView[] childViews = new ColumnView[structView.getNumChildren()];
            try {
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])childViews)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> {
                    childViews$1[idx] = idx == index ? toReplace : structView.getChildColumnView(idx);
                });
                columnView = new ColumnView(DType.STRUCT, structView.getRowCount(), Optional.empty(), validity, null, childViews);
            }
            finally {
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])childViews)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> {
                    block0: {
                        if (idx == index) break block0;
                        RapidsPluginImplicits.AutoCloseableColumn qual$1 = RapidsPluginImplicits$.MODULE$.AutoCloseableColumn((AutoCloseable)childViews[idx]);
                        Throwable x$1 = qual$1.safeClose$default$1();
                        qual$1.safeClose(x$1);
                    }
                });
            }
            return columnView;
        });
    }

    private ColumnView replaceExplodedKeyOrValueAsView(ColumnView mapCol, ColumnView toReplace, int index) {
        return (ColumnView)this.withResource(mapCol.getChildColumnView(0), (Function1 & Serializable & scala.Serializable)keyValueView -> (ColumnView)MODULE$.withResource(MODULE$.replaceStructChild((ColumnView)keyValueView, toReplace, index), (Function1 & Serializable & scala.Serializable)newKeyValueView -> GpuListUtils$.MODULE$.replaceListDataColumnAsView(mapCol, (ColumnView)newKeyValueView)));
    }

    public ColumnView replaceExplodedValueAsView(ColumnView mapCol, ColumnView newValue) {
        return this.replaceExplodedKeyOrValueAsView(mapCol, newValue, this.VALUE_INDEX());
    }

    public ColumnView replaceExplodedKeyAsView(ColumnView mapCol, ColumnView newKey) {
        return this.replaceExplodedKeyOrValueAsView(mapCol, newKey, this.KEY_INDEX());
    }

    public void assertNoNullKeys(ColumnView mapView) {
        this.withResource(mapView.getChildColumnView(0), (Function1 & Serializable & scala.Serializable)keyValueList -> {
            GpuMapUtils$.MODULE$.withResource(keyValueList.getChildColumnView(GpuMapUtils$.MODULE$.KEY_INDEX()), (Function1 & Serializable & scala.Serializable)keyView -> {
                GpuMapUtils$.$anonfun$assertNoNullKeys$2(keyView);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
    }

    public Throwable duplicateMapKeyFoundError() {
        return new RuntimeException(new StringBuilder(168).append("Duplicate map key was found, please check the input ").append("data. If you want to remove the duplicated keys, you can set ").append(SQLConf$.MODULE$.MAP_KEY_DEDUP_POLICY().key()).append(" to ").append(SQLConf.MapKeyDedupPolicy$.MODULE$.LAST_WIN()).append(" so that ").append("the key inserted at last takes precedence.").toString());
    }

    public static final /* synthetic */ void $anonfun$assertNoNullKeys$2(ColumnView keyView) {
        if (keyView.getNullCount() > 0L) {
            throw new RuntimeException("Cannot use null as map key.");
        }
    }

    private GpuMapUtils$() {
        MODULE$ = this;
        Arm.$init$(this);
        this.KEY_INDEX = 0;
        this.VALUE_INDEX = 1;
    }
}

