/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import ai.rapids.cudf.ColumnView;
import ai.rapids.cudf.NvtxColor;
import com.nvidia.spark.rapids.Arm;
import com.nvidia.spark.rapids.CloseableHolder;
import com.nvidia.spark.rapids.GpuColumnVector;
import com.nvidia.spark.rapids.GpuMetric;
import com.nvidia.spark.rapids.GpuProjectExec$;
import com.nvidia.spark.rapids.NvtxWithMetrics;
import com.nvidia.spark.rapids.RapidsBuffer;
import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.runtime.BoxesRunTime;

public final class GpuFilter$
implements Arm {
    public static GpuFilter$ MODULE$;

    static {
        new GpuFilter$();
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T r, Function1<T, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T[] r, Function1<T[], V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T, V> V withResourceIfAllowed(T r, Function1<T, V> block) {
        return (V)Arm.withResourceIfAllowed$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T[] r, Function1<T[], V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends RapidsBuffer, V> V freeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.freeOnExcept$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(CloseableHolder<T> h, Function1<CloseableHolder<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, h, block);
    }

    public ColumnarBatch apply(ColumnarBatch batch, Expression boundCondition, GpuMetric numOutputRows, GpuMetric numOutputBatches, GpuMetric filterTime) {
        return (ColumnarBatch)this.withResource(new NvtxWithMetrics("filter batch", NvtxColor.YELLOW, (Seq<GpuMetric>)Predef$.MODULE$.wrapRefArray((Object[])new GpuMetric[]{filterTime})), (Function1 & Serializable & scala.Serializable)x$13 -> {
            ColumnarBatch filteredBatch = MODULE$.apply(batch, boundCondition);
            numOutputBatches.$plus$eq(1L);
            numOutputRows.$plus$eq(filteredBatch.numRows());
            return filteredBatch;
        });
    }

    private boolean allEntriesAreTrue(GpuColumnVector mask) {
        return mask.hasNull() ? false : BoxesRunTime.unboxToBoolean(this.withResource(mask.getBase().all(), (Function1 & Serializable & scala.Serializable)all -> BoxesRunTime.boxToBoolean((boolean)all.getBoolean())));
    }

    public ColumnarBatch apply(ColumnarBatch batch2, Expression boundCondition) {
        return (ColumnarBatch)this.withResource(batch2, (Function1 & Serializable & scala.Serializable)batch -> {
            Option checkedFilterMask = (Option)MODULE$.withResource(GpuProjectExec$.MODULE$.projectSingle((ColumnarBatch)batch, boundCondition), (Function1 & Serializable & scala.Serializable)filterMask -> MODULE$.allEntriesAreTrue((GpuColumnVector)((Object)((Object)filterMask))) ? None$.MODULE$ : new Some((Object)filterMask.getBase().incRefCount()));
            return (ColumnarBatch)checkedFilterMask.map((Function1 & Serializable & scala.Serializable)checkedFilterMask2 -> (ColumnarBatch)MODULE$.withResource(checkedFilterMask2, (Function1 & Serializable & scala.Serializable)checkedFilterMask -> {
                DataType[] colTypes = GpuColumnVector.extractTypes(batch);
                return (ColumnarBatch)MODULE$.withResource(GpuColumnVector.from(batch), (Function1 & Serializable & scala.Serializable)tbl -> (ColumnarBatch)MODULE$.withResource(tbl.filter((ColumnView)checkedFilterMask), (Function1 & Serializable & scala.Serializable)filteredData -> GpuColumnVector.from(filteredData, colTypes)));
            })).getOrElse((Function0 & Serializable & scala.Serializable)() -> GpuColumnVector.incRefCounts(batch));
        });
    }

    private GpuFilter$() {
        MODULE$ = this;
        Arm.$init$(this);
    }
}

