/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import ai.rapids.cudf.ContiguousTable;
import ai.rapids.cudf.DeviceMemoryBuffer;
import ai.rapids.cudf.Table;
import com.nvidia.spark.rapids.GpuColumnVector;
import com.nvidia.spark.rapids.MetaUtils;
import com.nvidia.spark.rapids.format.TableMeta;
import java.util.Arrays;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarBatch;

public final class GpuColumnVectorFromBuffer
extends GpuColumnVector {
    private final DeviceMemoryBuffer buffer;
    private final TableMeta tableMeta;

    public static ColumnarBatch from(ContiguousTable contigTable, DataType[] colTypes) {
        DeviceMemoryBuffer buffer = contigTable.getBuffer();
        Table table = contigTable.getTable();
        TableMeta meta = MetaUtils.buildTableMeta(0, contigTable);
        return GpuColumnVectorFromBuffer.from(table, buffer, meta, colTypes);
    }

    public static ColumnarBatch from(Table table, DeviceMemoryBuffer buffer, TableMeta meta, DataType[] colTypes) {
        assert (table != null) : "Table cannot be null";
        assert (GpuColumnVector.typeConversionAllowed(table, colTypes)) : "Type conversion is not allowed from " + table + " to " + Arrays.toString(colTypes);
        long rows = table.getRowCount();
        if (rows != (long)((int)rows)) {
            throw new IllegalStateException("Cannot support a batch larger that MAX INT rows");
        }
        int numColumns = table.getNumberOfColumns();
        ColumnVector[] columns = new GpuColumnVector[numColumns];
        try {
            for (int i = 0; i < numColumns; ++i) {
                ai.rapids.cudf.ColumnVector v = table.getColumn(i);
                DataType type = colTypes[i];
                columns[i] = new GpuColumnVectorFromBuffer(type, v.incRefCount(), buffer, meta);
            }
            return new ColumnarBatch(columns, (int)rows);
        }
        catch (Exception e) {
            for (ColumnVector v : columns) {
                if (v == null) continue;
                v.close();
            }
            throw e;
        }
    }

    public GpuColumnVectorFromBuffer(DataType type, ai.rapids.cudf.ColumnVector cudfColumn, DeviceMemoryBuffer buffer, TableMeta meta) {
        super(type, cudfColumn);
        this.buffer = buffer;
        this.tableMeta = meta;
    }

    public DeviceMemoryBuffer getBuffer() {
        return this.buffer;
    }

    public TableMeta getTableMeta() {
        return this.tableMeta;
    }
}

