/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import com.nvidia.spark.rapids.RapidsConf;
import com.nvidia.spark.rapids.RapidsConf$;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.util.Properties;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.PlanExpression;
import org.apache.spark.sql.execution.datasources.CatalogFileIndex;
import org.apache.spark.sql.execution.datasources.FileIndex;
import org.apache.spark.sql.execution.datasources.FileStatusCache;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.InMemoryFileIndex;
import org.apache.spark.sql.execution.datasources.InMemoryFileIndex$;
import org.apache.spark.sql.execution.datasources.PartitionPath;
import org.apache.spark.sql.execution.datasources.PartitionSpec;
import org.apache.spark.sql.execution.datasources.PartitioningAwareFileIndex;
import org.apache.spark.sql.execution.datasources.rapids.GpuPartitioningUtils$;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.process.Process$;
import scala.sys.process.ProcessLogger$;
import scala.util.Properties$;

public final class AlluxioUtils$
implements Logging {
    public static AlluxioUtils$ MODULE$;
    private final HashSet<String> checkedAlluxioPath;
    private final Map<String, String> mountedBuckets;
    private Seq<String> alluxioCmd;
    private Option<String> alluxioMasterHost;
    private String alluxioHome;
    private boolean isInit;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new AlluxioUtils$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private HashSet<String> checkedAlluxioPath() {
        return this.checkedAlluxioPath;
    }

    private void checkAlluxioMounted(SparkSession sparkSession, String alluxio_path) {
        AlluxioUtils$ alluxioUtils$ = this;
        synchronized (alluxioUtils$) {
            Object object;
            if (!this.checkedAlluxioPath().contains((Object)alluxio_path)) {
                Path path = new Path(alluxio_path);
                FileSystem fs = path.getFileSystem(sparkSession.sparkContext().hadoopConfiguration());
                if (!fs.exists(path)) {
                    throw new FileNotFoundException(new StringBuilder(54).append("Alluxio path ").append(alluxio_path).append(" does not exist, maybe forgot to mount it").toString());
                }
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Alluxio path ").append(alluxio_path).append(" is mounted").toString());
                object = BoxesRunTime.boxToBoolean((boolean)this.checkedAlluxioPath().add((Object)alluxio_path));
            } else {
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Alluxio path ").append(alluxio_path).append(" already mounted").toString());
                object = BoxedUnit.UNIT;
            }
        }
    }

    private Map<String, String> mountedBuckets() {
        return this.mountedBuckets;
    }

    private Seq<String> alluxioCmd() {
        return this.alluxioCmd;
    }

    private void alluxioCmd_$eq(Seq<String> x$1) {
        this.alluxioCmd = x$1;
    }

    private Option<String> alluxioMasterHost() {
        return this.alluxioMasterHost;
    }

    private void alluxioMasterHost_$eq(Option<String> x$1) {
        this.alluxioMasterHost = x$1;
    }

    private String alluxioHome() {
        return this.alluxioHome;
    }

    private void alluxioHome_$eq(String x$1) {
        this.alluxioHome = x$1;
    }

    private boolean isInit() {
        return this.isInit;
    }

    private void isInit_$eq(boolean x$1) {
        this.isInit = x$1;
    }

    private synchronized void initAlluxioInfo(RapidsConf conf) {
        block11: {
            this.alluxioHome_$eq(Properties$.MODULE$.envOrElse("ALLUXIO_HOME", "/opt/alluxio-2.8.0"));
            this.alluxioCmd_$eq(conf.getAlluxioCmd());
            if (this.isInit()) break block11;
            String alluxio_port = null;
            String alluxio_master = null;
            try (BufferedSource buffered_source = null;){
                try {
                    buffered_source = Source$.MODULE$.fromFile(new StringBuilder(29).append(this.alluxioHome()).append("/conf/alluxio-site.properties").toString(), Codec$.MODULE$.fallbackSystemCodec());
                    Properties prop = new Properties();
                    prop.load(buffered_source.bufferedReader());
                    alluxio_master = prop.getProperty("alluxio.master.hostname");
                    alluxio_port = prop.getProperty("alluxio.master.rpc.port", "19998");
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException(new StringBuilder(104).append("Not found Alluxio config in ").append(this.alluxioHome()).append("/conf/alluxio-site.properties, ").append("please check if ALLUXIO_HOME is set correctly").toString());
                }
            }
            if (alluxio_master == null) {
                throw new RuntimeException(new StringBuilder(70).append("Can't find alluxio.master.hostname from ").append(this.alluxioHome()).append("/conf/alluxio-site.properties.").toString());
            }
            this.alluxioMasterHost_$eq((Option<String>)new Some((Object)new StringBuilder(1).append(alluxio_master).append(":").append(alluxio_port).toString()));
            Tuple2<Object, ArrayBuffer<String>> tuple2 = this.runAlluxioCmd("fs mount");
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            int ret = tuple2._1$mcI$sp();
            ArrayBuffer output2 = (ArrayBuffer)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)ret), (Object)output2);
            Tuple2 tuple23 = tuple22;
            int ret2 = tuple23._1$mcI$sp();
            ArrayBuffer output3 = (ArrayBuffer)tuple23._2();
            if (ret2 == 0) {
                output3.foreach((Function1 & Serializable & scala.Serializable)line -> {
                    AlluxioUtils$.$anonfun$initAlluxioInfo$1(line);
                    return BoxedUnit.UNIT;
                });
            } else {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Failed to run alluxio fs mount ").append(ret2).toString());
            }
            this.isInit_$eq(true);
        }
    }

    private Tuple2<String, String> getSchemeAndBucketFromPath(String path) {
        String[] i = path.split("://");
        String scheme = i[0];
        if (i.length <= 1) {
            throw new RuntimeException(new StringBuilder(44).append("path ").append(path).append(" is not expected for Alluxio auto mount").toString());
        }
        String bucket = i[1].split("/")[0];
        return new Tuple2((Object)scheme, (Object)bucket);
    }

    private Tuple2<Object, ArrayBuffer<String>> runAlluxioCmd(String param) {
        Seq params = this.alluxioCmd().tails().collect((PartialFunction)new scala.Serializable(param){
            public static final long serialVersionUID = 0L;
            private final String param$1;

            public final <A1 extends Seq<String>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                Some some = Seq$.MODULE$.unapplySeq(A1);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) >= 0) {
                    String first = (String)((SeqLike)some.get()).apply(0);
                    object = first;
                } else {
                    Some some2 = Seq$.MODULE$.unapplySeq(A1);
                    if (!some2.isEmpty() && some2.get() != null && ((SeqLike)some2.get()).lengthCompare(1) == 0) {
                        String last = (String)((SeqLike)some2.get()).apply(0);
                        object = new StringBuilder(1).append(last).append(" ").append(this.param$1).toString();
                    } else {
                        object = function1.apply(x1);
                    }
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Seq<String> x1) {
                Some some;
                Seq<String> seq = x1;
                Some some2 = Seq$.MODULE$.unapplySeq(seq);
                boolean bl = !some2.isEmpty() && some2.get() != null && ((SeqLike)some2.get()).lengthCompare(2) >= 0 ? true : !(some = Seq$.MODULE$.unapplySeq(seq)).isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0;
                return bl;
            }
            {
                this.param$1 = param$1;
            }
        }).toSeq();
        ArrayBuffer out = new ArrayBuffer(10);
        int ret = params.length() == 1 ? Process$.MODULE$.apply((String)params.last()).$bang(ProcessLogger$.MODULE$.apply((Function1 & Serializable & scala.Serializable)x$2 -> {
            out.$plus$eq((Object)x$2);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$3 -> {
            AlluxioUtils$.$anonfun$runAlluxioCmd$2(x$3);
            return BoxedUnit.UNIT;
        })) : Process$.MODULE$.apply(params).$bang(ProcessLogger$.MODULE$.apply((Function1 & Serializable & scala.Serializable)x$4 -> {
            out.$plus$eq((Object)x$4);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$5 -> {
            AlluxioUtils$.$anonfun$runAlluxioCmd$4(x$5);
            return BoxedUnit.UNIT;
        }));
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)ret), (Object)out);
    }

    private void autoMountBucket(String scheme, String bucket, Option<String> access_key, Option<String> secret_key) {
        String remote_path = new StringBuilder(4).append(scheme).append("://").append(bucket).append("/").toString();
        String local_bucket = new StringBuilder(1).append("/").append(bucket).toString();
        AlluxioUtils$ alluxioUtils$ = this;
        synchronized (alluxioUtils$) {
            if (!this.mountedBuckets().contains((Object)local_bucket)) {
                int output2;
                String parameter = new StringBuilder(21).append("fs mount --readonly ").append((Object)(access_key.isDefined() && secret_key.isDefined() ? new StringBuilder(50).append("--option s3a.accessKeyId=").append(access_key.get()).append(" ").append("--option s3a.secretKey=").append(secret_key.get()).append(" ").toString() : "")).append(local_bucket).append(" ").append(remote_path).toString();
                Tuple2<Object, ArrayBuffer<String>> tuple2 = this.runAlluxioCmd(parameter);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                int n = output2 = tuple2._1$mcI$sp();
                int output3 = n;
                if (output3 != 0) {
                    throw new RuntimeException(new StringBuilder(25).append("Mount bucket ").append(remote_path).append(" to ").append(local_bucket).append(" failed ").append(output3).toString());
                }
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Mounted bucket ").append(remote_path).append(" to ").append(local_bucket).append(" in Alluxio ").append(output3).toString());
                this.mountedBuckets().update((Object)local_bucket, (Object)remote_path);
            } else if (((String)this.mountedBuckets().apply((Object)local_bucket)).equals(remote_path)) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Already mounted bucket ").append(remote_path).append(" to ").append(local_bucket).append(" in Alluxio").toString());
            } else {
                throw new RuntimeException(new StringBuilder(33).append("Found a same bucket name in ").append(remote_path).append(" ").append("and ").append(this.mountedBuckets().apply((Object)local_bucket)).toString());
            }
        }
    }

    private Tuple2<Option<String>, Option<String>> getKeyAndSecret(HadoopFsRelation relation) {
        Tuple2 tuple2;
        String hadoopAccessKey = relation.sparkSession().sparkContext().hadoopConfiguration().get("fs.s3a.access.key");
        String hadoopSecretKey = relation.sparkSession().sparkContext().hadoopConfiguration().get("fs.s3a.secret.key");
        if (hadoopAccessKey != null && hadoopSecretKey != null) {
            tuple2 = new Tuple2((Object)new Some((Object)hadoopAccessKey), (Object)new Some((Object)hadoopSecretKey));
        } else {
            Option accessKey = relation.sparkSession().conf().getOption("spark.hadoop.fs.s3a.access.key");
            Option secretKey = relation.sparkSession().conf().getOption("spark.hadoop.fs.s3a.secret.key");
            if (accessKey.isDefined() && secretKey.isDefined()) {
                tuple2 = new Tuple2((Object)accessKey, (Object)secretKey);
            } else {
                Option envAccessKey = Properties$.MODULE$.envOrNone("AWS_ACCESS_KEY_ID");
                Option envSecretKey = Properties$.MODULE$.envOrNone("AWS_ACCESS_SECRET_KEY");
                tuple2 = new Tuple2((Object)envAccessKey, (Object)envSecretKey);
            }
        }
        return tuple2;
    }

    private Option<Function1<Path, Path>> genFuncForPathReplacement(Option<scala.collection.immutable.Map<String, String>> replaceMapOption) {
        return replaceMapOption.isDefined() ? new Some((Function1 & Serializable & scala.Serializable)f -> {
            String pathStr = f.toString();
            scala.collection.immutable.Map matchedSet = (scala.collection.immutable.Map)((TraversableLike)replaceMapOption.get()).filter((Function1 & Serializable & scala.Serializable)a -> BoxesRunTime.boxToBoolean((boolean)pathStr.startsWith((String)a._1())));
            if (matchedSet.size() > 1) {
                throw new IllegalArgumentException(new StringBuilder(79).append("Found ").append(matchedSet.size()).append(" same replacing rules ").append("from ").append(RapidsConf$.MODULE$.ALLUXIO_PATHS_REPLACE().key()).append(" which requires only 1 rule ").append("for each file path").toString());
            }
            return matchedSet.size() == 1 ? new Path(pathStr.replaceFirst((String)((Tuple2)matchedSet.head())._1(), (String)((Tuple2)matchedSet.head())._2())) : f;
        }) : None$.MODULE$;
    }

    private Option<Function1<Path, Path>> genFuncForAutoMountReplacement(RapidsConf conf, HadoopFsRelation relation, String alluxioBucketRegex) {
        return new Some((Function1 & Serializable & scala.Serializable)f -> {
            Path path;
            String pathStr = f.toString();
            if (pathStr.matches(alluxioBucketRegex)) {
                MODULE$.initAlluxioInfo(conf);
                Tuple2<Option<String>, Option<String>> tuple2 = MODULE$.getKeyAndSecret(relation);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                Option access_key = (Option)tuple2._1();
                Option secret_key = (Option)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)access_key, (Object)secret_key);
                Tuple2 tuple23 = tuple22;
                Option access_key2 = (Option)tuple23._1();
                Option secret_key2 = (Option)tuple23._2();
                Tuple2<String, String> tuple24 = MODULE$.getSchemeAndBucketFromPath(pathStr);
                if (tuple24 == null) {
                    throw new MatchError(tuple24);
                }
                String scheme = (String)tuple24._1();
                String bucket = (String)tuple24._2();
                Tuple2 tuple25 = new Tuple2((Object)scheme, (Object)bucket);
                Tuple2 tuple26 = tuple25;
                String scheme2 = (String)tuple26._1();
                String bucket2 = (String)tuple26._2();
                MODULE$.autoMountBucket(scheme2, bucket2, (Option<String>)access_key2, (Option<String>)secret_key2);
                Path newPath = new Path(pathStr.replaceFirst(new StringBuilder(2).append(scheme2).append(":/").toString(), new StringBuilder(10).append("alluxio://").append(MODULE$.alluxioMasterHost().get()).toString()));
                MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(12).append("Replace ").append(pathStr).append(" to ").append(newPath.toString()).toString());
                path = newPath;
            } else {
                path = f;
            }
            return path;
        });
    }

    public FileIndex replacePathIfNeeded(RapidsConf conf, HadoopFsRelation relation, Seq<Expression> partitionFilters2, Seq<Expression> dataFilters) {
        FileIndex fileIndex;
        Option<Function1<Path, Path>> replaceFunc;
        None$ replaceMapOption;
        Option<Seq<String>> alluxioPathsReplace = conf.getAlluxioPathsToReplace();
        boolean alluxioAutoMountEnabled = conf.getAlluxioAutoMountEnabled();
        String alluxioBucketRegex = conf.getAlluxioBucketRegex();
        Object object = replaceMapOption = alluxioPathsReplace.isDefined() ? alluxioPathsReplace.map((Function1 & Serializable & scala.Serializable)rules -> ((TraversableOnce)rules.map((Function1 & Serializable & scala.Serializable)rule -> {
            String[] split = rule.split("->");
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])split)).size() != 2) {
                throw new IllegalArgumentException(new StringBuilder(20).append("Invalid setting for ").append(RapidsConf$.MODULE$.ALLUXIO_PATHS_REPLACE().key()).toString());
            }
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)split[0].trim()), (Object)split[1].trim());
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())) : None$.MODULE$;
        Option<Function1<Path, Path>> option = replaceMapOption.isDefined() ? this.genFuncForPathReplacement((Option<scala.collection.immutable.Map<String, String>>)replaceMapOption) : (replaceFunc = alluxioAutoMountEnabled ? this.genFuncForAutoMountReplacement(conf, relation, alluxioBucketRegex) : None$.MODULE$);
        if (replaceFunc.isDefined()) {
            InMemoryFileIndex inMemoryFileIndex;
            FileIndex fileIndex2 = relation.location();
            if (fileIndex2 instanceof PartitioningAwareFileIndex) {
                PartitioningAwareFileIndex partitioningAwareFileIndex = (PartitioningAwareFileIndex)fileIndex2;
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Handling PartitioningAwareFileIndex");
                inMemoryFileIndex = AlluxioUtils$.createNewFileIndexWithPathsReplaced$1(partitioningAwareFileIndex.partitionSpec(), partitioningAwareFileIndex.rootPaths(), replaceFunc, relation);
            } else if (fileIndex2 instanceof CatalogFileIndex) {
                CatalogFileIndex catalogFileIndex = (CatalogFileIndex)fileIndex2;
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Handling CatalogFileIndex");
                InMemoryFileIndex memFI = catalogFileIndex.filterPartitions((Seq)Nil$.MODULE$);
                inMemoryFileIndex = AlluxioUtils$.createNewFileIndexWithPathsReplaced$1(memFI.partitionSpec(), memFI.rootPaths(), replaceFunc, relation);
            } else {
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Handling file index type: ").append(relation.location().getClass()).toString());
                Seq partitionDirs = relation.location().listFiles((Seq)partitionFilters2.filterNot((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)AlluxioUtils$.isDynamicPruningFilter$1(e))), dataFilters);
                Seq inputFiles = (Seq)partitionDirs.flatMap((Function1 & Serializable & scala.Serializable)partitionDir -> (Seq)partitionDir.files().map((Function1 & Serializable & scala.Serializable)f -> (Path)((Function1)replaceFunc.get()).apply((Object)f.getPath()), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
                Seq rootPaths = (Seq)relation.location().rootPaths().map((Function1)replaceFunc.get(), Seq$.MODULE$.canBuildFrom());
                if (replaceMapOption.isDefined()) {
                    rootPaths.foreach(arg_0 -> AlluxioUtils$.$anonfun$replacePathIfNeeded$11$adapted((Option)replaceMapOption, relation, arg_0));
                }
                scala.collection.immutable.Map parameters = relation.options();
                PartitionSpec partitionSpec = GpuPartitioningUtils$.MODULE$.inferPartitioning(relation.sparkSession(), (Seq<Path>)rootPaths, (Seq<Path>)inputFiles, (scala.collection.immutable.Map<String, String>)parameters, (Option<StructType>)Option$.MODULE$.apply((Object)relation.dataSchema()), (Function1<Path, Path>)((Function1)replaceFunc.get()));
                SparkSession x$1 = relation.sparkSession();
                Seq x$2 = inputFiles;
                scala.collection.immutable.Map x$3 = parameters;
                Option x$4 = Option$.MODULE$.apply((Object)relation.dataSchema());
                Some x$5 = new Some((Object)partitionSpec);
                FileStatusCache x$6 = InMemoryFileIndex$.MODULE$.$lessinit$greater$default$5();
                Option x$7 = InMemoryFileIndex$.MODULE$.$lessinit$greater$default$7();
                inMemoryFileIndex = new InMemoryFileIndex(x$1, x$2, x$3, x$4, x$6, (Option)x$5, x$7);
            }
            fileIndex = inMemoryFileIndex;
        } else {
            fileIndex = relation.location();
        }
        return fileIndex;
    }

    public static final /* synthetic */ void $anonfun$initAlluxioInfo$1(String line) {
        block0: {
            String[] items = line.trim().split(" +");
            MODULE$.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> line);
            if (items.length < 3 || !items[0].contains("://")) break block0;
            MODULE$.mountedBuckets().update((Object)items[2], (Object)items[0]);
            MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Found mounted bucket ").append(items[0]).append(" to ").append(items[2]).toString());
        }
    }

    public static final /* synthetic */ void $anonfun$runAlluxioCmd$2(String x$3) {
    }

    public static final /* synthetic */ void $anonfun$runAlluxioCmd$4(String x$5) {
    }

    private static final PartitionSpec replacePathsInPartitionSpec$1(PartitionSpec spec, Option replaceFunc$1) {
        Seq partitionsWithPathsReplaced = (Seq)spec.partitions().map((Function1 & Serializable & scala.Serializable)p -> {
            Path replacedPath = (Path)((Function1)replaceFunc$1.get()).apply((Object)p.path());
            return new PartitionPath(p.values(), replacedPath);
        }, Seq$.MODULE$.canBuildFrom());
        return new PartitionSpec(spec.partitionColumns(), partitionsWithPathsReplaced);
    }

    private static final InMemoryFileIndex createNewFileIndexWithPathsReplaced$1(PartitionSpec spec, Seq rootPaths, Option replaceFunc$1, HadoopFsRelation relation$2) {
        PartitionSpec specAdjusted = AlluxioUtils$.replacePathsInPartitionSpec$1(spec, replaceFunc$1);
        Seq replacedPaths = (Seq)rootPaths.map((Function1)replaceFunc$1.get(), Seq$.MODULE$.canBuildFrom());
        SparkSession x$1 = relation$2.sparkSession();
        Seq x$2 = replacedPaths;
        scala.collection.immutable.Map x$3 = relation$2.options();
        Option x$4 = Option$.MODULE$.apply((Object)relation$2.dataSchema());
        Some x$5 = new Some((Object)specAdjusted);
        FileStatusCache x$6 = InMemoryFileIndex$.MODULE$.$lessinit$greater$default$5();
        Option x$7 = InMemoryFileIndex$.MODULE$.$lessinit$greater$default$7();
        return new InMemoryFileIndex(x$1, x$2, x$3, x$4, x$6, (Option)x$5, x$7);
    }

    public static final /* synthetic */ boolean $anonfun$replacePathIfNeeded$7(Expression x$8) {
        return x$8 instanceof PlanExpression;
    }

    private static final boolean isDynamicPruningFilter$1(Expression e) {
        return e.find((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)AlluxioUtils$.$anonfun$replacePathIfNeeded$7(x$8))).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$replacePathIfNeeded$12(Path rootPath$1, String value) {
        return rootPath$1.toString().startsWith(value);
    }

    public static final /* synthetic */ void $anonfun$replacePathIfNeeded$11(Option replaceMapOption$2, HadoopFsRelation relation$2, Path rootPath) {
        ((MapLike)replaceMapOption$2.get()).values().find((Function1 & Serializable & scala.Serializable)value -> BoxesRunTime.boxToBoolean((boolean)AlluxioUtils$.$anonfun$replacePathIfNeeded$12(rootPath, value))).foreach((Function1 & Serializable & scala.Serializable)matched -> {
            AlluxioUtils$.MODULE$.checkAlluxioMounted(relation$2.sparkSession(), matched);
            return BoxedUnit.UNIT;
        });
    }

    private AlluxioUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.checkedAlluxioPath = (HashSet)HashSet$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.mountedBuckets = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.alluxioCmd = null;
        this.alluxioMasterHost = None$.MODULE$;
        this.alluxioHome = "/opt/alluxio-2.8.0";
        this.isInit = false;
    }

    public static final /* synthetic */ Object $anonfun$replacePathIfNeeded$11$adapted(Option replaceMapOption$2, HadoopFsRelation relation$2, Path rootPath) {
        AlluxioUtils$.$anonfun$replacePathIfNeeded$11(replaceMapOption$2, relation$2, rootPath);
        return BoxedUnit.UNIT;
    }
}

